/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SkipInputStream
extends BufferedInputStream {
    private final int searchSize;
    private boolean ignoreCase = false;
    private boolean found = false;

    public SkipInputStream(String searchTag, InputStream stream2, boolean ignorecase) {
        this(searchTag, stream2, ignorecase, -1);
    }

    public SkipInputStream(String searchTag, InputStream stream2, boolean ignorecase, int maxPreRead) {
        super(stream2);
        this.ignoreCase = ignorecase;
        int n = this.searchSize = searchTag == null ? 0 : searchTag.length();
        if (this.searchSize == 0) {
            this.found = true;
            return;
        }
        this.mark(this.searchSize + 10);
        try {
            this.readToTag(searchTag, maxPreRead);
        }
        catch (IOException x) {
            // empty catch block
        }
    }

    private void readToTag(String searchTag, int maxPreRead) throws IOException {
        if (searchTag == null) {
            return;
        }
        byte[] bytes = searchTag.getBytes();
        byte[] lowerBytes = searchTag.toLowerCase().getBytes();
        int tagPos = 0;
        int nSkipped = 0;
        while (nSkipped++ != maxPreRead) {
            int c;
            if (tagPos == 0) {
                this.mark(this.searchSize + 10);
            }
            if ((c = super.read()) == -1) break;
            if (c == bytes[tagPos] || this.ignoreCase && Character.toLowerCase(c) == lowerBytes[tagPos]) {
                if (++tagPos < this.searchSize) continue;
                this.reset();
                this.found = true;
                return;
            }
            tagPos = 0;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        return this.found ? super.read() : -1;
    }

    public String toString() {
        return "SkipInputStream " + this.found + " " + this.searchSize + " " + super.toString();
    }
}

