/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StringUtil;

public class StreamUtil {
    public static InputStream getBufferedInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayInputStream) {
            return is;
        }
        if (is instanceof BufferedInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static OutputStream getBufferedOutputStream(OutputStream os) {
        if (os == null) {
            return null;
        }
        if (os instanceof ByteArrayOutputStream) {
            return os;
        }
        if (os instanceof BufferedOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os);
    }

    public static VString getLines(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayIOStream ios = new ByteArrayIOStream(in);
        byte[] bytes = ios.getBuf();
        String s = bytes == null ? null : new String(bytes, 0, bytes.length);
        return StringUtil.tokenize(s, "\n\r", false);
    }
}

