/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;

public class UnitParser {
    private int precision;

    public UnitParser() {
        this.setPrecision(4);
    }

    public String extractUnits(String val) {
        if (val == null) {
            return val;
        }
        VString v = StringUtil.tokenize(val, " ", false);
        boolean bGood = true;
        for (int i = 0; i < v.size(); ++i) {
            String tmp = v.get(i).toLowerCase();
            double factor = 1.0;
            if (tmp.endsWith("mm")) {
                factor = 2.834645669291339;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith("cm")) {
                factor = 28.346456692913385;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith("in")) {
                factor = 72.0;
                tmp = StringUtil.leftStr(tmp, -2);
            }
            if (!StringUtil.isNumber(tmp)) {
                factor = 0.0;
            }
            if (factor == 0.0) {
                bGood = false;
                break;
            }
            double dbl = StringUtil.parseDouble(tmp, -1.0) * factor;
            v.setElementAt(new NumberFormatter().formatDouble(dbl, this.precision), i);
        }
        if (bGood) {
            val = StringUtil.setvString(v, " ", null, null);
        }
        return val;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }
}

