/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;

public class HotFolder
implements Runnable {
    public static int defaultStabilizeTime = 2222;
    public int stabilizeTime = defaultStabilizeTime;
    private boolean interrupt = false;
    private static int nThread = 0;
    private final File dir;
    private String allExtensions;
    private long lastModified = -1L;
    private final Vector<FileTime> lastFileTime;
    protected final Vector<ExtensionListener> hfl;
    private Thread runThread;
    private final Log log = LogFactory.getLog(this.getClass());

    public File getDir() {
        return this.dir;
    }

    private String getAllExtensions() {
        if (this.allExtensions != null) {
            return this.allExtensions;
        }
        if (this.hfl == null) {
            return null;
        }
        VString allextensions = new VString();
        for (int i = 0; i < this.hfl.size(); ++i) {
            Set<String> ext = this.hfl.get((int)i).extension;
            if (ext == null) {
                return null;
            }
            allextensions.addAll(ext);
        }
        allextensions.unify();
        this.allExtensions = allextensions.size() == 0 ? null : StringUtil.setvString(allextensions, ",", null, null);
        return this.allExtensions;
    }

    @Deprecated
    public HotFolder(File _dir) {
        this(_dir, null, null);
    }

    public synchronized void addListener(HotFolderListener _hfl, String ext) {
        if (this.hfl != null) {
            this.hfl.add(new ExtensionListener(_hfl, ext));
        }
        this.allExtensions = null;
        this.lastModified = 0L;
    }

    public HotFolder(File _dir, String ext, HotFolderListener _hfl) {
        this.dir = _dir;
        this.dir.mkdirs();
        this.dir.setWritable(true);
        this.lastFileTime = new Vector();
        this.hfl = new Vector();
        this.runThread = null;
        this.allExtensions = null;
        if (_hfl != null) {
            this.addListener(_hfl, ext);
        }
        this.restart();
    }

    public synchronized void restart() {
        if (this.runThread != null) {
            this.stop();
        }
        if (!this.dir.canWrite()) {
            this.log.error((Object)"Cannot use read only hot folder at");
        }
        String threadName = "HotFolder_" + nThread++ + "_" + this.dir.getAbsolutePath();
        this.runThread = new Thread((Runnable)this, threadName);
        this.runThread.setDaemon(true);
        this.interrupt = false;
        this.log.info((Object)("Starting hotfolder: " + threadName));
        this.lastModified = -1L;
        this.runThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.interrupt = true;
        if (this.runThread != null) {
            Thread thread = this.runThread;
            synchronized (thread) {
                this.runThread.notifyAll();
                String name = this.runThread.getName();
                this.log.info((Object)("Stopping hot folder: " + name));
                try {
                    this.runThread.join();
                }
                catch (InterruptedException x) {
                    this.log.info((Object)"interupted while dying... ", (Throwable)x);
                }
                this.log.info((Object)("Finished stopping hot folder: " + name));
            }
            this.runThread = null;
        } else {
            this.log.warn((Object)"Stopping stopped hot folder: ");
        }
    }

    @Override
    public void run() {
        this.log.info((Object)("starting hot folder at: " + this.dir.getAbsolutePath()));
        while (!this.interrupt) {
            long lastMod = this.dir.lastModified();
            if (lastMod > this.lastModified || this.lastFileTime.size() > 0) {
                this.lastModified = lastMod;
                File[] files = this.getHotFiles();
                if (files != null) {
                    int fileListLength = files.length;
                    for (int i = 0; i < this.lastFileTime.size(); ++i) {
                        boolean found = false;
                        FileTime lftAt = this.lastFileTime.elementAt(i);
                        for (int j = 0; j < fileListLength; ++j) {
                            File fileJ = files[j];
                            if (fileJ == null || !fileJ.equals(lftAt.f)) continue;
                            found = found || this.processSingleFile(files, lftAt, j, fileJ);
                        }
                        if (found) continue;
                        this.lastFileTime.remove(i--);
                    }
                    Vector<File> vf = ContainerUtil.toVector(files);
                    for (int i = vf.size() - 1; i >= 0; --i) {
                        if (vf.get(i) != null) continue;
                        vf.remove(i);
                    }
                    files = vf.toArray(new File[0]);
                    for (File f : files = new FileSorter(files).sortLastModified(false)) {
                        this.lastFileTime.add(new FileTime(f));
                    }
                }
            }
            ThreadUtil.wait(this.runThread, this.stabilizeTime);
        }
        this.runThread.interrupt();
        this.log.info((Object)("completed hot folder at: " + this.dir.getAbsolutePath()));
    }

    private File[] getHotFiles() {
        File[] files = FileUtil.listFilesWithExtension(this.dir, this.getAllExtensions());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].canWrite()) continue;
                this.log.warn((Object)("ignoring read only file in hot folder: " + files[i]));
                files[i] = null;
            }
        }
        return files;
    }

    private boolean processSingleFile(File[] files, FileTime lftAt, int j, File fileJ) {
        boolean found = true;
        if (fileJ.lastModified() == lftAt.modified) {
            if (fileJ.exists()) {
                this.hotFiles(fileJ);
            } else {
                found = false;
            }
        } else {
            lftAt.modified = files[j].lastModified();
        }
        files[j] = null;
        return found;
    }

    private void hotFiles(File fileJ) {
        for (ExtensionListener xl : this.hfl) {
            try {
                xl.hotFile(fileJ);
            }
            catch (Exception x) {
                this.log.error((Object)"exception processing hot files", (Throwable)x);
            }
        }
    }

    public String toString() {
        return "HotFolder: " + this.dir + " " + this.lastModified;
    }

    public static int getDefaultStabilizeTime() {
        return defaultStabilizeTime;
    }

    public static void setDefaultStabilizeTime(int defaultStabilizeTime) {
        HotFolder.defaultStabilizeTime = defaultStabilizeTime;
    }

    public int getStabilizeTime() {
        return this.stabilizeTime;
    }

    public void setStabilizeTime(int stabilizeTime) {
        this.stabilizeTime = stabilizeTime;
    }

    protected class ExtensionListener {
        protected final HotFolderListener fl;
        protected final Set<String> extension;

        protected ExtensionListener(HotFolderListener _hfl, String ext) {
            this.fl = _hfl;
            ext = StringUtil.getNonEmpty(ext);
            if (ext != null) {
                this.extension = new HashSet<String>();
                VString vs = StringUtil.tokenize(ext, ",", false);
                for (String s : vs) {
                    if (s.startsWith(".")) {
                        s = s.substring(1);
                    }
                    s = s.toLowerCase();
                    this.extension.add(s);
                }
            } else {
                this.extension = null;
            }
        }

        public void hotFile(File file) {
            String fileExt;
            if (file == null) {
                return;
            }
            if (this.extension != null && (fileExt = FileUtil.getExtension(file)) != null && !this.extension.contains(fileExt = fileExt.toLowerCase())) {
                return;
            }
            this.fl.hotFile(file);
        }
    }

    protected class FileTime {
        protected File f;
        protected long modified;

        protected FileTime(File _f) {
            this.f = _f;
            this.modified = -1L;
        }

        public String toString() {
            return this.f + " " + this.modified;
        }
    }
}

