/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.MyLong;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.IPersistable;
import org.cip4.jdflib.util.thread.MyMutex;

public class DelayedPersist
extends Thread {
    private final HashMap<IPersistable, MyLong> persistQueue;
    private boolean stop = false;
    private static DelayedPersist theDelayed = null;
    private MyMutex waitMutex;
    private final Log log = LogFactory.getLog(this.getClass());

    private DelayedPersist() {
        super("DelayedPersist");
        this.persistQueue = new HashMap();
        this.waitMutex = new MyMutex();
        this.start();
    }

    public static DelayedPersist getDelayedPersist() {
        if (theDelayed == null) {
            theDelayed = new DelayedPersist();
        }
        return theDelayed;
    }

    public static void shutDown() {
        if (theDelayed == null) {
            LogFactory.getLog(DelayedPersist.class).warn((Object)"Cannot shutdown null DelayedPersist, bailing out");
            return;
        }
        theDelayed._shutDown();
        theDelayed = null;
    }

    private void _shutDown() {
        this.log.info((Object)"shutting down delayed persist");
        this.stop = true;
        this.persistQueues();
        ThreadUtil.notifyAll(this.waitMutex);
        ThreadUtil.sleep(10);
        if (this.waitMutex != null) {
            this.log.info((Object)"waiting for persist of delayed persist");
            if (this.waitMutex != null) {
                ThreadUtil.wait(this.waitMutex, 120000);
            }
            this.log.info((Object)"finished waiting for persist of delayed persist");
        }
        theDelayed = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(IPersistable persistable, long deltaTime) {
        HashMap<IPersistable, MyLong> hashMap = this.persistQueue;
        synchronized (hashMap) {
            MyLong l = this.persistQueue.get(persistable);
            long t = System.currentTimeMillis();
            if (l == null) {
                this.persistQueue.put(persistable, new MyLong(t + deltaTime));
            } else if (t + deltaTime < l.i) {
                l.i = t + deltaTime;
            }
        }
        if (deltaTime <= 0L) {
            ThreadUtil.notifyAll(this.waitMutex);
        }
    }

    @Override
    public void run() {
        block3: {
            this.log.info((Object)"starting queue persist loop");
            do {
                try {
                    this.persistQueues();
                }
                catch (Exception e) {
                    this.log.error((Object)"whazzup queuing delayedPersist ", (Throwable)e);
                }
                if (!this.stop) continue;
                this.log.info((Object)"end of queue persist loop");
                ThreadUtil.notifyAll(this.waitMutex);
                this.waitMutex = null;
                break block3;
            } while (ThreadUtil.wait(this.waitMutex, 10000));
            this._shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistQueues() {
        long t = System.currentTimeMillis();
        Vector<IPersistable> theList = new Vector<IPersistable>();
        HashMap<IPersistable, MyLong> hashMap = this.persistQueue;
        synchronized (hashMap) {
            Vector<IPersistable> v = ContainerUtil.getKeyVector(this.persistQueue);
            if (v == null) {
                return;
            }
            for (IPersistable qp : v) {
                MyLong l = this.persistQueue.get(qp);
                if (!this.stop && l.i >= t) continue;
                theList.add(qp);
                this.persistQueue.remove(qp);
            }
        }
        for (IPersistable qp : theList) {
            qp.persist();
        }
        System.gc();
    }

    @Override
    public String toString() {
        return "DelayedPersist Thread " + this.stop + " queue: " + this.persistQueue;
    }
}

