/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;

public class OrderedTaskQueue
extends Thread {
    private final Vector<Runnable> queue;
    private boolean stop;
    private final Log log;
    private MyMutex mutex;
    private static Map<String, OrderedTaskQueue> theMap = new HashMap<String, OrderedTaskQueue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedTaskQueue getCreateQueue(String name) {
        name = OrderedTaskQueue.getThreadName(name);
        Map<String, OrderedTaskQueue> map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = theMap.get(name);
            if (orderedTaskQueue == null || orderedTaskQueue.stop) {
                orderedTaskQueue = new OrderedTaskQueue(name);
                theMap.put(name, orderedTaskQueue);
            }
            return orderedTaskQueue;
        }
    }

    private OrderedTaskQueue(String name) {
        super(name);
        this.setDaemon(true);
        this.log = LogFactory.getLog(this.getClass());
        this.queue = new Vector();
        this.mutex = new MyMutex();
        this.start();
    }

    private static String getThreadName(String name) {
        return name == null ? "OrderedTaskQueue" : "OrderedTaskQueue_" + name;
    }

    public static void shutDownAll() {
        LogFactory.getLog(OrderedTaskQueue.class).info((Object)"shutting down all ordered queues");
        Vector<String> v = ContainerUtil.getKeyVector(theMap);
        if (v != null) {
            for (String key : v) {
                theMap.get(key).shutDown();
            }
        }
    }

    public void shutDown() {
        this.log.info((Object)"shutting down ordered queue");
        this.stop = true;
        theMap.remove(this.getName());
    }

    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(Runnable task) {
        if (this.stop) {
            this.log.error((Object)"cannot queue task in stopped queue");
            return false;
        }
        Vector<Runnable> vector = this.queue;
        synchronized (vector) {
            this.queue.add(task);
            ThreadUtil.notifyAll(this.mutex);
            return true;
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"starting queue persist loop");
        do {
            try {
                this.runTasks();
            }
            catch (Exception e) {
                this.log.error((Object)"whazzup queueing ordered task ", (Throwable)e);
            }
            if (!this.stop) continue;
            this.log.info((Object)"end of ordered task loop");
            ThreadUtil.notifyAll(this.mutex);
            this.mutex = null;
            break;
        } while (ThreadUtil.wait(this.mutex, 1000000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        while (!this.stop) {
            Runnable r = null;
            Vector<Runnable> vector = this.queue;
            synchronized (vector) {
                if (this.queue.size() > 0) {
                    r = this.queue.remove(0);
                }
            }
            if (r == null) break;
            r.run();
            System.gc();
        }
    }

    @Override
    public String toString() {
        return "OrderedTaskQueue " + this.getName() + " " + this.stop + " queue: " + this.queue;
    }
}

