/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.util.JDFDate;

public abstract class JDFAutoDeliveryParams
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoDeliveryParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoDeliveryParams[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setEarliest(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("Earliest", date.getDateTimeISO(), null);
    }

    public JDFDate getEarliest() {
        String str = this.getAttribute("Earliest", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setMethod(String value) {
        this.setAttribute("Method", value, null);
    }

    public String getMethod() {
        return this.getAttribute("Method", null, "");
    }

    public void setPickup(boolean value) {
        this.setAttribute("Pickup", value, null);
    }

    public boolean getPickup() {
        return this.getBoolAttribute("Pickup", null, false);
    }

    public void setRequired(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("Required", date.getDateTimeISO(), null);
    }

    public JDFDate getRequired() {
        String str = this.getAttribute("Required", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setServiceLevel(String value) {
        this.setAttribute("ServiceLevel", value, null);
    }

    public String getServiceLevel() {
        return this.getAttribute("ServiceLevel", null, "");
    }

    public void setTransfer(EnumTransfer enumVar) {
        this.setAttribute("Transfer", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumTransfer getTransfer() {
        return EnumTransfer.getEnum(this.getAttribute("Transfer", null, null));
    }

    public JDFCompany getCompany() {
        return (JDFCompany)this.getElement("Company", null, 0);
    }

    public JDFCompany getCreateCompany() {
        return (JDFCompany)this.getCreateElement_KElement("Company", null, 0);
    }

    public JDFCompany appendCompany() throws JDFException {
        return (JDFCompany)this.appendElementN("Company", 1, null);
    }

    public void refCompany(JDFCompany refTarget) {
        this.refElement(refTarget);
    }

    public JDFContact getCreateContact(int iSkip) {
        return (JDFContact)this.getCreateElement_KElement("Contact", null, iSkip);
    }

    public JDFContact getContact(int iSkip) {
        return (JDFContact)this.getElement("Contact", null, iSkip);
    }

    public Collection<JDFContact> getAllContact() {
        VElement vc = this.getChildElementVector("Contact", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFContact> v = new Vector<JDFContact>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFContact)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFContact appendContact() {
        return (JDFContact)this.appendElement("Contact", null);
    }

    public void refContact(JDFContact refTarget) {
        this.refElement(refTarget);
    }

    public JDFDrop getCreateDrop(int iSkip) {
        return (JDFDrop)this.getCreateElement_KElement("Drop", null, iSkip);
    }

    public JDFDrop getDrop(int iSkip) {
        return (JDFDrop)this.getElement("Drop", null, iSkip);
    }

    public Collection<JDFDrop> getAllDrop() {
        VElement vc = this.getChildElementVector("Drop", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFDrop> v = new Vector<JDFDrop>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFDrop)vc.get(i));
        }
        return v;
    }

    public JDFDrop appendDrop() {
        return (JDFDrop)this.appendElement("Drop", null);
    }

    static {
        JDFAutoDeliveryParams.atrInfoTable[0] = new AtrInfoTable("Earliest", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeliveryParams.atrInfoTable[1] = new AtrInfoTable("Method", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeliveryParams.atrInfoTable[2] = new AtrInfoTable("Pickup", 0x44444433L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAutoDeliveryParams.atrInfoTable[3] = new AtrInfoTable("Required", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeliveryParams.atrInfoTable[4] = new AtrInfoTable("ServiceLevel", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeliveryParams.atrInfoTable[5] = new AtrInfoTable("Transfer", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, EnumTransfer.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[3];
        JDFAutoDeliveryParams.elemInfoTable[0] = new ElemInfoTable("Company", 0x77777776L);
        JDFAutoDeliveryParams.elemInfoTable[1] = new ElemInfoTable("Contact", 0x33333331L);
        JDFAutoDeliveryParams.elemInfoTable[2] = new ElemInfoTable("Drop", 0x22222222L);
    }

    public static class EnumTransfer
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumTransfer BuyerToPrinterDeliver = new EnumTransfer("BuyerToPrinterDeliver");
        public static final EnumTransfer BuyerToPrinterPickup = new EnumTransfer("BuyerToPrinterPickup");
        public static final EnumTransfer PrinterToBuyerDeliver = new EnumTransfer("PrinterToBuyerDeliver");
        public static final EnumTransfer PrinterToBuyerPickup = new EnumTransfer("PrinterToBuyerPickup");

        private EnumTransfer(String name) {
            super(name, m_startValue++);
        }

        public static EnumTransfer getEnum(String enumName) {
            return (EnumTransfer)EnumTransfer.getEnum(EnumTransfer.class, (String)enumName);
        }

        public static EnumTransfer getEnum(int enumValue) {
            return (EnumTransfer)EnumTransfer.getEnum(EnumTransfer.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumTransfer.getEnumMap(EnumTransfer.class);
        }

        public static List getEnumList() {
            return EnumTransfer.getEnumList(EnumTransfer.class);
        }

        public static Iterator iterator() {
            return EnumTransfer.iterator(EnumTransfer.class);
        }
    }
}

