/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFCostCenter;
import org.cip4.jdflib.resource.process.JDFEmployee;

public abstract class JDFAutoNotification
extends JDFAudit {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[8];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoNotification(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoNotification(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoNotification(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoNotification[  --> " + super.toString() + " ]";
    }

    public void setClass(EnumClass enumVar) {
        this.setAttribute("Class", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumClass getClassJDF() {
        return EnumClass.getEnum(this.getAttribute("Class", null, null));
    }

    public void setCombinedProcessIndex(JDFIntegerList value) {
        this.setAttribute("CombinedProcessIndex", value, null);
    }

    public JDFIntegerList getCombinedProcessIndex() {
        String strAttrName = this.getAttribute("CombinedProcessIndex", null, "");
        JDFIntegerList nPlaceHolder = JDFIntegerList.createIntegerList(strAttrName);
        return nPlaceHolder;
    }

    public void setJobID(String value) {
        this.setAttribute("JobID", value, null);
    }

    public String getJobID() {
        return this.getAttribute("JobID", null, "");
    }

    public void setJobPartID(String value) {
        this.setAttribute("JobPartID", value, null);
    }

    public String getJobPartID() {
        return this.getAttribute("JobPartID", null, "");
    }

    public void setModuleID(String value) {
        this.setAttribute("ModuleID", value, null);
    }

    public String getModuleID() {
        return this.getAttribute("ModuleID", null, "");
    }

    public void setModuleIndex(JDFIntegerRangeList value) {
        this.setAttribute("ModuleIndex", value, null);
    }

    public JDFIntegerRangeList getModuleIndex() {
        String strAttrName = this.getAttribute("ModuleIndex", null, "");
        JDFIntegerRangeList nPlaceHolder = JDFIntegerRangeList.createIntegerRangeList(strAttrName);
        return nPlaceHolder;
    }

    public void setModuleType(String value) {
        this.setAttribute("ModuleType", value, null);
    }

    public String getModuleType() {
        return this.getAttribute("ModuleType", null, "");
    }

    public void setType(String value) {
        this.setAttribute("Type", value, null);
    }

    public String getType() {
        return this.getAttribute("Type", null, "");
    }

    public JDFCostCenter getCostCenter() {
        return (JDFCostCenter)this.getElement("CostCenter", null, 0);
    }

    public JDFCostCenter getCreateCostCenter() {
        return (JDFCostCenter)this.getCreateElement_KElement("CostCenter", null, 0);
    }

    public JDFCostCenter appendCostCenter() throws JDFException {
        return (JDFCostCenter)this.appendElementN("CostCenter", 1, null);
    }

    @Override
    public JDFEmployee getCreateEmployee(int iSkip) {
        return (JDFEmployee)this.getCreateElement_KElement("Employee", null, iSkip);
    }

    @Override
    public JDFEmployee getEmployee(int iSkip) {
        return (JDFEmployee)this.getElement("Employee", null, iSkip);
    }

    @Override
    public Collection<JDFEmployee> getAllEmployee() {
        VElement vc = this.getChildElementVector("Employee", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFEmployee> v = new Vector<JDFEmployee>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFEmployee)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFEmployee appendEmployee() {
        return (JDFEmployee)this.appendElement("Employee", null);
    }

    public JDFPart getCreatePart(int iSkip) {
        return (JDFPart)this.getCreateElement_KElement("Part", null, iSkip);
    }

    public JDFPart getPart(int iSkip) {
        return (JDFPart)this.getElement("Part", null, iSkip);
    }

    public Collection<JDFPart> getAllPart() {
        VElement vc = this.getChildElementVector("Part", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFPart> v = new Vector<JDFPart>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFPart)vc.get(i));
        }
        return v;
    }

    public JDFPart appendPart() {
        return (JDFPart)this.appendElement("Part", null);
    }

    static {
        JDFAutoNotification.atrInfoTable[0] = new AtrInfoTable("Class", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumClass.getEnum(0), null);
        JDFAutoNotification.atrInfoTable[1] = new AtrInfoTable("CombinedProcessIndex", 0x33331111L, AttributeInfo.EnumAttributeType.IntegerList, null, null);
        JDFAutoNotification.atrInfoTable[2] = new AtrInfoTable("JobID", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoNotification.atrInfoTable[3] = new AtrInfoTable("JobPartID", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoNotification.atrInfoTable[4] = new AtrInfoTable("ModuleID", 0x33331111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoNotification.atrInfoTable[5] = new AtrInfoTable("ModuleIndex", 0x33331111L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFAutoNotification.atrInfoTable[6] = new AtrInfoTable("ModuleType", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoNotification.atrInfoTable[7] = new AtrInfoTable("Type", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        elemInfoTable = new ElemInfoTable[3];
        JDFAutoNotification.elemInfoTable[0] = new ElemInfoTable("CostCenter", 0x66666666L);
        JDFAutoNotification.elemInfoTable[1] = new ElemInfoTable("Employee", 0x33333333L);
        JDFAutoNotification.elemInfoTable[2] = new ElemInfoTable("Part", 0x33333331L);
    }

    public static class EnumClass
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumClass Event = new EnumClass("Event");
        public static final EnumClass Information = new EnumClass("Information");
        public static final EnumClass Warning = new EnumClass("Warning");
        public static final EnumClass Error = new EnumClass("Error");
        public static final EnumClass Fatal = new EnumClass("Fatal");

        private EnumClass(String name) {
            super(name, m_startValue++);
        }

        public static EnumClass getEnum(String enumName) {
            return (EnumClass)EnumClass.getEnum(EnumClass.class, (String)enumName);
        }

        public static EnumClass getEnum(int enumValue) {
            return (EnumClass)EnumClass.getEnum(EnumClass.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumClass.getEnumMap(EnumClass.class);
        }

        public static List getEnumList() {
            return EnumClass.getEnumList(EnumClass.class);
        }

        public static Iterator iterator() {
            return EnumClass.iterator(EnumClass.class);
        }
    }
}

