/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;

public class JDFSeparationList
extends JDFAutoSeparationList {
    private static final long serialVersionUID = 1L;

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFSeparationList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFSeparationList[ -->" + super.toString() + "]";
    }

    public VString getSeparations() {
        VString vName = new VString();
        VElement v = this.getChildElementVector("SeparationSpec", null, null, false, 0, false);
        for (KElement e : v) {
            JDFSeparationSpec sep = (JDFSeparationSpec)e;
            String sepName = sep.getName();
            vName.add(sepName);
        }
        return vName;
    }

    public void setSeparations(VString vSeps) {
        this.removeChildren("SeparationSpec", null, null);
        this.appendSeparations(vSeps);
    }

    public void appendSeparations(VString vSeps) {
        if (vSeps == null) {
            return;
        }
        for (int i = 0; i < vSeps.size(); ++i) {
            this.appendSeparation(vSeps.stringAt(i));
        }
    }

    public void setCMYK() {
        this.setSeparations(new VString("Cyan Magenta Yellow Black", null));
    }

    public void appendSeparation(String sep) {
        this.appendSeparationSpec().setName(sep);
    }

    public int removeSeparation(String sep) {
        VString vs = this.getSeparations();
        int index = vs.index(sep);
        if (index >= 0) {
            this.getSeparationSpec(index).deleteNode();
        }
        return index;
    }

    public String getSeparation(int iSkip) {
        JDFSeparationSpec ss = this.getSeparationSpec(iSkip);
        if (ss == null) {
            return null;
        }
        return ss.getName();
    }

    public VString unify() {
        VString v = this.getSeparations();
        int l = v.size();
        v.unify();
        if (v.size() != l) {
            this.setSeparations(v);
        }
        return v;
    }
}

