/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.HashUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.zip.ZipReader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class XMLDoc {
    protected DocumentXMLImpl m_doc;
    protected final Log log;
    protected static final String sm_strENCODING = "UTF-8";

    public XMLDoc() {
        this.m_doc = this.getImpl();
        this.log = LogFactory.getLog(this.getClass());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof XMLDoc)) {
            return false;
        }
        XMLDoc d = (XMLDoc)o;
        if (this.m_doc == null) {
            return d.m_doc == null;
        }
        return ((Object)((Object)this.m_doc)).equals((Object)d.m_doc);
    }

    public int hashCode() {
        return HashUtil.hashCode(0, (Object)this.m_doc);
    }

    public XMLDoc(Document document) {
        this.log = LogFactory.getLog(this.getClass());
        if (document == null) {
            throw new JDFException("XMLDoc(Document) null input Document");
        }
        try {
            this.m_doc = document instanceof DocumentXMLImpl ? (DocumentXMLImpl)((Object)document) : this.reparseDOM(document);
        }
        catch (Exception e) {
            this.log.error((Object)"exception constructing Document", (Throwable)e);
            String s = e.toString();
            throw new JDFException("Snafu: XMLDoc(Document) not implemented; class=" + s);
        }
    }

    protected XMLDoc createRoot(Document document) {
        return new XMLDoc(document.getDocumentElement().getNodeName(), StringUtil.getNonEmpty(document.getDocumentElement().getNamespaceURI()));
    }

    private DocumentXMLImpl reparseDOM(Document document) {
        XMLDoc d = this.createRoot(document);
        DocumentXMLImpl newDoc = d.getMemberDocument();
        this.reparseElement(newDoc.getDocumentElement(), document.getDocumentElement());
        return newDoc;
    }

    private void reparseElement(Element dst, Element src) {
        NamedNodeMap atts = src.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr item = (Attr)atts.item(i);
            dst.setAttribute(item.getNodeName(), item.getNodeValue());
        }
        NodeList nl = src.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Node childNode = dst.getOwnerDocument().importNode(n, true);
            dst.insertBefore(childNode, null);
        }
    }

    public XMLDoc(DocumentXMLImpl document) {
        this.log = LogFactory.getLog(this.getClass());
        if (document == null) {
            throw new JDFException("XMLDoc(DocumentXMLImpl) null input Document");
        }
        this.m_doc = document;
    }

    public XMLDoc(XMLDoc other) {
        this.log = LogFactory.getLog(this.getClass());
        this.m_doc = other == null ? null : other.m_doc;
    }

    @Deprecated
    public XMLDoc(String strDocType) {
        this(strDocType, null);
    }

    public XMLDoc(String strDocType, String namespaceURI) {
        this.log = LogFactory.getLog(this.getClass());
        this.m_doc = this.getImpl();
        this.setRoot(strDocType, namespaceURI);
    }

    protected DocumentXMLImpl getImpl() {
        return new DocumentXMLImpl();
    }

    public KElement setRoot(String strDocType, String namespaceURI) {
        KElement root = (KElement)this.m_doc.getDocumentElement();
        if (root != null) {
            throw new JDFException("XMLDoc.setRoot:  root already exists: ");
        }
        root = (KElement)this.appendChild(this.m_doc.createElementNS(namespaceURI, strDocType));
        return root;
    }

    public DocumentXMLImpl getMemberDocument() {
        return this.m_doc;
    }

    protected boolean flush() {
        return this.getRoot().flush();
    }

    public KElement getRoot() {
        return (KElement)this.m_doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write2String(int indent) {
        String strResult = "";
        ByteArrayOutputStream outStream = null;
        try {
            outStream = new ByteArrayOutputStream(4096);
            this.write2Stream(outStream, indent, indent == 0);
            strResult = outStream.toString(sm_strENCODING);
        }
        catch (IOException e) {
            this.log.error((Object)"write2String: ", (Throwable)e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e1) {
                    this.log.error((Object)"error closing: ", (Throwable)e1);
                }
            }
        }
        return strResult;
    }

    @Deprecated
    public boolean write2File(String oFilePath, int indent) {
        return this.write2File(oFilePath, indent, true);
    }

    public boolean write2File(String oFilePath, int indent, boolean bPreserveSpace) {
        if (oFilePath == null) {
            oFilePath = this.m_doc.m_OriginalFileName;
        }
        if (oFilePath == null) {
            this.log.error((Object)"writing to null File, bailing out");
            return false;
        }
        return this.write2File(new File(oFilePath), indent, bPreserveSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write2File(File file, int indent, boolean bPreserveSpace) {
        boolean fSuccess = true;
        if (file == null) {
            if (this.getOriginalFileName() != null) {
                file = new File(this.getOriginalFileName());
            } else {
                this.log.error((Object)"writing to null File, bailing out");
                return false;
            }
        }
        OutputStream outStream = null;
        try {
            if (file.isDirectory() && this.getOriginalFileName() != null) {
                File orig = new File(this.getOriginalFileName());
                file = new File(file + File.separator + orig.getName());
            }
            file.delete();
            fSuccess = FileUtil.createNewFile(file);
            if (fSuccess) {
                outStream = FileUtil.getBufferedOutputStream(file);
                this.write2Stream(outStream, indent, bPreserveSpace);
                if (this.getOriginalFileName() == null) {
                    this.setOriginalFileName(file.getPath());
                }
            }
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"writing to File, bailing out", (Throwable)e);
            fSuccess = false;
        }
        catch (IOException e) {
            this.log.error((Object)"writing to File, bailing out", (Throwable)e);
            fSuccess = false;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e1) {
                    this.log.error((Object)"closing File, bailing out", (Throwable)e1);
                }
            }
        }
        return fSuccess;
    }

    @Deprecated
    public void write2Stream(OutputStream outStream, int indent) throws IOException {
        this.write2Stream(outStream, indent, indent == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2Stream(OutputStream outStream, int indent, boolean bPreserveSpace) throws IOException {
        for (int i = 0; i < 3; ++i) {
            try {
                OutputFormat format = new OutputFormat((Document)((Object)this.m_doc));
                if (bPreserveSpace) {
                    format.setPreserveSpace(true);
                }
                if (indent < 1) {
                    format.setIndenting(false);
                } else {
                    format.setIndenting(true);
                    format.setIndent(indent);
                }
                XMLSerializer serial = new XMLSerializer(outStream, format);
                serial.setNamespaces(true);
                serial.asDOMSerializer();
                DocumentXMLImpl documentXMLImpl = this.m_doc;
                synchronized (documentXMLImpl) {
                    serial.serialize((Document)((Object)this.m_doc));
                }
                return;
            }
            catch (IOException x) {
                if (i >= 2) {
                    this.log.error((Object)"writing to Stream, bailing out", (Throwable)x);
                    throw x;
                }
                ThreadUtil.sleep(1000 * (i + 1));
                this.log.warn((Object)("retry IO exception " + i + " for writing to stream; original XML file=" + this.getOriginalFileName()), (Throwable)x);
                continue;
            }
        }
    }

    @Deprecated
    public static void write2StreamStatic(Element elem, OutputStream outStream, int indent) throws IOException {
        XMLDoc.write2StreamStatic(elem, outStream, indent, true);
    }

    @Deprecated
    public static void write2StreamStatic(Element elem, OutputStream outStream, int indent, boolean bPreserveSpace) throws IOException {
        Document doc = elem.getOwnerDocument();
        OutputFormat format = new OutputFormat(doc);
        if (bPreserveSpace) {
            format.setPreserveSpace(true);
        }
        if (indent < 1) {
            format.setIndenting(false);
        } else {
            format.setIndenting(true);
            format.setIndent(indent);
        }
        XMLSerializer serial = new XMLSerializer(outStream, format);
        serial.setNamespaces(true);
        serial.asDOMSerializer();
        serial.serialize(elem);
    }

    public DocumentType getDoctype() {
        return this.m_doc == null ? null : this.m_doc.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.m_doc == null ? null : this.m_doc.getImplementation();
    }

    public Element getDocumentElement() {
        return this.m_doc == null ? null : this.m_doc.getDocumentElement();
    }

    public Element createElement(String elementName) {
        Element elem = null;
        if (this.m_doc != null) {
            elem = this.m_doc.createElement(elementName);
        }
        return elem;
    }

    public DocumentFragment createDocumentFragment() {
        return this.m_doc == null ? null : this.m_doc.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.m_doc == null ? null : this.m_doc.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.m_doc == null ? null : this.m_doc.createComment(data);
    }

    public CDATASection createCDATASection(String data) {
        return this.m_doc == null ? null : this.m_doc.createCDATASection(data);
    }

    public void setXSLTURL(String url) {
        String data = "type=\"text/xsl\" href=\"" + url + "\"";
        ProcessingInstruction pi = this.createProcessingInstruction("xml-stylesheet", data);
        this.insertBefore(pi, this.getRoot());
    }

    public void setXPathValues(JDFAttributeMap valueMap) {
        if (valueMap != null && valueMap.size() > 0) {
            if (this.getRoot() == null) {
                String root = (String)valueMap.keySet().iterator().next();
                root = StringUtil.token(root, 0, "/");
                this.setRoot(root, null);
            }
            this.getRoot().setXPathValues(valueMap);
        }
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return this.m_doc == null ? null : this.m_doc.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) {
        Attr a = null;
        if (this.m_doc == null) {
            throw new JDFException("Creating an attribute on a null document");
        }
        a = name.indexOf(":") < 0 ? this.m_doc.createAttributeNS(null, name) : (name.startsWith("xsi:") ? this.m_doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", name) : (name.startsWith("xmlns:") ? this.m_doc.createAttributeNS("http://www.w3.org/2000/xmlns/", name) : this.m_doc.createAttribute(name)));
        return a;
    }

    public EntityReference createEntityReference(String name) {
        return this.m_doc == null ? null : this.m_doc.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.m_doc == null ? null : this.m_doc.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) {
        return this.m_doc == null ? null : this.m_doc.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return this.m_doc == null ? null : this.m_doc.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return this.m_doc == null ? null : this.m_doc.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String myLocalName) {
        return this.m_doc == null ? null : this.m_doc.getElementsByTagNameNS(namespaceURI, myLocalName);
    }

    public Element getElementById(String elementId) {
        KElement root = this.getRoot();
        return root.getTarget(elementId, null);
    }

    public String getNodeName() {
        return this.m_doc == null ? null : this.m_doc.getNodeName();
    }

    public String getNodeValue() {
        return this.m_doc == null ? null : this.m_doc.getNodeValue();
    }

    public void setNodeValue(String nodeValue) {
        if (this.m_doc != null) {
            this.m_doc.setNodeValue(nodeValue);
        }
    }

    public void setNSMap(XMLDoc other) {
        if (this.m_doc != null) {
            this.m_doc.setNSMap(other.m_doc);
        }
    }

    public short getNodeType() {
        return this.m_doc == null ? (short)0 : this.m_doc.getNodeType();
    }

    public Node getParentNode() {
        return this.m_doc == null ? null : this.m_doc.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.m_doc == null ? null : this.m_doc.getChildNodes();
    }

    public Node getFirstChild() {
        return this.m_doc == null ? null : this.m_doc.getFirstChild();
    }

    public Node getLastChild() {
        return this.m_doc == null ? null : this.m_doc.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.m_doc == null ? null : this.m_doc.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.m_doc == null ? null : this.m_doc.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.m_doc == null ? null : this.m_doc.getAttributes();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.m_doc == null ? null : this.m_doc.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        return this.m_doc == null ? null : this.m_doc.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) {
        return this.m_doc == null ? null : this.m_doc.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) {
        return this.m_doc == null ? null : this.m_doc.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.m_doc == null ? false : this.m_doc.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.m_doc == null ? null : this.m_doc.cloneNode(deep);
    }

    public void normalize() {
        if (this.m_doc != null) {
            this.m_doc.normalize();
        }
    }

    public boolean isSupported(String feature, String version) {
        return this.m_doc == null ? false : this.m_doc.isSupported(feature, version);
    }

    public String getPrefix() {
        if (this.m_doc != null) {
            return this.m_doc.getPrefix();
        }
        return null;
    }

    public void setPrefix(String prefix) {
        if (this.m_doc != null) {
            this.m_doc.setPrefix(prefix);
        }
    }

    public String getLocalName() {
        return this.m_doc == null ? null : this.m_doc.getLocalName();
    }

    public boolean isNull() {
        return this.m_doc == null;
    }

    public boolean hasAttributes() {
        return this.m_doc == null ? false : this.m_doc.hasAttributes();
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        return this.m_doc == null ? null : this.m_doc.createDocumentType(qualifiedName, publicID, systemID);
    }

    public void setErrorChecking(boolean check) {
        if (this.m_doc != null) {
            this.m_doc.setErrorChecking(check);
        }
    }

    public boolean getErrorChecking() {
        return this.m_doc == null ? false : this.m_doc.getErrorChecking();
    }

    public Entity createEntity(String name) {
        return this.m_doc == null ? null : this.m_doc.createEntity(name);
    }

    public Notation createNotation(String name) {
        return this.m_doc == null ? null : this.m_doc.createNotation(name);
    }

    public ElementDefinitionImpl createElementDefinition(String name) {
        return this.m_doc == null ? null : this.m_doc.createElementDefinition(name);
    }

    public void putIdentifier(String idName, Element element) {
        if (this.m_doc != null) {
            this.m_doc.putIdentifier(idName, element);
        }
    }

    public Element getIdentifier(String idName) {
        return this.m_doc == null ? null : this.m_doc.getIdentifier(idName);
    }

    public void removeIdentifier(String idName) {
        if (this.m_doc != null) {
            this.m_doc.removeIdentifier(idName);
        }
    }

    public Enumeration<?> getIdentifiers() {
        return this.m_doc == null ? null : this.m_doc.getIdentifiers();
    }

    public NodeIterator createNodeIterator(Node root, short whatToShow, NodeFilter filter) {
        return this.m_doc == null ? null : this.m_doc.createNodeIterator(root, whatToShow, filter);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        return this.m_doc == null ? null : this.m_doc.createNodeIterator(root, whatToShow, filter, entityReferenceExpansion);
    }

    public TreeWalker createTreeWalker(Node root, short whatToShow, NodeFilter filter) {
        return this.m_doc == null ? null : this.m_doc.createTreeWalker(root, whatToShow, filter);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        return this.m_doc == null ? null : this.m_doc.createTreeWalker(root, whatToShow, filter, entityReferenceExpansion);
    }

    public Range createRange() {
        return this.m_doc == null ? null : this.m_doc.createRange();
    }

    public Event createEvent(String type) {
        return this.m_doc == null ? null : this.m_doc.createEvent(type);
    }

    public XMLDoc clone() {
        XMLDoc clon = new XMLDoc();
        if (this.m_doc != null) {
            clon.m_doc = this.m_doc.clone();
        }
        return clon;
    }

    public String toString() {
        return this.write2String(2);
    }

    public String toXML() {
        String strXML = "";
        try {
            StringWriter osw = new StringWriter();
            KElement thisRoot = this.getRoot();
            OutputFormat format = new OutputFormat(thisRoot.getOwnerDocument());
            format.setPreserveSpace(true);
            format.setIndenting(true);
            format.setIndent(2);
            format.setEncoding(sm_strENCODING);
            XMLSerializer serial = new XMLSerializer((Writer)osw, format);
            serial.setNamespaces(true);
            serial.asDOMSerializer();
            serial.serialize(this.getDocumentElement());
            strXML = osw.toString();
        }
        catch (IOException e) {
            strXML = "XMLDoc.toXML: ### ERROR while serializing " + this.getClass().getName() + " element.";
        }
        return strXML;
    }

    protected void setMemberDoc(DocumentXMLImpl myDoc) {
        this.m_doc = myDoc;
    }

    public XMLDoc write2URL(String strURL, String strContentType) {
        XMLDoc docResponse = null;
        URL url = UrlUtil.stringToURL(strURL);
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase("File")) {
            this.write2File(UrlUtil.urlToFile(strURL), 0, true);
            docResponse = new XMLDoc();
        } else {
            InputStream inStream;
            UrlPart p = this.write2HttpURL(url, strContentType, null);
            InputStream inputStream = inStream = p == null ? null : p.getResponseStream();
            if (inStream == null) {
                return null;
            }
            XMLParser parser = this.getXMLParser();
            parser.parseStream(inStream);
            try {
                inStream.close();
            }
            catch (IOException x) {
                // empty catch block
            }
            XMLDoc xMLDoc = docResponse = parser.getDocument() == null ? null : new XMLDoc(parser.getDocument());
            if (docResponse != null && docResponse.getRoot() == null) {
                docResponse = null;
            }
        }
        return docResponse;
    }

    protected XMLParser getXMLParser() {
        return new XMLParser();
    }

    public HttpURLConnection write2HTTPURL(URL url, String strContentType, UrlUtil.HTTPDetails det) {
        UrlPart p = null;
        for (int i = 0; i < 2 && (p = this.write2HttpURL(url, strContentType, det)) == null && i == 0; ++i) {
            ThreadUtil.sleep(1000);
        }
        return p == null ? null : p.getConnection();
    }

    public UrlPart write2HttpURL(URL url, String strContentType, UrlUtil.HTTPDetails det) {
        if (url == null) {
            return null;
        }
        if (strContentType == null) {
            strContentType = "text/xml";
        }
        try {
            ByteArrayIOStream ios = new ByteArrayIOStream(1000);
            this.write2Stream(ios, 0, true);
            return UrlUtil.writeToURL(url.toExternalForm(), ios.getInputStream(), "POST", strContentType, det);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getDocMemoryUsed() {
        return this.m_doc.getDocMemoryUsed();
    }

    public BodyPart getBodyPart() {
        return this.m_doc.m_Bodypart;
    }

    public Multipart getMultiPart() {
        BodyPart bp = this.getBodyPart();
        if (bp == null) {
            return null;
        }
        return bp.getParent();
    }

    public void setBodyPart(BodyPart bodyPart) {
        this.m_doc.m_Bodypart = bodyPart;
    }

    public void setZipReader(ZipReader zip) {
        this.m_doc.m_ZipReader = zip;
    }

    public ZipReader getZipReader() {
        return this.m_doc.m_ZipReader;
    }

    public String getOriginalFileName() {
        return this.m_doc.m_OriginalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.m_doc.m_OriginalFileName = originalFileName;
    }

    public String getSchemaLocation(String nsURI) {
        KElement root = this.getRoot();
        if (root == null) {
            return null;
        }
        String schemaloc = root.getAttribute("schemaLocation", "xsi", null);
        if (schemaloc == null) {
            return null;
        }
        VString strings = StringUtil.tokenize(schemaloc, " ", false);
        int indexOfNS = strings.indexOf(nsURI);
        if (indexOfNS < 0 || indexOfNS >= strings.size() - 1) {
            return null;
        }
        schemaloc = strings.stringAt(indexOfNS + 1);
        return schemaloc;
    }

    public File getSchemaLocationFile(String nsURI) {
        String schemaloc = this.getSchemaLocation(nsURI);
        if (schemaloc == null) {
            return null;
        }
        File f = UrlUtil.urlToFile(schemaloc);
        if (f != null && f.canRead()) {
            return f;
        }
        return null;
    }

    public void setSchemaLocation(String nsURI, File _schemaLocation) {
        if (_schemaLocation != null && _schemaLocation.length() != 0L) {
            String fileToUrl = UrlUtil.fileToUrl(_schemaLocation, false);
            String schemaLocation = nsURI + " " + fileToUrl;
            KElement root = this.getRoot();
            if (root != null) {
                root.setAttribute("xs:schemaLocation", schemaLocation, "xsi");
            }
        }
    }

    public void setValidationResult(XMLDoc validationResult) {
        this.m_doc.m_validationResult = validationResult;
    }

    public static XMLDoc parseStream(InputStream is) {
        if (is == null) {
            return null;
        }
        XMLParser p = new XMLParser();
        XMLDoc d = p.parseStream(is);
        return d;
    }

    public static XMLDoc parseFile(String fileName) {
        XMLParser p = new XMLParser();
        XMLDoc d = p.parseFile(fileName);
        return d;
    }

    public static XMLDoc parseFile(File file) {
        XMLParser p = new XMLParser();
        XMLDoc d = p.parseFile(file);
        return d;
    }

    public static XMLDoc parseURL(String url, BodyPart bp) {
        XMLParser p = new XMLParser();
        InputStream inStream = UrlUtil.getURLInputStream(url, bp);
        File f = UrlUtil.urlToFile(url);
        XMLDoc d = p.parseStream(inStream);
        if (d != null) {
            d = new XMLDoc(d.getMemberDocument());
            if (f != null && f.canRead()) {
                d.setOriginalFileName(f.getAbsolutePath());
            } else {
                String fn = UrlUtil.urlToFileName(url);
                d.setOriginalFileName(fn);
            }
        }
        return d;
    }

    public void copyMeta(XMLDoc dMine) {
        this.setBodyPart(dMine.getBodyPart());
        this.setZipReader(dMine.getZipReader());
        this.setOriginalFileName(dMine.getOriginalFileName());
    }
}

