/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.JDFDuration;

public class JDFDurationRange
extends JDFRange {
    private JDFDuration m_left = null;
    private JDFDuration m_right = null;

    public JDFDurationRange() {
        this.init(new JDFDuration(0), new JDFDuration(0));
    }

    public JDFDurationRange(JDFDuration x) {
        this.init(x, x);
    }

    public JDFDurationRange(JDFDuration xmin, JDFDuration xmax) {
        this.init(xmin, xmax);
    }

    public JDFDurationRange(JDFDurationRange r) {
        this.init(r.getLeft(), r.getRight());
    }

    protected void init(JDFDuration xmin, JDFDuration xmax) {
        this.setLeft(xmin);
        this.setRight(xmax);
    }

    public JDFDurationRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFDurationRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = new JDFDuration(strArray[0].trim());
                this.m_right = new JDFDuration(strArray[0].trim());
            } else {
                this.m_left = new JDFDuration(strArray[0].trim());
                this.m_right = new JDFDuration(strArray[1].trim());
            }
        }
        catch (DataFormatException e) {
            throw new DataFormatException("JDFDurationRange illegal string: " + s);
        }
    }

    public String toString() {
        if (this.m_left.equals(this.m_right)) {
            return this.m_left.getDurationISO();
        }
        return this.m_left.getDurationISO() + " ~ " + this.m_right.getDurationISO();
    }

    public boolean isValid(String s) {
        try {
            new JDFDurationRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public boolean inRange(JDFDuration x) {
        JDFDuration min = this.getLowerValue();
        JDFDuration max = this.getUpperValue();
        return !(!x.isLonger(min) && !x.equals(min) || !x.isShorter(max) && !x.equals(max));
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFDurationRange r = (JDFDurationRange)ra;
        JDFDuration min = this.getLowerValue();
        JDFDuration r_min = r.getLowerValue();
        JDFDuration max = this.getUpperValue();
        JDFDuration r_max = r.getUpperValue();
        return !(!r_min.isLonger(min) && !r_min.equals(min) || !r_max.isShorter(max) && !r_max.equals(max));
    }

    public JDFDuration getLeft() {
        return this.m_left;
    }

    public JDFDuration getRight() {
        return this.m_right;
    }

    public void setLeft(JDFDuration x) {
        this.m_left = x;
    }

    public void setRight(JDFDuration x) {
        this.m_right = x;
    }

    public JDFDuration getUpperValue() {
        return this.m_left.isShorter(this.m_right) || this.m_left.equals(this.m_right) ? this.m_right : this.m_left;
    }

    public JDFDuration getLowerValue() {
        return this.m_left.isShorter(this.m_right) ? this.m_left : this.m_right;
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((JDFDuration)other);
    }
}

