/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerList
extends JDFNumList {
    @Override
    public boolean isValidString(String st) {
        VString v = StringUtil.tokenize(st, null, false);
        if (v != null) {
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                String s = v.stringAt(i);
                if (StringUtil.isInteger(s)) continue;
                return false;
            }
        }
        return true;
    }

    public JDFIntegerList() {
    }

    public JDFIntegerList(String s) throws DataFormatException {
        super(s);
    }

    @Deprecated
    public static JDFIntegerList getIntegerList(String s) {
        return JDFIntegerList.createIntegerList(s);
    }

    public static JDFIntegerList createIntegerList(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return new JDFIntegerList(s);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public JDFIntegerList(JDFIntegerList il) throws DataFormatException {
        super(il);
    }

    public JDFIntegerList(int[] iArray) {
        this.setIntArray(iArray);
    }

    public JDFIntegerList(int i) {
        this.setInt(i);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i) instanceof Integer) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public boolean contains(int d) {
        return this.contains((Object)d);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.toString().equals(((JDFIntegerList)other).toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Deprecated
    public void addIntegerList(JDFIntegerList il) {
        this.addAll(il);
    }

    public void add(int x) {
        this.add(Integer.valueOf(x));
    }

    @Deprecated
    public void add(JDFIntegerList il) {
        this.addAll(il);
    }

    public void add(String s) throws DataFormatException {
        StringTokenizer sToken = new StringTokenizer(s, " ");
        while (sToken.hasMoreTokens()) {
            if (StringUtil.isInteger(s)) {
                int i = StringUtil.parseInt(sToken.nextToken(), 0);
                this.add(Integer.valueOf(i));
                continue;
            }
            throw new DataFormatException("Bad integer: " + s);
        }
    }

    public int getInt(int pos) {
        Integer i;
        if (pos < 0) {
            pos += this.size();
        }
        if ((i = (Integer)this.elementAt(pos)) == null) {
            throw new JDFException("JDFIntegerList:getInt invalid index");
        }
        return i;
    }

    public void setInt(int pos, int val) {
        if (pos < 0) {
            pos += this.size();
        }
        if (pos == this.size()) {
            this.add(val);
        } else {
            if (pos > this.size()) {
                throw new JDFException("JDFIntegerList:setInt invalid index:" + pos);
            }
            this.set(pos, Integer.valueOf(val));
        }
    }

    @Override
    public JDFIntegerList scale(double factor) {
        int[] a = this.getIntArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = (int)((double)a[n] * factor);
        }
        this.setIntArray(a);
        return this;
    }

    @Override
    public int[] getIntArray() {
        int size = this.size();
        int[] intArray = new int[size];
        for (int i = 0; i < size; ++i) {
            intArray[i] = this.getInt(i);
        }
        return intArray;
    }

    public void setIntArray(int[] iArray) {
        this.clear();
        for (int i = 0; i < iArray.length; ++i) {
            this.add(Integer.valueOf(iArray[i]));
        }
    }

    public void setInt(int i) {
        this.clear();
        this.add(Integer.valueOf(i));
    }

    @Override
    public JDFNumList abs() {
        int[] a = this.getIntArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.abs(a[i]);
        }
        this.setIntArray(a);
        return this;
    }

    @Override
    public void subtract(JDFNumList l) {
        if (l == null || this.size() != l.size()) {
            return;
        }
        int[] me = this.getIntArray();
        int[] them = l.getIntArray();
        for (int i = 0; i < me.length; ++i) {
            int n = i;
            me[n] = me[n] - them[i];
            this.setElementAt(me[i], i);
        }
    }
}

