/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.util.HashUtil;

public class JDFShapeRange
extends JDFRange {
    private JDFShape m_left = null;
    private JDFShape m_right = null;

    public JDFShapeRange() {
        this.init(null, null);
    }

    public JDFShapeRange(JDFShape x) {
        this.init(x, x);
    }

    public JDFShapeRange(JDFShape xmin, JDFShape xmax) {
        this.init(xmin, xmax);
    }

    public JDFShapeRange(JDFShapeRange r) {
        this.init(r.getLeft(), r.getRight());
    }

    protected void init(JDFShape x, JDFShape y) {
        this.m_left = x;
        this.m_right = y;
    }

    public JDFShapeRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFShapeRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = new JDFShape(strArray[0].trim());
                this.m_right = new JDFShape(strArray[0].trim());
            } else {
                this.m_left = new JDFShape(strArray[0].trim());
                this.m_right = new JDFShape(strArray[1].trim());
            }
        }
        catch (DataFormatException e) {
            throw new DataFormatException("JDFShapeRange illegal string: " + s);
        }
    }

    public String toString() {
        if (this.m_left.equals(this.m_right)) {
            return "" + this.getLeft();
        }
        return this.getLeft() + " ~ " + this.getRight();
    }

    public boolean isValid(String s) {
        try {
            new JDFShapeRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFShapeRange range = (JDFShapeRange)other;
        return this.getLeft().equals(range.getLeft()) && this.getRight().equals(range.getRight());
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public boolean inRange(JDFShape x) {
        JDFShape min = this.getLowerValue();
        JDFShape max = this.getUpperValue();
        return x.isGreaterOrEqual(min) && x.isLessOrEqual(max);
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFShapeRange r = (JDFShapeRange)ra;
        JDFShape min = this.getLowerValue();
        JDFShape r_min = r.getLowerValue();
        JDFShape max = this.getUpperValue();
        JDFShape r_max = r.getUpperValue();
        return r_min.isGreaterOrEqual(min) && r_max.isLessOrEqual(max);
    }

    public JDFShape getLeft() {
        return this.m_left;
    }

    public JDFShape getRight() {
        return this.m_right;
    }

    public void setLeft(JDFShape x) {
        this.m_left = x;
    }

    public void setRight(JDFShape x) {
        this.m_right = x;
    }

    public JDFShape getUpperValue() {
        return this.m_left.isLessOrEqual(this.m_right) ? this.m_right : this.m_left;
    }

    public JDFShape getLowerValue() {
        return this.m_left.isLess(this.m_right) ? this.m_left : this.m_right;
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((JDFShape)other);
    }
}

