/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripCellParams;

class PostXJDFWalker
extends BaseElementWalker {
    public boolean mergeLayout = true;
    protected JDFElement newRoot;
    public boolean bIntentPartition = false;
    public boolean bDeliveryIntent = true;

    public PostXJDFWalker(JDFElement newRoot) {
        super(new BaseWalkerFactory());
        this.newRoot = newRoot;
    }

    protected class WalkXJDF
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("XJDF");
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.reorderSets((JDFElement)xjdf);
            super.walk(xjdf, dummy);
            return xjdf;
        }

        private void reorderSets(JDFElement xjdf) {
            Vector<SetHelper> v = new XJDFHelper(xjdf).getSets();
            if (v == null) {
                return;
            }
            int n = v.size();
            int j = 0;
            while (n > 0) {
                for (int i = 0; i < v.size(); ++i) {
                    KElement e;
                    SetHelper setHelper = v.get(i);
                    KElement kElement = e = setHelper == null ? null : setHelper.getSet();
                    if (e == null) continue;
                    JDFIntegerList lcpi = null;
                    String cpi = e.getAttribute("CombinedProcessIndex", null, null);
                    try {
                        lcpi = cpi == null ? null : new JDFIntegerList(cpi);
                    }
                    catch (DataFormatException dfe) {
                        // empty catch block
                    }
                    if (lcpi == null || lcpi.contains(j)) {
                        v.set(i, null);
                        e.removeAttribute("CombinedProcessIndex");
                        --n;
                        continue;
                    }
                    xjdf.moveElement(e, null);
                }
                ++j;
            }
        }
    }

    protected class WalkResourceElement
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            KElement parent = toCheck.getParentNode_KElement();
            if (parent == null) {
                return false;
            }
            return "Resource".equals(parent.getLocalName()) || "Parameter".equals(parent.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement ret = super.walk(xjdf, dummy);
            xjdf.eraseEmptyNodes(true);
            if (xjdf.getFirstChild() == null && xjdf.getAttributeMap().size() == 0) {
                xjdf.deleteNode();
                return null;
            }
            return ret;
        }
    }

    protected class WalkIntentSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("IntentSet");
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = xjdf.getElement("Intent");
            if (!PostXJDFWalker.this.bIntentPartition && intent != null) {
                intent.copyAttribute("ID", xjdf);
                intent.copyAttribute("Name", xjdf);
                xjdf.getParentNode_KElement().moveElement(intent, xjdf);
                xjdf.deleteNode();
            } else {
                super.walk(xjdf, dummy);
            }
            return intent;
        }
    }

    public class WalkDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "DeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(xjdf.getDeepParent("XJDF", 0));
                SetHelper delResHelper = h.getCreateSet("Parameter", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                PartitionHelper ph = delResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                dp.setFromDeliveryIntent((JDFDeliveryIntent)intent.getElement("DeliveryIntent"));
            }
            return intent;
        }
    }

    public class WalkArtDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "ArtDeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(xjdf.getDeepParent("XJDF", 0));
                SetHelper artDelResHelper = h.getCreateSet("Parameter", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                PartitionHelper ph = artDelResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                dp.setFromArtDelivery((JDFArtDeliveryIntent)intent.getElement("ArtDeliveryIntent"));
            }
            return intent;
        }
    }

    protected class WalkStrippingSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("ParameterSet") && "StrippingParams".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (PostXJDFWalker.this.mergeLayout) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    protected class WalkStrippingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }

        @Override
        public KElement walk(KElement strippingParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(strippingParams, dummy);
                return strippingParams;
            }
            XJDFHelper h = new XJDFHelper(PostXJDFWalker.this.newRoot);
            SetHelper layoutseth = h.getCreateSet("Parameter", "Layout", JDFResourceLink.EnumUsage.Input);
            VJDFAttributeMap vmap = new PartitionHelper(strippingParams.getParentNode_KElement()).getPartMapVector();
            JDFAttributeMap map = vmap.size() == 0 ? null : vmap.get(0);
            map = this.mergeStrippingParamsLayout((JDFStrippingParams)strippingParams, layoutseth, map);
            this.mergeSurfaces(map);
            super.walk(strippingParams, dummy);
            return null;
        }

        private JDFAttributeMap mergeStrippingParamsLayout(JDFStrippingParams strippingParams, SetHelper layoutseth, JDFAttributeMap map) {
            String bsName = map.remove("BinderySignatureName");
            String cellIndex = map.remove("CellIndex");
            PartitionHelper layoutPartitionH = layoutseth.getCreatePartition(map, true);
            KElement layoutPartition = layoutPartitionH.getResource();
            JDFBinderySignature bsOld = (JDFBinderySignature)layoutPartition.getChildWithAttribute("BinderySignature", "BinderySignatureName", null, bsName, 0, true);
            VElement childElementVector = strippingParams.getChildElementVector("SignatureCell", null);
            if (childElementVector != null) {
                for (KElement kid : childElementVector) {
                    JDFStripCellParams scp = (JDFStripCellParams)kid;
                    scp.setAttribute("CellIndex", cellIndex);
                }
            }
            if (bsOld != null) {
                this.moveStripCells(bsOld, childElementVector);
            } else {
                JDFBinderySignature bs = (JDFBinderySignature)strippingParams.getElement("BinderySignature");
                if (bs != null) {
                    bs.setBinderySignatureName(bsName);
                    bs.moveElements(strippingParams.getChildElementVector("Position", null), null);
                    this.moveStripCells(bs, childElementVector);
                    this.moveBSFromStripping(bs, strippingParams);
                }
                layoutPartition.copyInto(strippingParams, false);
            }
            return map;
        }

        private void moveBSFromStripping(JDFBinderySignature bs, JDFStrippingParams strippingParams) {
            if (strippingParams == null || bs == null) {
                return;
            }
            bs.moveAttribute("AssemblyID", bs, "AssemblyIDs", null, null);
            bs.moveAttribute("JobID", bs);
            bs.moveAttribute("InnermostShingling", bs);
            bs.moveAttribute("OutermostShingling", bs);
        }

        private void moveStripCells(JDFBinderySignature bindSig, VElement childElementVector) {
            if (childElementVector == null) {
                return;
            }
            for (KElement sigCell : childElementVector) {
                String cellindex = sigCell.getAttribute("CellIndex", null, null);
                JDFIntegerList il = JDFIntegerList.createIntegerList(cellindex);
                Vector<JDFSignatureCell> vbsCell = this.getSigCellForIndex(bindSig, il);
                sigCell.removeAttribute("CellIndex");
                if (vbsCell != null) {
                    for (JDFSignatureCell bsCell : vbsCell) {
                        bsCell.mergeElement(sigCell, false);
                    }
                }
                sigCell.deleteNode();
            }
        }

        private Vector<JDFSignatureCell> getSigCellForIndex(JDFBinderySignature bindSig, JDFIntegerList il) {
            Vector<JDFSignatureCell> v = bindSig.getChildrenByClass(JDFSignatureCell.class, true, 0);
            Vector<JDFSignatureCell> vRet = new Vector<JDFSignatureCell>();
            if (v == null || v.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            } else {
                for (JDFSignatureCell sc : v) {
                    if (!this.matchesIndex(sc, il)) continue;
                    vRet.add(sc);
                }
            }
            if (vRet.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            }
            return vRet;
        }

        private boolean matchesIndex(JDFSignatureCell sc, JDFIntegerList il) {
            if (il == null) {
                return true;
            }
            try {
                il = new JDFIntegerList(il);
            }
            catch (DataFormatException e) {
                return false;
            }
            il.scale(2.0);
            JDFIntegerList fp = sc.getFrontPages();
            return il.contains(fp);
        }

        private void mergeSurfaces(JDFAttributeMap map) {
        }
    }

    protected class WalkStripCellParams
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStripCellParams;
        }

        @Override
        public KElement walk(KElement stripCellParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(stripCellParams, dummy);
                return stripCellParams;
            }
            stripCellParams.renameElement("SignatureCell", null);
            super.walk(stripCellParams, dummy);
            return stripCellParams;
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(PostXJDFWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf.hasAttribute("xmlns")) {
                xjdf.removeAttribute("xmlns");
            }
            if (xjdf.getNamespaceURI().equals(JDFElement.getSchemaURL())) {
                xjdf.setNamespaceURI(XJDF20.getSchemaURL());
            }
            return xjdf;
        }
    }
}

