/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.cip4.jdflib.auto.JDFAutoGeneralID;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.extensions.PostXJDFWalker;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueEntryDef;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFSpawned;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFCreasingParams;
import org.cip4.jdflib.resource.JDFCuttingParams;
import org.cip4.jdflib.resource.JDFInterpretingParams;
import org.cip4.jdflib.resource.JDFMarkObject;
import org.cip4.jdflib.resource.JDFMerged;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFDevCap;
import org.cip4.jdflib.resource.devicecapability.JDFDevCapPool;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFColorControlStrip;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFContainer;
import org.cip4.jdflib.resource.process.JDFContentObject;
import org.cip4.jdflib.resource.process.JDFDependencies;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.JDFSeparationSpec;
import org.cip4.jdflib.resource.process.postpress.JDFFoldingParams;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.Node;

public class XJDF20
extends BaseElementWalker {
    public static final String rootName = "XJDF";
    public static final String rootJMF = "JMF";
    private final String m_spawnInfo = "SpawnInfo";
    private boolean trackAudits;
    protected VString resAttribs;
    protected KElement newRoot = null;
    protected JDFNode oldRoot = null;
    protected boolean walkingProduct = false;
    protected Set<String> first = new HashSet<String>();
    public boolean bMergeLayout = true;
    public boolean bMergeLayoutPrep = true;
    public boolean bMergeRunList = true;
    public boolean bRetainSpawnInfo = false;
    public boolean bSingleNode = true;
    private boolean bUpdateVersion = true;
    public boolean bTypeSafeMessage = true;
    public boolean bAbstractMessage = true;
    public boolean bSpanAsAttribute = true;
    public boolean bIntentPartition = false;
    public boolean bHTMLColor = false;
    public boolean bConvertTilde = false;

    public XJDF20() {
        super(new BaseWalkerFactory());
        KElement.uniqueID(-1000);
        this.trackAudits = true;
        this.init();
    }

    public void setTrackAudits(boolean trackAudits) {
        this.trackAudits = trackAudits;
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(2, 0);
    }

    public KElement convert(KElement root) {
        if (root instanceof JDFJMF) {
            return this.makeNewJMF((JDFJMF)root);
        }
        if (root instanceof JDFNode) {
            return this.makeNewJDF((JDFNode)root, null);
        }
        return null;
    }

    public KElement makeNewJMF(JDFJMF jmf) {
        JDFJMF root = (JDFJMF)jmf.cloneNewDoc();
        this.prepareNewDoc(true);
        this.walkTree(root, this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
        this.postWalk();
        return this.newRoot;
    }

    public KElement makeNewJDF(JDFNode node, VJDFAttributeMap vMap) {
        JDFNode root = (JDFNode)node.getJDFRoot().cloneNewDoc();
        if (this.trackAudits) {
            root.getCreateAuditPool().addCreated("XJDF Converter", null);
        }
        FixVersion vers = new FixVersion(JDFElement.EnumVersion.Version_1_4);
        vers.setLayoutPrepToStripping(this.bMergeLayoutPrep);
        vers.walkTree(root, null);
        String id = StringUtil.getNonEmpty(node.getID());
        JDFNode jDFNode = this.oldRoot = id == null ? root : (JDFNode)root.getChildWithAttribute(null, "ID", null, id, 0, false);
        if (this.oldRoot == null) {
            this.oldRoot = root;
        }
        this.walkingProduct = false;
        this.prepareNewDoc(false);
        this.loopNodes(this.oldRoot);
        this.walkingProduct = true;
        KElement productList = this.newRoot.appendElement("ProductList");
        this.prepareRoot(root);
        this.walkTree(root, productList);
        if (productList.getElement("Product") == null) {
            productList.deleteNode();
        }
        this.walkingProduct = false;
        this.postWalk();
        this.newRoot.getOwnerDocument_KElement().copyMeta(node.getOwnerDocument_KElement());
        return this.newRoot;
    }

    private void postWalk() {
        PostXJDFWalker pw = new PostXJDFWalker((JDFElement)this.newRoot);
        pw.mergeLayout = this.bMergeLayout;
        pw.bIntentPartition = this.bIntentPartition;
        pw.walkTreeKidsFirst(this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
    }

    private void prepareRoot(JDFNode node) {
        if (node != null) {
            node.ensureLink(node.getInheritedCustomerInfo(null), JDFResourceLink.EnumUsage.Input, null);
            node.ensureLink(node.getInheritedNodeInfo(null), JDFResourceLink.EnumUsage.Input, null);
        }
    }

    private void loopNodes(JDFNode node) {
        this.walkTree(node, this.newRoot);
    }

    private void prepareNewDoc(boolean bJMF) {
        JDFDoc newDoc = new JDFDoc(bJMF ? rootJMF : rootName);
        newDoc.setInitOnCreate(false);
        this.newRoot = newDoc.getRoot();
        this.newRoot.setNamespaceURI(XJDF20.getSchemaURL());
        this.first = new HashSet<String>();
    }

    private void init() {
        this.resAttribs = this.generateResourceAttributes();
    }

    protected VString generateResourceAttributes() {
        VString resAttribs = new VString();
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
        JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
        JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
        JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
        resAttribs = paramRes.knownAttributes();
        resAttribs.appendUnique(physRes.knownAttributes());
        resAttribs.appendUnique(intRes.knownAttributes());
        resAttribs.appendUnique(part.knownAttributes());
        return resAttribs;
    }

    public String getClassName(String name) {
        if (name == null) {
            return null;
        }
        KElement e = new JDFDoc(name).getRoot();
        String className = e instanceof JDFResource ? this.getClassName((JDFResource)e) : null;
        return className;
    }

    public String getClassName(JDFResource r) {
        KElement r2;
        if (r == null) {
            return null;
        }
        JDFResource.EnumResourceClass resourceClass = r.getResourceClass();
        if (resourceClass == null && (r2 = new JDFDoc(r.getLocalName()).getRoot()) instanceof JDFResource) {
            r2.init();
            resourceClass = ((JDFResource)r2).getResourceClass();
        }
        if (resourceClass == null) {
            return "Parameter";
        }
        String className = "Resource";
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.Parameter) || resourceClass.equals((Object)JDFResource.EnumResourceClass.Intent)) {
            className = resourceClass.getName();
        }
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.PlaceHolder)) {
            return null;
        }
        return className;
    }

    public static String getExtension() {
        return rootName.toLowerCase();
    }

    public void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        File file = new File(fileName);
        if (file.canRead()) {
            if (replace) {
                file.delete();
            } else {
                throw new JDFException("output file exists: " + file.getPath());
            }
        }
        try {
            VElement v = rootNode.getvJDFNode(null, null, false);
            FileOutputStream fos = new FileOutputStream(fileName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < v.size(); ++i) {
                JDFNode n = (JDFNode)v.elementAt(i);
                String nam = n.getJobPartID(false);
                if (nam == "") {
                    nam = "Node" + i;
                }
                try {
                    nam = nam + ".XJDF";
                    ZipEntry ze = new ZipEntry(nam);
                    zos.putNextEntry(ze);
                    KElement newRootL = this.makeNewJDF(n, null);
                    newRootL.getOwnerDocument_KElement().write2Stream(zos, 2, true);
                    zos.closeEntry();
                    continue;
                }
                catch (ZipException x) {
                    x.printStackTrace();
                    continue;
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            zos.close();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    void setAmountPool(JDFElement rl, KElement newLeaf, JDFAttributeMap partMap) {
        if (rl == null) {
            return;
        }
        JDFAmountPool ap = (JDFAmountPool)rl.getElement("AmountPool");
        if (ap == null) {
            if (rl.hasAttribute("Amount") || rl.hasAttribute("ActualAmount") || rl.hasAttribute("MaxAmount")) {
                newLeaf.setAttribute("AmountGood", rl.getAttribute("Amount", null, null));
                newLeaf.setAttribute("ActualAmountGood", rl.getAttribute("ActualAmount", null, null));
                newLeaf.setAttribute("MaxAmountGood", rl.getAttribute("MaxAmount", null, null));
            }
        } else {
            VElement vPartAmounts = ap.getMatchingPartAmountVector(partMap);
            if (vPartAmounts != null) {
                for (int i = 0; i < vPartAmounts.size(); ++i) {
                    JDFPartAmount pa = (JDFPartAmount)vPartAmounts.item(i);
                    JDFAttributeMap map = pa.getPartMap();
                    if (partMap != null) {
                        map.removeKeys(partMap.keySet());
                    }
                    if (map.isEmpty()) {
                        newLeaf.setAttribute("AmountGood", pa.getAttribute("Amount", null, null));
                        newLeaf.setAttribute("ActualAmountGood", pa.getAttribute("ActualAmount", null, null));
                        newLeaf.setAttribute("MaxAmountGood", pa.getAttribute("MaxAmount", null, null));
                        continue;
                    }
                    if (map.size() == 1 && map.containsKey("Condition")) {
                        JDFAttributeMap attMap = pa.getAttributeMap();
                        Iterator<String> it = attMap.getKeyIterator();
                        String condition = map.get("Condition");
                        while (it.hasNext()) {
                            String key = it.next();
                            if (key.indexOf("Amount") >= 0) {
                                newLeaf.setAttribute(key + condition, attMap.get(key));
                                continue;
                            }
                            newLeaf.setAttribute(key, attMap.get(key));
                        }
                        continue;
                    }
                    KElement amountPool = newLeaf.getCreateElement("AmountPool");
                    pa = (JDFPartAmount)amountPool.copyElement(pa, null);
                    pa.setPartMap(map);
                }
            }
        }
    }

    private KElement setBaseResource(JDFElement rl, JDFResource r, KElement xjdfSet) {
        JDFAttributeMap map = r.getPartMap();
        SetHelper sh = new SetHelper(xjdfSet);
        KElement newLeaf = sh.getCreatePartition(map, false).getPartition();
        this.setLeafAttributes(r, rl, newLeaf);
        return newLeaf;
    }

    private void setLeafAttributes(JDFResource leaf, JDFElement rl, KElement newLeaf) {
        JDFAttributeMap partMap = leaf.getPartMap();
        this.setAmountPool(rl, newLeaf, partMap);
        if (this.bRetainSpawnInfo && leaf.hasAttribute("SpawnIDs")) {
            KElement spawnInfo = newLeaf.getDocRoot().getCreateElement("SpawnInfo", null, 0);
            KElement spawnID = spawnInfo.appendElement("SpawnID");
            spawnID.moveAttribute("SpawnIDs", newLeaf, null, null, null);
            spawnID.moveAttribute("SpawnStatus", newLeaf, null, null, null);
            spawnID.copyAttribute("ResourceID", newLeaf, "ID", null, null);
        }
    }

    private void setSetAttributes(KElement resourceSet, KElement rl, JDFResource linkRoot) {
        resourceSet.setAttribute("Name", linkRoot.getNodeName());
        resourceSet.setAttributes(rl);
        resourceSet.removeAttribute("rRef");
        resourceSet.removeAttribute("rSubRef");
        resourceSet.removeAttribute("Amount");
        resourceSet.removeAttribute("AmountProduced");
        resourceSet.removeAttribute("MaxAmount");
        resourceSet.removeAttribute("ActualAmount");
        if (rl instanceof JDFResourceLink) {
            VElement vCreators;
            JDFResource resInRoot;
            JDFResourceLink resLink = (JDFResourceLink)rl;
            JDFNode rootIn = resLink.getJDFRoot();
            JDFResource jDFResource = resInRoot = rootIn == null ? linkRoot : (JDFResource)rootIn.getChildWithAttribute(null, "ID", null, resLink.getrRef(), 0, false);
            if (resInRoot != null && (vCreators = resInRoot.getCreator(JDFResourceLink.EnumUsage.Input.equals((Object)resLink.getUsage()))) != null) {
                int size = vCreators.size();
                for (int i = 0; i < size; ++i) {
                    JDFNode depNode = (JDFNode)vCreators.elementAt(i);
                    KElement dependent = resourceSet.appendElement("Dependent");
                    dependent.setAttribute("JobID", depNode.getJobID(true));
                    dependent.copyAttribute("JMFURL", depNode, null, null, null);
                    dependent.copyAttribute("JobPartID", depNode, null, null, null);
                }
            }
        }
    }

    protected VElement setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        VElement v = new VElement();
        String className = this.getClassName(linkTarget);
        if (className == null) {
            return null;
        }
        linkTarget.expand(false);
        String resID = linkTarget.getAttribute("ID");
        KElement resourceSet = xRoot.getChildWithAttribute(className + "Set", "ID", null, resID, 0, true);
        if (resourceSet == null) {
            resourceSet = xRoot.appendElement(className + "Set");
            resourceSet.setAttribute("ID", linkTarget.getID());
        }
        this.setSetAttributes(resourceSet, rl, linkTarget);
        int nLeaves = resourceSet.numChildElements(className, null);
        VElement vRes = rl instanceof JDFResourceLink ? ((JDFResourceLink)rl).getTargetVector(0) : linkTarget.getLeaves(false);
        for (int j = 0; j < vRes.size(); ++j) {
            JDFResource r = (JDFResource)vRes.elementAt(j);
            VElement vLeaves = r.getLeaves(false);
            for (int k = 0; k < vLeaves.size(); ++k) {
                JDFResource leaf = (JDFResource)vLeaves.elementAt(k);
                KElement newBaseRes = this.setBaseResource(rl, leaf, resourceSet);
                int nn = resourceSet.numChildElements(className, null);
                if (nn > nLeaves) {
                    nLeaves = nn;
                    this.walkTree(leaf, newBaseRes);
                }
                v.add(newBaseRes);
            }
        }
        return v;
    }

    protected static VJDFAttributeMap getPartMapVector(KElement res) {
        VJDFAttributeMap omaMaps = null;
        VElement parts = res.getChildElementVector("Part", null, null, true, 0, false);
        if (parts != null && parts.size() > 0) {
            omaMaps = new VJDFAttributeMap();
            for (int i = 0; i < parts.size(); ++i) {
                omaMaps.add(((JDFPart)parts.get(i)).getPartMap());
            }
        }
        return omaMaps;
    }

    public void retainAll() {
        this.bUpdateVersion = false;
        this.bHTMLColor = false;
        this.bMergeLayout = false;
        this.bIntentPartition = false;
        this.bSpanAsAttribute = false;
        this.bMergeLayoutPrep = false;
        this.bMergeRunList = false;
        this.bTypeSafeMessage = false;
        this.bRetainSpawnInfo = true;
    }

    public void setUpdateVersion(boolean bUpdateVersion) {
        this.bUpdateVersion = bUpdateVersion;
    }

    public boolean isUpdateVersion() {
        return this.bUpdateVersion;
    }

    public class WalkEvaluation
    extends WalkDevcapElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFEvaluation dc = (JDFEvaluation)e;
            VString v = this.getXPathVector(dc, null);
            if (v != null) {
                for (String path : v) {
                    KElement eval = trackElem.appendElement(e.getLocalName());
                    eval.setAttributes(e);
                    eval.setAttribute("XPath", StringUtil.token(path, -1, "/"));
                    eval.setAttribute("XPathRoot", StringUtil.replaceToken(path, -1, "/", null));
                    eval.removeAttribute("rRef");
                }
            }
            return trackElem;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFEvaluation;
        }
    }

    public class WalkState
    extends WalkDevcapElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFAbstractState st = (JDFAbstractState)e;
            VString v = this.getXPathVector(st, null);
            String name = st.getName();
            String stateName = st.getLocalName();
            KElement eStateFirst = null;
            for (String path : v) {
                KElement eState = trackElem.getChildWithAttribute(stateName, "XPath", null, "@" + name, 0, true);
                if (eState == null) {
                    eState = trackElem.appendElement(stateName);
                    String xPathRoot = this.getXPathRoot(path, null);
                    if (XJDF20.this.resAttribs.contains(name) && xPathRoot.contains("Set/")) {
                        xPathRoot = StringUtil.replaceToken(xPathRoot, -1, "/", null);
                    }
                    eState.setAttributes(e);
                    eState.setAttribute("XPathRoot", xPathRoot);
                    eState.setAttribute("XPath", "@" + name);
                    eState.removeAttribute("Name");
                }
                if (eStateFirst != null) continue;
                eStateFirst = eState;
            }
            return eStateFirst;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAbstractState;
        }
    }

    protected class WalkDevcapElement
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return trackElem;
        }

        protected String getXPathRoot(String path, String old) {
            if (path == null || "/".equals(path) || "".equals(path)) {
                return path;
            }
            String rootPath = StringUtil.replaceToken(path, -1, "/", null);
            return rootPath;
        }

        protected VString getXPathVector(JDFElement dc, String name) {
            VString v = null;
            if (dc instanceof JDFDevCap) {
                v = ((JDFDevCap)dc).getNamePathVector();
            } else if (dc instanceof JDFAbstractState) {
                v = ((JDFAbstractState)dc).getNamePathVector();
            } else if (dc instanceof JDFEvaluation) {
                ICapabilityElement refTarget = ((JDFEvaluation)dc).getRefTarget();
                v = refTarget != null ? refTarget.getNamePathVector() : null;
            }
            if (v != null && v.size() > 0) {
                VString v2 = new VString();
                for (String s : v) {
                    s = this.modifyXPath(s);
                    v2.add(s);
                }
                v = v2;
                v.unify();
            }
            return v;
        }

        public String modifyXPath(String s) {
            VString vs = StringUtil.tokenize(s, "/", false);
            for (int i = vs.size() - 2; i >= 0; --i) {
                if (!vs.elementAt(i).equals(vs.elementAt(i + 1))) continue;
                vs.remove(i + 1);
            }
            int posJMF = vs.indexOf(XJDF20.rootJMF);
            while (posJMF-- > 0) {
                vs.remove(0);
            }
            if (vs.size() == 0) {
                s = "/";
            } else {
                if ("JDF".equals(vs.get(0))) {
                    vs.set(0, XJDF20.rootName);
                }
                if (vs.size() > 1 && "ResourcePool".equals(vs.get(1))) {
                    String name;
                    String className = null;
                    if (vs.size() == 3 && (className = XJDF20.this.getClassName(name = vs.get(2))) != null) {
                        if ("Intent".equals(className)) {
                            vs.set(1, "ProductList/Product");
                        } else {
                            vs.set(1, className + "Set/" + className);
                        }
                    }
                    if (className == null) {
                        vs.remove(1);
                        vs.remove(0);
                    }
                }
                if (!(s = StringUtil.setvString(vs, "/", "/", null)).startsWith("/XJDF")) {
                    s = "/" + s;
                }
            }
            return s;
        }

        @Override
        public boolean matches(KElement e) {
            return false;
        }
    }

    public class WalkDeviceCap
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            KElement e2 = super.walk(e, trackElem);
            e2.removeAttribute("CombinedMethod");
            e2.removeAttribute("GenericAttributes");
            return e2;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDeviceCap;
        }
    }

    public class WalkDevCap
    extends WalkDevcapElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFDevCap dc = (JDFDevCap)e;
            String name = dc.getName();
            VString v = this.getXPathVector(dc, name);
            for (String path : v) {
                name = StringUtil.token(path, -1, "/");
                KElement eState = trackElem.getChildWithAttribute("ElementState", "XPath", null, name, 0, true);
                if (eState != null) continue;
                eState = trackElem.appendElement("ElementState");
                eState.setAttribute("XPathRoot", this.getXPathRoot(path, null));
                eState.setAttribute("XPath", name);
                eState.setAttributes(e);
                eState.removeAttribute("DevCapRef");
                eState.removeAttribute("Name");
                eState.removeAttribute("DevCapRefs");
            }
            return trackElem;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDevCap;
        }
    }

    public class WalkResourceInfo
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFResourceInfo ri = (JDFResourceInfo)jdf;
            KElement eNew = xjdf.copyElement(jdf, null);
            eNew.removeChildren(null, null, null);
            VElement vr = ((JDFResourceInfo)jdf).getChildElementVector(null, null);
            int nRes = 0;
            for (int i = 0; i < vr.size(); ++i) {
                if (!(vr.get(i) instanceof JDFResource)) continue;
                JDFResource r = (JDFResource)vr.get(i);
                if (nRes == 0) {
                    XJDF20.this.setResource(ri, r, eNew);
                } else {
                    XJDF20.this.setResource(null, r, eNew);
                }
                r.deleteNode();
                ++nRes;
            }
            return eNew;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceInfo;
        }
    }

    public class WalkMessage
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFMessage m = (JDFMessage)jdf;
            if (XJDF20.this.bTypeSafeMessage) {
                this.makeTypesafe(m);
            }
            return super.walk(jdf, xjdf);
        }

        void makeTypesafe(JDFMessage m) {
            String type = this.getMessageType(m);
            JDFMessage.EnumFamily family = this.getNewFamily(m);
            if (family == null) {
                this.log.error((Object)"cannot convert message with null family");
            } else {
                m.renameElement(family.getName() + type, null);
            }
        }

        String getMessageType(JDFMessage m) {
            String type = m.getType();
            return type;
        }

        private JDFMessage.EnumFamily getNewFamily(JDFMessage m) {
            JDFMessage.EnumFamily family = m.getFamily();
            if (XJDF20.this.bAbstractMessage) {
                if (JDFMessage.EnumFamily.Command.equals((Object)family) || JDFMessage.EnumFamily.Registration.equals((Object)family)) {
                    family = JDFMessage.EnumFamily.Query;
                }
                if (JDFMessage.EnumFamily.Acknowledge.equals((Object)family)) {
                    family = JDFMessage.EnumFamily.Response;
                }
            }
            return family;
        }

        @Override
        protected void removeUnused(KElement newRootP) {
            super.removeUnused(newRootP);
            if (XJDF20.this.bTypeSafeMessage) {
                newRootP.removeAttribute("Type");
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFMessage;
        }
    }

    public class WalkModifyQueueEntry
    extends WalkMessage {
        @Override
        void makeTypesafe(JDFMessage m) {
            String originalType = super.getMessageType(m);
            JDFQueueEntryDef queueEntryDef = m.getQueueEntryDef(0);
            String qeid = queueEntryDef == null ? null : queueEntryDef.getQueueEntryID();
            super.makeTypesafe(m);
            KElement modifyParams = m.getCreateElement("ModifyQueueEntryParams", null, 0);
            modifyParams.setAttribute("Operation", StringUtil.leftStr(originalType, -10));
            modifyParams.setXPathAttribute("QueueFilter/@QueueEntryIDs", qeid);
        }

        @Override
        String getMessageType(JDFMessage m) {
            return "ModifyQueueEntry";
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && this.isModifyQE(toCheck.getAttribute("Type"));
        }

        boolean isModifyQE(String type) {
            return StringUtil.hasToken("AbortQueueEntry,HoldQueueEntry,RemoveQueueEntry,ResumeQueueEntry,SetQueueEntryPosition,SetQueueEntryPriority,SuspendQueueEntry", type, ",", 0);
        }
    }

    public class WalkJMF
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            if (XJDF20.this.first.contains(jdf.getID())) {
                return null;
            }
            XJDF20.this.first.add(jdf.getID());
            JDFJMF jmf = (JDFJMF)jdf;
            this.setRootAttributes(jmf, xjdf);
            return xjdf;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFJMF;
        }

        private void setRootAttributes(JDFJMF jmf, KElement newRootP) {
            newRootP.appendXMLComment("Very preliminary experimental prototype trial version: using: " + JDFAudit.getStaticAgentName() + " " + JDFAudit.getStaticAgentVersion(), null);
            newRootP.setAttributes(jmf);
            if (XJDF20.this.isUpdateVersion()) {
                newRootP.setAttribute("Version", "2.0");
                newRootP.setAttribute("MaxVersion", "2.0");
            }
            this.removeUnused(newRootP);
        }
    }

    protected class WalkLayoutElement
    extends WalkInlineAllRes {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayoutElement;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement parent = jdf.getParentNode_KElement();
            boolean bInRunList = parent instanceof JDFRunList;
            this.bMerge = bInRunList ? XJDF20.this.bMergeRunList : false;
            KElement ret = super.walk(jdf, xjdf);
            if (!bInRunList && XJDF20.this.bMergeRunList) {
                KElement retPar = ret.getDeepParent("ParameterSet", 0);
                if (retPar != null) {
                    retPar.setAttribute("Name", "RunList");
                }
                ret.renameElement("RunList", null);
            }
            return ret;
        }
    }

    protected class WalkStrippingParams
    extends WalkMediaRefByType {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement e = super.walk(jdf, xjdf);
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }
    }

    protected class WalkRunList
    extends WalkInlineAllRes {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            return super.walk(jdf, xjdf);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFRunList;
        }
    }

    protected class WalkMediaRefByType
    extends WalkResource {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            return super.walk(jdf, xjdf);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFInterpretingParams || toCheck instanceof JDFLayout || toCheck instanceof JDFStrippingParams;
        }
    }

    protected class WalkComponent
    extends WalkResource {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFComponent k = (JDFComponent)super.walk(jdf, xjdf);
            String comptype = k.getAttribute("ComponentType");
            comptype = StringUtil.replaceString(comptype, "FinalProduct", null);
            comptype = StringUtil.replaceString(comptype, "PartialProduct", null);
            k.setAttribute("ComponentType", StringUtil.getNonEmpty(comptype));
            String prodType = k.getAttribute("ProductType");
            if ("Unknown".equals(prodType)) {
                k.removeAttribute("ProductType");
            }
            return k;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComponent;
        }
    }

    protected class WalkColor
    extends WalkResource {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFColor k = (JDFColor)super.walk(jdf, xjdf);
            if (XJDF20.this.bHTMLColor) {
                k.setAttribute("HTMLColor", ((JDFColor)jdf).getHTMLColor());
            }
            k.setActualColorName(jdf.getAttribute("Separation", null, null));
            return k;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFColor;
        }
    }

    public class WalkCompany
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFCompany;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            e.renameAttribute("ProductID", "CompanyID", null, null);
            return super.walk(e, trackElem);
        }
    }

    protected class WalkInlineResource
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFEmployee;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            String descName = jdf.getAttribute("DescriptiveName", null, null);
            KElement e = super.walk(jdf, xjdf);
            if (e != null) {
                e.setAttribute("DescriptiveName", descName);
            }
            return e;
        }
    }

    protected class WalkMediaLink
    extends WalkResLink {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceLink && "MediaLink".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFResourceLink rl = (JDFResourceLink)jdf;
            JDFResource r = rl.getLinkRoot();
            if (r != null) {
                // empty if block
            }
            return super.walk(jdf, xjdf);
        }
    }

    protected class WalkColorPoolRef
    extends WalkRefElement {
        @Override
        protected void makeRefAttribute(JDFRefElement re, KElement xjdf) {
            String attName = this.getRefName(re);
            VElement v = XJDF20.this.setResource(null, re.getTarget(), XJDF20.this.newRoot);
            if (v != null && v.size() > 0) {
                KElement ref = v.get(0).getParentNode_KElement();
                xjdf.setAttribute(attName, ref.getAttribute("ID"));
            }
            re.deleteNode();
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFRefElement && "ColorPoolRef".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFRefElement rl = (JDFRefElement)jdf;
            JDFResource r = rl.getTargetRoot();
            if (r != null) {
                VElement v = r.getChildElementVector("Color", null);
                for (int i = 0; i < v.size(); ++i) {
                    v.get(i).renameAttribute("Name", "Separation", null, null);
                }
                KElement cNew = r.getParentNode_KElement().appendElement("Color");
                cNew.copyInto(r, true);
                r.deleteNode();
                cNew.setAttribute("PartIDKeys", "Separation");
                rl.renameElement("ColorRef", null);
            }
            return super.walk(jdf, xjdf);
        }
    }

    protected class WalkColorPoolLink
    extends WalkResLink {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceLink && "ColorPoolLink".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFResourceLink rl = (JDFResourceLink)jdf;
            JDFResource r = rl.getLinkRoot();
            if (r != null) {
                VElement v = r.getChildElementVector("Color", null);
                for (int i = 0; i < v.size(); ++i) {
                    v.get(i).renameAttribute("Name", "Separation", null, null);
                }
                KElement cNew = r.getParentNode_KElement().appendElement("Color");
                cNew.copyInto(r, true);
                r.deleteNode();
                cNew.setAttribute("PartIDKeys", "Separation");
                rl.renameElement("ColorLink", null);
            }
            return super.walk(jdf, xjdf);
        }
    }

    protected class WalkInlineAllRes
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFColorControlStrip || toCheck instanceof JDFCuttingParams || toCheck instanceof JDFCreasingParams || toCheck instanceof JDFFoldingParams;
        }

        @Override
        protected boolean mustInline(String refLocalName) {
            return true;
        }
    }

    protected class WalkInlineAllElement
    extends WalkJDFElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFContentObject || toCheck instanceof JDFMarkObject;
        }

        @Override
        protected boolean mustInline(String refLocalName) {
            return true;
        }
    }

    protected class WalkDependencies
    extends WalkJDFElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDependencies;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFDependencies dep = (JDFDependencies)jdf;
            VElement v = dep.getChildElementVector("LayoutElement", null);
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    JDFLayoutElement leDep = (JDFLayoutElement)v.get(i);
                    leDep.makeRootResource(null, null, true);
                    VElement v2 = XJDF20.this.setResource(null, leDep, XJDF20.this.newRoot);
                    if (v2 == null) continue;
                    for (int j = 0; j < v2.size(); ++j) {
                        xjdf.appendAttribute("Dependencies", v2.get(j).getAttribute("ID"), null, " ", true);
                    }
                }
            }
            return null;
        }
    }

    protected class WalkContainer
    extends WalkJDFElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFContainer;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFContainer cont = (JDFContainer)jdf;
            JDFFileSpec fs = cont.getFileSpec();
            if (fs != null) {
                fs.makeRootResource(null, null, true);
                VElement v = XJDF20.this.setResource(null, fs, XJDF20.this.newRoot);
                if (v != null && v.size() == 1) {
                    xjdf.setAttribute("ContainerRef", v.get(0).getAttribute("ID"));
                }
            }
            return null;
        }
    }

    protected class WalkLayout
    extends WalkMediaRefByType {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayout;
        }
    }

    protected class WalkSeparationSpec
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFSeparationSpec ss = (JDFSeparationSpec)jdf;
            String name = ss.getName();
            name = StringUtil.replaceChar(name, ' ', "_", 0);
            xjdf.appendAttribute("SeparationSpec", name, null, " ", false);
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFSeparationSpec;
        }
    }

    protected class WalkSeparationList
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFSeparationList je = (JDFSeparationList)jdf;
            String name = jdf.getLocalName();
            VString cols = je.getSeparations();
            if (cols != null) {
                for (int i = 0; i < cols.size(); ++i) {
                    String col = cols.get(i);
                    cols.set(i, StringUtil.replaceChar(col, ' ', "_", 0));
                }
            }
            xjdf.setAttribute(name, cols, null);
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFSeparationList;
        }
    }

    protected class WalkSpan
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFSpanBase span = (JDFSpanBase)jdf;
            KElement ret = XJDF20.this.bSpanAsAttribute ? this.spanToAttribute(span, xjdf) : this.invertSpan(span, xjdf);
            return ret;
        }

        private KElement spanToAttribute(JDFSpanBase span, KElement xjdf) {
            String name = span.getLocalName();
            String val = span.guessActual();
            if (val != null) {
                xjdf.setAttribute(name, val);
            }
            return null;
        }

        private KElement invertSpan(JDFSpanBase span, KElement xjdf) {
            span.inlineRefElements(null, null, false);
            JDFSpanBase.EnumDataType dataType = span.getDataType();
            if (dataType == null) {
                return null;
            }
            KElement eNew = xjdf.appendElement(dataType.getName());
            eNew.setAttributes(span);
            eNew.removeAttribute("DataType");
            eNew.setAttribute("Name", span.getLocalName());
            return eNew;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFSpanBase;
        }
    }

    protected class WalkPhaseTimeAudit
    extends WalkAudit {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement x2;
            JDFPhaseTime pt = (JDFPhaseTime)jdf;
            VElement vL = pt.getLinkVector();
            VElement phaseAmount = new VElement();
            if (vL != null) {
                for (int i = 0; i < vL.size(); ++i) {
                    JDFResourceLink rl = (JDFResourceLink)vL.get(i);
                    VElement vR = XJDF20.this.setResource(null, rl.getLinkRoot(), XJDF20.this.newRoot);
                    KElement pA = xjdf.appendElement("PhaseAmount");
                    for (int j = 0; j < vR.size(); ++j) {
                        pA.appendAttribute("rRef", vR.get(j).getAttribute("ID"), null, " ", true);
                        XJDF20.this.setAmountPool(rl, pA, null);
                        rl.deleteNode();
                        for (String extension : new String[]{"", "Good", "Waste"}) {
                            pA.removeAttribute("Amount" + extension);
                            pA.renameAttribute("ActualAmount" + extension, "Amount" + extension, null, null);
                        }
                    }
                    phaseAmount.add(pA);
                }
            }
            if ((x2 = super.walk(jdf, xjdf)) != null) {
                for (int i = 0; i < phaseAmount.size(); ++i) {
                    x2.moveElement(phaseAmount.get(i), null);
                }
            }
            return x2;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFPhaseTime;
        }
    }

    protected class WalkResourceAudit
    extends WalkAudit {
        VJDFAttributeMap partMap;

        public WalkResourceAudit() {
            this.partMap = null;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement raNew = super.walk(jdf, xjdf);
            JDFResourceAudit ra = (JDFResourceAudit)jdf;
            this.partMap = ra.getPartMapVector();
            this.copyLinkValues(raNew, ra.getNewLink(), "NewRef");
            this.copyLinkValues(raNew, ra.getOldLink(), "OldRef");
            return null;
        }

        protected void copyLinkValues(KElement raNew, JDFResourceLink rl, String val) {
            VElement v;
            JDFResource rlRoot;
            JDFResource jDFResource = rlRoot = rl == null ? null : rl.getLinkRoot();
            if (rlRoot != null && rl != null && (v = XJDF20.this.setResource(null, rlRoot, XJDF20.this.newRoot)) != null) {
                for (KElement kElem : v) {
                    KElement resAmount = raNew.appendElement("ResourceAmount");
                    resAmount.setAttribute("Type", val);
                    resAmount.setAttribute("rRef", kElem.getAttribute("ID"));
                    if (this.partMap == null || this.partMap.size() == 0) {
                        XJDF20.this.setAmountPool(rl, resAmount, null);
                        continue;
                    }
                    for (int i = 0; i < this.partMap.size(); ++i) {
                        JDFAttributeMap partMap2 = this.partMap.get(i);
                        XJDF20.this.setAmountPool(rl, resAmount, partMap2);
                        resAmount.appendElement("Part").setAttributes(partMap2);
                    }
                }
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceAudit;
        }
    }

    protected class WalkAudit
    extends WalkJDFElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAudit;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement e = super.walk(jdf, xjdf);
            if (!XJDF20.this.bSingleNode && e != null) {
                JDFNode n = ((JDFAudit)jdf).getParentJDF();
                e.copyAttribute("JobPartID", n);
            }
            return e;
        }
    }

    protected class WalkAuditPool
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            if (XJDF20.this.walkingProduct) {
                return null;
            }
            if (XJDF20.this.newRoot.getElement("AuditPool") != null) {
                return XJDF20.this.newRoot.getElement("AuditPool");
            }
            return super.walk(jdf, xjdf);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAuditPool;
        }
    }

    protected class WalkSkip
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            return xjdf;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDevCapPool || toCheck instanceof JDFDevCaps;
        }
    }

    protected class WalkIgnore
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAncestorPool || toCheck instanceof JDFResourcePool || toCheck instanceof JDFSpawned || toCheck instanceof JDFMerged;
        }
    }

    protected class WalkElement
    extends BaseWalker {
        boolean bMerge;

        public WalkElement() {
            super(XJDF20.this.getFactory());
            this.bMerge = false;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            String xmlComment;
            KElement eNew = this.bMerge ? xjdf : xjdf.appendElement(jdf.getNodeName(), jdf.getNamespaceURI());
            this.setAttributes(jdf, eNew);
            eNew.setText(jdf.getText());
            Node before = null;
            int i = 0;
            while ((xmlComment = jdf.getXMLComment(i)) != null) {
                Node comment = eNew.appendXMLComment(xmlComment, null);
                if (before == null) {
                    before = comment.getNextSibling();
                } else {
                    eNew.insertBefore(comment, before);
                }
                ++i;
            }
            this.removeUnused(eNew);
            return eNew;
        }

        protected void setAttributes(KElement jdf, KElement eNew) {
            JDFAttributeMap map = jdf instanceof JDFElement ? this.convertRanges((JDFElement)jdf) : jdf.getAttributeMap();
            eNew.setAttributes(map);
        }

        private JDFAttributeMap convertRanges(JDFElement jdf) {
            JDFAttributeMap map = jdf.getAttributeMap();
            if (XJDF20.this.bConvertTilde) {
                VString keys = map.getKeys();
                for (String key : keys) {
                    JDFNameRangeList rl;
                    if (!AttributeInfo.EnumAttributeType.isRange(jdf.getAtrType(key)) || (rl = JDFNameRangeList.createNameRangeList(map.get(key))) == null) continue;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < rl.size(); ++i) {
                        JDFNameRange r = (JDFNameRange)rl.at(i);
                        if (i > 0) {
                            buf.append(" ");
                        }
                        buf.append(r.getLeft());
                        buf.append(" ");
                        buf.append(r.getRight());
                    }
                    map.put(key, buf.toString());
                }
            }
            return map;
        }

        protected void removeUnused(KElement newRootP) {
            newRootP.removeAttribute("xsi:type");
        }
    }

    public class WalkProduct
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement pList = "Product".equals(xjdf.getLocalName()) ? xjdf.getParentNode_KElement() : xjdf;
            JDFNode node = (JDFNode)jdf;
            if (!JDFNode.EnumType.Product.equals((Object)node.getEnumType())) {
                return null;
            }
            KElement prod = pList.appendElement("Product");
            prod.setAttributes(jdf);
            prod.removeAttribute("Type");
            prod.removeAttribute("Activation");
            prod.removeAttribute("Version");
            prod.removeAttribute("MaxVersion");
            prod.removeAttribute("ICSVersions");
            prod.removeAttribute("Status");
            prod.removeAttribute("StatusDetails");
            prod.removeAttribute("xmlns");
            prod.removeAttribute("xsi:type");
            prod.removeAttribute("JobID");
            prod.renameAttribute("JobPartID", "ProductID", null, null);
            prod.removeAttribute("xmlns:xsi");
            this.calcChildren(node, prod);
            this.readComponent(node, prod);
            return prod;
        }

        private void readComponent(JDFNode node, KElement prod) {
            JDFResourceLink cOut = node.getLink(0, "ComponentLink", new JDFAttributeMap("Usage", "Output"), null);
            if (cOut == null) {
                return;
            }
            XJDF20.this.setAmountPool(cOut, prod, null);
            prod.renameAttribute("AmountGood", "Amount", null, null);
            prod.removeAttribute("AmountWaste");
            JDFComponent component = (JDFComponent)cOut.getTarget();
            prod.copyAttribute("ProductType", component);
            prod.copyAttribute("ProductTypeDetails", component);
        }

        private void calcChildren(JDFNode node, KElement prod) {
            VString kids = new VString();
            VElement vComp = node.getPredecessors(true, true);
            if (vComp != null) {
                int siz = vComp.size();
                for (int i = 0; i < siz; ++i) {
                    JDFNode nPre = (JDFNode)vComp.get(i);
                    if (!JDFNode.EnumType.Product.equals((Object)nPre.getEnumType())) continue;
                    kids.add(nPre.getID());
                }
            }
            if (kids.size() > 0) {
                for (int i = 0; i < kids.size(); ++i) {
                    KElement sub = prod.appendElement("ChildProduct");
                    sub.setAttribute("ChildRef", kids.get(i), null);
                }
            } else {
                node.setAttribute("RootProduct", true, null);
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return XJDF20.this.walkingProduct && toCheck instanceof JDFNode;
        }
    }

    public class WalkJDF
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            if (XJDF20.this.first.contains(jdf.getID()) || XJDF20.this.bSingleNode && XJDF20.this.first.size() > 0) {
                return null;
            }
            XJDF20.this.first.add(jdf.getID());
            JDFNode node = (JDFNode)jdf;
            this.setRootAttributes(node, xjdf);
            return xjdf;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return !XJDF20.this.walkingProduct && toCheck instanceof JDFNode;
        }

        private void setRootAttributes(JDFNode node, KElement newRootP) {
            newRootP.appendXMLComment("Very preliminary experimental prototype trial version: using: " + JDFAudit.getStaticAgentName() + " " + JDFAudit.getStaticAgentVersion(), null);
            newRootP.setAttribute("JobID", node.getJobID(true));
            JDFNodeInfo ni = node.getCreateNodeInfo();
            VElement niLeaves = ni.getLeaves(false);
            for (int i = 0; i < niLeaves.size(); ++i) {
                JDFNodeInfo niLeaf = (JDFNodeInfo)niLeaves.get(i);
                JDFAttributeMap map = niLeaf.getPartMap();
                niLeaf.setNodeStatus(node.getPartStatus(map, 0));
                niLeaf.setNodeStatusDetails(StringUtil.getNonEmpty(node.getPartStatusDetails(map)));
            }
            String types = newRootP.getAttribute("Types", null, null);
            newRootP.setAttributes(node);
            this.removeUnused(newRootP);
            if (XJDF20.this.isUpdateVersion()) {
                newRootP.setAttribute("Version", "2.0");
                newRootP.setAttribute("MaxVersion", "2.0");
            }
            this.updateTypes(newRootP, types);
            this.namedFeaturesToGeneralID(node, newRootP);
            this.updateSpawnInfo(node, newRootP);
        }

        private void namedFeaturesToGeneralID(JDFNode node, KElement newRootP) {
            if (node.hasAttribute("NamedFeatures")) {
                VString vnf = node.getNamedFeatures();
                for (int i = 0; i < vnf.size(); i += 2) {
                    JDFGeneralID gi = (JDFGeneralID)newRootP.appendElement("GeneralID");
                    gi.setIDUsage(vnf.get(i));
                    gi.setIDValue(vnf.get(i + 1));
                    gi.setDataType(JDFAutoGeneralID.EnumDataType.NMTOKEN);
                    gi.setDescriptiveName("Copy from NamedFeatures");
                }
                newRootP.removeAttribute("NamedFeatures");
            }
        }

        @Override
        protected void removeUnused(KElement newRootP) {
            newRootP.removeAttribute("Status");
            newRootP.removeAttribute("StatusDetails");
            newRootP.removeAttribute("Activation");
            newRootP.removeAttribute("Template");
            super.removeUnused(newRootP);
        }

        private void updateTypes(KElement newRootP, String types) {
            if (!newRootP.hasAttribute("Types")) {
                newRootP.renameAttribute("Type", "Types", null, null);
            } else {
                newRootP.removeAttribute("Type");
            }
            VString t1 = StringUtil.tokenize(types, null, false);
            VString t2 = StringUtil.tokenize(newRootP.getAttribute("Types"), null, false);
            t1.appendUnique(t2);
            t1.removeStrings("ProcessGroup", 0);
            t1.removeStrings("Combined", 0);
            newRootP.setAttribute("Types", t1, null);
        }

        private void updateSpawnInfo(JDFNode node, KElement newRootP) {
            if ("SpawnInfo" != null && newRootP.hasAttribute("SpawnID")) {
                VJDFAttributeMap vParts;
                KElement spawnInfo = newRootP.appendElement("SpawnInfo", "www.cip4.org/SpawnInfo");
                spawnInfo.moveAttribute("SpawnID", newRootP, null, null, null);
                JDFAncestorPool ancestorPool = node.getAncestorPool();
                if (ancestorPool != null && (vParts = ancestorPool.getPartMapVector()) != null) {
                    int size = vParts.size();
                    for (int i = 0; i < size; ++i) {
                        spawnInfo.appendElement("Part").setAttributes(vParts.elementAt(i));
                    }
                }
            }
        }
    }

    public class WalkResLinkPool
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement resLinkPool, KElement xjdf) {
            this.getLinksFromAncestorPool(resLinkPool);
            return xjdf;
        }

        private void getLinksFromAncestorPool(KElement resLinkPool) {
            String[] v;
            KElement parent = resLinkPool.getParentNode_KElement();
            if (!(parent instanceof JDFNode)) {
                return;
            }
            JDFNode n = (JDFNode)parent;
            JDFAncestorPool ap = n.getAncestorPool();
            if (ap == null) {
                return;
            }
            for (String s : v = new String[]{"NodeInfo", "CustomerInfo"}) {
                JDFResource ni = n.getResource(s, null, 0);
                if (ni != null) continue;
                JDFResource resAnc = (JDFResource)ap.getAncestorElement(s, null, null);
                n.linkResource(resAnc, JDFResourceLink.EnumUsage.Input, null);
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceLinkPool;
        }
    }

    public class WalkRefElement
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFRefElement refElem = (JDFRefElement)jdf;
            if (this.mustInline(refElem)) {
                try {
                    JDFElement e = refElem.inlineRef();
                    XJDF20.this.walkTree(e, xjdf);
                }
                catch (JDFException x) {
                    // empty catch block
                }
                return null;
            }
            this.makeRefAttribute(refElem, xjdf);
            return null;
        }

        protected void makeRefAttribute(JDFRefElement re, KElement xjdf) {
            JDFResource target = re.getTarget();
            JDFResourceLink rl = this.getLinkForRef(re, target);
            VElement v = XJDF20.this.setResource(rl, target, this.getRefRoot(xjdf));
            if (v != null) {
                String attName = this.getRefName(re);
                for (int i = 0; i < v.size(); ++i) {
                    KElement ref = v.get(i);
                    xjdf.appendAttribute(attName, ref.getAttribute("ID"), null, " ", true);
                }
            }
            re.deleteNode();
        }

        private JDFResourceLink getLinkForRef(JDFRefElement re, JDFResource target) {
            JDFResourceLink rl = null;
            if (XJDF20.this.oldRoot != null) {
                JDFResourceLinkPool resourceLinkPool = XJDF20.this.oldRoot.getResourceLinkPool();
                rl = resourceLinkPool != null ? resourceLinkPool.getLink(target, null, null) : null;
            }
            return rl;
        }

        private KElement getRefRoot(KElement xjdf) {
            KElement ret = null;
            if (xjdf != null) {
                ret = xjdf.getDeepParent("ResourceInfo", 0);
            }
            return ret == null ? XJDF20.this.newRoot : ret;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFRefElement;
        }
    }

    public class WalkResLink
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFResourceLink rl = (JDFResourceLink)jdf;
            JDFResource linkTarget = rl.getLinkRoot();
            if (linkTarget == null) {
                return null;
            }
            if (XJDF20.this.walkingProduct) {
                if (!JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass())) {
                    return null;
                }
                this.setResource(rl, linkTarget, xjdf);
            } else {
                if (JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass())) {
                    return null;
                }
                this.setResource(rl, linkTarget, XJDF20.this.newRoot);
                if (!XJDF20.this.bSingleNode) {
                    this.setProcess(rl);
                }
            }
            return null;
        }

        VElement setResource(JDFResourceLink rl, JDFResource linkTarget, KElement xjdf) {
            return XJDF20.this.setResource(rl, linkTarget, xjdf);
        }

        private void setProcess(JDFResourceLink rl) {
            if (rl == null) {
                return;
            }
            KElement process = this.getProcess(rl);
            this.setLink(process, rl);
        }

        private void setLink(KElement process, JDFResourceLink rl) {
            if (rl == null || process == null) {
                return;
            }
            JDFResourceLink.EnumUsage usage = rl.getUsage();
            if (usage == null) {
                return;
            }
            String attName = usage.getName();
            if (attName != null) {
                process.appendAttribute(attName, rl.getrRef(), null, " ", true);
            }
        }

        private KElement getProcess(JDFResourceLink rl) {
            JDFNode parent = rl.getParentJDF();
            if (parent == null || "Product".equals(parent.getType())) {
                return null;
            }
            String jobPartID = this.getJobPartID(parent);
            if (jobPartID == null) {
                return null;
            }
            KElement processList = XJDF20.this.newRoot.getCreateElement("ProcessList", null, 0);
            KElement process = processList.getChildWithAttribute("Process", "JobPartID", null, jobPartID, 0, true);
            if (process == null) {
                process = processList.appendElement("Process");
                process.setAttribute("JobPartID", jobPartID);
                JDFNode grandparent = parent.getParentJDF();
                if (parent.hasAttribute("Types")) {
                    process.copyAttribute("Types", parent);
                } else {
                    process.copyAttribute("Types", parent, "Type", null, null);
                }
                if (grandparent != null) {
                    process.setAttribute("Parent", this.getJobPartID(grandparent));
                }
            }
            return process;
        }

        private String getJobPartID(JDFNode parent) {
            String jobPartID = StringUtil.getNonEmpty(parent.getJobPartID(false));
            if (jobPartID == null) {
                jobPartID = StringUtil.getNonEmpty(parent.getID());
            }
            return jobPartID;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceLink;
        }
    }

    public class WalkColorIntentResLink
    extends WalkResLink {
        @Override
        VElement setResource(JDFResourceLink rl, JDFResource linkTarget, KElement xjdf) {
            VElement v = super.setResource(rl, linkTarget, xjdf);
            KElement e0 = null;
            VString frontBack = new VString("ColorsUsed Coatings ColorStandard Coverage", null);
            for (KElement e : v) {
                JDFPart part = (JDFPart)e.getElement("Part");
                e = e.getElement("ColorIntent");
                if (e0 == null) {
                    e0 = e;
                }
                if (e == null) {
                    if (part == null) continue;
                    part.deleteNode();
                    continue;
                }
                if (part != null) {
                    String attVal;
                    JDFAutoPart.EnumSide side = part.getSide();
                    if (JDFAutoPart.EnumSide.Front.equals((Object)side) && e0 != e) {
                        for (String att : frontBack) {
                            attVal = e.getAttribute(att, null, null);
                            if (attVal == null) continue;
                            e0.setAttribute(att, attVal);
                        }
                    } else if (JDFAutoPart.EnumSide.Back.equals((Object)side)) {
                        for (String att : frontBack) {
                            attVal = e.getAttribute(att, null, null);
                            if (attVal == null) continue;
                            e0.setAttribute(att + "Back", attVal);
                        }
                    }
                    part.deleteNode();
                    continue;
                }
                for (String att : frontBack) {
                    String attValBack;
                    String attValBase;
                    String attVal = e.getAttribute(att, null, null);
                    if (attVal == null) continue;
                    if (e0 != e && (attValBase = e0.getAttribute(att, null, null)) == null) {
                        e0.setAttribute(att, attVal);
                    }
                    if ((attValBack = e0.getAttribute(att + "Back", null, null)) != null) continue;
                    e0.setAttribute(att + "Back", attVal);
                }
            }
            return v;
        }

        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            KElement e = super.walk(jdf, xjdf);
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "ColorIntentLink".equals(toCheck.getLocalName());
        }
    }

    public class WalkJDFElement
    extends WalkElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFElement je = (JDFElement)jdf;
            this.makeRefElements(je);
            return super.walk(jdf, xjdf);
        }

        private void makeRefElements(JDFElement je) {
            VElement v = je.getChildElementVector_KElement(null, null, null, true, 0);
            for (int i = 0; i < v.size(); ++i) {
                JDFResource r;
                KElement e = v.get(i);
                if (!(e instanceof JDFResource) || this.mustInline((r = (JDFResource)e).getLocalName())) continue;
                this.cleanRefs(je, r);
            }
        }

        private void cleanRefs(JDFElement je, JDFResource r) {
            JDFNode parentJDF = je.getParentJDF();
            if (parentJDF != null) {
                r = r.makeRootResource(null, parentJDF, false);
                r.setResStatus(JDFResource.EnumResStatus.Available, true);
                JDFResourcePool prevPool = parentJDF.getResourcePool();
                if (prevPool != null) {
                    r = this.removeDuplicateRefs(r, prevPool);
                }
                je.refElement(r);
            } else if (je.getJMFRoot() != null) {
                JDFResource resourceRoot = r.getResourceRoot();
                JDFElement parent = (JDFElement)(resourceRoot == null ? null : resourceRoot.getParentNode_KElement());
                r = r.makeRootResource(null, parent, false);
                r.setResStatus(JDFResource.EnumResStatus.Available, true);
                je.refElement(r);
            }
        }

        private JDFResource removeDuplicateRefs(JDFResource r, JDFResourcePool prevPool) {
            JDFAttributeMap m = r.getAttributeMap();
            m.remove("ID");
            VElement prevs = prevPool.getChildrenByTagName(r.getNodeName(), null, m, true, true, 0);
            if (prevs != null) {
                for (int j = 0; j < prevs.size(); ++j) {
                    JDFResource prev = (JDFResource)prevs.get(j);
                    if (r == prev) continue;
                    String pid = prev.getID();
                    String rid = r.getID();
                    prev.removeAttribute("ID");
                    r.removeAttribute("ID");
                    if (r.isEqual(prev)) {
                        r.deleteNode();
                        r = prev;
                        prev.setID(pid);
                        break;
                    }
                    r.setID(rid);
                    prev.setID(pid);
                }
            }
            return r;
        }

        protected String getRefName(JDFRefElement re) {
            return re.getLocalName();
        }

        protected boolean mustInline(JDFRefElement re) {
            return this.mustInline(re.getRefLocalName());
        }

        protected boolean mustInline(String refLocalName) {
            return "ObjectResolution".equals(refLocalName) || "BarcodeCompParams".equals(refLocalName) || "BarcodeReproParams".equals(refLocalName) || "ComChannel".equals(refLocalName) || "InterpretedPDLData".equals(refLocalName) || "ByteMap".equals(refLocalName) || "Company".equals(refLocalName) || "CostCenter".equals(refLocalName) || "Address".equals(refLocalName) || "Person".equals(refLocalName) || "Device".equals(refLocalName) || "DeviceNSpace".equals(refLocalName) || "ColorantAlias".equals(refLocalName) || "GlueLine".equals(refLocalName) || "GlueApplication".equals(refLocalName) || "CIELABMeasuringField".equals(refLocalName) || "RegisterMark".equals(refLocalName) || "FitPolicy".equals(refLocalName) || "CutBlock".equals(refLocalName) || "Employee".equals(refLocalName) || "ElementColorParams".equals(refLocalName) || "Cut".equals(refLocalName) || "PDLResourceAlias".equals(refLocalName) || "HoleList".equals(refLocalName) || "Hole".equals(refLocalName) || "MISDetails".equals(refLocalName) || "HoleLine".equals(refLocalName) || "JobField".equals(refLocalName) || "ObjectResolution".equals(refLocalName) || "AutomatedOverPrintParams".equals(refLocalName) || "ExternalImpositionTemplate".equals(refLocalName) || "ProductionPath".equals(refLocalName) || "Shape".equals(refLocalName) || "ScavengerArea".equals(refLocalName) || "ScavengerArea".equals(refLocalName) || "TrapRegion".equals(refLocalName) || "TransferCurve".equals(refLocalName) || "ColorControlStrip".equals(refLocalName) || "LayerList".equals(refLocalName) || "PageCondition".equals(refLocalName) || "ContentObject".equals(refLocalName) || "MarkObject".equals(refLocalName) || "FileSpec".equals(refLocalName) || "LayerDetails".equals(refLocalName) || "BinderySignature".equals(refLocalName);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFElement;
        }

        @Override
        protected void removeUnused(KElement newRootP) {
            newRootP.removeAttribute("SpawnID");
            super.removeUnused(newRootP);
        }
    }

    public class WalkResource
    extends WalkJDFElement {
        @Override
        public KElement walk(KElement jdf, KElement xjdf) {
            JDFResource r = (JDFResource)jdf;
            KElement newResLeaf = super.walk(jdf, xjdf);
            if (newResLeaf != null) {
                newResLeaf.removeAttribute("ID");
                this.moveAttribsToBase(xjdf, newResLeaf);
                this.removeDeprecatedResourceAttribs(r, newResLeaf);
                this.removeDeprecatedResourceAttribs(r, xjdf);
            }
            return newResLeaf;
        }

        protected void moveAttribsToBase(KElement xjdf, KElement newResLeaf) {
            String localName = xjdf.getLocalName();
            boolean bRoot = "Intent".equals(localName) || "Parameter".equals(localName) || "Resource".equals(localName);
            for (String attrib : XJDF20.this.resAttribs) {
                if (!newResLeaf.hasAttribute(attrib)) continue;
                if (bRoot) {
                    xjdf.moveAttribute(attrib, newResLeaf, null, null, null);
                    continue;
                }
                newResLeaf.removeAttribute(attrib);
            }
        }

        private void removeDeprecatedResourceAttribs(JDFResource r, KElement newResLeaf) {
            newResLeaf.removeAttributes(r.getPartIDKeys());
            newResLeaf.removeAttribute("Class");
            newResLeaf.removeAttribute("PartUsage");
            newResLeaf.removeAttribute("Locked");
            newResLeaf.removeAttribute("NoOp");
            newResLeaf.removeAttribute("SpawnStatus");
            newResLeaf.removeAttribute("SpawnIDs");
            newResLeaf.removeAttribute("PartIDKeys");
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResource;
        }
    }
}

