/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class XJDFHelper
extends BaseXJDFHelper {
    public static final String PRODUCT = "Product";
    public static final String RESOURCE = "Resource";
    public static final String PARAMETER = "Parameter";

    public static XJDFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return root.getLocalName().equals("XJDF") ? new XJDFHelper(root) : null;
    }

    public XJDFHelper(KElement xjdf) {
        if (xjdf == null) {
            this.newXJDF();
        } else {
            this.theElement = xjdf;
        }
        if (this.theElement instanceof JDFElement) {
            ((JDFElement)this.theElement).getOwnerDocument_JDFElement().setInitOnCreate(false);
        }
    }

    public XJDFHelper(String jobID, String jobPartID, VJDFAttributeMap parts) {
        this.newXJDF();
        if (jobID == null) {
            jobID = "Job_" + new JDFDate().getFormattedDateTime("MMdd_hhmmss");
        }
        this.theElement.setAttribute("JobID", jobID);
        this.theElement.setAttribute("JobPartID", jobPartID);
        this.setParts(parts);
    }

    private void setParts(VJDFAttributeMap parts) {
        SetHelper niHelper = this.getCreateSet(PARAMETER, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        niHelper.getCreatePartitions(parts, true);
    }

    private void newXJDF() {
        JDFDoc doc = new JDFDoc("XJDF");
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        JDFAuditPool ap = (JDFAuditPool)this.theElement.getCreateElement("AuditPool");
        ap.addAudit(JDFAudit.EnumAuditType.Created, null).init();
    }

    public Vector<SetHelper> getSets() {
        Vector<SetHelper> v = new Vector<SetHelper>();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!e.getLocalName().endsWith("Set")) continue;
            v.add(new SetHelper(e));
        }
        return v.size() == 0 ? null : v;
    }

    public String getJobID() {
        return this.getXPathValue("@JobID");
    }

    public ProductHelper getRootProduct(int iProduct) {
        Vector<ProductHelper> rootProductHelpers = this.getRootProductHelpers();
        if (rootProductHelpers == null) {
            return null;
        }
        if (iProduct < 0) {
            iProduct = rootProductHelpers.size() + iProduct;
        }
        if (iProduct >= rootProductHelpers.size() || iProduct < 0) {
            return null;
        }
        ProductHelper productHelper = rootProductHelpers.get(iProduct);
        return productHelper;
    }

    public Vector<ProductHelper> getRootProductHelpers() {
        Vector<ProductHelper> vp = this.getProductHelpers();
        if (vp == null) {
            return null;
        }
        Vector<ProductHelper> vp2 = new Vector<ProductHelper>();
        for (ProductHelper ph : vp) {
            if (!ph.isRootProduct()) continue;
            vp2.add(ph);
        }
        return vp2.size() == 0 ? null : vp2;
    }

    public Vector<ProductHelper> getProductHelpers() {
        VElement products;
        if (this.theElement == null) {
            return null;
        }
        KElement productList = this.theElement.getElement("ProductList");
        VElement vElement = products = productList == null ? null : productList.getChildElementVector(PRODUCT, null);
        if (products == null || products.size() == 0) {
            return null;
        }
        Vector<ProductHelper> vph = new Vector<ProductHelper>();
        for (KElement e : products) {
            vph.add(new ProductHelper(e));
        }
        return vph;
    }

    public PartitionHelper getPartition(String name, int iSet, int iPart) {
        SetHelper sh = this.getSet(name, iSet);
        return sh == null ? null : sh.getPartition(iPart);
    }

    public KElement getResource(String name, int iSet, int iPart) {
        PartitionHelper ph = this.getPartition(name, iSet, iPart);
        return ph == null ? null : ph.getResource();
    }

    public SetHelper getSet(String name, int iSkip) {
        int n = 0;
        KElement e2 = null;
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!e.getLocalName().endsWith("Set") || name != null && !name.equals(e.getAttribute("Name", null, null)) || n++ != iSkip) continue;
            e2 = e;
            break;
        }
        return e2 == null ? null : new SetHelper(e2);
    }

    public SetHelper appendSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        KElement newSet = this.theElement.appendElement(family + "Set");
        newSet.setAttribute("Name", name);
        if (name == null) {
            name = "Set";
        }
        newSet.setAttribute("ID", name + KElement.uniqueID(0));
        SetHelper h = new SetHelper(newSet);
        if (usage != null) {
            h.setUsage(usage);
        }
        return h;
    }

    public SetHelper getCreateSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet == null) {
            newSet = this.appendSet(family, name, usage);
        }
        return newSet;
    }

    public SetHelper getCreateResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public SetHelper getCreateParameterSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(PARAMETER, name, usage);
    }

    public void removeSet(String name) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet != null) {
            newSet.getSet().deleteNode();
        }
    }

    public SetHelper appendParameter(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(PARAMETER, name, usage);
    }

    public ProductHelper appendProduct() {
        KElement product = this.theElement.getCreateElement("ProductList").appendElement(PRODUCT);
        return new ProductHelper(product);
    }

    public SetHelper appendResource(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(RESOURCE, name, usage);
    }

    public String toString() {
        return "XJDFHelper: " + this.theElement;
    }

    public boolean writeToFile(String file) {
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public void setTypes(String types) {
        VString vtypes = VString.getVString(types, null);
        this.setTypes(vtypes);
    }

    public void setTypes(VString vtypes) {
        this.setXPathValue("@Types", StringUtil.setvString(vtypes));
    }

    public VString getTypes() {
        return VString.getVString(this.getXPathValue("@Types"), null);
    }
}

