/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.HashMap;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;

public class IDFinder
extends BaseElementWalker {
    protected final Map<String, IDPart> theMap = new HashMap<String, IDPart>();

    public IDFinder() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public Map<String, IDPart> getMap(KElement n) {
        this.theMap.clear();
        this.walkTree(n, null);
        return this.theMap;
    }

    @Override
    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }

    public class WalkSet
    extends BaseWalker {
        public WalkSet() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = "IDF" + KElement.uniqueID(0);
                e.setID(id);
            }
            IDFinder.this.theMap.put(id, new IDPart(id, null));
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            String localName = toCheck.getLocalName();
            return localName.equals("ResourceSet") || localName.equals("ParameterSet");
        }
    }

    public class WalkResource
    extends BaseWalker {
        public WalkResource() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String idParent = e.getParentNode_KElement().getAttribute("ID", null, null);
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = e.generateDotID("ID", null);
                e.setID(id);
            }
            VElement vPart = e.getChildElementVector("Part", null, null, true, 0, false);
            IDFinder.this.theMap.put(id, new IDPart(idParent, vPart));
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            String localName = toCheck.getLocalName();
            return localName.equals("Resource") || localName.equals("Parameter");
        }
    }

    public class IDPart {
        protected String id;
        protected VJDFAttributeMap vMap;

        public IDPart(String idParent, VElement parts) {
            this.id = idParent;
            this.vMap = null;
            if (parts != null && parts.size() > 0) {
                this.vMap = new VJDFAttributeMap();
                for (int i = 0; i < parts.size(); ++i) {
                    this.vMap.add(parts.get(i).getAttributeMap());
                }
            }
        }

        public String toString() {
            return "IDPart: ID=" + this.id + " Map= " + this.vMap;
        }

        public String getID() {
            return this.id;
        }

        public VJDFAttributeMap getPartMap() {
            return this.vMap;
        }
    }
}

