/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import java.io.File;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoConventionalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoPreview;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFColorIntent;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFColorantControl;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFConventionalPrintingParams;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFPreview;
import org.cip4.jdflib.resource.process.prepress.JDFInk;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.UrlUtil;

public class MISCPGoldenTicket
extends MISGoldenTicket {
    public static final String MISCPS_PRINTING = "MISCPS.Printing";
    public boolean splitSheets = false;
    public VString inks = null;
    public VString inkProductIDs = null;
    public boolean previewAvailable = false;
    public String previewShare = null;
    public boolean bPPF = false;

    public MISCPGoldenTicket(int _icsLevel, JDFElement.EnumVersion jdfVersion, int _jmfLevel, int _misLevel, boolean isGrayBox, VJDFAttributeMap vPartMap) {
        super(_misLevel, jdfVersion, _jmfLevel);
        this.icsLevel = _icsLevel;
        this.vParts = vPartMap;
        this.grayBox = isGrayBox;
        this.setup();
    }

    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put(MISCPS_PRINTING, new VString("InkZoneCalculation ConventionalPrinting", null));
    }

    public MISCPGoldenTicket(MISCPGoldenTicket parent) {
        super(parent);
        this.grayBox = parent.grayBox;
        this.setup();
    }

    private void setup() {
        if (this.grayBox) {
            this.setCategory(MISCPS_PRINTING);
        }
        this.theStatusCounter.addIgnorePart(JDFResource.EnumPartIDKey.Separation);
        this.previewShare = UrlUtil.fileToUrl(UrlUtil.urlToFile("file:/host/root/preview"), false);
    }

    @Override
    public VString getICSVersions() {
        VString v = super.getICSVersions();
        String icsTag = "MISCPS_L" + this.icsLevel + "-" + this.theVersion.getName();
        v.appendUnique(icsTag);
        return v;
    }

    @Override
    public void init() {
        this.initColsFromParent();
        this.initAmountsFromParent();
        if (this.partIDKeys == null) {
            this.partIDKeys = new VString("SignatureName SheetName Side Separation", null);
        }
        int ncols = this.getNCols();
        while (this.cols.size() > ncols && ncols > 0) {
            this.cols.remove(ncols);
        }
        if (this.icsLevel < 0) {
            return;
        }
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("MISCPS Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        if (!this.grayBox) {
            this.theNode.setType(JDFNode.EnumType.ConventionalPrinting);
        }
        this.initColorantControl();
        this.initConventionalPrintingParams();
        JDFMedia m = this.initPaperMedia();
        this.initPlateXM(JDFResourceLink.EnumUsage.Input);
        this.initDevice(this.thePreviousNode);
        JDFComponent c = this.initOutputComponent();
        this.initInk();
        super.init();
        this.initPreview();
        this.setActivePart(this.vParts, true);
        this.theStatusCounter.setTrackWaste(c.getID(), true);
        this.theStatusCounter.setTrackWaste(m.getID(), true);
    }

    private void initColsFromParent() {
        if (this.theParentProduct == null) {
            return;
        }
        JDFColorIntent ci = (JDFColorIntent)this.theParentProduct.getResource("ColorIntent", JDFResourceLink.EnumUsage.Input, 0);
        if (ci == null) {
            return;
        }
        int c = ci.getNumColors();
        if (c > 0) {
            this.nCols[0] = this.nCols[1] = c;
        }
    }

    private void initAmountsFromParent() {
        if (this.theParentProduct == null) {
            return;
        }
        JDFComponent c = (JDFComponent)this.theParentProduct.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        JDFResourceLink cl = this.theParentProduct.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        if (cl == null) {
            return;
        }
        double amount = cl.getAmount(null);
        if (amount > 0.0) {
            this.good = (int)amount;
            this.waste = (int)((double)this.good * 0.1);
        }
    }

    @Override
    public void setActivePart(VJDFAttributeMap vp, boolean bFirst) {
        this.amountLinks = null;
        this.addAmountLink("Media:Input");
        this.addAmountLink("Component:Output");
        super.setActivePart(vp, bFirst);
    }

    @Override
    protected JDFMedia initPaperMedia() {
        VJDFAttributeMap reducedMap;
        JDFMedia m = super.initPaperMedia();
        JDFResourceLink rl = this.theNode.getLink((JDFResource)m, null);
        if (rl == null) {
            rl = this.theNode.linkResource((JDFResource)m, JDFResourceLink.EnumUsage.Input, null);
        }
        if (this.vParts != null && (reducedMap = this.getReducedMap(new VString("Side Separation", " "))) != null) {
            int size = reducedMap.size();
            for (int i = 0; i < size; ++i) {
                JDFAttributeMap part = reducedMap.elementAt(i);
                JDFAttributeMap newMap = new JDFAttributeMap(part);
                newMap.put("Condition", "Good");
                rl.setAmount(this.good, newMap);
                rl.setMaxAmount(this.good + this.waste, newMap);
                newMap.put("Condition", "Waste");
                rl.setMaxAmount(this.waste, newMap);
            }
        }
        return m;
    }

    protected void initInk() {
        if (this.inks == null) {
            return;
        }
        JDFInk ink = (JDFInk)this.theNode.getCreateResource("Ink", JDFResourceLink.EnumUsage.Input, 0);
        int ncols = this.getNCols();
        for (int j = 0; j < ncols; ++j) {
            JDFInk inkp = (JDFInk)ink.addPartition(JDFResource.EnumPartIDKey.Separation, this.cols.stringAt(j));
            inkp.setInkName(this.inks.elementAt(j));
            if (this.cols.get(j).toLowerCase().indexOf("varnish") >= 0 || this.inks.get(j).toLowerCase().indexOf("varnish") >= 0) {
                inkp.setFamily("Varnish");
            }
            if (this.inkProductIDs == null) continue;
            inkp.setProductID(this.inkProductIDs.get(j));
        }
    }

    protected void initPreview() {
        VJDFAttributeMap reducedMap;
        JDFResourceLink rlP = null;
        if (this.theNode.getCombinedProcessIndex(JDFNode.EnumType.InkZoneCalculation, 0) < 0) {
            return;
        }
        if (this.thePreviousNode != null) {
            rlP = this.theNode.linkResource(this.thePreviousNode.getResource("Preview", JDFResourceLink.EnumUsage.Output, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        if (rlP == null && this.theParentNode != null) {
            rlP = this.theNode.linkResource(this.theParentNode.getResource("Preview", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        JDFPreview pv = (JDFPreview)this.theNode.getCreateResource("Preview", JDFResourceLink.EnumUsage.Input, 0);
        pv.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
        pv.setPreviewUsage(JDFAutoPreview.EnumPreviewUsage.Separation);
        pv.setPartUsage(JDFResource.EnumPartUsage.Explicit);
        pv.setPreviewFileType(this.bPPF ? JDFPreview.EnumPreviewFileType.CIP3Single : JDFPreview.EnumPreviewFileType.PNG);
        VJDFAttributeMap vJDFAttributeMap = reducedMap = this.bPPF ? this.getReducedMap(new VString("Side Separation", " ")) : this.vParts;
        if (reducedMap != null) {
            int size = reducedMap.size();
            for (int i = 0; i < size; ++i) {
                JDFAttributeMap part = new JDFAttributeMap(reducedMap.elementAt(i));
                JDFPreview previewPartition = (JDFPreview)pv.getCreatePartition(part, this.partIDKeys);
                if (this.bPPF) {
                    this.preparePreview(previewPartition);
                    continue;
                }
                for (int j = 0; j < this.getNCols(); ++j) {
                    part.put((ValuedEnum)JDFResource.EnumPartIDKey.Separation, this.cols.stringAt(j));
                    JDFPreview sepPreview = (JDFPreview)previewPartition.getCreatePartition(part, this.partIDKeys);
                    this.preparePreview(sepPreview);
                }
            }
        }
    }

    private void preparePreview(JDFPreview previewPartition) {
        if (this.previewAvailable) {
            this.setPreviewURL(previewPartition);
            previewPartition.setResStatus(JDFResource.EnumResStatus.Available, false);
        } else {
            previewPartition.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
        }
    }

    protected void initConventionalPrintingParams() {
        if (this.theParentNode != null) {
            this.theNode.linkResource(this.theParentNode.getResource("ConventionalPrintingParams", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        JDFConventionalPrintingParams cpp = (JDFConventionalPrintingParams)this.theNode.getCreateResource("ConventionalPrintingParams", JDFResourceLink.EnumUsage.Input, 0);
        cpp.setPrintingType(JDFAutoConventionalPrintingParams.EnumPrintingType.SheetFed);
        cpp.setWorkStyle(this.workStyle);
        cpp.setResStatus(JDFResource.EnumResStatus.Available, false);
    }

    @Override
    protected JDFDevice initDevice(JDFNode reuseNode) {
        if (this.misICSLevel < 2) {
            return null;
        }
        super.initDevice(reuseNode);
        JDFDevice dev = (JDFDevice)this.theNode.getCreateResource("Device", JDFResourceLink.EnumUsage.Input, 0);
        VJDFAttributeMap reducedMap = this.getReducedMap(new VString("Side Separation", " "));
        if (reducedMap != null && this.devID != null && this.splitSheets) {
            int size = reducedMap.size();
            for (int i = 0; i < size; ++i) {
                JDFAttributeMap part = reducedMap.elementAt(i);
                JDFDevice devPart = (JDFDevice)dev.getCreatePartition(part, this.partIDKeys);
                devPart.setResStatus(JDFResource.EnumResStatus.Available, false);
                devPart.setDeviceID(this.devID);
            }
        }
        return dev;
    }

    protected void makeReadyColorantControl() {
        JDFColorantControl cc = (JDFColorantControl)this.theExpandedNode.getCreateResource("ColorantControl", JDFResourceLink.EnumUsage.Input, 0);
        JDFColorPool cp = cc.getCreateColorPool();
        for (int i = 0; i < this.getNCols(); ++i) {
            String name = this.cols.stringAt(i);
            JDFColor c = cp.getCreateColorWithName(name, null);
            c.setActualColorName(this.colsActual.stringAt(i));
        }
    }

    @Override
    public void makeReady() {
        super.makeReady();
        this.makeReadyPreview();
        this.makeReadyColorantControl();
    }

    private void makeReadyPreview() {
        JDFPreview pv = (JDFPreview)this.theNode.getResource("Preview", JDFResourceLink.EnumUsage.Input, 0);
        VElement v = pv == null ? new VElement() : pv.getLeaves(false);
        for (int i = 0; i < v.size(); ++i) {
            JDFPreview pvp = (JDFPreview)v.elementAt(i);
            this.setPreviewURL(pvp);
            pvp.setResStatus(JDFResource.EnumResStatus.Available, true);
        }
    }

    private void setPreviewURL(JDFPreview previewLeaf) {
        File share = UrlUtil.urlToFile(this.previewShare);
        File file = this.bPPF ? new File(previewLeaf.getSheetName() + ".ppf") : new File(previewLeaf.getSheetName() + "_" + previewLeaf.getSide().getName().substring(0, 1) + "_" + previewLeaf.getSeparation() + ".png");
        file = FileUtil.getFileInDirectory(share, file);
        previewLeaf.setURL(UrlUtil.fileToUrl(file, false));
        previewLeaf.setPreviewUsage(JDFAutoPreview.EnumPreviewUsage.Separation);
        previewLeaf.setPreviewFileType(JDFPreview.EnumPreviewFileType.CIP3Single);
    }

    @Override
    protected JDFNodeInfo initNodeInfo() {
        JDFNodeInfo ni = super.initNodeInfo();
        if (this.vParts != null) {
            VJDFAttributeMap reducedMap = new VJDFAttributeMap(this.vParts);
            VString reduceKeys = new VString(this.partIDKeys);
            if (JDFAutoConventionalPrintingParams.EnumWorkStyle.Simplex.equals((Object)this.workStyle) || JDFAutoConventionalPrintingParams.EnumWorkStyle.Perfecting.equals((Object)this.workStyle)) {
                reduceKeys.remove("Side");
            }
            reducedMap.reduceMap(reduceKeys.getSet());
            this.theNode.setPartStatus(reducedMap, JDFElement.EnumNodeStatus.Waiting, null);
            for (int i = 0; i < reducedMap.size(); ++i) {
                JDFAttributeMap part = reducedMap.elementAt(i);
                JDFNodeInfo niPart = (JDFNodeInfo)ni.getCreatePartition(part, this.partIDKeys);
                niPart.setDescriptiveName("Printing for" + part.toString());
            }
        }
        return ni;
    }

    @Override
    protected void runphases(int pgood, int pwaste, boolean bOutAvail, boolean bFirst) {
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.InProgress, "Good", JDFAutoDeviceInfo.EnumDeviceStatus.Running, "Printing");
        this.runSinglePhase(pgood, pwaste, bOutAvail, bFirst);
        this.finalize();
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.Completed, "Done", JDFAutoDeviceInfo.EnumDeviceStatus.Idle, "Waiting");
    }

    @Override
    public void assign(JDFNode node) {
        super.assign(node);
        this.theNode.getCreateNodeInfo().setPartIDKeys(this.partIDKeys);
    }

    @Override
    protected void initColorantControl() {
        JDFResourceLink rl;
        super.initColorantControl();
        JDFColorPool cp = (JDFColorPool)this.theNode.getResource("ColorPool", JDFResourceLink.EnumUsage.Input, 0);
        if (cp != null && (rl = this.theNode.getLink((JDFResource)cp, JDFResourceLink.EnumUsage.Input)) != null) {
            rl.deleteNode();
        }
    }
}

