/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAssembly;
import org.cip4.jdflib.auto.JDFAutoBinderySignature;
import org.cip4.jdflib.auto.JDFAutoContentObject;
import org.cip4.jdflib.auto.JDFAutoImageShift;
import org.cip4.jdflib.auto.JDFAutoLayoutPreparationParams;
import org.cip4.jdflib.auto.JDFAutoPageCell;
import org.cip4.jdflib.auto.JDFAutoSignatureCell;
import org.cip4.jdflib.auto.JDFAutoStripMark;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFImageShift;
import org.cip4.jdflib.resource.JDFModified;
import org.cip4.jdflib.resource.JDFPageCell;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFExternalImpositionTemplate;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripMark;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFLayoutPreparationParams
extends JDFAutoLayoutPreparationParams {
    private static final long serialVersionUID = 1L;

    public JDFLayoutPreparationParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFLayoutPreparationParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFLayoutPreparationParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFLayoutPreparationParams[  --> " + super.toString() + " ]";
    }

    public StrippingConverter convertToStripping(JDFNode n) {
        StrippingConverter c = new StrippingConverter(n);
        c.convert();
        return c;
    }

    public class StrippingConverter {
        private JDFAssembly assembly = null;
        private JDFBinderySignature binderySignature = null;
        private JDFStrippingParams strippingParams = null;
        private final JDFNode parent;

        public StrippingConverter(JDFNode n) {
            this.parent = n == null ? JDFLayoutPreparationParams.this.getParentJDF() : n;
        }

        public JDFBinderySignature getBinderySignature() {
            return this.binderySignature;
        }

        public void convert() {
            this.convertParentNode();
            this.convertAssembly();
            this.strippingParams = (JDFStrippingParams)this.parent.addResource("StrippingParams", JDFResourceLink.EnumUsage.Input);
            this.strippingParams.clonePartitions(JDFLayoutPreparationParams.this, null);
            VElement vThis = JDFLayoutPreparationParams.this.getLeaves(false);
            for (KElement e : vThis) {
                JDFLayoutPreparationParams jDFLayoutPreparationParams = (JDFLayoutPreparationParams)e;
                jDFLayoutPreparationParams.getClass();
                jDFLayoutPreparationParams.new StrippingConverter(this.parent).convertLeaf();
            }
        }

        protected void convertLeaf() {
            this.strippingParams = (JDFStrippingParams)this.parent.getResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
            JDFAttributeMap partMap = JDFLayoutPreparationParams.this.getPartMap();
            if (partMap != null && partMap.size() > 0) {
                this.strippingParams = (JDFStrippingParams)this.strippingParams.getPartition(partMap, null);
            }
            this.convertStrippingParams();
            this.convertBinderySignature();
            this.setSignatureCell();
            this.setStripCellParams();
            this.removeObsolete();
        }

        private void removeObsolete() {
            VElement v = JDFLayoutPreparationParams.this.getLinksAndRefs(true, true);
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    v.get(i).deleteNode();
                }
            }
            JDFLayoutPreparationParams.this.deleteNode();
        }

        private void convertStrippingParams() {
            JDFMedia media = JDFLayoutPreparationParams.this.getMedia();
            if (media != null) {
                media.makeRootResource(null, null, true);
                this.strippingParams.refElement(media);
            }
            JDFExternalImpositionTemplate template = JDFLayoutPreparationParams.this.getExternalImpositionTemplate();
            this.strippingParams.copyElement(template, null);
            this.setPosition();
            this.setStripMarks(JDFLayoutPreparationParams.this.getFrontMarkList(), JDFAutoStripMark.EnumMarkSide.Front);
            this.setStripMarks(JDFLayoutPreparationParams.this.getBackMarkList(), JDFAutoStripMark.EnumMarkSide.Back);
        }

        private void setStripCellParams() {
            JDFXYPair ts;
            JDFPageCell pageCell = JDFLayoutPreparationParams.this.getPageCell();
            if (pageCell != null && (ts = pageCell.getTrimSize()) != null) {
                this.strippingParams.getCreateStripCellParams().setTrimSize(ts);
            }
        }

        private void setSignatureCell() {
            JDFPageCell pageCell = JDFLayoutPreparationParams.this.getPageCell();
            if (pageCell == null) {
                return;
            }
            JDFSignatureCell signatureCell = this.getBinderySignature().getCreateSignatureCell(0);
            signatureCell.setOrientation(this.getSigCellOrientation(pageCell.getRotate()));
            this.convertImageShift(pageCell, signatureCell);
            signatureCell.copyElement(pageCell.getFitPolicy(), null);
        }

        private void convertImageShift(JDFPageCell pageCell, JDFSignatureCell signatureCell) {
            JDFAutoContentObject.EnumAnchor ea;
            JDFImageShift imageShift = pageCell.getImageShift();
            if (imageShift == null) {
                return;
            }
            JDFAutoImageShift.EnumPositionX posX = imageShift.getPositionX();
            JDFAutoImageShift.EnumPositionY posY = imageShift.getPositionY();
            if (posX == null || posY == null) {
                return;
            }
            String anchor = posY.getName() + posX.getName();
            if ("CenterCenter".equals(anchor)) {
                anchor = "Center";
            }
            if ((ea = JDFAutoContentObject.EnumAnchor.getEnum(anchor)) != null) {
                signatureCell.setAttribute("Anchor", anchor);
            }
        }

        private JDFAutoSignatureCell.EnumOrientation getSigCellOrientation(JDFAutoPageCell.EnumRotate rotate) {
            if (JDFAutoPageCell.EnumRotate.Rotate90.equals((Object)rotate)) {
                return JDFAutoSignatureCell.EnumOrientation.Left;
            }
            if (JDFAutoPageCell.EnumRotate.Rotate180.equals((Object)rotate)) {
                return JDFAutoSignatureCell.EnumOrientation.Down;
            }
            if (JDFAutoPageCell.EnumRotate.Rotate270.equals((Object)rotate)) {
                return JDFAutoSignatureCell.EnumOrientation.Right;
            }
            return JDFAutoSignatureCell.EnumOrientation.Up;
        }

        private void setPosition() {
            JDFIntegerList sr = JDFLayoutPreparationParams.this.getStepRepeat();
            if (sr == null) {
                this.addSinglePosition(1, 1, 0, null);
            } else {
                int iX = sr.getInt(0);
                int iY = sr.getInt(1);
                JDFXYPair numberUp = JDFLayoutPreparationParams.this.getNumberUp();
                int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
                for (int i = 0; i < total; ++i) {
                    this.addSinglePosition(iX, iY, i, numberUp);
                }
            }
        }

        private void addSinglePosition(int x, int y, int n, JDFXYPair numberUp) {
            String bsName = this.getBSName(x, y, n, numberUp);
            JDFStrippingParams sp = bsName == null ? this.strippingParams : this.strippingParams.getCreatePartition(new JDFAttributeMap("BinderySignatureName", bsName), null);
            JDFPosition position = sp.appendPosition();
            position.setRelativeBox(this.getRelativeBox(x, y, n, numberUp));
            position.copyAttribute("Orientation", JDFLayoutPreparationParams.this, "Rotate", null, null);
        }

        private JDFRectangle getRelativeBox(int srx, int sry, int n, JDFXYPair numberUp) {
            int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
            if (total == 1) {
                return new JDFRectangle(0.0, 0.0, 1.0, 1.0);
            }
            double dx = 1.0 / numberUp.getX();
            double dy = 1.0 / numberUp.getY();
            double x = n % (int)numberUp.getX();
            double y = n / (int)numberUp.getX();
            return new JDFRectangle(x /= numberUp.getX(), y /= numberUp.getY(), x + dx, y + dy);
        }

        private String getBSName(int srx, int sry, int n, JDFXYPair numberUp) {
            int total = (int)(numberUp == null ? 1.0 : numberUp.getX() * numberUp.getY());
            if (total == 1) {
                return null;
            }
            int x = n % (int)numberUp.getX();
            int y = n / (int)numberUp.getX();
            return "BS_" + (1 + (x /= srx)) + "_" + (1 + (y /= sry));
        }

        private void setStripMarks(VString marks, JDFAutoStripMark.EnumMarkSide side) {
            for (String markName : marks) {
                JDFStripMark sm = this.strippingParams.appendStripMark();
                sm.setMarkName(markName);
                sm.setMarkSide(side);
            }
        }

        private void convertBinderySignature() {
            this.binderySignature = this.strippingParams.appendBinderySignature();
            this.binderySignature.makeRootResource(null, null, true);
            this.binderySignature.copyAttribute("BindingEdge", JDFLayoutPreparationParams.this);
            if (JDFLayoutPreparationParams.this.hasAttribute("StepRepeat")) {
                this.binderySignature.setNumberUp(1, 1);
            } else {
                this.binderySignature.copyAttribute("NumberUp", JDFLayoutPreparationParams.this);
            }
            this.binderySignature.copyAttribute("FoldCatalog", JDFLayoutPreparationParams.this);
            String pageDistribution = JDFLayoutPreparationParams.this.getPageDistributionScheme();
            String foldcatalog = StringUtil.getNonEmpty(JDFLayoutPreparationParams.this.getFoldCatalog());
            if ("Sequential".equals(pageDistribution) && (foldcatalog == null || "F2-1".equals(foldcatalog))) {
                this.binderySignature.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Grid);
            } else {
                this.binderySignature.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Fold);
            }
            this.binderySignature.copyAttribute("Sides", JDFLayoutPreparationParams.this);
        }

        private void convertAssembly() {
            this.assembly = (JDFAssembly)this.parent.addResource("Assembly", JDFResourceLink.EnumUsage.Input);
            this.assembly.copyAttribute("BindingSide", JDFLayoutPreparationParams.this, "BindingEdge", null, null);
            JDFAutoLayoutPreparationParams.EnumFinishingOrder fo = JDFLayoutPreparationParams.this.getFinishingOrder();
            if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.FoldCollect.equals((Object)fo)) {
                this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Collecting);
            } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.FoldGather.equals((Object)fo)) {
                this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
            } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.Gather.equals((Object)fo)) {
                this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
            } else if (JDFAutoLayoutPreparationParams.EnumFinishingOrder.GatherFold.equals((Object)fo)) {
                String pageDistribution = JDFLayoutPreparationParams.this.getPageDistributionScheme();
                if ("Saddle".equals(pageDistribution)) {
                    this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Collecting);
                } else {
                    this.assembly.setOrder(JDFAutoAssembly.EnumOrder.Gathering);
                }
            }
        }

        private JDFNode convertParentNode() {
            int n;
            VString types = this.parent.getTypes();
            if (types == null && JDFNode.EnumType.LayoutPreparation.equals((Object)this.parent.getEnumType())) {
                this.parent.setType(JDFNode.EnumType.Stripping);
            } else if (types != null && (n = types.index(JDFNode.EnumType.LayoutPreparation.getName())) >= 0) {
                types.set(n, JDFNode.EnumType.Stripping.getName());
                this.parent.setTypes(types);
            }
            JDFModified mod = this.parent.getCreateAuditPool().addModified(null, null);
            mod.setDescriptiveName("Automatic LayoutPrep to Stripping Conversion");
            return this.parent;
        }

        public JDFAssembly getAssembly() {
            return this.assembly;
        }

        public JDFStrippingParams getStrippingParams() {
            return this.strippingParams;
        }
    }
}

