/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.auto.JDFAutoValue;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.resource.JDFValue;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFLoc;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;

public class JDFMatrixState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[8];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFMatrixState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFMatrixState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFMatrixState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFMatrixState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFMatrix value) {
        this.setAttribute("CurrentValue", value.toString(), null);
    }

    public JDFMatrix getCurrentValue() {
        try {
            return new JDFMatrix(this.getAttribute("CurrentValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFMatrixState.getCurrentValue: Attribute CURRENTVALUE is not capable to create JDFMatrix");
        }
    }

    public void setDefaultValue(JDFMatrix value) {
        this.setAttribute("DefaultValue", value.toString(), null);
    }

    public JDFMatrix getDefaultValue() {
        try {
            return new JDFMatrix(this.getAttribute("DefaultValue"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFMatrixState.getDefaultValue: Attribute DEFAULTVALUE is not capable to create JDFMatrix");
        }
    }

    public void setAllowedRotateMod(double value) {
        this.setAttribute("AllowedRotateMod", value, null);
    }

    public double getAllowedRotateMod() {
        return this.getRealAttribute("AllowedRotateMod", null, 0.0);
    }

    public void setPresentRotateMod(double value) {
        this.setAttribute("PresentRotateMod", value, null);
    }

    public double getPresentRotateMod() {
        if (this.hasAttribute("PresentRotateMod")) {
            return this.getRealAttribute("PresentRotateMod", null, 0.0);
        }
        return this.getAllowedRotateMod();
    }

    public void setAllowedShift(JDFRectangle value) {
        this.setAttribute("AllowedShift", value.toString());
    }

    public JDFRectangle getAllowedShift() {
        try {
            return new JDFRectangle(this.getAttribute("AllowedShift", null, ""));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFMatrixState.getAllowedShift: AttributeValue not capable to create JDFRectangle");
        }
    }

    public void setPresentShift(JDFRectangle value) {
        this.setAttribute("PresentShift", value.toString());
    }

    public JDFRectangle getPresentShift() {
        if (this.hasAttribute("PresentShift")) {
            try {
                return new JDFRectangle(this.getAttribute("PresentShift", null, ""));
            }
            catch (DataFormatException e) {
                throw new JDFException("JDFMatrixState.getPresentShift: AttributeValue not capable to create JDFRectangle");
            }
        }
        return this.getAllowedShift();
    }

    public Vector getAllowedTransforms() {
        return this.getEnumerationsAttribute("AllowedTransforms", null, JDFElement.EnumOrientation.getEnum(0), false);
    }

    public void setAllowedTransforms(Vector value) {
        this.setEnumerationsAttribute("AllowedTransforms", value, null);
    }

    public Vector getPresentTransforms() {
        if (this.hasAttribute("PresentTransforms")) {
            return this.getEnumerationsAttribute("PresentTransforms", null, JDFElement.EnumOrientation.getEnum(0), false);
        }
        return this.getAllowedTransforms();
    }

    public void setPresentTransforms(Vector value) {
        this.setEnumerationsAttribute("PresentTransforms", value, null);
    }

    public JDFValue getValue(int iSkip) {
        return (JDFValue)this.getElement("Value", "", iSkip);
    }

    public JDFValue appendValue() {
        return (JDFValue)this.appendElement("Value", null);
    }

    @Override
    public JDFLoc appendValueLocLoc(int iSkip) {
        JDFValue val = this.getValue(iSkip);
        if (val == null) {
            return null;
        }
        return val.appendLoc();
    }

    public void setValueAllowedValue(int iSkip, JDFMatrix value) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        e.setAllowedValue(value.toString());
    }

    public final JDFMatrix getValueAllowedValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        try {
            return new JDFMatrix(e.getAllowedValue());
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFMatrixState.getValueAllowedValue: AttributeValue not capable to create JDFMatrix");
        }
    }

    public void setValueValueUsage(int iSkip, JDFBaseDataTypes.EnumFitsValue value) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        e.setValueUsage(JDFAutoValue.EnumValueUsage.getEnum(value.getName()));
    }

    public final JDFBaseDataTypes.EnumFitsValue getValueValueUsage(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        return JDFBaseDataTypes.EnumFitsValue.getEnum(e.getValueUsage().getName());
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFValue v;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            new JDFMatrix(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value);
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Allowed);
            }
        }
        if (JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value);
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Present);
            }
        }
    }

    public void appendValue(JDFMatrix value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFValue v;
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value.toString());
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Allowed);
            }
        }
        if (JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value.toString());
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Present);
            }
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        VString vs = new VString(value, " ");
        int siz = vs.size();
        if (siz % 6 != 0) {
            return false;
        }
        Vector<JDFMatrix> matrixList = new Vector<JDFMatrix>();
        for (int i = 0; i < siz; i += 6) {
            VString v = new VString();
            v.ensureCapacity(6);
            for (int j = 0; j < 6; ++j) {
                v.add(vs.stringAt(i + j));
            }
            try {
                JDFMatrix m = new JDFMatrix(StringUtil.setvString(vs, " ", null, null));
                matrixList.add(m);
                continue;
            }
            catch (DataFormatException x) {
                return false;
            }
        }
        if (this.fitsListType(matrixList)) {
            for (int k = 0; k < matrixList.size(); ++k) {
                JDFMatrix matrix = (JDFMatrix)matrixList.elementAt(k);
                if (this.fitsRotateMod(matrix, testlists) && this.fitsShift(matrix, testlists) && this.fitsTransforms(matrix, testlists) && this.fitsValueElem(matrix, testlists)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean fitsListType(Vector matrixList) {
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        int size = matrixList.size();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            return size == 1;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    JDFMatrix mj;
                    JDFMatrix mi = (JDFMatrix)matrixList.elementAt(i);
                    if (!mi.equals(mj = (JDFMatrix)matrixList.elementAt(j))) continue;
                    return false;
                }
            }
            return true;
        }
        throw new JDFException("JDFMatrixState.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueElem(JDFMatrix matrix, JDFBaseDataTypes.EnumFitsValue valuelist) {
        VElement v = this.getChildElementVector("Value", null, null, true, 0, false);
        int siz = v.size();
        boolean hasValue = false;
        for (int i = 0; i < siz; ++i) {
            JDFValue elm = (JDFValue)v.elementAt(i);
            if (elm.hasAttribute("ValueUsage")) {
                JDFBaseDataTypes.EnumFitsValue valueUsage = this.getValueValueUsage(i);
                if (!valuelist.equals((Object)valueUsage)) continue;
                hasValue = true;
                JDFMatrix value = this.getValueAllowedValue(i);
                if (!value.equals(matrix)) continue;
                return true;
            }
            hasValue = true;
            JDFMatrix value = this.getValueAllowedValue(i);
            if (!value.equals(matrix)) continue;
            return true;
        }
        return !hasValue;
    }

    private final boolean fitsRotateMod(JDFMatrix matrix, JDFBaseDataTypes.EnumFitsValue rotatemod) {
        if (rotatemod == null || rotatemod.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? !this.hasAttribute("AllowedRotateMod") : !this.hasAttribute("AllowedRotateMod") && !this.hasAttribute("PresentRotateMod")) {
            return true;
        }
        double rm = rotatemod == null || rotatemod.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedRotateMod() : this.getPresentRotateMod();
        double a = matrix.getA();
        double b = matrix.getB();
        double c = matrix.getC();
        double d = matrix.getD();
        if (a * d - b * c == 0.0) {
            return false;
        }
        double param = a / Math.sqrt(Math.abs(a * d - b * c));
        if (param - 1.0E-6 > 1.0 || param + 1.0E-6 < -1.0) {
            return false;
        }
        if (param > 1.0) {
            param -= 1.0E-6;
        }
        if (param < -1.0) {
            param += 1.0E-6;
        }
        double fi = Math.acos(param) * 180.0 / Math.PI;
        double result = fi + 1.0E-6 - rm * (double)((int)((fi + 1.0E-6) / rm));
        double result180 = fi + 180.0 + 1.0E-6 - rm * (double)((int)((fi + 180.0 + 1.0E-6) / rm));
        return Math.abs(result) <= 2.0E-6 || Math.abs(result180) <= 2.0E-6;
    }

    private final boolean fitsShift(JDFMatrix matrix, JDFBaseDataTypes.EnumFitsValue shift) {
        if (shift == null || shift.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? !this.hasAttribute("AllowedShift") : !this.hasAttribute("AllowedShift") && !this.hasAttribute("PresentShift")) {
            return true;
        }
        JDFRectangle shiftValue = shift == null || shift.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? new JDFRectangle(this.getAllowedShift()) : new JDFRectangle(this.getPresentShift());
        double minTx = shiftValue.getLlx();
        double minTy = shiftValue.getLly();
        double maxTx = shiftValue.getUrx();
        double maxTy = shiftValue.getUry();
        double Tx = matrix.getTx();
        double Ty = matrix.getTy();
        return Tx >= minTx && Tx <= maxTx && Ty >= minTy && Ty <= maxTy;
    }

    private final boolean fitsTransforms(JDFMatrix matrix, JDFBaseDataTypes.EnumFitsValue transforms) {
        if (transforms == null || transforms.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? !this.hasAttribute("AllowedTransforms") : !this.hasAttribute("AllowedTransforms") && !this.hasAttribute("PresentTransforms")) {
            return true;
        }
        double nT = 1.0E-6;
        double pT = 1.0E-6;
        double a = matrix.getA();
        double b = matrix.getB();
        double c = matrix.getC();
        double d = matrix.getD();
        double det = a * d - b * c;
        if (det == 0.0) {
            return false;
        }
        a /= Math.sqrt(Math.abs(det));
        b /= Math.sqrt(Math.abs(det));
        c /= Math.sqrt(Math.abs(det));
        d /= Math.sqrt(Math.abs(det));
        Vector vTransf = transforms == null || transforms.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedTransforms() : this.getPresentTransforms();
        int siz = vTransf.size();
        for (int i = 0; i < siz; ++i) {
            JDFElement.EnumOrientation orientation = (JDFElement.EnumOrientation)((Object)vTransf.elementAt(i));
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip0)) {
                if (!(a - 1.0 < pT) || !(a - 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d + 1.0 < pT) || !(d + 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip90)) {
                if (!(a < pT) || !(a > -nT) || !(b + 1.0 < pT) || !(b + 1.0 > -nT) || !(c + 1.0 < pT) || !(c + 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip180)) {
                if (!(a + 1.0 < pT) || !(a + 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d - 1.0 < pT) || !(d - 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Flip270)) {
                if (!(a < pT) || !(a > -nT) || !(b - 1.0 < pT) || !(b - 1.0 > -nT) || !(c - 1.0 < pT) || !(c - 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate0)) {
                if (!(a - 1.0 < pT) || !(a - 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d - 1.0 < pT) || !(d - 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate90)) {
                if (!(a < pT) || !(a > -nT) || !(b - 1.0 < pT) || !(b - 1.0 > -nT) || !(c + 1.0 < pT) || !(c + 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate180)) {
                if (!(a + 1.0 < pT) || !(a + 1.0 > -nT) || !(b < pT) || !(b > -nT) || !(c < pT) || !(c > -nT) || !(d + 1.0 < pT) || !(d + 1.0 > -nT)) continue;
                return true;
            }
            if (orientation.equals((Object)JDFElement.EnumOrientation.Rotate270)) {
                if (!(a < pT) || !(a > -nT) || !(b + 1.0 < pT) || !(b + 1.0 > -nT) || !(c - 1.0 < pT) || !(c - 1.0 > -nT) || !(d < pT) || !(d > -nT)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.MatrixEvaluation;
    }

    static {
        JDFMatrixState.atrInfoTable[0] = new AtrInfoTable("AllowedRotateMod", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFMatrixState.atrInfoTable[1] = new AtrInfoTable("AllowedShift", 0x33333311L, AttributeInfo.EnumAttributeType.NumberList, null, null);
        JDFMatrixState.atrInfoTable[2] = new AtrInfoTable("AllowedTransforms", 0x33333311L, AttributeInfo.EnumAttributeType.enumerations, JDFElement.EnumOrientation.getEnum(0), null);
        JDFMatrixState.atrInfoTable[3] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.matrix, null, null);
        JDFMatrixState.atrInfoTable[4] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.matrix, null, null);
        JDFMatrixState.atrInfoTable[5] = new AtrInfoTable("PresentRotateMod", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFMatrixState.atrInfoTable[6] = new AtrInfoTable("PresentShift", 0x33333311L, AttributeInfo.EnumAttributeType.NumberList, null, null);
        JDFMatrixState.atrInfoTable[7] = new AtrInfoTable("PresentTransforms", 0x44444431L, AttributeInfo.EnumAttributeType.enumerations, JDFElement.EnumOrientation.getEnum(0), null);
        elemInfoTable = new ElemInfoTable[1];
        JDFMatrixState.elemInfoTable[0] = new ElemInfoTable("Value", 0x33333311L);
    }
}

