/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.JDFXYPairRange;
import org.cip4.jdflib.datatypes.JDFXYPairRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;

public class JDFXYPairEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[3];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFXYPairEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFXYPairEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFXYPairEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFXYPairEvaluation[ --> " + super.toString() + " ]";
    }

    public void setValueList(JDFXYPairRangeList value) {
        this.setAttribute("ValueList", value.toString(), null);
    }

    public void setValueList(JDFXYPair value) {
        this.setAttribute("ValueList", value.toString(), null);
    }

    public JDFXYPairRangeList getValueList() {
        try {
            String valuelist = this.getAttribute("ValueList", null, null);
            if (valuelist == null) {
                return null;
            }
            JDFXYPairRangeList xyprl = new JDFXYPairRangeList(valuelist);
            return xyprl;
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFXYPairEvaluation.getValueList: Attribute VALUELIST is not applicable to create JDFXYPairRangeList");
        }
    }

    public void setXYRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("XYRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getXYRelation() {
        return JDFElement.EnumXYRelation.getEnum(this.getAttribute("XYRelation", null, null));
    }

    public void setTolerance(JDFXYPair value) {
        this.setAttribute("Tolerance", value.toString(), null);
    }

    @Override
    public JDFXYPair getTolerance() {
        return super.getTolerance();
    }

    @Override
    public boolean fitsValue(String value) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFXYPairRangeList rrl = null;
        try {
            rrl = new JDFXYPairRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        int siz = rrl.size();
        for (int i = 0; i < siz; ++i) {
            JDFXYPair xypair;
            JDFXYPair right;
            JDFXYPairRange range = (JDFXYPairRange)rrl.at(i);
            JDFXYPair left = range.getLeft();
            if (!(left.equals(right = range.getRight()) ? !(this.fitsValueList(new JDFXYPairRange(xypair = left)) && this.fitsXYRelation(xypair)) : !(this.fitsValueList(range) && this.fitsXYRelation(left) && this.fitsXYRelation(right)))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsListType(String value) {
        JDFXYPairRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFXYPairRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType == null || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue)) {
            try {
                new JDFXYPair(value);
            }
            catch (JDFException e) {
                return false;
            }
            catch (DataFormatException ie) {
                return false;
            }
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.RangeList) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.Span)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List)) {
            return rangelist.isList();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFXYPairEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFXYPairRange range) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        JDFXYPairRangeList rangelist = this.getValueList();
        if (this.hasAttribute("Tolerance")) {
            return this.fitsTolerance(rangelist).isPartOfRange(range);
        }
        return rangelist.isPartOfRange(range);
    }

    private JDFXYPairRangeList fitsTolerance(JDFXYPairRangeList origRangeList) {
        JDFXYPair tolerance = this.getTolerance();
        double nt = tolerance.getX();
        double pt = tolerance.getY();
        if (nt == 0.0 && pt == 0.0) {
            return origRangeList;
        }
        JDFXYPairRangeList rangeList = new JDFXYPairRangeList(origRangeList);
        JDFXYPairRangeList tolRangeList = new JDFXYPairRangeList();
        int size = rangeList.size();
        for (int i = 0; i < size; ++i) {
            JDFXYPairRange range = (JDFXYPairRange)rangeList.at(i);
            JDFXYPair left = range.getLeft();
            double leftX = left.getX();
            double leftY = left.getY();
            left.setX(leftX - nt);
            left.setY(leftY - nt);
            JDFXYPair right = range.getRight();
            double rightX = right.getX();
            double rightY = right.getY();
            right.setX(rightX + pt);
            right.setY(rightY + pt);
            range.setLeft(left);
            range.setRight(right);
            tolRangeList.append(range);
        }
        return tolRangeList;
    }

    private final boolean fitsXYRelation(JDFXYPair xypair) {
        if (!this.hasAttribute("XYRelation")) {
            return true;
        }
        double x = xypair.getX();
        double y = xypair.getY();
        JDFElement.EnumXYRelation relation = this.getXYRelation();
        if (!this.hasAttribute("Tolerance")) {
            return relation.evaluateXY(x, y, 1.0E-6, 1.0E-6);
        }
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        return relation.evaluateXY(x, y, nt, pt);
    }

    static {
        JDFXYPairEvaluation.atrInfoTable[0] = new AtrInfoTable("Tolerance", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, "0 0");
        JDFXYPairEvaluation.atrInfoTable[1] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.XYPairRangeList, null, null);
        JDFXYPairEvaluation.atrInfoTable[2] = new AtrInfoTable("XYRelation", 0x33333333L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
    }
}

