/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.PlatformUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.URLReader;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.net.ProxyUtil;

public class UrlUtil {
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String KEEPALIVE = "keep-alive";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String m_URIEscape = "|#%?@&=+$,;[]\\\"'<>^`\u00b4{}~";
    public static final String m_UNCEscape = "/\\*?<>|";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_UNKNOWN = "text/unknown";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_XZIP = "application/x-zip-compressed";
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_CSV = "text/csv";
    public static final String VND_JDF = "application/vnd.cip4-jdf+xml";
    public static final String VND_JMF = "application/vnd.cip4-jmf+xml";
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String BASE64 = "base64";
    public static final String BINARY = "binary";
    private static HashMap<String, String> mimeMap = null;

    public static String getRelativeURL(File f, File baseDir, boolean bEscape128) {
        String relPath = UrlUtil.getRelativePath(f, baseDir);
        if (relPath == null) {
            return UrlUtil.fileToUrl(f, true);
        }
        relPath = StringUtil.replaceChar(relPath, '\\', "/", 0);
        byte[] utf8 = StringUtil.setUTF8String(relPath);
        relPath = new String(utf8);
        relPath = StringUtil.escape(relPath, m_URIEscape, "%", 16, 2, 33, bEscape128 ? 128 : -1);
        return relPath;
    }

    public static String createHttpUrl(boolean bSecure, String host, int port, String path) {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            if (port > 0) {
                URL url = new URL("http" + (bSecure ? "s" : ""), host, port, path);
                return url.toExternalForm();
            }
            URL url = new URL("http" + (bSecure ? "s" : ""), host, path);
            return url.toExternalForm();
        }
        catch (MalformedURLException x) {
            return null;
        }
    }

    public static String getRelativePath(File f, File fCWD) {
        File fCWDLocal = fCWD;
        if (fCWDLocal == null) {
            fCWDLocal = new File(System.getProperty("user.dir"));
        }
        String cPath = null;
        String cwd = null;
        try {
            cPath = f.getCanonicalPath();
            cwd = fCWDLocal.getCanonicalPath();
            if (cPath.charAt(0) != cwd.charAt(0)) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        VString vCwd = StringUtil.tokenize(cwd, File.separator, false);
        VString vPath = StringUtil.tokenize(cPath, File.separator, false);
        int lenPath = vPath.size();
        int siz = vCwd.size();
        if (lenPath < siz) {
            siz = lenPath;
        }
        for (int i = 0; i < siz && vCwd.stringAt(0).equals(vPath.stringAt(0)); ++i) {
            vCwd.remove(0);
            vPath.remove(0);
        }
        lenPath = vPath.size();
        siz = vCwd.size();
        String prefix = siz == 0 ? "." : "..";
        for (int i = 1; i < siz; ++i) {
            prefix = prefix + "/..";
        }
        String s = lenPath == 0 ? prefix : StringUtil.setvString(vPath, File.separator, prefix + File.separator, null);
        return UrlUtil.cleanDots(s);
    }

    public static String getFileName(String url, Multipart mp) {
        BodyPart bp;
        String ret;
        if (!UrlUtil.isNotCID(url) && (ret = MimeUtil.getFileName(bp = MimeUtil.getPartByCID(mp, url))) != null) {
            return ret;
        }
        return UrlUtil.urlToFileName(url);
    }

    public static InputStream getCidURLStream(String url, Multipart multipart) {
        if (url == null || url.equals("")) {
            return null;
        }
        BodyPart bp = new MimeHelper(multipart).getPartByCID(url);
        return new BodyPartHelper(bp).getInputStream();
    }

    public static String extension(String pathName) {
        if (pathName == null) {
            return null;
        }
        int index = pathName.lastIndexOf(".");
        return index == -1 ? null : pathName.substring(index + 1);
    }

    @Deprecated
    public static String removeExtension(String pathName) {
        return UrlUtil.prefix(pathName);
    }

    public static UrlPart[] getURLParts(HttpURLConnection connection) {
        Multipart mp;
        if (connection == null) {
            return null;
        }
        String urlContentType = connection.getContentType();
        if (!"multipart/related".equalsIgnoreCase(urlContentType)) {
            UrlPart p;
            try {
                p = new UrlPart(connection);
            }
            catch (IOException x) {
                return null;
            }
            return new UrlPart[]{p};
        }
        try {
            mp = MimeUtil.getMultiPart(connection.getInputStream());
        }
        catch (IOException x) {
            return null;
        }
        BodyPart[] bp = MimeUtil.getBodyParts(mp);
        if (bp == null) {
            return null;
        }
        UrlPart[] parts = new UrlPart[bp.length];
        for (int i = 0; i < bp.length; ++i) {
            try {
                bp[i].getContentType();
                parts[i] = new UrlPart(bp[i]);
                continue;
            }
            catch (MessagingException e) {
                parts[i] = null;
                continue;
            }
            catch (IOException e) {
                parts[i] = null;
            }
        }
        return parts;
    }

    public static InputStream getURLInputStream(String urlString, BodyPart bodyPart) {
        URLReader reader = new URLReader(urlString);
        reader.setBodyPart(bodyPart);
        return reader.getURLInputStream();
    }

    public static InputStream getURLInputStream(String urlString) {
        return UrlUtil.getURLInputStream(urlString, null);
    }

    @Deprecated
    public static File getCreateDirectory(String newDir) {
        return FileUtil.getCreateDirectory(newDir);
    }

    public static String fileToUrl(File f, boolean bEscape128) {
        if (f == null) {
            return null;
        }
        String s = f.getAbsolutePath();
        if (File.separator.equals("\\")) {
            s = StringUtil.replaceChar(s, '\\', "/", 0);
        }
        s = UrlUtil.cleanDots(s);
        if ((s = UrlUtil.escape(s, bEscape128)).charAt(0) != '/') {
            s = "///" + s;
        }
        return "file:" + s;
    }

    public static String urlToFileName(String urlString) {
        int posQ;
        if (urlString == null) {
            return null;
        }
        int posSlash = urlString.lastIndexOf("/");
        posSlash = Math.max(posSlash, urlString.lastIndexOf("\\"));
        if ((posSlash = Math.max(posSlash, urlString.lastIndexOf(":"))) > 0) {
            urlString = urlString.substring(posSlash + 1);
        }
        if ((posQ = urlString.lastIndexOf("?")) > 0) {
            urlString = urlString.substring(0, posQ);
        }
        if (urlString.length() == 0) {
            return null;
        }
        File urlToFile = UrlUtil.urlToFile(urlString);
        return urlToFile == null ? null : urlToFile.getName();
    }

    public static File urlToFile(String urlString) {
        if (urlString == null) {
            return null;
        }
        if (UrlUtil.isCID(urlString) || UrlUtil.isHttp(urlString)) {
            return null;
        }
        if (UrlUtil.isFile(urlString)) {
            urlString = urlString.substring(5);
        }
        if (StringUtil.getNonEmpty(urlString) == null) {
            return null;
        }
        File f = new File(urlString);
        if (f.canRead()) {
            return f;
        }
        if (FileUtil.isWindows()) {
            if (urlString.startsWith("///") && urlString.length() > 6 && urlString.charAt(4) == ':' && urlString.charAt(5) == '/') {
                urlString = urlString.charAt(3) + ":" + urlString.substring(5);
            } else if (urlString.startsWith("/") && urlString.length() > 3 && urlString.charAt(2) == '/' && urlString.charAt(1) != '/') {
                urlString = urlString.charAt(1) + ":" + urlString.substring(2);
            } else if (urlString.startsWith("///")) {
                urlString = urlString.substring(2);
            }
        }
        urlString = UrlUtil.unEscape(urlString);
        return new File(urlString);
    }

    public static String urlToUNC(String urlString) {
        if (urlString == null) {
            return null;
        }
        if (UrlUtil.isCID(urlString) || UrlUtil.isHttp(urlString)) {
            return null;
        }
        if (UrlUtil.isFile(urlString)) {
            urlString = urlString.substring(5);
        }
        if (StringUtil.getNonEmpty(urlString) == null) {
            return null;
        }
        urlString = StringUtil.replaceCharSet(urlString, "/\\", "\u0000", 0);
        urlString = UrlUtil.unEscape(urlString);
        urlString = StringUtil.escape(urlString, m_UNCEscape, "%", 16, 2, -1, -1);
        urlString = StringUtil.replaceChar(urlString, '\u0000', "\\", 0);
        return urlString;
    }

    public static String uncToUrl(String unc, boolean escape128) {
        if (!UrlUtil.isUNC(unc)) {
            URL url = UrlUtil.stringToURL(unc);
            return url == null ? null : url.toExternalForm();
        }
        String url = StringUtil.replaceCharSet(unc, "\\", "/", 0);
        url = UrlUtil.escape(url, escape128);
        return "file:" + url;
    }

    public static String urlToString(URL url) {
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public static String addParameter(String baseUrl, String key, String val) {
        int posQMark = baseUrl.indexOf("?");
        String flag = posQMark >= 0 ? "&" : "?";
        StringBuffer buf = new StringBuffer(baseUrl);
        key = UrlUtil.escape(key, true);
        val = UrlUtil.escape(val, true);
        val = StringUtil.escape(val, ":/", "%", 16, 2, -1, -1);
        buf.append(flag).append(key).append("=").append(val);
        return buf.toString();
    }

    public static String addPath(String baseUrl, String path) {
        if (path == null) {
            return baseUrl;
        }
        if (baseUrl == null) {
            return path;
        }
        String request = StringUtil.token(baseUrl, 0, "?");
        request = StringUtil.addToken(request, "/", path);
        String params = StringUtil.token(baseUrl, 1, "?");
        if (params != null) {
            request = request + "?" + params;
        }
        return request;
    }

    public static String escape(String toEscape, boolean bEscape128) {
        if (toEscape == null) {
            return null;
        }
        if (bEscape128) {
            toEscape = new String(StringUtil.setUTF8String(toEscape));
            toEscape = StringUtil.escape(toEscape, m_URIEscape, "%", 16, 2, 33, 127);
        } else {
            toEscape = StringUtil.escape(toEscape, m_URIEscape, "%", 16, 2, 33, Integer.MAX_VALUE);
        }
        return toEscape;
    }

    public static String unEscape(String toEscape) {
        return StringUtil.unEscape(toEscape, "%", 16, 2);
    }

    public static URL stringToURL(String urlString) {
        URL url = null;
        if (StringUtil.getNonEmpty(urlString) == null) {
            return null;
        }
        if (UrlUtil.isUNC(urlString)) {
            try {
                return new URL(UrlUtil.uncToUrl(urlString, true));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (UrlUtil.isEscaped(urlString)) {
            urlString = UrlUtil.unEscape(urlString);
        }
        try {
            String fileToUrl;
            url = UrlUtil.isCID(urlString) || UrlUtil.isHttp(urlString) ? new URL(urlString) : ((fileToUrl = UrlUtil.fileToUrl(UrlUtil.urlToFile(urlString), true)) == null ? null : new URL(fileToUrl));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static boolean isFileOK(File f) {
        return f != null && !f.isDirectory() && f.canRead();
    }

    public static boolean isEscaped(String url) {
        if (url == null) {
            return false;
        }
        int posColon = url.indexOf(":");
        int posEscapedColon = url.toLowerCase().indexOf("%3a");
        if (posColon < 0 && posEscapedColon < 0) {
            return false;
        }
        if (posColon < 0) {
            posColon += Integer.MAX_VALUE;
        }
        if (posEscapedColon < 0) {
            posEscapedColon += Integer.MAX_VALUE;
        }
        return posEscapedColon < posColon;
    }

    public static String getMimeTypeFromURL(String url) {
        String extension;
        if (mimeMap == null) {
            mimeMap = new HashMap();
            mimeMap.put("pdf", APPLICATION_PDF);
            mimeMap.put("ps", "application/postscript");
            mimeMap.put("ppf", "application/vnd.cip3-ppf");
            mimeMap.put("ppml", "application/vnd.podi-ppml+xml");
            mimeMap.put("ptk", "application/vnd.cip4-ptk+xml");
            mimeMap.put("xjdf", "application/vnd.cip4-xjdf+xml");
            mimeMap.put("jdf", VND_JDF);
            mimeMap.put("jmf", VND_JMF);
            mimeMap.put("xml", TEXT_XML);
            mimeMap.put("xsl", TEXT_XML);
            mimeMap.put("xsd", TEXT_XML);
            mimeMap.put("csv", TEXT_CSV);
            mimeMap.put("jpg", "image/jpeg");
            mimeMap.put("jpeg", "image/jpeg");
            mimeMap.put("png", "image/x-png");
            mimeMap.put("tif", "image/tiff");
            mimeMap.put("tiff", "image/tiff");
            mimeMap.put("mjm", "multipart/related");
            mimeMap.put("mjd", "multipart/related");
            mimeMap.put("mim", "multipart/related");
            mimeMap.put("zip", APPLICATION_ZIP);
        }
        String mimeType = (extension = UrlUtil.extension(url)) == null ? null : mimeMap.get(extension.toLowerCase());
        return mimeType == null ? TEXT_UNKNOWN : mimeType;
    }

    public static boolean isCID(String url) {
        String urlLocal = url;
        if (urlLocal == null) {
            return false;
        }
        if (urlLocal.startsWith("<")) {
            urlLocal = urlLocal.substring(1);
        }
        String lowerURL = urlLocal.toLowerCase();
        return lowerURL.startsWith("cid:");
    }

    public static boolean isNotCID(String url) {
        if (StringUtil.getNonEmpty(url) == null) {
            return true;
        }
        if (UrlUtil.isCID(url)) {
            return false;
        }
        if (UrlUtil.isHttp(url) || UrlUtil.isHttps(url)) {
            return true;
        }
        return UrlUtil.isFile(url);
    }

    public static boolean isFile(String url) {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith("file:");
    }

    public static boolean isWindowsLocalPath(String pathName) {
        if (pathName == null || pathName.length() <= 1 || UrlUtil.isUNC(pathName)) {
            return false;
        }
        return StringUtils.isAlpha((String)pathName.substring(0, 1)) && pathName.substring(1, 2).equals(":") || StringUtils.countMatches((String)pathName, (String)"\\") > StringUtils.countMatches((String)pathName, (String)"/");
    }

    public static boolean isHttp(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith("http://");
    }

    public static boolean isHttps(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith("https://");
    }

    public static String normalize(String urlString) {
        URL url;
        if (!UrlUtil.isRelativeURL(urlString) && (url = UrlUtil.stringToURL(urlString)) != null) {
            return UrlUtil.urlToString(url);
        }
        urlString = UrlUtil.unEscape(urlString);
        urlString = UrlUtil.escape(urlString, false);
        urlString = UrlUtil.cleanDots(urlString);
        return urlString;
    }

    public static boolean isUNC(String pathName) {
        if (pathName == null || pathName.length() == 0) {
            return false;
        }
        return pathName.startsWith("\\\\");
    }

    public static boolean isMIME(File file) {
        String packageName;
        try {
            packageName = file.getCanonicalPath();
        }
        catch (IOException x) {
            return false;
        }
        String lower = packageName.toLowerCase();
        return UrlUtil.isMIMEExtenstension(lower);
    }

    public static URLProtocol getProtocol(String url) {
        if (UrlUtil.isCID(url)) {
            return URLProtocol.cid;
        }
        if (UrlUtil.isHttp(url) || UrlUtil.isHttps(url)) {
            return URLProtocol.http;
        }
        if (UrlUtil.isFile(url)) {
            return URLProtocol.file;
        }
        return null;
    }

    public static String getIPFromBytes(byte[] ip) {
        if (ip == null || ip.length != 4 && ip.length != 6) {
            return null;
        }
        StringBuffer b = new StringBuffer(32);
        for (int i = 0; i < ip.length; ++i) {
            b.append(ip[i]);
            if (i <= 0) continue;
            b.append('.');
        }
        return b.toString();
    }

    public static byte[] getBytesFromIP(String ip) {
        VString v = StringUtil.tokenize(ip, ".", false);
        if (v == null || v.size() < 4) {
            return null;
        }
        byte[] b = new byte[v.size()];
        int n = 0;
        for (String s : v) {
            int i = StringUtil.parseInt(s, -1);
            if (i > 255 || i < 0) {
                return null;
            }
            b[n++] = (byte)i;
        }
        return b;
    }

    public static boolean isMIMEExtenstension(String lower) {
        if ((lower = UrlUtil.extension(lower)) == null) {
            return false;
        }
        return lower.equalsIgnoreCase("mjm") || lower.equalsIgnoreCase("mjd") || lower.equalsIgnoreCase("mim");
    }

    public static boolean isIRL(String val) {
        char[] c = val.toCharArray();
        boolean bFix = false;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '\u007f') continue;
            c[i] = 97;
            bFix = true;
        }
        return UrlUtil.isURL(bFix ? new String(c) : val);
    }

    public static String removeProtocol(String url) {
        if (url == null) {
            return null;
        }
        int pos = url.indexOf("://");
        if (pos > -1) {
            url = url.substring(pos + 3);
        } else if (UrlUtil.isCID(url)) {
            url = StringUtil.rightStr(url, -4);
        }
        return StringUtil.getNonEmpty(url);
    }

    public static boolean isURL(String val) {
        if (val == null) {
            return false;
        }
        try {
            URI uri = new URI(val);
            String scheme = uri.getScheme();
            if (scheme != null && scheme.toLowerCase().startsWith("http") && uri.getHost() == null) {
                return false;
            }
        }
        catch (URISyntaxException x) {
            return false;
        }
        return val.length() < 4096;
    }

    public static String getLocalURL(String directory, String url) {
        if (directory == null || url == null || directory.length() == 0) {
            return url;
        }
        int len = directory.length();
        if (len > 0 && !directory.endsWith("/")) {
            ++len;
        }
        if (url.length() <= len) {
            return null;
        }
        VString vDirectory = StringUtil.tokenize(directory, "/", false);
        VString vURL = StringUtil.tokenize(url, "/", false);
        if (vDirectory.size() >= vURL.size()) {
            return null;
        }
        if (vDirectory.size() > 0 && vURL.size() > 0) {
            if (vDirectory.get(0).endsWith(":")) {
                vDirectory.set(0, vDirectory.get(0).toLowerCase());
            }
            if (vURL.get(0).endsWith(":")) {
                vURL.set(0, vURL.get(0).toLowerCase());
            }
        }
        for (String dirChunk : vDirectory) {
            String urlChunk = vURL.get(0);
            if (urlChunk.equals(dirChunk)) {
                vURL.remove(0);
                continue;
            }
            return null;
        }
        return StringUtil.setvString(vURL, "/", null, null);
    }

    public static String getURLWithDirectory(String directory, String url) {
        if (StringUtil.getNonEmpty(directory) == null) {
            return url;
        }
        if (url == null) {
            return directory;
        }
        if (url.indexOf(":") > 0 && (url.indexOf("/") < 0 || url.indexOf("/") > url.indexOf(":"))) {
            return url;
        }
        if (url.startsWith("/")) {
            try {
                URI dirURI = new URI(directory);
                String scheme = dirURI.getScheme();
                if (scheme != null) {
                    directory = scheme + ":";
                    if (!url.startsWith("//")) {
                        url = "/" + url;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (!directory.endsWith("/") && !url.startsWith("/")) {
            directory = directory + "/";
        }
        return UrlUtil.cleanDots(directory + url);
    }

    public static String getParentDirectory(String url) {
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(47);
        int pos2 = url.lastIndexOf(92);
        if (pos2 >= 0 && pos2 > pos) {
            pos = pos2;
        }
        return pos > 0 ? StringUtil.leftStr(url, pos) : ".";
    }

    public static String cleanDots(String url) {
        int i;
        String prefix;
        int posTriple;
        if (url == null) {
            return null;
        }
        while (url.length() > 2 && url.startsWith("./")) {
            url = url.substring(2);
        }
        int posDouble = url.indexOf("//");
        int prefixLen = posDouble == (posTriple = url.indexOf("///")) ? 3 : 2;
        String string = prefix = url.startsWith("/") ? "/" : "";
        if (posDouble >= 0) {
            prefix = url.substring(0, posDouble + prefixLen);
            url = url.substring(posDouble + prefixLen);
        }
        VString vs = StringUtil.tokenize(url, "/", false);
        for (i = vs.size() - 1; i > 0; --i) {
            if (!vs.stringAt(i).equals("") && !vs.stringAt(i).equals(".")) continue;
            vs.remove(i);
        }
        block2: for (i = vs.size() - 1; i > 0; --i) {
            if (!vs.stringAt(i).equals("..")) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (vs.stringAt(j).equals("..")) continue;
                vs.remove(i--);
                vs.remove(j);
                continue block2;
            }
        }
        return prefix + (vs.isEmpty() ? "." : StringUtil.setvString(vs, "/", null, null));
    }

    public static String cleanHttpURL(String url) {
        VString v = StringUtil.tokenize(url, "/", false);
        if (v == null) {
            return null;
        }
        String protocol = v.get(0);
        if (!protocol.startsWith("http")) {
            protocol = "http://";
        } else if (protocol.startsWith("https")) {
            protocol = "https://";
            v.remove(0);
        } else {
            protocol = "http://";
            v.remove(0);
        }
        return StringUtil.setvString(v, "/", protocol, null);
    }

    public static UrlPart writeToURL(String strUrl, InputStream stream, String method, String contentType, HTTPDetails details) {
        URLWriter urlWriter = new URLWriter(strUrl, stream, method, contentType, details);
        return urlWriter.writeToURL();
    }

    @Deprecated
    public static File moveToDir(IURLSetter parent, File dir, boolean overWrite) {
        return UrlUtil.moveToDir(parent, dir, null, overWrite);
    }

    public static File moveToDir(IURLSetter parent, File dir, String cwd, boolean overWrite) {
        InputStream inputStream;
        File localFile;
        File out;
        XMLDoc d;
        File oldDir;
        File oldFile;
        if (dir == null) {
            return null;
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                return null;
            }
        } else {
            dir.mkdirs();
        }
        String url = parent.getURL();
        String fileName = null;
        if (UrlUtil.isRelativeURL(url)) {
            fileName = UrlUtil.cleanDots(url);
            if (cwd != null) {
                url = UrlUtil.getURLWithDirectory(cwd, url);
            }
        }
        if ((oldFile = UrlUtil.urlToFile(url)) != null && FileUtil.equals(oldDir = oldFile.getParentFile(), dir)) {
            return oldFile;
        }
        XMLDoc xMLDoc = d = parent instanceof KElement ? ((KElement)((Object)parent)).getOwnerDocument_KElement() : null;
        if (fileName == null) {
            Multipart mp = d == null ? null : d.getMultiPart();
            fileName = UrlUtil.getFileName(url, mp);
        }
        if ((out = FileUtil.getFileInDirectory(dir, localFile = fileName == null ? null : new File(fileName))).exists()) {
            if (overWrite) {
                out.delete();
            } else {
                return out;
            }
        }
        if ((inputStream = new URLReader(url, d).getURLInputStream()) != null) {
            if ((out = FileUtil.streamToFile(inputStream, out)) != null) {
                parent.setURL(UrlUtil.fileToUrl(out, false));
            }
        } else {
            out = null;
        }
        return out;
    }

    public static boolean isRelativeURL(String url) {
        if (url == null) {
            return false;
        }
        return url.indexOf(":/") < 0 && url.indexOf(":\\") < 0 && !url.startsWith("/") && !url.startsWith("\\") && !UrlUtil.isCID(url);
    }

    public static boolean isXMLType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lower = contentType.toLowerCase().trim();
        while (lower.endsWith(";")) {
            lower = StringUtil.leftStr(lower, -1);
        }
        if (TEXT_XML.equals(lower) || APPLICATION_XML.equals(lower)) {
            return true;
        }
        return (lower.startsWith("application") || lower.startsWith("text")) && lower.endsWith("+xml");
    }

    public static boolean isZIPType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lower = contentType.toLowerCase().trim();
        while (lower.endsWith(";")) {
            lower = StringUtil.leftStr(lower, -1);
        }
        return APPLICATION_ZIP.equals(lower) || APPLICATION_XZIP.equals(lower);
    }

    public static String newExtension(String strWork, String newExt) {
        if (newExt == null) {
            return UrlUtil.prefix(strWork);
        }
        if (!newExt.startsWith(".")) {
            newExt = "." + newExt;
        }
        return UrlUtil.prefix(strWork) + newExt;
    }

    public static String prefix(String strWork) {
        String ext = UrlUtil.extension(strWork);
        if (ext == null) {
            return strWork;
        }
        return strWork.substring(0, strWork.length() - ext.length() - 1);
    }

    private static class URLWriter {
        private final String strUrl;
        private InputStream stream;
        private final String method;
        private final String contentType;
        private final HTTPDetails details;

        public String toString() {
            return "UrlWriter: " + this.method + " / " + this.contentType + " --> " + this.strUrl;
        }

        public URLWriter(String strUrl, InputStream stream, String method, String contentType, HTTPDetails details) {
            this.strUrl = strUrl;
            this.stream = stream;
            this.method = method;
            if (contentType == null) {
                contentType = UrlUtil.TEXT_UNKNOWN;
            }
            this.contentType = StringUtil.token(contentType, 0, "\r\n");
            this.details = details;
        }

        protected UrlPart writeToURL() {
            UrlPart p = null;
            UrlPart p0 = null;
            if (UrlUtil.isFile(this.strUrl)) {
                p = this.writeFile();
            } else {
                URL url = UrlUtil.stringToURL(this.strUrl);
                URI uri = ProxyUtil.getHostURI(url);
                if (uri == null) {
                    return null;
                }
                ProxySelector selector = ProxySelector.getDefault();
                List<Proxy> list = selector.select(uri);
                if (!list.contains(Proxy.NO_PROXY)) {
                    Vector<Proxy> list2 = new Vector<Proxy>();
                    list2.add(Proxy.NO_PROXY);
                    list2.addAll(list);
                    list = list2;
                }
                for (Proxy proxy : list) {
                    if (list.size() > 1) {
                        this.stream = ByteArrayIOStream.getBufferedInputStream(this.stream);
                    }
                    if ((p = this.callProxy(proxy)) == null) continue;
                    if (p.getResponseCode() == 200) {
                        return p;
                    }
                    p0 = p;
                }
            }
            return p == null ? p0 : p;
        }

        private UrlPart writeFile() {
            File f = UrlUtil.urlToFile(this.strUrl);
            f = FileUtil.streamToFile(this.stream, f);
            try {
                return new UrlPart(f);
            }
            catch (IOException x) {
                return null;
            }
        }

        private UrlPart callProxy(Proxy proxy) {
            URL url = UrlUtil.stringToURL(this.strUrl);
            try {
                HttpURLConnection httpURLconnection = (HttpURLConnection)url.openConnection(proxy);
                httpURLconnection.setConnectTimeout(PlatformUtil.getConnectionTimeout());
                httpURLconnection.setRequestMethod(this.method);
                httpURLconnection.setRequestProperty("Connection", UrlUtil.KEEPALIVE);
                httpURLconnection.setRequestProperty(UrlUtil.CONTENT_TYPE, this.contentType);
                if (this.details != null) {
                    this.details.applyTo(httpURLconnection);
                }
                this.output(httpURLconnection);
                return new UrlPart(httpURLconnection);
            }
            catch (Throwable x) {
                LogFactory.getLog(URLWriter.class).error((Object)(x.getClass().getCanonicalName() + " snafu writing to url: " + this.strUrl + " " + x.getMessage()));
                return null;
            }
        }

        private void output(HttpURLConnection httpURLconnection) throws IOException {
            boolean doOutput = this.stream != null;
            httpURLconnection.setDoOutput(doOutput);
            if (doOutput) {
                OutputStream out = httpURLconnection.getOutputStream();
                IOUtils.copy((InputStream)this.stream, (OutputStream)out);
                out.flush();
                out.close();
            }
        }
    }

    public static enum URLProtocol {
        cid,
        http,
        file;

    }

    public static class HTTPDetails {
        public int chunkSize = defaultChunkSize;
        public static int defaultChunkSize = -1;

        public void applyTo(HttpURLConnection urlCon) {
            if (urlCon != null && this.chunkSize > 0) {
                urlCon.setChunkedStreamingMode(this.chunkSize);
            }
        }
    }
}

