/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.util.ContainerUtil;

public class VectorMap<key, vectorObject>
extends HashMap<key, Vector<vectorObject>> {
    private static final long serialVersionUID = -2180413692846276265L;
    private boolean bUnique;

    public VectorMap() {
        this.setUnique(true);
    }

    public vectorObject getOne(Object key, int i) {
        Vector c = (Vector)this.get(key);
        if (c == null) {
            return null;
        }
        int n = c.size();
        if (i < 0) {
            i += n;
        }
        if (i < 0 || i >= n) {
            return null;
        }
        return (vectorObject)c.get(i);
    }

    public int getIndex(key key, vectorObject singleObject) {
        Vector keyVector = (Vector)this.get(key);
        if (keyVector == null) {
            return -2;
        }
        return keyVector.indexOf(singleObject);
    }

    public int size(key key) {
        Vector c = (Vector)this.get(key);
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public void putOne(key key, vectorObject val) {
        Vector<vectorObject> v = (Vector<vectorObject>)this.get(key);
        if (v == null) {
            v = new Vector<vectorObject>();
            this.put(key, v);
        }
        if (!this.bUnique || !v.contains(val)) {
            v.add(val);
        }
    }

    public synchronized void appendUnique(key key, Vector<vectorObject> vVal) {
        if (vVal == null) {
            return;
        }
        boolean keepUnique = this.bUnique;
        this.bUnique = true;
        for (vectorObject val : vVal) {
            this.putOne(key, val);
        }
        this.bUnique = keepUnique;
    }

    public void appendUnique(VectorMap<key, vectorObject> map) {
        if (map == null) {
            return;
        }
        for (Object next : map.keySet()) {
            this.appendUnique(next, (Vector)map.get(next));
        }
    }

    public Vector<vectorObject> getAllValues() {
        Vector v = new Vector();
        Collection c = this.values();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            v = (Vector)ContainerUtil.addAll(v, (Collection)it.next());
        }
        return v.size() == 0 ? null : v;
    }

    public Map<vectorObject, key> getInvertedMap() {
        HashMap inverted = new HashMap();
        Set keys = this.keySet();
        for (Object k : keys) {
            Vector v = (Vector)this.get(k);
            if (v == null) continue;
            for (Object vo : v) {
                inverted.put(vo, k);
            }
        }
        return inverted;
    }

    public void removeOne(key key, vectorObject val) {
        Vector v = (Vector)this.get(key);
        if (v != null) {
            v.remove(val);
            if (v.size() == 0) {
                this.remove(key);
            }
        }
    }

    public void setOne(key key, vectorObject newObj, vectorObject oldObj) {
        Vector v = (Vector)this.get(key);
        if (v != null) {
            int i = v.indexOf(oldObj);
            if (i < 0) {
                this.putOne(key, newObj);
            } else {
                v.set(i, newObj);
            }
        } else {
            this.putOne(key, newObj);
        }
    }

    public void setOne(key key, vectorObject newObj, int pos) {
        Vector<vectorObject> v = (Vector<vectorObject>)this.get(key);
        if (v == null) {
            v = new Vector<vectorObject>();
            this.put(key, v);
        }
        if (pos < 0) {
            pos += v.size();
        }
        if (pos < 0) {
            throw new IllegalArgumentException("index <0 after adding size: " + pos);
        }
        ContainerUtil.ensureSize(pos + 1, v);
        v.set(pos, newObj);
    }

    public boolean isUnique() {
        return this.bUnique;
    }

    public void setUnique(boolean bUnique) {
        this.bUnique = bUnique;
    }
}

