/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFReturnQueueEntryParams;
import org.cip4.jdflib.jmf.JMFBuilder;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.QueueHotFolderListener;

public class QueueHotFolderListenerImpl
implements HotFolderListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    final QueueHotFolderListener qhfl;
    final JDFCommand queueCommand;

    public QueueHotFolderListenerImpl(QueueHotFolderListener qhfl, JDFJMF _queueCommand) {
        this.qhfl = qhfl;
        if (_queueCommand == null) {
            _queueCommand = new JMFBuilder().buildSubmitQueueEntry(null);
        }
        this.queueCommand = _queueCommand.getCommand(0);
    }

    @Override
    public boolean hotFile(File hotFile) {
        String stringURL = UrlUtil.fileToUrl(hotFile, false);
        JDFDoc jmfDoc = new JDFDoc("JMF");
        JDFJMF jmfRoot = jmfDoc.getJMFRoot();
        JDFCommand newCommand = (JDFCommand)jmfRoot.copyElement(this.queueCommand, null);
        newCommand.removeAttribute("ID");
        newCommand.appendAnchor(null);
        JDFMessage.EnumType cType = newCommand.getEnumType();
        JDFDoc jdfDoc = JDFDoc.parseFile(hotFile.getPath());
        JDFNode jdfRoot = jdfDoc.getJDFRoot();
        this.log.info((Object)("generating queue command: " + this.queueCommand.getType()));
        if (JDFMessage.EnumType.ReturnQueueEntry.equals((Object)cType)) {
            this.extractReturnParams(stringURL, newCommand, jdfRoot);
        } else if (JDFMessage.EnumType.SubmitQueueEntry.equals((Object)cType)) {
            this.extractSubmitParams(stringURL, newCommand, jdfRoot);
        }
        return this.qhfl.submitted(jmfRoot);
    }

    protected void extractReturnParams(String stringURL, JDFCommand newCommand, JDFNode jdfRoot) {
        JDFReturnQueueEntryParams rqp = newCommand.getCreateReturnQueueEntryParams(0);
        rqp.setURL(stringURL);
        if (jdfRoot != null) {
            String queueEID;
            JDFAuditPool ap = jdfRoot.getCreateAuditPool();
            JDFProcessRun pr = (JDFProcessRun)ap.getAudit(-1, JDFAudit.EnumAuditType.ProcessRun, null, null);
            String string = queueEID = pr == null ? null : pr.getAttribute("QueueEntryID");
            if (!KElement.isWildCard(queueEID)) {
                rqp.setQueueEntryID(queueEID);
            }
        }
    }

    protected void extractSubmitParams(String stringURL, JDFCommand newCommand, JDFNode jdfRoot) {
        JDFQueueSubmissionParams sqp = newCommand.getCreateQueueSubmissionParams(0);
        sqp.setURL(stringURL);
        if (jdfRoot != null) {
            JDFAuditPool ap = jdfRoot.getCreateAuditPool();
            ap.createSubmitProcessRun(null);
        }
    }
}

