/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.thread.WaitTimeout;

public class UrlCheck {
    public final String method;
    private final String url;
    private UrlWait wait;

    public UrlCheck(String url) {
        this(url, "HEAD");
    }

    public UrlCheck(String url, String method) {
        this.url = url;
        this.wait = null;
        this.method = method;
    }

    public UrlPart ping(int waitMillis) {
        this.startPing(waitMillis);
        UrlPart p = this.getPing();
        return p;
    }

    public UrlPart getPing() {
        UrlPart p = this.wait == null ? null : (UrlPart)this.wait.getWaitedObject();
        return p;
    }

    public void startPing(int waitMillis) {
        this.wait = new UrlWait(waitMillis);
    }

    public int pingRC(int waitMillis) {
        UrlPart p = this.ping(waitMillis);
        return p == null ? -1 : p.getResponseCode();
    }

    public int getPingRC() {
        UrlPart p = this.getPing();
        return p == null ? -1 : p.getResponseCode();
    }

    private class UrlWait
    extends WaitTimeout<UrlPart> {
        UrlWait(int millis) {
            super(millis);
            this.start();
        }

        @Override
        protected UrlPart handle() {
            UrlPart p = UrlUtil.writeToURL(UrlCheck.this.url, null, UrlCheck.this.method, null, null);
            return p;
        }
    }
}

