/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Map;
import java.util.Vector;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.OrderedTaskQueue;

public class MultiTaskQueue
extends OrderedTaskQueue {
    private int maxParallel = 2;
    private final Vector<NextRunner> current = new Vector();
    private int totalParallel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiTaskQueue getCreateQueue(String name, int maxParallel) {
        name = MultiTaskQueue.getThreadName(name);
        Map map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = (OrderedTaskQueue)theMap.get(name);
            if (!(orderedTaskQueue instanceof MultiTaskQueue) || orderedTaskQueue.stop) {
                orderedTaskQueue = new MultiTaskQueue(name);
                theMap.put(name, orderedTaskQueue);
            }
            MultiTaskQueue multiTaskQueue = (MultiTaskQueue)orderedTaskQueue;
            multiTaskQueue.setMaxParallel(maxParallel);
            return multiTaskQueue;
        }
    }

    public void setMaxParallel(int maxParallel) {
        if (maxParallel > 0) {
            this.maxParallel = maxParallel;
        }
    }

    public int getCurrentRunning() {
        return this.current.size();
    }

    @Override
    public boolean interruptCurrent(int minAge) {
        Vector<NextRunner> currentCopy = new Vector<NextRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (NextRunner next : currentCopy) {
            if (next.worker.getRunTime() < (long)minAge) continue;
            this.interruptRunner(next);
            bRet = bRet || !this.current.contains(next);
        }
        return bRet;
    }

    public boolean interruptTask(Runnable theRunner) {
        Vector<NextRunner> currentCopy = new Vector<NextRunner>();
        currentCopy.addAll(this.current);
        boolean bRet = false;
        for (NextRunner next : currentCopy) {
            if (next.worker.theTask != theRunner) continue;
            this.interruptRunner(next);
            bRet = !this.current.contains(next);
            break;
        }
        return bRet;
    }

    private void interruptRunner(NextRunner next) {
        int n = 0;
        while (this.current.contains(next)) {
            next.interrupt();
            if (ThreadUtil.sleep(++n) && n <= 10) continue;
            break;
        }
    }

    Vector<Runnable> getCurrent(int minAge) {
        Vector<NextRunner> currentCopy = new Vector<NextRunner>();
        currentCopy.addAll(this.current);
        Vector<Runnable> vReturn = new Vector<Runnable>();
        for (NextRunner next : currentCopy) {
            if (next.worker.getRunTime() < (long)minAge) continue;
            vReturn.add(next.worker.theTask);
        }
        return vReturn;
    }

    private MultiTaskQueue(String name) {
        super(name);
    }

    @Override
    public String toString() {
        return "MultiTaskQueue " + this.getName() + " " + this.stop + " queue: " + this.queue;
    }

    @Override
    synchronized OrderedTaskQueue.TaskRunner getFirstTask() {
        if (this.getCurrentRunning() >= this.maxParallel) {
            return null;
        }
        OrderedTaskQueue.TaskRunner r = super.getFirstTask();
        return r;
    }

    @Override
    void runTask(OrderedTaskQueue.TaskRunner r) {
        NextRunner nextRunner = new NextRunner(r);
        this.current.add(nextRunner);
        nextRunner.start();
    }

    private class NextRunner
    extends Thread {
        OrderedTaskQueue.TaskRunner worker;

        NextRunner(OrderedTaskQueue.TaskRunner worker) {
            super(MultiTaskQueue.this.getName() + "_" + ++MultiTaskQueue.this.totalParallel + "_" + MultiTaskQueue.this.current.size());
            this.worker = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.worker.run();
            }
            finally {
                MultiTaskQueue.this.current.remove(this);
                ThreadUtil.notifyAll(MultiTaskQueue.this.mutex);
            }
        }
    }
}

