/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;

public class OrderedTaskQueue
extends Thread {
    final Vector<TaskRunner> queue;
    boolean stop;
    final Log log;
    MyMutex mutex;
    int done;
    long sumQueue;
    long sumRun;
    TaskRunner currentRunning;
    static Map<String, OrderedTaskQueue> theMap = new HashMap<String, OrderedTaskQueue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedTaskQueue getCreateQueue(String name) {
        name = OrderedTaskQueue.getThreadName(name);
        Map<String, OrderedTaskQueue> map = theMap;
        synchronized (map) {
            OrderedTaskQueue orderedTaskQueue = theMap.get(name);
            if (orderedTaskQueue == null || orderedTaskQueue.stop) {
                orderedTaskQueue = new OrderedTaskQueue(name);
                theMap.put(name, orderedTaskQueue);
            }
            return orderedTaskQueue;
        }
    }

    OrderedTaskQueue(String name) {
        super(name);
        this.setDaemon(true);
        this.log = LogFactory.getLog(this.getClass());
        this.queue = new Vector();
        this.mutex = new MyMutex();
        this.done = 0;
        this.sumQueue = 0L;
        this.sumRun = 0L;
        this.start();
    }

    static String getThreadName(String name) {
        return name == null ? "OrderedTaskQueue" : "OrderedTaskQueue_" + name;
    }

    public static void shutDownAll() {
        LogFactory.getLog(OrderedTaskQueue.class).info((Object)"shutting down all ordered queues");
        Vector<String> v = ContainerUtil.getKeyVector(theMap);
        if (v != null) {
            for (String key : v) {
                theMap.get(key).shutDown();
            }
        }
    }

    public void shutDown() {
        this.log.info((Object)"shutting down ordered queue");
        this.stop = true;
        theMap.remove(this.getName());
    }

    public boolean interruptCurrent(int minAge) {
        TaskRunner cr = this.currentRunning;
        if (cr != null && cr.getRunTime() < (long)minAge) {
            return false;
        }
        int n = 0;
        while (cr != null && cr == this.currentRunning) {
            this.interrupt();
            if (ThreadUtil.sleep(++n) && n <= 10) continue;
        }
        return cr == null || cr != this.currentRunning;
    }

    public int size() {
        return this.queue.size();
    }

    public int getDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(Runnable task) {
        if (this.stop) {
            this.log.error((Object)"cannot queue task in stopped queue");
            return false;
        }
        Vector<TaskRunner> vector = this.queue;
        synchronized (vector) {
            this.queue.add(new TaskRunner(task));
        }
        ThreadUtil.notifyAll(this.mutex);
        return true;
    }

    @Override
    public void run() {
        this.log.info((Object)"starting queue persist loop");
        do {
            try {
                this.runTasks();
            }
            catch (Throwable e) {
                this.log.error((Object)"whazzup queueing ordered task ", e);
            }
            if (!this.stop) continue;
            this.log.info((Object)"end of ordered task loop");
            ThreadUtil.notifyAll(this.mutex);
            this.mutex = null;
            break;
        } while (ThreadUtil.wait(this.mutex, 1000000));
    }

    private void runTasks() {
        while (!this.stop) {
            this.currentRunning = this.getFirstTask();
            if (this.currentRunning == null) break;
            this.runTask(this.currentRunning);
            this.currentRunning = null;
        }
    }

    void runTask(TaskRunner r) {
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskRunner getFirstTask() {
        Vector<TaskRunner> vector = this.queue;
        synchronized (vector) {
            if (this.queue.size() > 0) {
                return this.queue.remove(0);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "OrderedTaskQueue " + this.getName() + " " + this.stop + " queue: " + this.queue;
    }

    public long getAvQueue() {
        return this.done == 0 ? 0L : this.sumQueue / (long)this.done;
    }

    public long getSumQueue() {
        return this.sumQueue;
    }

    public long getAvRun() {
        return this.done == 0 ? 0L : this.sumRun / (long)this.done;
    }

    public long getSumRun() {
        return this.sumRun;
    }

    class TaskRunner
    implements Runnable {
        long tQueue;
        long tStart;
        long tEnd;
        Runnable theTask;

        TaskRunner(Runnable r) {
            this.theTask = r;
            this.tQueue = System.currentTimeMillis();
            this.tStart = 0L;
            this.tEnd = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.tStart = System.currentTimeMillis();
            OrderedTaskQueue.this.sumQueue += this.getWaitTime();
            try {
                this.theTask.run();
            }
            finally {
                this.tEnd = System.currentTimeMillis();
                OrderedTaskQueue.this.sumRun += this.getRunTime();
                ++OrderedTaskQueue.this.done;
            }
        }

        public long getWaitTime() {
            return this.tStart == 0L ? System.currentTimeMillis() - this.tQueue : this.tStart - this.tQueue;
        }

        public long getStartTime() {
            return this.tStart;
        }

        public long getRunTime() {
            return this.tStart == 0L ? 0L : (this.tEnd == 0L ? System.currentTimeMillis() - this.tStart : this.tEnd - this.tStart);
        }

        public String toString() {
            return "TaskRunner :" + this.getWaitTime() + " / " + this.getRunTime() + "\n" + this.theTask;
        }
    }
}

