/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class ZipReader {
    final InputStream is;
    ByteArrayIOStream bos;
    ZipInputStream zis;
    final Log log = LogFactory.getLog(this.getClass());
    ZipEntry currentEntry;
    String rootEntry;
    boolean caseSensitive;

    public String getRootEntry() {
        return this.rootEntry;
    }

    public void setRootEntry(String rootEntry) {
        this.rootEntry = StringUtil.getNonEmpty(rootEntry);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public ZipReader(InputStream inStream) {
        this.is = inStream;
        this.zis = new ZipInputStream(this.is);
        this.bos = null;
        this.caseSensitive = true;
    }

    public ZipReader(File file) {
        this(FileUtil.getBufferedInputStream(file));
        if (file != null) {
            this.setRootEntry(UrlUtil.newExtension(file.getName(), null) + "/");
        }
    }

    public ZipReader(String fileName) {
        this(UrlUtil.urlToFile(fileName));
    }

    public Vector<ZipEntry> getEntries() {
        Vector<ZipEntry> vze = new Vector<ZipEntry>();
        ZipEntry ze = this.getNextEntry();
        while (ze != null) {
            vze.add(ze);
            ze = this.getNextEntry();
        }
        return vze;
    }

    public ZipEntry getNextEntry() {
        try {
            ZipEntry nextEntry;
            this.currentEntry = nextEntry = this.zis.getNextEntry();
            return nextEntry;
        }
        catch (IOException e) {
            this.currentEntry = null;
            return null;
        }
    }

    public int unPack(File dir) {
        if (dir == null) {
            return 0;
        }
        dir.mkdirs();
        if (!dir.isDirectory()) {
            return 0;
        }
        int n = 0;
        ZipEntry ze = this.getNextEntry();
        while (ze != null) {
            boolean b = this.unPack(dir, ze);
            if (b) {
                ++n;
            }
            ze = this.getNextEntry();
        }
        return n;
    }

    public boolean unPack(File dir, ZipEntry ze) {
        if (dir == null) {
            return false;
        }
        if (this.currentEntry != ze) {
            this.log.warn((Object)"snafu with entries");
            return false;
        }
        String fileName = ze.getName();
        File file = new File(fileName);
        File absoluteFile = FileUtil.getFileInDirectory(dir, file);
        try {
            if (ze.isDirectory()) {
                absoluteFile.mkdirs();
            } else {
                File parent = absoluteFile.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(absoluteFile));
                IOUtils.copy((InputStream)this.zis, (OutputStream)fos);
                ((OutputStream)fos).flush();
                ((OutputStream)fos).close();
            }
            this.zis.closeEntry();
        }
        catch (IOException e) {
            this.log.error((Object)("Snafu unpacking zip to: " + fileName), (Throwable)e);
        }
        return true;
    }

    public ZipEntry getEntry(String urlString) {
        this.buffer();
        if (urlString == null) {
            this.log.error((Object)"cannot retrieve null entry");
            return null;
        }
        urlString = UrlUtil.cleanDots(urlString);
        ZipEntry ze = this.getNextEntry();
        while (ze != null) {
            boolean matches;
            String name = UrlUtil.cleanDots(ze.getName());
            boolean bl = matches = this.caseSensitive ? urlString.equals(name) : urlString.equalsIgnoreCase(name);
            if (!matches && this.rootEntry != null && name.startsWith(this.rootEntry) && (name = StringUtil.rightStr(name, -this.rootEntry.length())) != null && name.length() > 0) {
                boolean bl2 = matches = this.caseSensitive ? urlString.equals(name) : urlString.equalsIgnoreCase(name);
            }
            if (matches) {
                return ze;
            }
            ze = this.getNextEntry();
        }
        return null;
    }

    public ZipEntry getMatchingEntry(String expr, int iSkip) {
        this.buffer();
        ZipEntry ze = this.getNextEntry();
        expr = StringUtil.simpleRegExptoRegExp(expr);
        int n = 0;
        while (ze != null) {
            boolean matches;
            String name = ze.getName();
            boolean bl = matches = this.caseSensitive ? StringUtil.matchesSimple(name, expr) : StringUtil.matchesIgnoreCase(name, expr);
            if (!matches && this.rootEntry != null && name.startsWith(this.rootEntry) && (name = StringUtil.rightStr(name, -this.rootEntry.length())) != null && name.length() > 0) {
                boolean bl2 = matches = this.caseSensitive ? StringUtil.matches(name, expr) : StringUtil.matchesIgnoreCase(name, expr);
            }
            if (matches) {
                if (n >= iSkip) {
                    return ze;
                }
                ++n;
            }
            ze = this.getNextEntry();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.currentEntry == null ? null : this.zis;
    }

    public XMLDoc getXMLDoc() {
        if (this.currentEntry == null) {
            return null;
        }
        XMLDoc doc = XMLDoc.parseStream(this.zis);
        if (doc != null) {
            doc.setZipReader(this);
        }
        return doc;
    }

    public JDFDoc getJDFDoc() {
        if (this.currentEntry == null) {
            return null;
        }
        JDFDoc doc = JDFDoc.parseStream(this.zis);
        if (doc != null) {
            doc.setZipReader(this);
        }
        return doc;
    }

    public void buffer() {
        if (this.bos == null) {
            this.bos = new ByteArrayIOStream(this.is);
        }
        this.reset();
    }

    private void reset() {
        if (this.bos != null) {
            this.zis = new ZipInputStream(this.bos.getInputStream());
        }
    }

    public String toString() {
        return "ZipReader root=" + this.rootEntry;
    }
}

