/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.validate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.EnumUtil;

public class VersionTranslator {
    private final JDFElement.EnumVersion version;

    public VersionTranslator(JDFElement.EnumVersion version) {
        this.version = version;
    }

    public Vector<InputStream> convertStream(InputStream stream) {
        Vector<InputStream> v;
        JDFParser p = new JDFParser();
        JDFDoc d = p.parseStream(stream);
        KElement root = this.getRoot(d);
        if (root == null) {
            return null;
        }
        KElement newRoot = this.convertElement(root);
        if (newRoot == null) {
            return null;
        }
        ByteArrayIOStream bios = new ByteArrayIOStream();
        try {
            newRoot.getOwnerDocument_KElement().write2Stream(bios, 2, true);
        }
        catch (IOException e) {
            bios = null;
        }
        if (bios == null) {
            v = null;
        } else {
            v = new Vector<InputStream>();
            v.add(bios.getInputStream());
        }
        return v;
    }

    public KElement convertElement(KElement root) {
        KElement retElem;
        JDFElement.EnumVersion inVersion = this.getVersion(root);
        if (EnumUtil.aLessThanB(inVersion, JDFElement.EnumVersion.Version_2_0)) {
            if (EnumUtil.aLessThanB(this.version, JDFElement.EnumVersion.Version_2_0)) {
                FixVersion fix = new FixVersion(this.version);
                fix.walkTree(root, null);
                retElem = root;
            } else {
                XJDF20 xCon = new XJDF20();
                retElem = xCon.convert(root);
            }
        } else {
            XJDFToJDFConverter xCon;
            JDFDoc dOut;
            retElem = EnumUtil.aLessThanB(this.version, JDFElement.EnumVersion.Version_2_0) ? ((dOut = (xCon = new XJDFToJDFConverter(null)).convert(root)) == null ? null : dOut.getRoot()) : root;
        }
        return retElem;
    }

    private JDFElement.EnumVersion getVersion(KElement root) {
        JDFElement.EnumVersion vers = root instanceof JDFNode ? ((JDFNode)root).getVersion(true) : (root instanceof JDFJMF ? ((JDFJMF)root).getVersion(true) : JDFElement.EnumVersion.Version_2_0);
        return vers;
    }

    private KElement getRoot(JDFDoc d) {
        if (d == null) {
            return null;
        }
        KElement root = d.getJDFRoot();
        if (root == null) {
            root = d.getJMFRoot();
        }
        if (root == null) {
            XJDFHelper helper = XJDFHelper.getHelper(d);
            root = helper == null ? null : helper.getRoot();
        }
        return root;
    }
}

