/*
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2010 The International Cooperation for the Integration of
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment mrSubRefay appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior writtenrestartProcesses()
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIrSubRefAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software restartProcesses()
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG
 * copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *
 */
/**
 *
 * Copyright (c) 2001 Heidelberger Druckmaschinen AG, All Rights Reserved.
 *
 * JDFStringSpan.java
 *
 * Last changes
 *
 */
package org.cip4.jdflib.span;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFConstants;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.w3c.dom.DOMException;

/**
  * @author Rainer Prosi, Heidelberger Druckmaschinen *
 */
public class JDFStringSpan extends JDFSpanBase
{
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor for JDFStringSpan
	 * @param myOwnerDocument 
	 * @param qualifiedName 
	 * @throws DOMException 
	 * 
	 */
	public JDFStringSpan(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Gets the value of attribute DataType
	 * 
	 * @return EnumDataType - the attribute DataType value
	 */
	@Override
	public EnumDataType getDataType()
	{
		return EnumDataType.StringSpan;
	}

	/**
	 * Constructor for JDFStringSpan
	 * @param myOwnerDocument 
	 * @param myNamespaceURI 
	 * @param qualifiedName 
	 * @throws DOMException 
	 * 
	 */
	public JDFStringSpan(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFStringSpan
	 * @param myOwnerDocument 
	 * @param myNamespaceURI 
	 * @param qualifiedName 
	 * @param myLocalName 
	 * @throws DOMException 
	 * 
	 */
	public JDFStringSpan(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	@Override
	protected AttributeInfo getTheAttributeInfo()
	{
		return super.getTheAttributeInfo().updateReplace(atrInfoTable);
	}

	private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];
	static
	{
		atrInfoTable[0] = new AtrInfoTable(AttributeName.ACTUAL, 0x33333333, AttributeInfo.EnumAttributeType.string, null, null);
		atrInfoTable[1] = new AtrInfoTable(AttributeName.PREFERRED, 0x33333333, AttributeInfo.EnumAttributeType.string, null, null);
	}

	private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[2];
	static
	{
		elemInfoTable[0] = new ElemInfoTable(ElementName.RANGE, 0x33333333);
		elemInfoTable[1] = new ElemInfoTable(ElementName.OFFERRANGE, 0x33333111);
	}

	@Override
	protected ElementInfo getTheElementInfo()
	{
		return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
	}

	// **************************************** Methods
	// *********************************************
	/**
	 * toString
	 * 
	 * @return String
	 */
	@Override
	public String toString()
	{
		return "JDFStringSpan[ --> " + super.toString() + " ]";
	}

	/**
	 * Set attribute Actual
	 * 
	 * @param value - the value to set
	 */
	public void setActual(String value)
	{
		setAttribute(AttributeName.ACTUAL, value);
	}

	/**
	 * Get attribute Actual value
	 * 
	 * @return String - the value of attribute Actual
	 */
	public String getActual()
	{
		return getAttribute(AttributeName.ACTUAL, null, JDFConstants.EMPTYSTRING);
	}

	/**
	 * Set attribute Preferred
	 * 
	 * @param value - the value to set
	 */
	public void setPreferred(String value)
	{
		setAttribute(AttributeName.PREFERRED, value);
	}

	/**
	 * Get attribute Preferred value
	 * 
	 * @return String - the value of attribute Preferred
	 */
	public String getPreferred()
	{
		return getAttribute(AttributeName.PREFERRED, null, JDFConstants.EMPTYSTRING);
	}

	/**
	 * GetRange
	 * @param elementName 
	 * 
	 * @return Vector of strings in Range
	 */
	private VString getRangeOfferRange(String elementName)
	{
		VString vL = new VString();
		VElement v = getChildrenByTagName(elementName, null, null, true, true, 0);
		for (int i = 0; i < v.size(); i++)
		{
			KElement e = v.elementAt(i);
			vL.addElement(e.getText(0));
		}
		return vL;
	}

	/**
	 * GetRange
	 * 
	 * @return Vector of strings in Range
	 */
	public VString getRange()
	{
		return getRangeOfferRange(ElementName.RANGE);
	}

	/**
	 * SetRange
	 * 
	 * @param s - the vector of strings to set Range to
	 */
	public void setRange(VString s)
	{
		setRangeOfferRange(ElementName.RANGE, s);
	}

	/**
	 * addRange
	 * 
	 * @param s - string to append as a new text element
	 */
	public void addRange(String s)
	{
		appendTextElement(ElementName.RANGE, s);
	}

	/**
	 * GetRange
	 * 
	 * @return Vector of strings in Range
	 */
	public VString getOfferRange()
	{
		return getRangeOfferRange(ElementName.OFFERRANGE);
	}

	/**
	 * SetRange
	 * @param elementName 
	 * @param s - the vector of strings to set Range to
	 */
	private void setRangeOfferRange(String elementName, VString s)
	{
		removeChildren(elementName, null, null);
		final int size = s.size();
		for (int i = 0; i < size; i++)
		{
			appendTextElement(elementName, s.stringAt(i));
		}
	}

	/**
	 * SetRange
	 * 
	 * @param s - the vector of strings to set Range to
	 */
	public void setOfferRange(VString s)
	{
		setRangeOfferRange(ElementName.OFFERRANGE, s);
	}

	/**
	 * addRange
	 * 
	 * @param s - string to append as a new text element
	 */
	public void addOfferRange(String s)
	{
		appendTextElement(ElementName.OFFERRANGE, s);
	}

	/**
	 * @see org.cip4.jdflib.core.KElement#init()
	 * @return
	*/
	@Override
	public boolean init()
	{
		boolean b = super.init();
		setDataType(EnumDataType.StringSpan);
		return b;
	}
}
