/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.resource.process.JDFComponent;

public abstract class JDFAutoBundleItem
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[4];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoBundleItem(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoBundleItem(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoBundleItem(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoBundleItem[  --> " + super.toString() + " ]";
    }

    public void setAmount(int value) {
        this.setAttribute("Amount", value, (String)null);
    }

    public int getAmount() {
        return this.getIntAttribute("Amount", null, 0);
    }

    public void setItemName(String value) {
        this.setAttribute("ItemName", value, null);
    }

    public String getItemName() {
        return this.getAttribute("ItemName", null, "");
    }

    public void setOrientation(EnumOrientation enumVar) {
        this.setAttribute("Orientation", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumOrientation getOrientation() {
        return EnumOrientation.getEnum(this.getAttribute("Orientation", null, null));
    }

    public void setTransformation(JDFMatrix value) {
        this.setAttribute("Transformation", value, null);
    }

    public JDFMatrix getTransformation() {
        String strAttrName = this.getAttribute("Transformation", null, "");
        JDFMatrix nPlaceHolder = JDFMatrix.createMatrix(strAttrName);
        return nPlaceHolder;
    }

    public JDFComponent getComponent() {
        return (JDFComponent)this.getElement("Component", null, 0);
    }

    public JDFComponent getCreateComponent() {
        return (JDFComponent)this.getCreateElement_KElement("Component", null, 0);
    }

    public JDFComponent appendComponent() throws JDFException {
        return (JDFComponent)this.appendElementN("Component", 1, null);
    }

    public void refComponent(JDFComponent refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoBundleItem.atrInfoTable[0] = new AtrInfoTable("Amount", 0x22222221L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoBundleItem.atrInfoTable[1] = new AtrInfoTable("ItemName", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoBundleItem.atrInfoTable[2] = new AtrInfoTable("Orientation", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumOrientation.getEnum(0), null);
        JDFAutoBundleItem.atrInfoTable[3] = new AtrInfoTable("Transformation", 0x33333331L, AttributeInfo.EnumAttributeType.matrix, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAutoBundleItem.elemInfoTable[0] = new ElemInfoTable("Component", 0x55555551L);
    }

    public static class EnumOrientation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumOrientation Rotate0 = new EnumOrientation("Rotate0");
        public static final EnumOrientation Rotate90 = new EnumOrientation("Rotate90");
        public static final EnumOrientation Rotate180 = new EnumOrientation("Rotate180");
        public static final EnumOrientation Rotate270 = new EnumOrientation("Rotate270");
        public static final EnumOrientation Flip0 = new EnumOrientation("Flip0");
        public static final EnumOrientation Flip90 = new EnumOrientation("Flip90");
        public static final EnumOrientation Flip180 = new EnumOrientation("Flip180");
        public static final EnumOrientation Flip270 = new EnumOrientation("Flip270");

        private EnumOrientation(String name) {
            super(name, m_startValue++);
        }

        public static EnumOrientation getEnum(String enumName) {
            return (EnumOrientation)EnumOrientation.getEnum(EnumOrientation.class, (String)enumName);
        }

        public static EnumOrientation getEnum(int enumValue) {
            return (EnumOrientation)EnumOrientation.getEnum(EnumOrientation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumOrientation.getEnumMap(EnumOrientation.class);
        }

        public static List getEnumList() {
            return EnumOrientation.getEnumList(EnumOrientation.class);
        }

        public static Iterator iterator() {
            return EnumOrientation.iterator(EnumOrientation.class);
        }
    }
}

