/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFAudit
extends JDFElement
implements Comparator<JDFAudit> {
    private static final long serialVersionUID = 1L;
    private static final String m_libAgentName = "CIP4 JDF Writer Java";
    private static final String m_libAgentVersion = "1.4a BLD 76";
    private static String m_strAgentName = "CIP4 JDF Writer Java";
    private static String m_strAgentVersion = "1.4a BLD 76";
    private static String m_strAuthor = null;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[8];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFAudit[ -->" + super.toString() + "]";
    }

    @Override
    public int compare(JDFAudit a1, JDFAudit a2) {
        JDFDate d1 = a1.getTimeStampDate();
        JDFDate d2 = a2.getTimeStampDate();
        return ContainerUtil.compare(d1, d2);
    }

    public void setSeverity(EnumSeverity s) {
        this.setAttribute("Severity", s.getName(), null);
    }

    public EnumSeverity getSeverity() {
        return EnumSeverity.getEnum(this.getAttribute("Severity", null, null));
    }

    @Override
    public void setStatus(JDFElement.EnumNodeStatus s) {
        if (s == null) {
            throw new JDFException("setStatus setting to null");
        }
        this.setAttribute("Status", s.getName(), null);
    }

    public void setEndStatus(JDFElement.EnumNodeStatus s) {
        this.setAttribute("EndStatus", s.getName(), null);
    }

    protected JDFElement.EnumNodeStatus getEndStatus() {
        return JDFElement.EnumNodeStatus.getEnum(this.getAttribute("EndStatus", null, null));
    }

    public EnumAuditType getAuditType() {
        String nam = this.getLocalName();
        return EnumAuditType.getEnum(nam);
    }

    @Deprecated
    public JDFElement.EnumNodeStatus getPhase() {
        if (!this.getNodeName().equals("PhaseTime")) {
            return null;
        }
        return super.getStatus();
    }

    @Deprecated
    public void setPart(JDFAttributeMap m) {
        super.setPartMap(m);
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    public void setSpawnID(String value) {
        this.setAttribute("SpawnID", value, "");
    }

    public void setrefID(String value) {
        this.setAttribute("refID", value, null);
    }

    public void setRef(JDFAudit previous) {
        if (previous != null) {
            String id = previous.appendAnchor(null);
            this.setrefID(id);
        }
    }

    public void setAuthor(String author) {
        this.setAttribute("Author", author, null);
    }

    @Deprecated
    public void setBy(String by) {
        if (by == null || by.equals("")) {
            return;
        }
        this.setAttribute("Author", by, "");
    }

    public static String software() {
        return "CIP4 JDF Writer Java 1.4a BLD 76";
    }

    @Override
    public boolean init() {
        JDFElement.EnumVersion auditVersion = this.getVersion(true);
        this.setAttributeNameTimeStamp("TimeStamp", null);
        if (auditVersion == null || auditVersion.getValue() >= JDFElement.EnumVersion.Version_1_2.getValue()) {
            this.setAgentName(m_strAgentName);
            this.setAgentVersion(m_strAgentVersion);
        }
        if (m_strAuthor != null) {
            if (EnumUtil.aLessThanB(this.getVersion(true), JDFElement.EnumVersion.Version_1_4)) {
                this.setAuthor(m_strAuthor);
            } else {
                this.appendEmployee().setDescriptiveName(m_strAuthor);
            }
        }
        if (auditVersion == null || auditVersion.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
            this.appendAnchor(null);
        }
        return super.init();
    }

    @Override
    public String getIDPrefix() {
        return "a";
    }

    @Deprecated
    public void setTimeStamp() {
        this.setTimeStamp(null);
    }

    @Deprecated
    public String getTimeStamp() {
        return this.getAttribute("TimeStamp", null, "");
    }

    public JDFDate getTimeStampDate() {
        String str = this.getAttribute("TimeStamp", null, null);
        if (str == null) {
            return null;
        }
        try {
            return new JDFDate(str);
        }
        catch (DataFormatException dfe) {
            throw new JDFException("not a valid date string. Malformed JDF");
        }
    }

    public String getSpawnID() {
        return this.getAttribute("SpawnID", null, "");
    }

    public String getrefID() {
        return this.getAttribute("refID", null, "");
    }

    public String getAuthor() {
        return this.getAttribute("Author");
    }

    public void setAgentName(String value) {
        this.setAttribute("AgentName", value);
    }

    public String getQueueEntryID() {
        return this.getAttribute("QueueEntryID");
    }

    public void setQueueEntryID(String value) {
        this.setAttribute("QueueEntryID", value);
    }

    public String getAgentName() {
        return this.getAttribute("AgentName");
    }

    public void setAgentVersion(String value) {
        this.setAttribute("AgentVersion", value);
    }

    public String getAgentVersion() {
        return this.getAttribute("AgentVersion");
    }

    public void setTimeStamp(JDFDate value) {
        this.setAttributeNameTimeStamp("TimeStamp", value);
    }

    public JDFAuditPool getAuditPool() {
        return (JDFAuditPool)this.getDeepParent("AuditPool", 0);
    }

    public JDFAudit createUpdateAudit() {
        JDFAuditPool pool = this.getAuditPool();
        if (pool == null) {
            return null;
        }
        JDFAudit copy = (JDFAudit)pool.copyElement(this, null);
        copy.removeAttribute("ID");
        copy.removeAttribute("AgentName");
        copy.removeAttribute("AgentVersion");
        copy.init();
        copy.setRef(this);
        return copy;
    }

    public JDFAudit getUpdatedPreviousAudit() {
        String refID = this.getrefID();
        if (StringUtil.getNonEmpty(refID) == null) {
            return null;
        }
        JDFAuditPool pool = this.getAuditPool();
        if (pool == null) {
            throw new JDFException("Updating audit that is not in an audit pool");
        }
        return (JDFAudit)pool.getChildWithAttribute(null, "ID", null, refID, 0, true);
    }

    public static synchronized String getStaticAgentName() {
        return m_strAgentName;
    }

    public static synchronized void setStaticAgentName(String agentName) {
        m_strAgentName = agentName;
    }

    public static synchronized String getStaticAuthor() {
        return m_strAuthor;
    }

    public static synchronized void setStaticAuthor(String author) {
        m_strAuthor = author;
    }

    public static synchronized String getStaticAgentVersion() {
        return m_strAgentVersion;
    }

    public static synchronized void setStaticAgentVersion(String agentVersion) {
        m_strAgentVersion = agentVersion;
    }

    public JDFEmployee getCreateEmployee(int iSkip) {
        return (JDFEmployee)this.getCreateElement_KElement("Employee", null, iSkip);
    }

    public JDFEmployee getEmployee(int iSkip) {
        return (JDFEmployee)this.getElement("Employee", null, iSkip);
    }

    public Collection<JDFEmployee> getAllEmployee() {
        Vector<JDFEmployee> v = new Vector<JDFEmployee>();
        for (JDFEmployee kElem = (JDFEmployee)this.getFirstChildElement("Employee", null); kElem != null; kElem = (JDFEmployee)kElem.getNextSiblingElement("Employee", null)) {
            v.add(kElem);
        }
        return v;
    }

    public JDFEmployee appendEmployee() throws JDFException {
        return (JDFEmployee)this.appendElement("Employee", null);
    }

    static {
        JDFAudit.atrInfoTable[0] = new AtrInfoTable("Author", 0x44443333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAudit.atrInfoTable[1] = new AtrInfoTable("SpawnID", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAudit.atrInfoTable[2] = new AtrInfoTable("AgentName", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAudit.atrInfoTable[3] = new AtrInfoTable("AgentVersion", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAudit.atrInfoTable[4] = new AtrInfoTable("ID", 0x33333311L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFAudit.atrInfoTable[5] = new AtrInfoTable("refID", 0x33333311L, AttributeInfo.EnumAttributeType.IDREF, null, null);
        JDFAudit.atrInfoTable[6] = new AtrInfoTable("TimeStamp", 0x33333222L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAudit.atrInfoTable[7] = new AtrInfoTable("QueueEntryID", 0x33331111L, AttributeInfo.EnumAttributeType.shortString, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAudit.elemInfoTable[0] = new ElemInfoTable("Employee", 0x33331111L);
    }

    public static final class EnumSeverity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSeverity Event = new EnumSeverity("Event");
        public static final EnumSeverity Information = new EnumSeverity("Information");
        public static final EnumSeverity Warning = new EnumSeverity("Warning");
        public static final EnumSeverity Error = new EnumSeverity("Error");
        public static final EnumSeverity Fatal = new EnumSeverity("Fatal");

        private EnumSeverity(String name) {
            super(name, m_startValue++);
        }

        public static EnumSeverity getEnum(String enumName) {
            return (EnumSeverity)EnumSeverity.getEnum(EnumSeverity.class, (String)enumName);
        }

        public static EnumSeverity getEnum(int enumValue) {
            return (EnumSeverity)EnumSeverity.getEnum(EnumSeverity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumSeverity.getEnumMap(EnumSeverity.class);
        }

        public static List getEnumList() {
            return EnumSeverity.getEnumList(EnumSeverity.class);
        }

        public static Iterator iterator() {
            return EnumSeverity.iterator(EnumSeverity.class);
        }
    }

    public static class EnumAuditType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAuditType Created = new EnumAuditType("Created");
        public static final EnumAuditType Modified = new EnumAuditType("Modified");
        public static final EnumAuditType Deleted = new EnumAuditType("Deleted");
        public static final EnumAuditType Spawned = new EnumAuditType("Spawned");
        public static final EnumAuditType Merged = new EnumAuditType("Merged");
        public static final EnumAuditType Notification = new EnumAuditType("Notification");
        public static final EnumAuditType PhaseTime = new EnumAuditType("PhaseTime");
        public static final EnumAuditType ResourceAudit = new EnumAuditType("ResourceAudit");
        public static final EnumAuditType ProcessRun = new EnumAuditType("ProcessRun");

        protected EnumAuditType(String name) {
            super(name, m_startValue++);
        }

        public static EnumAuditType getEnum(String enumName) {
            return (EnumAuditType)EnumAuditType.getEnum(EnumAuditType.class, (String)enumName);
        }

        public static EnumAuditType getEnum(int enumValue) {
            return (EnumAuditType)EnumAuditType.getEnum(EnumAuditType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAuditType.getEnumMap(EnumAuditType.class);
        }

        public static List getEnumList() {
            return EnumAuditType.getEnumList(EnumAuditType.class);
        }

        public static Iterator iterator() {
            return EnumAuditType.iterator(EnumAuditType.class);
        }
    }
}

