/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.mail.BodyPart;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JDFDoc
extends XMLDoc {
    public JDFDoc() {
        ((DocumentJDFImpl)this.m_doc).bInitOnCreate = true;
        ((DocumentJDFImpl)this.m_doc).bKElementOnly = false;
    }

    public JDFDoc(Document document) {
        super(document);
        if (document instanceof DocumentXMLImpl && !(document instanceof DocumentJDFImpl)) {
            this.reparse(document);
        }
    }

    public JDFDoc(XMLDoc document) {
        super(document);
        DocumentXMLImpl memberDoc;
        DocumentXMLImpl documentXMLImpl = memberDoc = document == null ? null : document.getMemberDocument();
        if (memberDoc instanceof DocumentXMLImpl && !(memberDoc instanceof DocumentJDFImpl)) {
            this.reparse((Document)((Object)memberDoc));
        }
    }

    protected void reparse(Document document) {
        JDFDoc doc = this.createRoot(document);
        doc.setInitOnCreate(false);
        doc.copyMeta(this);
        KElement newRoot = doc.getRoot();
        if (newRoot != null) {
            newRoot.copyInto((KElement)document.getDocumentElement(), false);
        }
        this.m_doc = doc.m_doc;
    }

    @Override
    protected JDFDoc createRoot(Document document) {
        Element documentElement = document.getDocumentElement();
        return documentElement == null ? new JDFDoc() : new JDFDoc(documentElement.getNodeName());
    }

    public JDFDoc(DocumentJDFImpl document) {
        super(document);
    }

    public JDFDoc(String strDocType) {
        super(strDocType, JDFElement.getSchemaURL());
        ((DocumentJDFImpl)this.m_doc).bInitOnCreate = true;
        ((DocumentJDFImpl)this.m_doc).bKElementOnly = false;
    }

    @Override
    protected DocumentXMLImpl getImpl() {
        return new DocumentJDFImpl();
    }

    public JDFNode getJDFRoot() {
        return (JDFNode)this.getJXFRoot("JDF");
    }

    @Override
    protected void setMemberDoc(DocumentXMLImpl myDoc) {
        super.setMemberDoc(myDoc);
        if (this.m_doc != null) {
            this.getCreateXMLDocUserData();
        }
    }

    public JDFJMF getJMFRoot() {
        return (JDFJMF)this.getJXFRoot("JMF");
    }

    private KElement getJXFRoot(String rootName) {
        KElement root = this.getRoot();
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals(rootName)) {
            root = root.getChildByTagName(rootName, JDFElement.getSchemaURL(), 0, null, true, false);
        }
        return root;
    }

    @Override
    public JDFDoc clone() {
        return new JDFDoc((Document)((Object)super.clone().getMemberDocument()));
    }

    @Override
    public String toString() {
        return "JDFDoc: " + super.toString();
    }

    @Deprecated
    public static JDFDoc createJDF(String jdfPath) {
        JDFDoc new_doc = new JDFDoc();
        JDFNode root = (JDFNode)new_doc.createElement("JDF");
        root.setAttribute("ID", KElement.uniqueID(50), "");
        root.init();
        new_doc.appendChild(root);
        new_doc.write2File(jdfPath, 0, true);
        return new_doc;
    }

    @Deprecated
    public JDFNode getJDFNodeByID(String id) {
        return (JDFNode)this.getRoot().getTarget(id, "ID");
    }

    @Deprecated
    public int collectGarbageResources(VString nodeNames) {
        int i;
        boolean bCollectAll = nodeNames == null || nodeNames.isEmpty();
        VElement vProcs = this.getJDFRoot().getvJDFNode(null, null, false);
        VElement vResources = new VElement();
        VElement vLinkedResources = new VElement();
        for (int i2 = 0; i2 < vProcs.size(); ++i2) {
            JDFNode n = (JDFNode)vProcs.elementAt(i2);
            vLinkedResources.appendUnique(n.getLinkedResources(null, true));
            JDFResourcePool rp = n.getResourcePool();
            if (rp == null) continue;
            VElement resources = rp.getPoolChildren(null, null, null);
            vResources.appendUnique(resources);
            for (int j = 0; j < resources.size(); ++j) {
                vResources.appendUnique(((JDFResource)resources.elementAt(j)).getvHRefRes(true, true));
            }
        }
        VElement vr = new VElement();
        for (i = 0; i < vResources.size(); ++i) {
            vr.appendUnique(((JDFResource)vResources.elementAt(i)).getResourceRoot());
        }
        vResources = vr;
        vr.clear();
        for (i = 0; i < vLinkedResources.size(); ++i) {
            vr.appendUnique(((JDFResource)vLinkedResources.elementAt(i)).getResourceRoot());
        }
        vLinkedResources = vr;
        int nDeleted = 0;
        for (int i3 = 0; i3 < vResources.size(); ++i3) {
            JDFResource r = (JDFResource)vResources.elementAt(i3);
            if (vLinkedResources.index(r) >= 0 || !bCollectAll && (nodeNames == null || !nodeNames.contains(r.getLocalName()))) continue;
            r.deleteNode();
            ++nDeleted;
        }
        Runtime.getRuntime().gc();
        Runtime.getRuntime().gc();
        return nDeleted;
    }

    public String getContentType() {
        KElement e = this.getRoot();
        String strContentType = e instanceof JDFNode ? "application/vnd.cip4-jdf+xml" : (e instanceof JDFJMF ? "application/vnd.cip4-jmf+xml" : "text/xml");
        return strContentType;
    }

    public static JDFDoc parseStream(InputStream is) {
        if (is == null) {
            return null;
        }
        JDFParser p = new JDFParser();
        return p.parseStream(is);
    }

    public static JDFDoc parseFile(File file) {
        BufferedInputStream is = FileUtil.getBufferedInputStream(file);
        JDFDoc d = JDFDoc.parseStream(is);
        if (file.canRead() && d != null) {
            d.setOriginalFileName(file.getAbsolutePath());
        }
        return d;
    }

    public static JDFDoc parseFile(String fileName) {
        if (StringUtil.getNonEmpty(fileName) == null) {
            return null;
        }
        File f = new File(fileName);
        return JDFDoc.parseFile(f);
    }

    public static JDFDoc parseURL(String url, BodyPart bp) {
        InputStream inStream = UrlUtil.getURLInputStream(url, bp);
        File f = UrlUtil.urlToFile(url);
        JDFDoc d = JDFDoc.parseStream(inStream);
        if (d != null) {
            if (f != null && f.canRead()) {
                d.setOriginalFileName(f.getAbsolutePath());
            } else {
                String fn = UrlUtil.urlToFileName(url);
                d.setOriginalFileName(fn);
            }
        }
        return d;
    }

    @Override
    public KElement setRoot(String strDocType, String namespaceURI) {
        KElement root = super.setRoot(strDocType, namespaceURI);
        if (root != null && ((DocumentJDFImpl)this.m_doc).bInitOnCreate) {
            if (root instanceof JDFNode) {
                ((JDFNode)root).init();
            } else if (root instanceof JDFJMF) {
                String comment = "Generated by the CIP4 Java open source JDF Library version : ";
                comment = comment + JDFAudit.software();
                ((JDFJMF)root).init();
                ((JDFJMF)root).appendXMLComment(comment, null);
            }
        }
        return root;
    }

    public static void registerCustomClass(String strElement, String packagepath) {
        DocumentJDFImpl.registerCustomClass(strElement, packagepath);
    }

    public JDFDoc write2URL(String strURL) {
        KElement e = this.getRoot();
        if (e == null) {
            return null;
        }
        String strContentType = JDFDoc.getContentType(e);
        XMLDoc d = super.write2URL(strURL, strContentType);
        return d == null ? null : new JDFDoc((Document)((Object)d.getMemberDocument()));
    }

    @Override
    protected XMLParser getXMLParser() {
        return new JDFParser();
    }

    public HttpURLConnection write2HTTPURL(URL strURL, UrlUtil.HTTPDetails det) {
        KElement e = this.getRoot();
        if (e == null) {
            return null;
        }
        String strContentType = JDFDoc.getContentType(e);
        return super.write2HTTPURL(strURL, strContentType, det);
    }

    public UrlPart write2HttpURL(URL strURL, UrlUtil.HTTPDetails det) {
        KElement e = this.getRoot();
        if (e == null) {
            return null;
        }
        String strContentType = JDFDoc.getContentType(e);
        return super.write2HttpURL(strURL, strContentType, det);
    }

    public static String getContentType(KElement e) {
        String strContentType = "text/xml";
        if (e instanceof JDFNode) {
            strContentType = "application/vnd.cip4-jdf+xml";
        } else if (e instanceof JDFJMF) {
            strContentType = "application/vnd.cip4-jmf+xml";
        }
        return strContentType;
    }

    @Override
    public Element createElement(String elementName) {
        Element elem = super.createElement(elementName);
        if (elem instanceof KElement && ((DocumentJDFImpl)this.m_doc).bInitOnCreate) {
            ((KElement)elem).init();
        }
        return elem;
    }

    protected XMLDocUserData getXMLDocUserData() {
        return ((DocumentJDFImpl)this.m_doc).getMyUserData();
    }

    protected boolean hasXMLDocUserData() {
        return ((DocumentJDFImpl)this.m_doc).getMyUserData() != null;
    }

    public XMLDocUserData getCreateXMLDocUserData() {
        return ((DocumentJDFImpl)this.m_doc).getMyUserData();
    }

    public VString getDirtyIDs() {
        XMLDocUserData xmlUserData = this.getXMLDocUserData();
        if (xmlUserData != null) {
            return xmlUserData.getDirtyIDs();
        }
        return null;
    }

    public void clearDirtyIDs() {
        this.getCreateXMLDocUserData().clearDirtyIDs();
    }

    public boolean isDirty(String strID) {
        XMLDocUserData docUserData = this.getXMLDocUserData();
        return docUserData == null ? false : docUserData.isDirty(strID);
    }

    public XMLDoc getValidationResult() {
        return ((DocumentJDFImpl)this.m_doc).m_validationResult;
    }

    public void setInitOnCreate(boolean bInitOnCreate) {
        ((DocumentJDFImpl)this.m_doc).bInitOnCreate = bInitOnCreate;
    }

    public boolean getInitOnCreate() {
        return ((DocumentJDFImpl)this.m_doc).bInitOnCreate;
    }

    @Override
    public DocumentJDFImpl getMemberDocument() {
        return (DocumentJDFImpl)this.m_doc;
    }

    @Override
    public void setXPathValues(JDFAttributeMap valueMap) {
        boolean bOld = this.getInitOnCreate();
        this.setInitOnCreate(false);
        super.setXPathValues(valueMap);
        this.setInitOnCreate(bOld);
    }
}

