/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import javax.xml.parsers.DocumentBuilder;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JDFDocumentBuilder
extends DocumentBuilder {
    private JDFParser m_parser;

    public JDFDocumentBuilder() {
        this.init(new JDFParser());
    }

    private void init(JDFParser parser) {
        this.m_parser = parser;
    }

    public JDFParser getParser() {
        return this.m_parser;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        boolean isValidating = false;
        try {
            isValidating = this.m_parser.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        return isValidating;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        throw new JDFException("JDFDocumentBuilder.getDOMImplementation is not implemented");
    }

    @Override
    public Document newDocument() {
        DocumentJDFImpl documentJDFImpl = new DocumentJDFImpl();
        documentJDFImpl.bInitOnCreate = true;
        return documentJDFImpl;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.m_parser.setEntityResolver(er);
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.m_parser.setErrorHandler(eh);
    }

    @Override
    public Document parse(InputSource is) {
        this.m_parser.parse(is);
        Document doc = this.m_parser.getDocument();
        this.m_parser.reset();
        return doc;
    }
}

