/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoNodeInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQuery;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.EnumUtil;
import org.w3c.dom.Node;

public class JDFNodeInfo
extends JDFAutoNodeInfo {
    private static final long serialVersionUID = 1L;
    private static boolean bDefaultWorkStepID = false;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[20];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = this.getParentNode().getLocalName().equals("JDF") ? super.getTheAttributeInfo_JDFElement().updateReplace(atrInfoTable) : super.getTheAttributeInfo().updateReplace(atrInfoTable);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ei = this.getParentNode().getLocalName().equals("JDF") ? new ElementInfo(super.getTheElementInfo_JDFElement(), elemInfoTable) : new ElementInfo(super.getTheElementInfo(), elemInfoTable);
        return ei;
    }

    public JDFNodeInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNodeInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNodeInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNodeInfo[ --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        Node n = this.getParentNode();
        if (bDefaultWorkStepID && !this.hasAttribute("WorkStepID")) {
            if (this.isResourceRoot()) {
                this.setWorkStepID("W" + JDFNodeInfo.uniqueID(0));
            } else {
                this.setWorkStepID(this.generateDotID("WorkStepID", null));
            }
        }
        if (n != null && "ResourcePool".equals(n.getLocalName())) {
            super.init();
            this.setResStatus(JDFResource.EnumResStatus.Available, false);
            this.setPartUsage(JDFResource.EnumPartUsage.Implicit);
        }
        return true;
    }

    public boolean updateBusiness(EnumBusinessObject businessObject, String newID) {
        KElement bo = this.getElement("BusinessInfo", "", 0);
        VString vBos = EnumUtil.getNamesVector(EnumBusinessObject.class);
        KElement boe = bo.getChildFromList(vBos, 0, null, true);
        String bos = boe.getNodeName();
        int oldType = vBos.indexOf(bos);
        boe.renameElement(vBos.elementAt(businessObject.getValue()), null);
        if (businessObject.getValue() > oldType) {
            boe.setAttribute("BusinessRefID", boe.getAttribute("BusinessID"));
            if (newID.length() != 0) {
                boe.setAttribute("BusinessID", newID);
            }
        }
        return true;
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        VElement vChild = this.getChildElementVector(null, null, null, true, 0, false);
        VElement vElem = new VElement();
        for (int i = 0; i < vChild.size(); ++i) {
            if (!(vChild.elementAt(i) instanceof JDFRefElement)) continue;
            JDFRefElement l = (JDFRefElement)vChild.elementAt(i);
            JDFResource r = l.getTarget();
            JDFResource jDFResource = r = r == null ? null : r.getResourceRoot();
            if (r == null || !r.includesAttributes(mResAtt, true)) continue;
            vElem.addElement(r);
            if (!bFollowRefs) continue;
            vElem.appendUnique(r.getvHRefRes(bFollowRefs, true));
        }
        return vElem;
    }

    @Override
    public void cleanResourceAttributes() {
        this.removeAttribute("NodeStatus");
        this.removeAttribute("NodeStatusDetails");
        super.cleanResourceAttributes();
    }

    public static boolean isDefaultWorkStepID() {
        return bDefaultWorkStepID;
    }

    public static void setDefaultWorkStepID(boolean defaultWorkStepID) {
        bDefaultWorkStepID = defaultWorkStepID;
    }

    public JDFQuery getCreateJMFQuery(JDFMessage.EnumType queryType) {
        JDFQuery q = null;
        VElement v = this.getChildElementVector("JMF", null);
        if (v != null) {
            JDFJMF jmf;
            int siz = v.size();
            for (int i = 0; i < siz && (q = (JDFQuery)(jmf = (JDFJMF)v.elementAt(i)).getMessageElement(JDFMessage.EnumFamily.Query, queryType, 0)) == null; ++i) {
            }
        }
        if (q == null) {
            q = this.appendJMF().appendQuery(queryType);
        }
        return q;
    }

    static {
        JDFNodeInfo.atrInfoTable[0] = new AtrInfoTable("CleanupDuration", 0x33333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFNodeInfo.atrInfoTable[1] = new AtrInfoTable("DueLevel", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoNodeInfo.EnumDueLevel.getEnum(0), null);
        JDFNodeInfo.atrInfoTable[2] = new AtrInfoTable("End", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[3] = new AtrInfoTable("FirstEnd", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[4] = new AtrInfoTable("FirstStart", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[5] = new AtrInfoTable("IPPVersion", 0x33333331L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFNodeInfo.atrInfoTable[6] = new AtrInfoTable("JobPriority", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, "50");
        JDFNodeInfo.atrInfoTable[7] = new AtrInfoTable("LastEnd", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[8] = new AtrInfoTable("LastStart", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[9] = new AtrInfoTable("NaturalLang", 0x33333331L, AttributeInfo.EnumAttributeType.language, null, null);
        JDFNodeInfo.atrInfoTable[10] = new AtrInfoTable("MergeTarget", 0x44444443L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFNodeInfo.atrInfoTable[11] = new AtrInfoTable("Route", 0x33333333L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFNodeInfo.atrInfoTable[12] = new AtrInfoTable("rRefs", 0x44444433L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        JDFNodeInfo.atrInfoTable[13] = new AtrInfoTable("SetupDuration", 0x33333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFNodeInfo.atrInfoTable[14] = new AtrInfoTable("Start", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFNodeInfo.atrInfoTable[15] = new AtrInfoTable("TargetRoute", 0x33333333L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFNodeInfo.atrInfoTable[16] = new AtrInfoTable("TotalDuration", 0x33333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFNodeInfo.atrInfoTable[17] = new AtrInfoTable("NodeStatus", 0x33333111L, AttributeInfo.EnumAttributeType.enumeration, JDFElement.EnumNodeStatus.getEnum(0), null);
        JDFNodeInfo.atrInfoTable[18] = new AtrInfoTable("NodeStatusDetails", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNodeInfo.atrInfoTable[19] = new AtrInfoTable("WorkStepID", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        elemInfoTable = new ElemInfoTable[5];
        JDFNodeInfo.elemInfoTable[0] = new ElemInfoTable("BusinessInfo", 0x33333333L);
        JDFNodeInfo.elemInfoTable[1] = new ElemInfoTable("Employee", 0x33333333L);
        JDFNodeInfo.elemInfoTable[2] = new ElemInfoTable("JMF", 0x33333333L);
        JDFNodeInfo.elemInfoTable[3] = new ElemInfoTable("MISDetails", 0x33333311L);
        JDFNodeInfo.elemInfoTable[4] = new ElemInfoTable("NotificationFilter", 0x33333311L);
    }

    public static final class EnumBusinessObject
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumBusinessObject BusinessObject_Unknown = new EnumBusinessObject("BusinessObject_Unknown");
        public static final EnumBusinessObject BusinessObject_RFQ = new EnumBusinessObject("BusinessObject_RFQ");
        public static final EnumBusinessObject BusinessObject_Quote = new EnumBusinessObject("BusinessObject_Quote");
        public static final EnumBusinessObject BusinessObject_RFRequote = new EnumBusinessObject("BusinessObject_RFRequote");
        public static final EnumBusinessObject BusinessObject_Requote = new EnumBusinessObject("BusinessObject_Requote");
        public static final EnumBusinessObject BusinessObject_PO = new EnumBusinessObject("BusinessObject_PO");
        public static final EnumBusinessObject BusinessObject_Confirmation = new EnumBusinessObject("BusinessObject_Confirmation");
        public static final EnumBusinessObject BusinessObject_CO_RFQ = new EnumBusinessObject("BusinessObject_CO_RFQ");
        public static final EnumBusinessObject BusinessObject_CO_Quote = new EnumBusinessObject("BusinessObject_CO_Quote");
        public static final EnumBusinessObject BusinessObject_CO_PO = new EnumBusinessObject("BusinessObject_CO_PO");
        public static final EnumBusinessObject BusinessObject_CO_Confirmation = new EnumBusinessObject("BusinessObject_CO_Confirmation");
        public static final EnumBusinessObject BusinessObject_Invoice = new EnumBusinessObject("BusinessObject_Invoice");
        public static final EnumBusinessObject BusinessObject_None = new EnumBusinessObject("BusinessObject_None");

        private EnumBusinessObject(String status) {
            super(status, m_startValue++);
        }

        public static EnumBusinessObject getEnum(String status) {
            return (EnumBusinessObject)EnumBusinessObject.getEnum(EnumBusinessObject.class, (String)status);
        }

        public static EnumBusinessObject getEnum(int value) {
            return (EnumBusinessObject)EnumBusinessObject.getEnum(EnumBusinessObject.class, (int)value);
        }

        public static Map getEnumMap() {
            return EnumBusinessObject.getEnumMap(EnumBusinessObject.class);
        }

        public static List getEnumList() {
            return EnumBusinessObject.getEnumList(EnumBusinessObject.class);
        }

        public static Iterator iterator() {
            return EnumBusinessObject.iterator(EnumBusinessObject.class);
        }

        @Deprecated
        public static Vector getNamesVector() {
            Vector<String> namesVector = new Vector<String>();
            Iterator it = EnumBusinessObject.iterator(EnumBusinessObject.class);
            while (it.hasNext()) {
                namesVector.addElement(((ValuedEnum)it.next()).getName());
            }
            return namesVector;
        }
    }
}

