/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFDateTimeRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFDateTimeRangeList
extends JDFRangeList {
    public JDFDateTimeRangeList() {
    }

    public JDFDateTimeRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public static JDFDateTimeRangeList createDateTimeRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFDateTimeRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFDateTimeRangeList(JDFDateTimeRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public boolean inRange(JDFDate x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFDateTimeRange r = (JDFDateTimeRange)this.rangeList.elementAt(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFDateTimeRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString v = StringUtil.tokenize(zappedWS, " \t", false);
        VString vs = new VString(v);
        this.rangeList.clear();
        for (int i = 0; i < vs.size(); ++i) {
            String str = vs.elementAt(i);
            try {
                JDFDateTimeRange dr = new JDFDateTimeRange(str);
                this.rangeList.addElement(dr);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFDateTimeRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFDateTimeRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFDateTimeRange r) {
        this.rangeList.addElement(r);
    }

    public void append(JDFDate xMin, JDFDate xMax) {
        this.append(new JDFDateTimeRange(xMin, xMax));
    }

    public void append(JDFDate x) {
        this.append(new JDFDateTimeRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFDate> v = new Vector<JDFDate>();
        for (int i = 0; i < siz; ++i) {
            JDFDateTimeRange r = (JDFDateTimeRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDate first = (JDFDate)v.elementAt(0);
        JDFDate last = (JDFDate)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            JDFDate value = (JDFDate)v.elementAt(j);
            JDFDate nextvalue = (JDFDate)v.elementAt(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isEarlier(last) && (value.isEarlier(nextvalue) || value.equals(nextvalue)) || first.isLater(last) && (value.isLater(nextvalue) || value.equals(nextvalue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFDate last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFDate> v = new Vector<JDFDate>();
        for (int i = 0; i < siz; ++i) {
            JDFDateTimeRange r = (JDFDateTimeRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDate first = (JDFDate)v.elementAt(0);
        if (first.equals(last = (JDFDate)v.elementAt(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFDate value = (JDFDate)v.elementAt(j);
            JDFDate nextvalue = (JDFDate)v.elementAt(j + 1);
            if (first.isEarlier(last) && value.isEarlier(nextvalue) || first.isLater(last) && value.isLater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

