/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.util.StringUtil;

public class SetHelper
extends BaseXJDFHelper {
    public static final String PARAMETER = "Parameter";
    public static final String RESOURCE = "Resource";

    public SetHelper(KElement set) {
        this.theElement = set;
    }

    public PartitionHelper getPartition(JDFAttributeMap map) {
        Vector<PartitionHelper> v = this.getPartitions();
        for (PartitionHelper ph : v) {
            if (!ph.matches(map)) continue;
            return ph;
        }
        return null;
    }

    public PartitionHelper getPartition(int index) {
        Vector<PartitionHelper> v = this.getPartitions();
        if (index < 0) {
            index += v.size();
        }
        if (index >= v.size()) {
            return null;
        }
        return index < 0 ? null : v.get(index);
    }

    public PartitionHelper getCreatePartition(JDFAttributeMap map, boolean addRes) {
        PartitionHelper e = this.getPartition(map);
        if (e == null) {
            e = this.appendPartition(map, addRes);
        } else if (!e.containsMap(map)) {
            e = this.insertPartitionBefore(e, map, addRes);
        }
        if (addRes) {
            e.getCreateResource();
        }
        return e;
    }

    public PartitionHelper insertPartitionBefore(PartitionHelper e, JDFAttributeMap map, boolean addRes) {
        PartitionHelper e2 = this.appendPartition(map, addRes);
        if (e != null) {
            KElement e3 = e.getPartition();
            e3.getParentNode_KElement().moveElement(e2.getPartition(), e3);
        }
        return e2;
    }

    public Vector<PartitionHelper> getCreatePartitions(VJDFAttributeMap vmap, boolean addRes) {
        if (vmap == null) {
            vmap = new VJDFAttributeMap();
            vmap.add(null);
        }
        Vector<PartitionHelper> vp = new Vector<PartitionHelper>();
        for (JDFAttributeMap m : vmap) {
            vp.add(this.getCreatePartition(m, addRes));
        }
        return vp;
    }

    public PartitionHelper getCreatePartition(int index, boolean addRes) {
        Vector<PartitionHelper> v = this.getPartitions();
        int size = v.size();
        if (index < 0) {
            index += size;
        }
        while (index < 0) {
            this.appendPartition(null, addRes);
            ++index;
        }
        while (index >= size) {
            this.appendPartition(null, addRes);
            ++size;
        }
        if (size != v.size()) {
            v = this.getPartitions();
        }
        PartitionHelper ph = v.get(index);
        if (addRes) {
            ph.getCreateResource();
        }
        return ph;
    }

    public void removePartitions() {
        Vector<PartitionHelper> v = this.getPartitions();
        for (PartitionHelper ph : v) {
            ph.getPartition().deleteNode();
        }
    }

    public PartitionHelper appendPartition(JDFAttributeMap partMap, boolean addRes) {
        String resName;
        KElement newPart = this.theElement.appendElement(this.getPartitionName());
        PartitionHelper partitionHelper = new PartitionHelper(newPart);
        partitionHelper.cleanUp();
        if (partMap != null && partMap.size() > 0) {
            JDFPart part = (JDFPart)newPart.appendElement("Part");
            this.updatePartitions(partMap);
            part.setPartMap(partMap);
        }
        if ((resName = this.getName()) != null && addRes) {
            KElement newRes = newPart.appendElement(resName);
            newRes.removeAttribute("Class");
        }
        return partitionHelper;
    }

    private void updatePartitions(JDFAttributeMap partMap) {
        String sep = partMap.get("Separation");
        if (sep != null) {
            partMap.put("Separation", StringUtil.replaceChar(sep, ' ', "_", 0));
        }
    }

    public Vector<PartitionHelper> getPartitions() {
        VElement v = this.theElement.getChildElementVector(this.getPartitionName(), null);
        Vector<PartitionHelper> v2 = new Vector<PartitionHelper>();
        if (v != null) {
            for (KElement e : v) {
                v2.add(new PartitionHelper(e));
            }
        }
        return v2;
    }

    public void cleanUp() {
        Vector<PartitionHelper> kids;
        if (!this.theElement.hasAttribute("Name")) {
            this.theElement.setAttribute("Name", this.getName());
        }
        if (!this.theElement.hasAttribute("ID")) {
            this.theElement.appendAnchor(null);
        }
        if ((kids = this.getPartitions()) != null) {
            for (PartitionHelper kid : kids) {
                kid.cleanUp();
            }
        }
    }

    public String getName() {
        String name = this.theElement.getAttribute("Name", null, null);
        if (name == null) {
            Vector<PartitionHelper> v = this.getPartitions();
            for (PartitionHelper ph : v) {
                KElement res = ph.getResource();
                if (res == null) continue;
                name = res.getNodeName();
                this.theElement.setAttribute("Name", name);
                return name;
            }
        }
        return name;
    }

    public String getPartitionName() {
        String name = StringUtil.leftStr(this.theElement.getLocalName(), -3);
        return name;
    }

    public PartitionHelper getPartition(VJDFAttributeMap vmap) {
        Vector<PartitionHelper> v = this.getPartitions();
        for (PartitionHelper ph : v) {
            if (!ph.matches(vmap)) continue;
            return ph;
        }
        return null;
    }

    public KElement getSet() {
        return this.theElement;
    }

    public void setUsage(JDFResourceLink.EnumUsage value) {
        this.theElement.setAttribute("Usage", value == null ? null : value.getName());
    }

    public String toString() {
        return "SetHelper: " + this.theElement;
    }
}

