/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceFilter;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFDeviceList;
import org.cip4.jdflib.util.EnumUtil;

public class JDFDeviceFilter
extends JDFAutoDeviceFilter {
    private static final long serialVersionUID = 1L;

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDeviceFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDeviceFilter[  --> " + super.toString() + " ]";
    }

    public void applyTo(JDFDeviceList dl) {
        if (dl == null) {
            return;
        }
        VElement v = dl.getChildElementVector("DeviceInfo", null);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            this.applyTo((JDFDeviceInfo)v.get(i));
        }
    }

    private void applyTo(JDFDeviceInfo deviceInfo) {
        JDFDevice dev;
        if (deviceInfo == null) {
            return;
        }
        JDFAutoDeviceFilter.EnumDeviceDetails det = this.getDeviceDetails();
        if (EnumUtil.aLessThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Capability) && (dev = deviceInfo.getDevice()) != null) {
            dev.removeChildren("DeviceCap", null, null);
        }
        if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Brief)) {
            deviceInfo.removeChildren("ModuleStatus", null, null);
        }
        if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.Brief)) {
            deviceInfo.removeChildren("Device", null, null);
        }
        if (EnumUtil.aLessEqualsThanB(det, JDFAutoDeviceFilter.EnumDeviceDetails.None)) {
            JDFAttributeMap map = new JDFAttributeMap();
            map.putNotNull("DeviceID", deviceInfo.getDeviceID());
            map.putNotNull("DeviceStatus", (Object)deviceInfo.getDeviceStatus());
            map.putNotNull("DescriptiveName", deviceInfo.getDescriptiveName());
            deviceInfo.removeAttributes(null);
            deviceInfo.setAttributes(map);
        }
    }
}

