/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoResourceCmdParams;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class JDFResourceCmdParams
extends JDFAutoResourceCmdParams
implements INodeIdentifiable {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];

    public JDFResourceCmdParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceCmdParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceCmdParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    @Override
    public String toString() {
        return "JDFResourceCmdParams[  --> " + super.toString() + " ]";
    }

    public JDFResource getCreateResource(String resName) {
        JDFResource r = null;
        KElement e = this.getCreateElement(resName, "", 0);
        if (!(e instanceof JDFResource)) {
            throw new JDFException("JDFResourceCmdParams.getCreateResource tried to create a JDFElement instead of a JDFResource");
        }
        return r;
    }

    public JDFResource getResource(String resName) {
        if (resName != null) {
            KElement e = this.getElement(resName, null, 0);
            if (e instanceof JDFResource) {
                return (JDFResource)e;
            }
        } else {
            String resName2 = this.getResourceName();
            if (resName2 != null && !resName2.equals("")) {
                return this.getResource(resName2);
            }
            for (KElement e2 = this.getFirstChildElement(); e2 != null; e2 = e2.getNextSiblingElement()) {
                if (!(e2 instanceof JDFResource)) continue;
                return (JDFResource)e2;
            }
        }
        return null;
    }

    public JDFResource appendResource(String resName) {
        KElement e = this.appendElement(resName, null);
        if (!(e instanceof JDFResource)) {
            throw new JDFException("JDFResourceCMDParams.appendResource tried to return a JDFElement instead of a JDFResource");
        }
        return (JDFResource)e;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourcePool, nMax);
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public void applyResourceCommand(JDFNode parentNode) {
        new ApplyCommand().applyResourceCommand(parentNode);
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
    }

    @Override
    public void setUsage(JDFResourceLink.EnumUsage enumVar) {
        this.setAttribute("Usage", enumVar == null ? null : enumVar.getName(), null);
    }

    @Override
    public JDFResourceLink.EnumUsage getUsage() {
        return JDFResourceLink.EnumUsage.getEnum(this.getAttribute("Usage", null, null));
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        NodeIdentifier niLocal = ni;
        if (niLocal == null) {
            niLocal = new NodeIdentifier();
        }
        this.setJobID(niLocal.getJobID());
        this.setJobPartID(niLocal.getJobPartID());
        this.setPartMapVector(niLocal.getPartMapVector());
    }

    static {
        int i = 0;
        JDFResourceCmdParams.elemInfoTable[i++] = new ElemInfoTable("Preview", 0x33333333L);
    }

    protected class ApplyCommand {
        protected ApplyCommand() {
        }

        void applyResourceCommand(JDFNode parentNode) {
            if (parentNode == null) {
                return;
            }
            VElement vNodes = parentNode.getvJDFNode(null, null, false);
            int size = vNodes.size();
            for (int i = 0; i < size; ++i) {
                this.applyNode(vNodes, i);
            }
        }

        private void applyNode(VElement vNodes, int i) {
            int sizCmd;
            JDFNode node = (JDFNode)vNodes.elementAt(i);
            if (!this.matchesNode(node)) {
                return;
            }
            JDFResource resCmd = JDFResourceCmdParams.this.getResource(null);
            if (resCmd == null) {
                return;
            }
            boolean isIncremental = JDFResourceCmdParams.this.getUpdateMethod() == JDFAutoResourceCmdParams.EnumUpdateMethod.Incremental;
            VJDFAttributeMap vamParts = JDFResourceCmdParams.this.getPartMapVector();
            JDFResource resTarget = this.getTargetResource(node);
            if (resTarget == null && (resTarget = this.createNewResource(node, resCmd)) == null) {
                return;
            }
            VString vsPartIDKeys = resTarget.getPartIDKeys();
            VString vsPartIDKeysCmd = resCmd.getPartIDKeys();
            int sizTarget = vsPartIDKeys == null ? 0 : vsPartIDKeys.size();
            int n = sizCmd = vsPartIDKeysCmd == null ? 0 : vsPartIDKeysCmd.size();
            if (sizCmd > sizTarget) {
                vsPartIDKeys = vsPartIDKeysCmd;
            }
            int sizeParts = vamParts == null ? 1 : vamParts.size();
            for (int j = 0; j < sizeParts; ++j) {
                JDFAttributeMap amParts = vamParts == null ? null : vamParts.elementAt(j);
                JDFResource resTargetPart = resTarget.getCreatePartition(amParts, vsPartIDKeys);
                if (resTargetPart == null) continue;
                String id = resTargetPart.getID();
                if (!isIncremental) {
                    JDFAttributeMap map = resTargetPart.getPartMap();
                    resTargetPart.flush();
                    resTargetPart.setAttributes(map);
                }
                JDFResource resCmdPart = this.cleanResCmdPart(resCmd, vsPartIDKeys, amParts, resTargetPart);
                resTargetPart.mergeElement(resCmdPart, false);
                resTarget.setID(id);
            }
            if (sizeParts > 0 && resTarget instanceof JDFNodeInfo) {
                this.fixNodeStatusFromNodeInfo(node, resTarget);
            }
        }

        private JDFResource cleanResCmdPart(JDFResource resCmd, VString vsPartIDKeys, JDFAttributeMap amParts, JDFResource resTargetPart) {
            JDFResource resCmdPart = (JDFResource)resCmd.getPartition(amParts, JDFResource.EnumPartUsage.Implicit).clone();
            JDFAttributeMap mapCmdAttribs = resCmdPart.getAttributeMap();
            VString keys = mapCmdAttribs.getKeys();
            if (keys != null) {
                for (String key : keys) {
                    String value = mapCmdAttribs.get(key);
                    if (value == null) {
                        resCmdPart.removeAttribute(key);
                        resTargetPart.removeAttribute(key);
                        continue;
                    }
                    if (vsPartIDKeys == null || !vsPartIDKeys.contains(key)) continue;
                    resCmdPart.removeAttribute(key);
                }
            }
            return resCmdPart;
        }

        private JDFResource getTargetResource(JDFNode node) {
            VElement vRes;
            VElement vRes2;
            if (node == null) {
                return null;
            }
            JDFResourceLinkPool rlp = node.getResourceLinkPool();
            if (rlp == null) {
                return null;
            }
            String resID = JDFResourceCmdParams.this.getResourceID();
            if (resID != null && !resID.equals("") && (vRes2 = rlp.getLinkedResources(null, null, new JDFAttributeMap("ID", resID), false, null)).size() > 0) {
                return (JDFResource)vRes2.elementAt(0);
            }
            String resName = JDFResourceCmdParams.this.getResourceName();
            if (resName != null && !resName.equals("") && (vRes = rlp.getLinkedResources(resName, null, null, false, null)).size() > 0) {
                return (JDFResource)vRes.elementAt(0);
            }
            return null;
        }

        private boolean matchesNode(JDFNode node) {
            if (node == null) {
                return false;
            }
            boolean bMatch = true;
            String jobID = StringUtil.getNonEmpty(JDFResourceCmdParams.this.getJobID());
            if (jobID != null) {
                bMatch = jobID.equals(node.getJobID(true));
            }
            if (!bMatch) {
                return false;
            }
            String jobPartID = StringUtil.getNonEmpty(JDFResourceCmdParams.this.getJobPartID());
            if (jobPartID != null) {
                bMatch = jobPartID.equals(node.getJobPartID(true));
            }
            return bMatch;
        }

        private JDFResource createNewResource(JDFNode node, JDFResource resCmd) {
            JDFResource resTarget = null;
            JDFResourceLink.EnumUsage u = JDFResourceCmdParams.this.getUsage();
            if (u != null) {
                resTarget = (JDFResource)node.getCreateResourcePool().copyElement(resCmd, null);
                JDFResourceLink rl = node.linkResource(resTarget, u, null);
                rl.copyAttribute("ProcessUsage", JDFResourceCmdParams.this);
                resTarget = this.getTargetResource(node);
            }
            return resTarget;
        }

        private void fixNodeStatusFromNodeInfo(JDFNode node, JDFResource resTarget) {
            JDFElement.EnumNodeStatus nodeStatus = node.getStatus();
            if (!JDFElement.EnumNodeStatus.Part.equals((Object)nodeStatus) && !JDFElement.EnumNodeStatus.Pool.equals((Object)node.getStatus())) {
                node.setStatus(JDFElement.EnumNodeStatus.Part);
                JDFNodeInfo ni = (JDFNodeInfo)resTarget;
                if (!ni.hasAttribute("NodeStatus")) {
                    ni.setNodeStatus(nodeStatus);
                }
            }
        }
    }
}

