/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.auto.JDFAutoDevCap;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFBooleanState;
import org.cip4.jdflib.resource.devicecapability.JDFDateTimeState;
import org.cip4.jdflib.resource.devicecapability.JDFDevCapPool;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFDurationState;
import org.cip4.jdflib.resource.devicecapability.JDFEnumerationState;
import org.cip4.jdflib.resource.devicecapability.JDFIntegerState;
import org.cip4.jdflib.resource.devicecapability.JDFMatrixState;
import org.cip4.jdflib.resource.devicecapability.JDFModuleCap;
import org.cip4.jdflib.resource.devicecapability.JDFModulePool;
import org.cip4.jdflib.resource.devicecapability.JDFNameState;
import org.cip4.jdflib.resource.devicecapability.JDFNumberState;
import org.cip4.jdflib.resource.devicecapability.JDFPDFPathState;
import org.cip4.jdflib.resource.devicecapability.JDFRectangleState;
import org.cip4.jdflib.resource.devicecapability.JDFShapeState;
import org.cip4.jdflib.resource.devicecapability.JDFStringState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.resource.devicecapability.JDFXYPairState;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.StringUtil;

public class JDFDevCap
extends JDFAutoDevCap
implements ICapabilityElement {
    private static final long serialVersionUID = -8230286210621220326L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[14];
    private static AtrInfoTable[] atrInfoTable;

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFDevCap(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDevCap(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDevCap(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDevCap[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        this.appendAnchor(null);
        return super.init();
    }

    @Override
    public void setDevCapRefs(VString value) {
        this.setAttribute("DevCapRefs", value, null);
    }

    @Override
    public void setID(String value) {
        this.setAttribute("ID", value, null);
    }

    @Override
    public String getID() {
        return this.getAttribute("ID", null, "");
    }

    @Override
    protected String getIDPrefix() {
        return "d";
    }

    @Override
    public JDFDeviceCap.EnumAvailability getAvailability() {
        JDFDeviceCap.EnumAvailability avail = JDFDeviceCap.EnumAvailability.getEnum(this.getAttribute("Availability", null, null));
        if (avail == null) {
            String parName = this.getParentNode().getNodeName();
            if (parName.equals("DevCap")) {
                JDFDevCap devCap = (JDFDevCap)this.getParentNode();
                avail = devCap.getAvailability();
            } else if (parName.equals("DevCaps")) {
                JDFDevCaps devCaps = (JDFDevCaps)this.getParentNode();
                avail = devCaps.getAvailability();
            }
        }
        return avail == null ? JDFDeviceCap.EnumAvailability.Installed : avail;
    }

    public JDFDevCap getDevCap(int iSkip) {
        return (JDFDevCap)this.getElement("DevCap", "", iSkip);
    }

    public JDFDevCap getCreateDevCap(int iSkip) {
        return (JDFDevCap)this.getCreateElement("DevCap", "", iSkip);
    }

    public JDFDevCap appendDevCap() {
        return (JDFDevCap)this.appendElement("DevCap", null);
    }

    public void appendDevCapRefs(JDFDevCap dc) {
        if (!(dc.getParentNode() instanceof JDFDevCapPool)) {
            throw new JDFException("appendDevCapRefs: referenced devCap must reide in a devCapPool");
        }
        dc.appendAnchor(null);
        String id2 = dc.getID();
        this.appendDevCapRefs(id2);
    }

    public void appendDevCapRefs(String dcID) {
        this.appendAttribute("DevCapRefs", dcID, null, " ", true);
    }

    public JDFBooleanState getBooleanState(int iSkip) {
        return (JDFBooleanState)this.getElement("BooleanState", null, iSkip);
    }

    public JDFBooleanState getBooleanState(String nam) {
        return (JDFBooleanState)this.getChildWithAttribute("BooleanState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFBooleanState getCreateBooleanState(int iSkip) {
        return (JDFBooleanState)this.getCreateElement("BooleanState", null, iSkip);
    }

    public JDFBooleanState getCreateBooleanState(String nam) {
        JDFBooleanState s = this.getBooleanState(nam);
        if (s == null) {
            s = this.appendBooleanState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFBooleanState appendBooleanState() {
        return (JDFBooleanState)this.appendElement("BooleanState", null);
    }

    public JDFBooleanState appendBooleanState(String nam) {
        JDFBooleanState s = (JDFBooleanState)this.appendElement("BooleanState", null);
        s.setName(nam);
        return s;
    }

    public JDFIntegerState getIntegerState(int iSkip) {
        JDFIntegerState e = (JDFIntegerState)this.getElement("IntegerState", null, iSkip);
        return e;
    }

    public JDFIntegerState getIntegerState(String nam) {
        return (JDFIntegerState)this.getChildWithAttribute("IntegerState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFIntegerState getCreateIntegerState(int iSkip) {
        return (JDFIntegerState)this.getCreateElement("IntegerState", null, iSkip);
    }

    public JDFIntegerState getCreateIntegerState(String nam) {
        JDFIntegerState s = this.getIntegerState(nam);
        if (s == null) {
            s = this.appendIntegerState(nam);
        }
        return s;
    }

    public JDFIntegerState appendIntegerState() {
        return (JDFIntegerState)this.appendElement("IntegerState", null);
    }

    public JDFIntegerState appendIntegerState(String nam) {
        JDFIntegerState s = (JDFIntegerState)this.appendElement("IntegerState", null);
        s.setName(nam);
        return s;
    }

    public JDFNumberState getNumberState(int iSkip) {
        return (JDFNumberState)this.getElement("NumberState", null, iSkip);
    }

    public JDFNumberState getNumberState(String nam) {
        return (JDFNumberState)this.getChildWithAttribute("NumberState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFNumberState getCreateNumberState(int iSkip) {
        return (JDFNumberState)this.getCreateElement("NumberState", null, iSkip);
    }

    public JDFNumberState getCreateNumberState(String nam) {
        JDFNumberState s = this.getNumberState(nam);
        if (s == null) {
            s = this.appendNumberState(nam);
        }
        return s;
    }

    public JDFNumberState appendNumberState(String nam) {
        JDFNumberState s = (JDFNumberState)this.appendElement("NumberState", null);
        s.setName(nam);
        return s;
    }

    @Deprecated
    public JDFNumberState appendNumberState() {
        return this.appendNumberState(null);
    }

    public JDFEnumerationState getEnumerationState(int iSkip) {
        return (JDFEnumerationState)this.getElement("EnumerationState", null, iSkip);
    }

    public JDFEnumerationState getEnumerationState(String nam) {
        return (JDFEnumerationState)this.getChildWithAttribute("EnumerationState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFEnumerationState getCreateEnumerationState(int iSkip) {
        return (JDFEnumerationState)this.getCreateElement("EnumerationState", null, iSkip);
    }

    public JDFEnumerationState getCreateEnumerationState(String nam) {
        JDFEnumerationState s = this.getEnumerationState(nam);
        if (s == null) {
            s = this.appendEnumerationState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFEnumerationState appendEnumerationState() {
        return (JDFEnumerationState)this.appendElement("EnumerationState", null);
    }

    public JDFEnumerationState appendEnumerationState(String nam) {
        JDFEnumerationState s = (JDFEnumerationState)this.appendElement("EnumerationState", null);
        s.setName(nam);
        return s;
    }

    public JDFNameState getNameState(int iSkip) {
        return (JDFNameState)this.getElement("NameState", null, iSkip);
    }

    public JDFNameState getNameState(String nam) {
        return (JDFNameState)this.getChildWithAttribute("NameState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFNameState getCreateNameState(int iSkip) {
        return (JDFNameState)this.getCreateElement("NameState", null, iSkip);
    }

    public JDFNameState getCreateNameState(String nam) {
        JDFNameState s = this.getNameState(nam);
        if (s == null) {
            s = this.appendNameState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFNameState appendNameState() {
        return (JDFNameState)this.appendElement("NameState", null);
    }

    public JDFNameState appendNameState(String nam) {
        JDFNameState s = (JDFNameState)this.appendElement("NameState", null);
        s.setName(nam);
        return s;
    }

    public JDFStringState getStringState(int iSkip) {
        return (JDFStringState)this.getElement("StringState", null, iSkip);
    }

    public JDFStringState getStringState(String nam) {
        return (JDFStringState)this.getChildWithAttribute("StringState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFStringState getCreateStringState(int iSkip) {
        return (JDFStringState)this.getCreateElement("StringState", null, iSkip);
    }

    public JDFStringState getCreateStringState(String nam) {
        JDFStringState s = this.getStringState(nam);
        if (s == null) {
            s = this.appendStringState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFStringState appendStringState() {
        return (JDFStringState)this.appendElement("StringState", null);
    }

    public JDFStringState appendStringState(String nam) {
        JDFStringState s = (JDFStringState)this.appendElement("StringState", null);
        s.setName(nam);
        return s;
    }

    public JDFXYPairState getXYPairState(int iSkip) {
        return (JDFXYPairState)this.getElement("XYPairState", null, iSkip);
    }

    public JDFXYPairState getXYPairState(String nam) {
        return (JDFXYPairState)this.getChildWithAttribute("XYPairState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFXYPairState getCreateXYPairState(int iSkip) {
        return (JDFXYPairState)this.getCreateElement("XYPairState", null, iSkip);
    }

    public JDFXYPairState getCreateXYPairState(String nam) {
        JDFXYPairState s = this.getXYPairState(nam);
        if (s == null) {
            s = this.appendXYPairState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFXYPairState appendXYPairState() {
        return (JDFXYPairState)this.appendElement("XYPairState", null);
    }

    public JDFXYPairState appendXYPairState(String nam) {
        JDFXYPairState s = (JDFXYPairState)this.appendElement("XYPairState", null);
        s.setName(nam);
        return s;
    }

    public JDFShapeState getShapeState(int iSkip) {
        return (JDFShapeState)this.getElement("ShapeState", null, iSkip);
    }

    public JDFShapeState getShapeState(String nam) {
        return (JDFShapeState)this.getChildWithAttribute("ShapeState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFShapeState getCreateShapeState(int iSkip) {
        return (JDFShapeState)this.getCreateElement("ShapeState", null, iSkip);
    }

    public JDFShapeState getCreateShapeState(String nam) {
        JDFShapeState s = this.getShapeState(nam);
        if (s == null) {
            s = this.appendShapeState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFShapeState appendShapeState() {
        return (JDFShapeState)this.appendElement("ShapeState", null);
    }

    public JDFShapeState appendShapeState(String nam) {
        JDFShapeState s = (JDFShapeState)this.appendElement("ShapeState", null);
        s.setName(nam);
        return s;
    }

    public JDFMatrixState getMatrixState(int iSkip) {
        return (JDFMatrixState)this.getElement("MatrixState", null, iSkip);
    }

    public JDFMatrixState getMatrixState(String nam) {
        return (JDFMatrixState)this.getChildWithAttribute("MatrixState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFMatrixState getCreateMatrixState(int iSkip) {
        return (JDFMatrixState)this.getCreateElement("MatrixState", null, iSkip);
    }

    public JDFMatrixState getCreateMatrixState(String nam) {
        JDFMatrixState s = this.getMatrixState(nam);
        if (s == null) {
            s = this.appendMatrixState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFMatrixState appendMatrixState() {
        return (JDFMatrixState)this.appendElement("MatrixState", null);
    }

    public JDFMatrixState appendMatrixState(String nam) {
        JDFMatrixState s = (JDFMatrixState)this.appendElement("MatrixState", null);
        s.setName(nam);
        return s;
    }

    public JDFDateTimeState getDateTimeState(int iSkip) {
        return (JDFDateTimeState)this.getElement("DateTimeState", null, iSkip);
    }

    public JDFDateTimeState getDateTimeState(String nam) {
        return (JDFDateTimeState)this.getChildWithAttribute("DateTimeState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFDateTimeState getCreateDateTimeState(int iSkip) {
        return (JDFDateTimeState)this.getCreateElement("DateTimeState", null, iSkip);
    }

    public JDFDateTimeState getCreateDateTimeState(String nam) {
        JDFDateTimeState s = this.getDateTimeState(nam);
        if (s == null) {
            s = this.appendDateTimeState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFDateTimeState appendDateTimeState() {
        return (JDFDateTimeState)this.appendElement("DateTimeState", null);
    }

    public JDFDateTimeState appendDateTimeState(String nam) {
        JDFDateTimeState s = (JDFDateTimeState)this.appendElement("DateTimeState", null);
        s.setName(nam);
        return s;
    }

    public JDFDurationState getDurationState(int iSkip) {
        return (JDFDurationState)this.getElement("DurationState", null, iSkip);
    }

    public JDFDurationState getDurationState(String nam) {
        return (JDFDurationState)this.getChildWithAttribute("DurationState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFDurationState getCreateDurationState(int iSkip) {
        return (JDFDurationState)this.getCreateElement("DurationState", null, iSkip);
    }

    public JDFDurationState getCreateDurationState(String nam) {
        JDFDurationState s = this.getDurationState(nam);
        if (s == null) {
            s = this.appendDurationState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFDurationState appendDurationState() {
        return (JDFDurationState)this.appendElement("DurationState", null);
    }

    public JDFDurationState appendDurationState(String nam) {
        JDFDurationState s = (JDFDurationState)this.appendElement("DurationState", null);
        s.setName(nam);
        return s;
    }

    public JDFPDFPathState getPDFPathState(int iSkip) {
        return (JDFPDFPathState)this.getElement("PDFPathState", null, iSkip);
    }

    public JDFPDFPathState getPDFPathState(String nam) {
        return (JDFPDFPathState)this.getChildWithAttribute("PDFPathState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFPDFPathState getCreatePDFPathState(int iSkip) {
        return (JDFPDFPathState)this.getCreateElement("PDFPathState", null, iSkip);
    }

    public JDFPDFPathState getCreatePDFPathState(String nam) {
        JDFPDFPathState s = this.getPDFPathState(nam);
        if (s == null) {
            s = this.appendPDFPathState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFPDFPathState appendPDFPathState() {
        return (JDFPDFPathState)this.appendElement("PDFPathState", null);
    }

    public JDFPDFPathState appendPDFPathState(String nam) {
        JDFPDFPathState s = (JDFPDFPathState)this.appendElement("PDFPathState", null);
        s.setName(nam);
        return s;
    }

    public JDFRectangleState getRectangleState(int iSkip) {
        return (JDFRectangleState)this.getElement("RectangleState", null, iSkip);
    }

    public JDFRectangleState getRectangleState(String nam) {
        return (JDFRectangleState)this.getChildWithAttribute("RectangleState", "Name", null, nam, 0, true);
    }

    @Deprecated
    public JDFRectangleState getCreateRectangleState(int iSkip) {
        return (JDFRectangleState)this.getCreateElement("RectangleState", null, iSkip);
    }

    public JDFRectangleState getCreateRectangleState(String nam) {
        JDFRectangleState s = this.getRectangleState(nam);
        if (s == null) {
            s = this.appendRectangleState(nam);
        }
        return s;
    }

    @Deprecated
    public JDFRectangleState appendRectangleState() {
        return (JDFRectangleState)this.appendElement("RectangleState", null);
    }

    public JDFRectangleState appendRectangleState(String nam) {
        JDFRectangleState s = (JDFRectangleState)this.appendElement("RectangleState", null);
        s.setName(nam);
        return s;
    }

    private KElement getParentPool(String poolName) {
        KElement parent = this.getPoolParent();
        return parent.getElement(poolName);
    }

    private KElement getCreateParentPool(String poolName) {
        KElement parent = this.getPoolParent();
        return parent.getCreateElement(poolName);
    }

    private boolean getIgnoreDefaults() {
        KElement p = this.getPoolParent();
        if (p instanceof JDFDeviceCap) {
            return ((JDFDeviceCap)p).isIgnoreDefaults();
        }
        return false;
    }

    private KElement getPoolParent() {
        KElement parent = this.getDeepParent("DeviceCap", 0);
        if (parent == null) {
            parent = this.getDeepParent("MessageService", 0);
        }
        if (parent != null && !(parent instanceof JDFDeviceCap) && !(parent instanceof JDFMessageService)) {
            throw new JDFException("JDFDevCap.getParentPool - invalid parent context");
        }
        return parent;
    }

    public final VElement getDevCapVector(VElement devCaps, boolean bDirect) {
        int preFill = 0;
        VElement vDevCap = this.getChildElementVector("DevCap", null, null, true, 0, false);
        if (devCaps != null) {
            preFill = devCaps.size();
            devCaps.appendUnique(vDevCap);
            vDevCap = devCaps;
        } else if (!bDirect) {
            vDevCap.appendUnique(this);
        }
        if (this.hasAttribute("DevCapRefs")) {
            JDFDevCapPool devCapPool = (JDFDevCapPool)this.getParentPool("DevCapPool");
            if (devCapPool != null) {
                VString idRefs = this.getDevCapRefs();
                for (int i = 0; i < idRefs.size(); ++i) {
                    JDFDevCap devCap = devCapPool.getDevCap(idRefs.stringAt(i));
                    if (devCap == null) {
                        throw new JDFException("JDFDevCap.getDevCapVector: Attribute DevCapRefs refers to the non-existent DevCap: " + idRefs.stringAt(i));
                    }
                    vDevCap.appendUnique(devCap);
                }
            } else {
                throw new JDFException("JDFDevCap.getDevCapVector: Attribute DevCapRefs refers to the non-existent DevCapPool");
            }
        }
        if (!bDirect) {
            for (int i = preFill; i < vDevCap.size(); ++i) {
                JDFDevCap dcChild = (JDFDevCap)vDevCap.elementAt(i);
                vDevCap = dcChild.getDevCapVector(vDevCap, bDirect);
            }
        }
        return vDevCap;
    }

    public final KElement stateReport(KElement e, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, boolean ignoreExtensions, boolean bRecurse, KElement parentReport) {
        boolean bRecurseLocal = bRecurse;
        KElement parentReportLocal = parentReport;
        if (!(e instanceof JDFNode) && !ignoreExtensions) {
            this.missingDevCap(e, parentReportLocal);
        }
        if (e instanceof JDFResource && bRecurseLocal) {
            JDFResource res = (JDFResource)e;
            JDFResource resourceRoot = res.getResourceRoot();
            if (resourceRoot.hasAttribute_KElement("PartIDKeys", null, false)) {
                VElement vLeaves = res.getLeaves(!JDFResource.EnumPartUsage.Explicit.equals((Object)resourceRoot.getPartUsage()));
                int size = vLeaves.size();
                for (int i = 0; i < size; ++i) {
                    KElement p;
                    JDFResource leaf = (JDFResource)vLeaves.elementAt(i);
                    KElement partTestResult = this.stateReport(leaf, testlists, level, ignoreExtensions, false, p = parentReportLocal.appendElement("InvalidPartitionLeaf"));
                    if (partTestResult != null) {
                        String path = leaf.buildXPath(null, 1);
                        p.setAttribute("XPath", path);
                        String leafPath = path.substring(res.buildXPath(null, 1).length());
                        p.setAttribute("LeafXPath", res.getNodeName() + leafPath);
                        continue;
                    }
                    p.deleteNode();
                }
            } else {
                bRecurseLocal = false;
            }
        } else {
            bRecurseLocal = false;
        }
        if (!bRecurseLocal) {
            this.subelementsTest(e, testlists, level, ignoreExtensions, parentReportLocal);
            this.spanAndAttributesTest(e, testlists, level, ignoreExtensions, parentReportLocal);
        }
        if (!parentReportLocal.hasChildElements()) {
            parentReportLocal = null;
        }
        return parentReportLocal;
    }

    private final KElement subelementsTest(KElement testElem, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, boolean ignoreExtensions, KElement parentReport) {
        KElement parentReportLocal = parentReport;
        VElement vDevCap = this.getDevCapVector(null, true);
        HashSet<KElement> goodElems = new HashSet<KElement>();
        HashMap<KElement, KElement> badElems = new HashMap<KElement, KElement>();
        for (int k = 0; k < vDevCap.size(); ++k) {
            KElement r;
            KElement subEl;
            int j;
            JDFDevCap dc = (JDFDevCap)vDevCap.elementAt(k);
            String dcName = dc.getName();
            JDFDeviceCap.EnumAvailability av = dc.getModuleAvailability();
            if (!JDFDeviceCap.EnumAvailability.Installed.equals((Object)av)) continue;
            VElement vElem = dc.getMatchingElementsFromParent(testElem, vDevCap);
            int occurs = vElem == null ? 0 : vElem.size();
            int minOccurs = dc.getMinOccurs();
            int maxOccurs = dc.getMaxOccurs();
            if (occurs > maxOccurs && vElem != null) {
                for (j = 0; j < occurs; ++j) {
                    subEl = vElem.item(j);
                    r = parentReportLocal.appendElement("InvalidElement");
                    r.setAttribute("CapXPath", dc.getNamePath(true));
                    r.setAttribute("XPath", subEl.buildXPath(null, 1));
                    r.setAttribute("Name", dcName);
                    r.setAttribute("Message", "Element occurrence exceeds value of MaxOccurs");
                    r.setAttribute("MaxOccurs", maxOccurs, (String)null);
                    r.setAttribute("FoundElements", occurs, (String)null);
                }
            } else if (occurs < minOccurs && JDFElement.EnumValidationLevel.isRequired(level)) {
                r = parentReportLocal.appendElement("MissingElement");
                r.setAttribute("CapXPath", dc.getNamePath(true));
                r.setAttribute("XPath", testElem.buildXPath(null, 1) + "/" + dcName);
                r.setAttribute("Name", dcName);
                r.setAttribute("Message", "Element occurrence is less than value of MinOccurs");
                r.setAttribute("MinOccurs", minOccurs, (String)null);
                r.setAttribute("FoundElements", occurs, (String)null);
            }
            if (vElem == null) continue;
            for (j = 0; j < occurs; ++j) {
                subEl = vElem.item(j);
                if (goodElems.contains(subEl)) continue;
                r = parentReportLocal.appendElement("InvalidElement");
                KElement recursionResult = dc.stateReport(subEl, testlists, level, ignoreExtensions, true, r);
                if (recursionResult == null) {
                    goodElems.add(subEl);
                    KElement badReport = (KElement)badElems.get(subEl);
                    if (badReport != null) {
                        badReport.deleteNode();
                    }
                } else {
                    recursionResult.appendAttribute("DevCapRefs", dc.getID(), null, " ", true);
                    badElems.put(subEl, recursionResult);
                }
                if (recursionResult != null) {
                    r.setAttribute("CapXPath", dc.getNamePath(true));
                    r.setAttribute("XPath", subEl.buildXPath(null, 1));
                    r.setAttribute("Name", dcName);
                    continue;
                }
                r.deleteNode();
            }
        }
        if (!parentReportLocal.hasChildElements()) {
            parentReportLocal = null;
        }
        return parentReportLocal;
    }

    private final KElement spanAndAttributesTest(KElement e, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, boolean ignoreExtensions, KElement parentReport) {
        KElement parentReportLocal = parentReport;
        KElement msp = parentReportLocal.appendElement("UnknownAttributes");
        KElement map = parentReportLocal.appendElement("MissingAttributes");
        KElement iap = parentReportLocal.appendElement("InvalidAttributes");
        VElement vStates = this.getStates(true, null);
        JDFAttributeMap missMap = new JDFAttributeMap();
        JDFAttributeMap capMap = new JDFAttributeMap();
        JDFAttributeMap defMap = this.getIgnoreDefaults() || !(e instanceof JDFElement) ? null : ((JDFElement)e).getDefaultAttributeMap();
        JDFAttributeMap am = new JDFAttributeMap(defMap);
        am.putAll(e.getAttributeMap());
        JDFAttributeMap m = this.getSpanAndAttributesMap(e);
        VString vKeys = m.getKeys();
        if (vStates != null) {
            int sizeStates = vStates.size();
            for (int j = 0; j < sizeStates; ++j) {
                JDFAbstractState state = (JDFAbstractState)vStates.item(j);
                String nam = state.getName();
                JDFDeviceCap.EnumAvailability av = state.getModuleAvailability();
                if (!JDFDeviceCap.EnumAvailability.Installed.equals((Object)av)) continue;
                int size = vKeys.size();
                for (int i = size - 1; i >= 0; --i) {
                    String value;
                    String key = vKeys.elementAt(i);
                    if (!nam.equals(key) && (!key.equals("CommentText") || nam.length() != 0)) continue;
                    String string = value = nam.length() != 0 ? m.get(key) : m.get("CommentText");
                    if (!state.fitsValue(value, testlists)) {
                        KElement r;
                        if (!am.containsKey(key) && !key.equals("CommentText")) {
                            r = iap.appendElement("InvalidSpan");
                            r.setAttribute("XPath", e.buildXPath(null, 1) + "/" + key);
                            r.setAttribute("Message", "Span value doesn't fit this State description");
                        } else if (key.equals("CommentText")) {
                            r = iap.appendElement("InvalidComment");
                            r.setAttribute("XPath", e.buildXPath(null, 1) + "/" + key);
                            r.setAttribute("Message", "Comment doesn't fit this State description");
                        } else {
                            r = iap.appendElement("InvalidAttribute");
                            r.setAttribute("XPath", e.buildXPath(null, 1) + "/@" + key);
                            r.setAttribute("Message", "Attribute value doesn't fit this State description");
                        }
                        r.setAttribute("Name", key);
                        r.setAttribute("CapXPath", state.getNamePath());
                        r.setAttribute("Value", value);
                        r.copyElement(state, null);
                    }
                    vKeys.removeElementAt(i);
                    break;
                }
                if (size != vKeys.size() || !state.getRequired() || !JDFElement.EnumValidationLevel.isRequired(level)) continue;
                if (state.getListType().equals((Object)JDFAutoBasicPreflightTest.EnumListType.Span)) {
                    missMap.put(nam, "Span");
                } else {
                    missMap.put(nam, "Attribute");
                }
                capMap.put(nam, state.getNamePath());
            }
        }
        JDFElement.EnumValidationLevel l2 = level;
        if (e instanceof JDFResource && JDFResource.EnumResStatus.Incomplete.equals((Object)((JDFResource)e).getResStatus(false))) {
            l2 = JDFElement.EnumValidationLevel.incompleteLevel(level);
        }
        if (JDFElement.EnumValidationLevel.isRequired(l2) && e instanceof JDFElement) {
            int i;
            JDFElement je = (JDFElement)e;
            VString missAts = je.getMissingAttributes(9999999);
            for (i = 0; i < missAts.size(); ++i) {
                missMap.put(missAts.stringAt(i), "Attribute");
            }
            missAts = je.getMissingElements(99999);
            for (i = 0; i < missAts.size(); ++i) {
                String stringAt = missAts.stringAt(i);
                if (!stringAt.endsWith("Span")) continue;
                missMap.put(stringAt, "Span");
            }
        }
        for (String nam : missMap.keySet()) {
            String typ = missMap.get(nam);
            KElement ms = map.appendElement("Missing" + typ);
            ms.setAttribute("Message", "Missing " + typ);
            ms.setAttribute("XPath", e.buildXPath(null, 1) + "/@" + nam);
            String capNamePath = capMap.get(nam);
            if (capNamePath != null) {
                ms.setAttribute("CapXPath", capNamePath);
            }
            ms.setAttribute("Name", nam);
        }
        if (!ignoreExtensions) {
            for (int x = 0; x < vKeys.size(); ++x) {
                KElement us;
                String key = vKeys.elementAt(x);
                if (this.isGenericAttribute(key) || defMap != null && defMap.containsKey(key)) continue;
                if (!am.containsKey(key) && !key.equals("CommentText")) {
                    us = msp.appendElement("UnknownSpan");
                    us.setAttribute("XPath", e.buildXPath(null, 1) + "/" + key);
                    us.setAttribute("CapXPath", this.getNamePath(true) + "/" + key);
                } else {
                    us = msp.appendElement("UnknownAttribute");
                    us.setAttribute("XPath", e.buildXPath(null, 1) + "/@" + key);
                    us.setAttribute("CapXPath", this.getNamePath(true) + "/@" + key);
                }
                us.setAttribute("Name", key);
                us.setAttribute("Message", "No State description for " + key);
            }
        }
        if (!map.hasChildElements()) {
            parentReportLocal.removeChild(map);
        }
        if (!iap.hasChildElements()) {
            parentReportLocal.removeChild(iap);
        }
        if (!msp.hasChildElements()) {
            parentReportLocal.removeChild(msp);
        }
        if (!parentReportLocal.hasChildElements()) {
            parentReportLocal = null;
        }
        return parentReportLocal;
    }

    private final JDFAttributeMap getSpanAndAttributesMap(KElement e) {
        JDFAttributeMap defMap = this.getIgnoreDefaults() || !(e instanceof JDFElement) ? null : ((JDFElement)e).getDefaultAttributeMap();
        JDFAttributeMap m = new JDFAttributeMap(defMap);
        m.putAll(e.getAttributeMap());
        if (e instanceof JDFResource) {
            JDFResource r = (JDFResource)e;
            if (r.getResourceClass() == JDFResource.EnumResourceClass.Intent) {
                JDFAttributeMap spanMap = this.getSpanValueMap(r);
                VString vSpanMapKeys = spanMap.getKeys();
                for (int k = 0; k < vSpanMapKeys.size(); ++k) {
                    String spanKey = vSpanMapKeys.elementAt(k);
                    m.put(spanKey, spanMap.get(spanKey));
                }
            }
        } else if (e instanceof JDFComment) {
            JDFComment c = (JDFComment)e;
            m.put("CommentText", c.getText(0));
        }
        return m;
    }

    private final JDFAttributeMap getSpanValueMap(JDFResource r) {
        JDFAttributeMap map = new JDFAttributeMap();
        VElement v = r.getChildElementVector(null, null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            String value;
            KElement el = v.item(i);
            if (!(el instanceof JDFSpanBase)) continue;
            String string = value = el.hasAttribute("Actual") ? el.getAttribute("Actual") : el.getAttribute("Preferred");
            if (value.length() == 0) {
                value = el.getAttribute("Range");
            }
            map.put(el.getNodeName(), value);
        }
        return map;
    }

    private final KElement missingDevCap(KElement elem, KElement parentReport) {
        KElement root = parentReport.appendElement("UnknownElements");
        VElement vDevCap = this.getDevCapVector(null, true);
        VElement vSubElem = elem.getChildElementVector(null, null, null, true, 0, true);
        for (int i = 0; i < vSubElem.size(); ++i) {
            KElement e = vSubElem.item(i);
            if (e instanceof JDFSpanBase || e instanceof JDFNode) continue;
            String nam = e.getNodeName();
            boolean bFound = false;
            JDFDeviceCap.EnumAvailability foundAv = null;
            for (int k = 0; k < vDevCap.size(); ++k) {
                JDFDevCap devCap = (JDFDevCap)vDevCap.elementAt(k);
                if (!devCap.getName().equals(nam)) continue;
                JDFDeviceCap.EnumAvailability moduleAvailability = devCap.getModuleAvailability();
                if (JDFDeviceCap.EnumAvailability.Installed.equals((Object)moduleAvailability)) {
                    bFound = true;
                    break;
                }
                if (foundAv == null) {
                    foundAv = moduleAvailability;
                    continue;
                }
                if (moduleAvailability == null || foundAv.getValue() >= moduleAvailability.getValue()) continue;
                foundAv = moduleAvailability;
            }
            if (bFound) continue;
            KElement us = root.appendElement("UnknownElement");
            us.setAttribute("XPath", e.buildXPath(null, 1));
            us.setAttribute("CapXPath", this.getNamePath(false) + "/" + nam);
            us.setAttribute("Name", nam);
            us.setAttribute("Message", "Found no DevCap description for this element");
            us.setAttribute("Availability", foundAv == null ? "None" : foundAv.getName());
        }
        if (!root.hasChildElements()) {
            root.deleteNode();
            root = null;
        }
        return root;
    }

    private final boolean isGenericAttribute(String key) {
        if (key == null) {
            return true;
        }
        if (key.startsWith("xmlns")) {
            return true;
        }
        KElement deviceCap = this.getDeepParent("DeviceCap", 0);
        if (deviceCap == null) {
            deviceCap = this.getDeepParent("MessageService", 0);
        }
        if (deviceCap == null) {
            return false;
        }
        VString s = StringUtil.tokenize(deviceCap.getAttribute("GenericAttributes"), " ", false);
        return s != null && (s.contains(key) || s.contains("*"));
    }

    public final String getNamePath(boolean bRecurse) {
        VString paths = this.getNamePathVector(bRecurse);
        if (paths == null || paths.size() < 1) {
            return null;
        }
        return paths.stringAt(0);
    }

    @Override
    public VString getNamePathVector() {
        return this.getNamePathVector(true);
    }

    public final VString getNamePathVector(boolean bRecurse) {
        String result = this.getName();
        VString vResult = null;
        if (result == null) {
            return null;
        }
        KElement parentNode = this.getParentNode_KElement();
        if (parentNode instanceof JDFDevCap) {
            JDFDevCap devCap = (JDFDevCap)parentNode;
            vResult = devCap.getNamePathVector(bRecurse);
        } else if (parentNode instanceof JDFDevCapPool) {
            String id;
            if (bRecurse && !(id = this.getID()).equals("")) {
                VElement v = parentNode.getChildrenByTagName("DevCap", null, null, false, true, 0);
                KElement deviceCap = parentNode.getParentNode_KElement();
                for (int i = 0; i < v.size(); ++i) {
                    String dcID;
                    JDFDevCaps dcs;
                    JDFDevCap dc = (JDFDevCap)v.elementAt(i);
                    VString refs = dc.getDevCapRefs();
                    if (!refs.contains(id)) continue;
                    if (vResult == null) {
                        vResult = new VString();
                    }
                    if ((dcs = (JDFDevCaps)((dcID = dc.getAttribute("ID", null, null)) == null ? null : deviceCap.getChildWithAttribute("DevCaps", "DevCapRef", null, dcID, 0, true))) != null) {
                        vResult.appendUnique(dcs.getNamePathVector());
                        continue;
                    }
                    vResult.appendUnique(dc.getNamePathVector(bRecurse));
                }
                JDFDevCaps dcs = (JDFDevCaps)deviceCap.getChildWithAttribute("DevCaps", "DevCapRef", null, id, 0, true);
                if (dcs != null) {
                    VString vResult2 = dcs.getNamePathVector();
                    if (vResult == null) {
                        vResult = vResult2;
                    } else {
                        StringUtil.concatStrings(vResult, "/" + result);
                        vResult.appendUnique(vResult2);
                    }
                    return vResult;
                }
            }
        } else if (parentNode instanceof JDFDevCaps) {
            JDFDevCaps devCaps = (JDFDevCaps)parentNode;
            vResult = devCaps.getNamePathVector();
            return vResult;
        }
        if (vResult == null) {
            vResult = new VString();
            vResult.add(result);
        } else {
            StringUtil.concatStrings(vResult, "/" + result);
        }
        return vResult;
    }

    @Override
    public String getName() {
        String s = this.getAttribute("Name", null, null);
        if (s == null) {
            JDFDeviceCap dec;
            JDFDevCaps dcs;
            String id;
            KElement parentNode = this.getParentNode_KElement();
            if (parentNode instanceof JDFDevCaps) {
                JDFDevCaps devCaps = (JDFDevCaps)this.getParentNode();
                s = devCaps.getName();
            } else if (parentNode instanceof JDFDevCap) {
                JDFDevCap devCap = (JDFDevCap)this.getParentNode();
                s = devCap.getName();
            } else if (parentNode instanceof JDFDevCapPool && !(id = this.getID()).equals("") && (dcs = (JDFDevCaps)(dec = (JDFDeviceCap)parentNode.getParentNode()).getChildWithAttribute("DevCaps", "DevCapRef", null, id, 0, true)) != null) {
                s = dcs.getName();
            }
        }
        return s;
    }

    public VElement getStates(boolean bDirect, String id) {
        JDFAttributeMap m = null;
        if (id != null) {
            m = new JDFAttributeMap("ID", id);
        }
        VElement v = null;
        if (bDirect) {
            v = this.getChildrenByTagName(null, null, m, bDirect, true, 0);
            for (int i = v.size() - 1; i >= 0; --i) {
                if (v.elementAt(i) instanceof JDFAbstractState) continue;
                v.remove(i);
            }
        } else {
            v = new VElement();
            VElement vdevCap = this.getDevCapVector(null, false);
            for (int i = 0; i < vdevCap.size(); ++i) {
                JDFDevCap child = (JDFDevCap)vdevCap.elementAt(i);
                v.appendUnique(child.getStates(true, id));
            }
        }
        return v;
    }

    @Override
    public void setMaxOccurs(int value) {
        if (value == Integer.MAX_VALUE) {
            this.setAttribute("MaxOccurs", "INF", null);
        } else {
            this.setAttribute("MaxOccurs", value, (String)null);
        }
    }

    @Override
    public int getMaxOccurs() {
        String s = this.getAttribute("MaxOccurs", null, null);
        if ("unbounded".equals(s)) {
            return Integer.MAX_VALUE;
        }
        return StringUtil.parseInt(s, 1);
    }

    public VElement getMatchingElementsFromParent(KElement parent, VElement vDevCap) {
        VElement v = this.getAllMatchingElementsFromParent(parent);
        if (v == null) {
            return null;
        }
        String _name = this.getName();
        VElement vOther = new VElement();
        if (vDevCap != null) {
            for (int i = 0; i < vDevCap.size(); ++i) {
                VElement vOtherMatch;
                JDFDevCap dcOther = (JDFDevCap)vDevCap.elementAt(i);
                if (dcOther == this || !_name.equals(dcOther.getName()) || (vOtherMatch = dcOther.getAllMatchingElementsFromParent(parent)) == null) continue;
                vOther.add(dcOther);
            }
        }
        if (vOther.size() == 0) {
            return v;
        }
        XMLDoc doc = new XMLDoc("dummy", null);
        KElement repRootDummy = doc.getRoot();
        block1: for (int i = v.size() - 1; i >= 0; --i) {
            KElement e = v.item(i);
            repRootDummy.flush();
            if (this.spanAndAttributesTest(e, JDFBaseDataTypes.EnumFitsValue.Allowed, JDFElement.EnumValidationLevel.Incomplete, true, repRootDummy) == null && this.subelementsTest(e, JDFBaseDataTypes.EnumFitsValue.Allowed, JDFElement.EnumValidationLevel.Incomplete, true, repRootDummy) == null) continue;
            for (int j = 0; j < vOther.size(); ++j) {
                repRootDummy.flush();
                JDFDevCap dcOther = (JDFDevCap)vOther.elementAt(j);
                if (dcOther.spanAndAttributesTest(e, JDFBaseDataTypes.EnumFitsValue.Allowed, JDFElement.EnumValidationLevel.Incomplete, true, repRootDummy) != null || dcOther.subelementsTest(e, JDFBaseDataTypes.EnumFitsValue.Allowed, JDFElement.EnumValidationLevel.Incomplete, true, repRootDummy) != null) continue;
                v.remove(i);
                continue block1;
            }
        }
        return v.size() != 0 ? v : null;
    }

    public VElement getAllMatchingElementsFromParent(KElement parent) {
        VElement subElems;
        VString valList;
        JDFNameState ns;
        String nam = this.getName();
        JDFAttributeMap map = null;
        if (parent instanceof JDFJMF && (ns = this.getNameState("Type")) != null && (valList = ns.getAllowedValueList()) != null) {
            map = new JDFAttributeMap("Type", valList.stringAt(0));
        }
        return (subElems = parent.getChildElementVector(nam, null, map, true, 999999, true)).size() == 0 ? null : subElems;
    }

    public boolean setDefaultsFromCaps(KElement element, boolean bAll) {
        JDFResource r;
        boolean success = false;
        if (element instanceof JDFResource && !(r = (JDFResource)element).isLeaf()) {
            VElement vR = r.getLeaves(false);
            for (int i = 0; i < vR.size(); ++i) {
                success = this.setDefaultsFromCaps(vR.item(i), bAll) || success;
            }
            return success;
        }
        VElement vSubDevCap = null;
        try {
            vSubDevCap = this.getDevCapVector(null, true);
        }
        catch (JDFException x) {
            return false;
        }
        for (int i = 0; i < vSubDevCap.size(); ++i) {
            int ii;
            JDFDevCap subDevCap = (JDFDevCap)vSubDevCap.elementAt(i);
            int minOccurs = subDevCap.getMinOccurs();
            if (minOccurs == 0 && bAll) {
                minOccurs = 1;
            }
            VElement subElms = subDevCap.getMatchingElementsFromParent(element, vSubDevCap);
            if (minOccurs > 0) {
                int occurs;
                int n = occurs = subElms == null ? 0 : subElms.size();
                if (occurs < minOccurs && subElms == null) {
                    subElms = new VElement();
                }
                if (subElms != null) {
                    for (ii = occurs; ii < minOccurs; ++ii) {
                        KElement isThere;
                        String id = subDevCap.getID();
                        KElement kElement = isThere = id == null ? null : element.getOwnerDocument_KElement().getRoot().getTarget(id, "ID");
                        if (!(isThere instanceof JDFResource) || !(element instanceof JDFElement)) {
                            KElement newSub = element.appendElement(subDevCap.getName(), subDevCap.getDevNS());
                            subElms.add(newSub);
                        } else {
                            JDFRefElement re = ((JDFElement)element).refElement((JDFResource)isThere);
                            subElms.add(re.getTarget());
                        }
                        success = true;
                    }
                }
            }
            if (subElms == null) continue;
            int subSize = subElms.size();
            for (ii = 0; ii < subSize; ++ii) {
                success = subDevCap.setDefaultsFromCaps(subElms.item(ii), bAll) || success;
            }
        }
        VElement vStates = this.getStates(true, null);
        for (int i = 0; i < vStates.size(); ++i) {
            JDFAbstractState state = (JDFAbstractState)vStates.elementAt(i);
            success = state.setDefaultsFromCaps(element, bAll) || success;
        }
        return false;
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        JDFDoc tmpDoc;
        KElement tmpRoot;
        VString vs = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (nMax > 0 && vs.size() > nMax) {
            return vs;
        }
        if (JDFElement.EnumValidationLevel.isRecursive(level) && !vs.contains("DevCapRefs") && this.hasAttribute("DevCapRefs")) {
            JDFDevCapPool devCapPool;
            JDFDeviceCap deviceCap = (JDFDeviceCap)this.getDeepParent("DeviceCap", 0);
            JDFDevCapPool jDFDevCapPool = devCapPool = deviceCap == null ? null : deviceCap.getDevCapPool();
            if (devCapPool == null) {
                vs.add("DevCapRefs");
                return vs;
            }
            VString idRefs = this.getDevCapRefs();
            for (int i = 0; i < idRefs.size(); ++i) {
                JDFDevCap devCap = devCapPool.getDevCap(idRefs.stringAt(i));
                if (devCap != null) continue;
                vs.add("DevCapRefs");
                return vs;
            }
        }
        String nam = this.getName();
        if (!vs.contains("Name") && nam != null && this.getDevNS().equals(JDFElement.getSchemaURL()) && JDFElement.class.equals((tmpRoot = (tmpDoc = new JDFDoc(nam = KElement.xmlnsLocalName(nam))).getRoot()).getClass())) {
            vs.add("DevNS");
        }
        return vs;
    }

    @Override
    public JDFModulePool getModulePool() {
        return (JDFModulePool)this.getParentPool("ModulePool");
    }

    @Override
    public JDFModulePool getCreateModulePool() {
        return (JDFModulePool)this.getCreateParentPool("ModulePool");
    }

    public JDFDeviceCap.EnumAvailability getModuleAvailability() {
        return JDFModulePool.getModuleAvailability(this);
    }

    @Override
    public JDFModuleCap appendModuleRef(String id) {
        return JDFModulePool.appendModuleRef(this, id);
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.IsPresentEvaluation;
    }

    static {
        JDFDevCap.elemInfoTable[0] = new ElemInfoTable("DevCap", 0x33333333L);
        JDFDevCap.elemInfoTable[1] = new ElemInfoTable("BooleanState", 0x33333333L);
        JDFDevCap.elemInfoTable[2] = new ElemInfoTable("DateTimeState", 0x33333333L);
        JDFDevCap.elemInfoTable[3] = new ElemInfoTable("DurationState", 0x33333333L);
        JDFDevCap.elemInfoTable[4] = new ElemInfoTable("EnumerationState", 0x33333333L);
        JDFDevCap.elemInfoTable[5] = new ElemInfoTable("IntegerState", 0x33333333L);
        JDFDevCap.elemInfoTable[6] = new ElemInfoTable("MatrixState", 0x33333333L);
        JDFDevCap.elemInfoTable[7] = new ElemInfoTable("NameState", 0x33333333L);
        JDFDevCap.elemInfoTable[8] = new ElemInfoTable("NumberState", 0x33333333L);
        JDFDevCap.elemInfoTable[9] = new ElemInfoTable("PDFPathState", 0x33333333L);
        JDFDevCap.elemInfoTable[10] = new ElemInfoTable("RectangleState", 0x33333333L);
        JDFDevCap.elemInfoTable[11] = new ElemInfoTable("ShapeState", 0x33333333L);
        JDFDevCap.elemInfoTable[12] = new ElemInfoTable("StringState", 0x33333333L);
        JDFDevCap.elemInfoTable[13] = new ElemInfoTable("XYPairState", 0x33333333L);
        atrInfoTable = new AtrInfoTable[1];
        JDFDevCap.atrInfoTable[0] = new AtrInfoTable("MaxOccurs", 0x33333331L, AttributeInfo.EnumAttributeType.unbounded, null, "1");
    }
}

