/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoModulePool;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFModuleCap;

public class JDFModulePool
extends JDFAutoModulePool {
    private static final long serialVersionUID = 1L;

    public JDFModulePool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFModulePool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFModulePool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFModulePool[  --> " + super.toString() + " ]";
    }

    public JDFDeviceCap.EnumAvailability getMinAvailability(VString vModuleRefs) {
        Map m = this.getModuleMap();
        if (vModuleRefs == null || m == null || vModuleRefs.size() == 0) {
            return null;
        }
        JDFDeviceCap.EnumAvailability minAvail = JDFDeviceCap.EnumAvailability.Installed;
        for (int i = 0; i < vModuleRefs.size(); ++i) {
            JDFModuleCap mc = (JDFModuleCap)m.get(vModuleRefs.stringAt(i));
            if (mc == null) {
                return null;
            }
            JDFDeviceCap.EnumAvailability a = mc.getAvailability();
            if (a == null || JDFDeviceCap.EnumAvailability.Module.equals((Object)a)) {
                return null;
            }
            if (minAvail.compareTo((Object)a) <= 0) continue;
            minAvail = a;
        }
        return minAvail;
    }

    public Map getModuleMap() {
        HashMap<String, JDFModuleCap> hashMap = null;
        VElement v = this.getChildElementVector("ModuleCap", null, null, true, 0, true);
        if (v != null) {
            int siz = v.size();
            hashMap = new HashMap<String, JDFModuleCap>();
            for (int i = 0; i < siz; ++i) {
                JDFModuleCap mc = (JDFModuleCap)v.elementAt(i);
                String id = mc.getID();
                if (JDFModulePool.isWildCard(id)) continue;
                hashMap.put(id, mc);
            }
            hashMap = hashMap.size() == 0 ? null : hashMap;
        }
        return hashMap;
    }

    public static JDFDeviceCap.EnumAvailability getModuleAvailability(ICapabilityElement caps) {
        JDFDeviceCap.EnumAvailability a = caps.getAvailability();
        if (!JDFDeviceCap.EnumAvailability.Module.equals((Object)a)) {
            return a;
        }
        JDFModulePool mp = caps.getModulePool();
        if (mp == null) {
            return null;
        }
        return mp.getMinAvailability(caps.getModuleRefs());
    }

    public static JDFModuleCap appendModuleRef(ICapabilityElement caps, String id) {
        caps.setAvailability(JDFDeviceCap.EnumAvailability.Module);
        JDFModulePool mp = caps.getCreateModulePool();
        ((KElement)((Object)caps)).appendAttribute("ModuleRefs", id, null, null, true);
        return mp.getCreateModuleCap(id);
    }

    public JDFModuleCap getModuleCap(String id) {
        return (JDFModuleCap)this.getChildWithAttribute("ModuleCap", "ID", null, id, 0, true);
    }

    public JDFModuleCap getCreateModuleCap(String id) {
        JDFModuleCap mc = this.getModuleCap(id);
        if (mc == null) {
            mc = this.appendModuleCap();
            mc.setID(id);
        }
        return mc;
    }
}

