/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;

public class ByteArrayIOStream
extends ByteArrayOutputStream {
    private final Log log = LogFactory.getLog(this.getClass());

    public static ByteArrayIOInputStream getBufferedInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayIOInputStream) {
            return ((ByteArrayIOInputStream)is).getNewStream();
        }
        ByteArrayIOStream byteArrayIOStream = new ByteArrayIOStream(is);
        ByteArrayIOInputStream inputStream = byteArrayIOStream.getInputStream();
        byteArrayIOStream.close();
        return inputStream;
    }

    public ByteArrayIOStream() {
    }

    public ByteArrayIOStream(int i) {
        super(i);
    }

    public ByteArrayIOStream(InputStream is) {
        super(1000);
        if (is == null) {
            return;
        }
        if (is instanceof ByteArrayIOInputStream) {
            ByteArrayIOInputStream bis = (ByteArrayIOInputStream)is;
            this.buf = bis.getBuf();
            this.count = bis.getCount();
        } else {
            try {
                int available = is.available();
                if (available > 1000) {
                    this.buf = new byte[available + 1000];
                }
                IOUtils.copy((InputStream)is, (OutputStream)this);
            }
            catch (IOException e) {
                this.log.error((Object)"error copying streams to buffer", (Throwable)e);
            }
        }
    }

    public ByteArrayIOStream(File f) throws IOException {
        super(10);
        BufferedInputStream fis;
        if (f != null && f.length() > 10L) {
            this.buf = new byte[(int)f.length() + 100];
        }
        if ((fis = FileUtil.getBufferedInputStream(f)) != null) {
            IOUtils.copy((InputStream)fis, (OutputStream)this);
            ((InputStream)fis).close();
        } else {
            this.log.warn((Object)("cannot create buffered stream for: " + f));
        }
    }

    public ByteArrayIOStream(byte[] b) {
        this.buf = b;
        this.count = b.length;
    }

    public ByteArrayIOInputStream getInputStream() {
        ByteArrayIOInputStream is = new ByteArrayIOInputStream(this.buf, this.count);
        return is;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    @Override
    public synchronized String toString() {
        return "ByteArrayIOStream:\n" + new String(this.buf, 0, this.count);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class ByteArrayIOInputStream
    extends ByteArrayInputStream {
        ByteArrayIOInputStream(byte[] buf, int count) {
            super(buf, 0, count);
        }

        public ByteArrayIOInputStream getNewStream() {
            return new ByteArrayIOInputStream(this.buf, this.count);
        }

        public synchronized String toString() {
            return "ByteArrayIOInputStream:\n" + new String(this.buf, 0, this.count);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

