/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlUtil;

public class FileUtil {
    public static File[] listFilesWithExtension(File dir, String extension) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new ExtensionFileFilter(extension));
        return files == null || files.length == 0 ? null : files;
    }

    public static File[] listFilesWithExpression(File dir, String expression) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new ExpressionFileFilter(expression));
        return files == null || files.length == 0 ? null : files;
    }

    public static Vector<File> listFilesInTree(File dir, FileFilter filter) {
        Vector v = null;
        if (dir == null || filter == null) {
            return null;
        }
        File[] f = dir.listFiles(filter);
        v = ContainerUtil.toVector(f);
        File[] dirs = FileUtil.listDirectories(dir);
        if (dirs != null) {
            for (File d : dirs) {
                Vector<File> v2 = FileUtil.listFilesInTree(d, filter);
                v = (Vector)ContainerUtil.addAll(v, v2);
            }
        }
        return v;
    }

    public static Vector<File> listFilesInTree(File dir, String expression) {
        Vector<File> v = null;
        if (dir == null || expression == null) {
            return null;
        }
        int posSlash = expression.indexOf(47);
        if (posSlash < 0) {
            File[] f = FileUtil.listFilesWithExpression(dir, expression);
            v = ContainerUtil.toVector(f);
            File[] dirs = FileUtil.listDirectories(dir);
            if (dirs != null) {
                for (File d : dirs) {
                    Vector<File> v2 = FileUtil.listFilesInTree(d, expression);
                    v = (Vector)ContainerUtil.addAll(v, v2);
                }
            }
        } else {
            String nextDir = expression.substring(0, posSlash);
            File[] files = FileUtil.listFilesWithExpression(dir, nextDir);
            if (files != null) {
                v = new Vector();
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    v.add(file);
                }
                if (v.size() == 0) {
                    v = null;
                }
                if (posSlash + 1 != expression.length() && v != null) {
                    Vector<File> ret = new Vector<File>();
                    String next = expression.substring(posSlash + 1);
                    for (int i = 0; i < v.size(); ++i) {
                        Vector<File> v2 = FileUtil.listFilesInTree(v.get(i), next);
                        if (v2 == null) continue;
                        ret.addAll(v2);
                    }
                    v = ret.size() == 0 ? null : ret;
                }
            }
        }
        return v;
    }

    public static File[] listDirectories(File dir) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles(new DirectoryFileFilter());
        return files == null || files.length == 0 ? null : files;
    }

    public static boolean deleteAll(File dirToZapp) {
        File[] ff;
        if (dirToZapp == null) {
            return false;
        }
        boolean b = true;
        if (dirToZapp.isDirectory() && (ff = dirToZapp.listFiles()) != null) {
            int siz = ff.length;
            for (int i = 0; i < siz; ++i) {
                b = FileUtil.deleteAll(ff[i]) && b;
            }
        }
        return dirToZapp.delete() && b;
    }

    public static File streamToFile(InputStream fis, String fileName) {
        if (fis == null) {
            return null;
        }
        File tmp = UrlUtil.urlToFile(fileName);
        if (tmp == null) {
            return null;
        }
        return FileUtil.streamToFile(fis, tmp);
    }

    public static File writeFile(IStreamWriter w, File file) {
        boolean b = FileUtil.createNewFile(file);
        if (!b) {
            return null;
        }
        try {
            BufferedOutputStream fos = FileUtil.getBufferedOutputStream(file);
            if (fos == null) {
                return null;
            }
            w.writeStream(fos);
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    public static File newExtension(File f, String newExt) {
        if (f == null) {
            return null;
        }
        return new File(UrlUtil.newExtension(f.getPath(), newExt));
    }

    public static File streamToFile(InputStream fis, File fil) {
        if (fis == null) {
            return null;
        }
        FileUtil.createNewFile(fil);
        try {
            BufferedOutputStream fos = FileUtil.getBufferedOutputStream(fil);
            if (fos == null) {
                return null;
            }
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
            fis.close();
        }
        catch (IOException x) {
            return null;
        }
        return fil;
    }

    public static byte[] fileToByteArray(File file) {
        if (file == null || !file.canRead()) {
            return null;
        }
        try {
            int len = (int)file.length();
            if (len <= 0) {
                return null;
            }
            BufferedInputStream fis = FileUtil.getBufferedInputStream(file);
            byte[] b = new byte[len];
            int l = ((InputStream)fis).read(b);
            ((InputStream)fis).close();
            fis = null;
            if (l != len) {
                if (l == 0) {
                    return null;
                }
                byte[] b2 = new byte[l];
                for (int i = 0; i < l; ++i) {
                    b2[i] = b[i];
                }
                b = b2;
            }
            return b;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static File moveFileToDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        return (b = FileUtil.moveFile(fromFile, newFile = FileUtil.getFileInDirectory(toDir, new File(fromFile.getName())))) ? newFile : null;
    }

    public static boolean moveFile(File fromFile, File toFile) {
        if (fromFile.equals(toFile)) {
            return true;
        }
        if (fromFile.renameTo(toFile)) {
            return true;
        }
        if (!FileUtil.copyFile(fromFile, toFile)) {
            return false;
        }
        return fromFile.delete();
    }

    public static boolean copyBytes(byte[] buf, File toFile) {
        if (buf == null || toFile == null) {
            return false;
        }
        if (!toFile.canWrite()) {
            FileUtil.createNewFile(toFile);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(toFile, true);
            fileOutputStream.write(buf);
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean copyFile(File fromFile, File toFile) {
        if (fromFile == null || toFile == null || fromFile.equals(toFile)) {
            return false;
        }
        try {
            return FileUtil.streamToFile((InputStream)new FileInputStream(fromFile), toFile) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static File ensureFileInDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        if (!(b = (newFile = FileUtil.getFileInDirectory(toDir, new File(fromFile.getName()))).canRead())) {
            b = FileUtil.copyFile(fromFile, newFile);
        }
        return b ? newFile : null;
    }

    public static File cleanDots(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (File.separator != "/") {
            path = StringUtil.replaceString(path, File.separator, "/");
            path = UrlUtil.cleanDots(path);
            path = StringUtil.replaceString(path, "/", File.separator);
        } else {
            path = UrlUtil.cleanDots(path);
        }
        return new File(path);
    }

    public static File copyFileToDir(File fromFile, File toDir) {
        File newFile;
        boolean b;
        if (fromFile == null || toDir == null) {
            return null;
        }
        if (!toDir.isDirectory()) {
            toDir.mkdirs();
        }
        return (b = FileUtil.copyFile(fromFile, newFile = FileUtil.getFileInDirectory(toDir, new File(fromFile.getName())))) ? newFile : null;
    }

    public static File getFileInDirectory(File dir, File localFile) {
        if (dir == null) {
            return localFile;
        }
        if (localFile == null) {
            return null;
        }
        String fullPath = dir.getPath() + File.separator + localFile.getPath();
        File fullFile = new File(fullPath);
        return FileUtil.cleanDots(fullFile);
    }

    public static boolean forceDelete(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        boolean bOK = file.delete();
        int i = 1;
        while (!bOK) {
            boolean bInterupt = !ThreadUtil.sleep(i * i * 100);
            bOK = file.delete();
            if (!bInterupt && i++ <= 6) continue;
            LogFactory.getLog(FileUtil.class).warn((Object)("cannot force delete of file: " + file.getAbsolutePath()));
            break;
        }
        return bOK;
    }

    public static File getCreateDirectory(String newDir) {
        File f = UrlUtil.urlToFile(newDir);
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            return null;
        }
        return f;
    }

    public static File cleanURL(File f) {
        String s = UrlUtil.fileToUrl(f, false);
        return UrlUtil.urlToFile(s);
    }

    public static boolean isDirectory(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        try {
            File canonical = f.getCanonicalFile();
            return canonical.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isDirectory(String s) {
        return FileUtil.isDirectory(UrlUtil.urlToFile(s));
    }

    public static boolean isAbsoluteFile(File f) {
        String s = f == null ? null : f.getPath();
        return FileUtil.isAbsoluteFile(s);
    }

    public static boolean isAbsoluteFile(String f) {
        if (f == null) {
            return false;
        }
        if (f.startsWith(File.separator)) {
            return true;
        }
        File[] roots = File.listRoots();
        if (roots != null) {
            f = f.toLowerCase();
            for (int i = 0; i < roots.length; ++i) {
                if (!f.startsWith(roots[i].getPath().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        return file == null ? null : UrlUtil.extension(file.getName());
    }

    public static boolean createNewFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            return file.createNewFile();
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean equals(File file1, File file2) {
        return ContainerUtil.equals(file1, file2);
    }

    public static BufferedInputStream getBufferedInputStream(File file) {
        FileInputStream fis;
        if (file == null) {
            LogFactory.getLog(FileUtil.class).warn((Object)"extracting stream from null file");
            return null;
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException x) {
            LogFactory.getLog(FileUtil.class).warn((Object)("extracting stream from non-existing file: " + file.getAbsolutePath()), (Throwable)x);
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        return bis;
    }

    public static BufferedOutputStream getBufferedOutputStream(File file) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException x) {
            return null;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        return bos;
    }

    public static BufferedOutputStream getBufferedOutputStream(File file, boolean append) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException x) {
            return null;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        return bos;
    }

    public static boolean isWindows() {
        return File.separator.equals("\\");
    }

    protected static class ExpressionFileFilter
    implements FileFilter {
        private final String regExp;

        public ExpressionFileFilter(String _regExp) {
            this.regExp = StringUtil.simpleRegExptoRegExp(_regExp);
        }

        @Override
        public boolean accept(File checkFile) {
            return checkFile != null && StringUtil.matchesSimple(checkFile.getName(), this.regExp);
        }
    }

    protected static class DirectoryFileFilter
    implements FileFilter {
        protected DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File checkFile) {
            return checkFile != null && checkFile.isDirectory();
        }
    }

    public static class ExtensionFileFilter
    implements FileFilter {
        private Set<String> m_extension;

        protected ExtensionFileFilter(String fileExtension) {
            if (fileExtension != null) {
                VString list = StringUtil.tokenize(fileExtension, ",", false);
                this.m_extension = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String st = list.stringAt(i);
                    if (st.startsWith(".")) {
                        st = st.substring(1);
                    }
                    st = st.toLowerCase();
                    this.m_extension.add(st);
                }
            }
        }

        protected ExtensionFileFilter(VString fileExtensionVector) {
            if (fileExtensionVector != null) {
                this.m_extension = new HashSet<String>();
                for (String st : fileExtensionVector) {
                    if (st.startsWith(".")) {
                        st = st.substring(1);
                    }
                    st = st.toLowerCase();
                    this.m_extension.add(st);
                }
            }
        }

        @Override
        public boolean accept(File checkFile) {
            if (checkFile == null || !checkFile.isFile()) {
                return false;
            }
            if (this.m_extension == null) {
                return true;
            }
            String xt = UrlUtil.extension(checkFile.getPath());
            xt = xt == null ? "" : xt.toLowerCase();
            return this.m_extension.contains(xt);
        }
    }
}

