/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.auto.JDFAutoNotification;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFPartStatus;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFSpawned;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.pool.JDFStatusPool;
import org.cip4.jdflib.resource.JDFMerged;
import org.cip4.jdflib.resource.JDFNotification;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFMerge {
    private JDFSpawned spawnAudit = null;
    private final JDFNode m_ParentNode;
    private JDFNode subJDFNode;
    private Set<String> vsRO;
    private Set<String> vsRW;
    private String spawnID = null;
    private final VString previousMergeIDs = new VString();
    private boolean bSnafu = true;
    private JDFNode overWriteNode;
    private HashMap<String, JDFSpawned> newSpawnMap = null;
    private String urlMerge = null;
    private final Log log;
    public boolean bUpdateStati = false;
    public boolean bAddMergeToProcessRun = false;
    private JDFNode.EnumCleanUpMerge cleanPolicy;
    private JDFResource.EnumAmountMerge amountPolicy;
    private VJDFAttributeMap parts;

    public JDFMerge(JDFNode parentNode) {
        this.m_ParentNode = parentNode;
        this.parts = null;
        this.cleanPolicy = JDFNode.EnumCleanUpMerge.None;
        this.amountPolicy = JDFResource.EnumAmountMerge.None;
        this.log = LogFactory.getLog(this.getClass());
    }

    public JDFNode mergeJDF(JDFNode _toMerge, String urlMerge, JDFNode.EnumCleanUpMerge cleanPolicy, JDFResource.EnumAmountMerge amountPolicy) {
        this.urlMerge = urlMerge;
        this.cleanPolicy = cleanPolicy;
        this.amountPolicy = amountPolicy;
        return this.mergeJDF(_toMerge);
    }

    public synchronized JDFNode mergeJDF(JDFNode _toMerge) {
        this.subJDFNode = _toMerge;
        if (this.subJDFNode == null || !this.subJDFNode.hasParent(this.m_ParentNode)) {
            throw new JDFException("JDFNode.MergeJDF no matching parent found");
        }
        this.findOverwriteNode();
        this.analyzeAncestorPool(true);
        this.vsRO = this.spawnAudit.getrRefsROCopied().getSet();
        this.vsRW = this.spawnAudit.getrRefsRWCopied().getSet();
        String preSpawn = this.mergeCheckPrespawn();
        this.mergeLocalLinks();
        this.cleanROResources();
        this.mergeRWResources();
        this.mergeLocalNodes();
        JDFMerged mergeAudit = this.mergeMainPools(preSpawn);
        if (this.spawnID != null) {
            JDFNode overWriteParent = mergeAudit.getParentJDF();
            this.cleanUpMerge(overWriteParent);
        }
        this.overWriteNode = (JDFNode)this.overWriteNode.replaceElement(this.subJDFNode);
        this.overWriteNode.eraseEmptyNodes(true);
        if (this.bUpdateStati) {
            this.overWriteNode.updatePartStatus(this.parts, true, true, 0);
        }
        return this.overWriteNode;
    }

    public synchronized JDFNode remergeJDF(JDFNode _toMerge) {
        try {
            return this.mergeJDF(_toMerge);
        }
        catch (JDFException x) {
            this.log.error((Object)"Snafu merging - trying default merge", (Throwable)x);
            this.subJDFNode = _toMerge;
            if (this.subJDFNode == null || !this.subJDFNode.hasParent(this.m_ParentNode)) {
                throw new JDFException("JDFNode.remergeJDF no matching parent found");
            }
            this.findOverwriteNode();
            this.analyzeAncestorPool(false);
            this.mergeLocalLinks();
            this.remergeAuditPools();
            JDFNode overwriteParent = this.parts == null ? this.overWriteNode.getParentJDF() : this.overWriteNode;
            JDFAuditPool ap = overwriteParent.getCreateAuditPool();
            if (!JDFNode.EnumCleanUpMerge.RemoveAll.equals((Object)this.cleanPolicy)) {
                this.createMergeAudit(ap, null);
            }
            if (this.bUpdateStati) {
                this.overWriteNode.updatePartStatus(this.parts, true, true, 0);
            }
            return this.overWriteNode;
        }
    }

    protected void remergeAuditPools() {
        VElement vn = this.overWriteNode.getvJDFNode(null, null, false);
        int size = vn.size();
        for (int nod = 0; nod < size; ++nod) {
            JDFNode toMergeLocalNode = (JDFNode)vn.elementAt(nod);
            JDFNode overwriteLocalNode = this.subJDFNode.getChildJDFNode(toMergeLocalNode.getID(), false);
            this.mergeAuditPool(overwriteLocalNode, toMergeLocalNode, true);
        }
    }

    private void findOverwriteNode() {
        String subJDFID = this.subJDFNode.getID();
        this.overWriteNode = (JDFNode)this.m_ParentNode.getTarget(subJDFID, "ID");
        if (this.overWriteNode == null) {
            throw new JDFException("JDFNode.MergeJDF no Node with ID: " + subJDFID);
        }
    }

    private void analyzeAncestorPool(boolean bFindSpawnAudit) {
        String subJDFID = this.subJDFNode.getID();
        JDFAncestorPool ancestorPool = this.subJDFNode.getAncestorPool();
        if (ancestorPool == null) {
            throw new JDFException("JDFNode.MergeJDF no Ancestor Pool in Node: " + subJDFID);
        }
        this.parts = ancestorPool.getPartMapVector();
        if (bFindSpawnAudit) {
            this.findSpawnAudit();
        }
    }

    protected void findSpawnAudit() {
        String idParent;
        KElement k;
        String subJDFID = this.subJDFNode.getID();
        JDFAncestorPool ancestorPool = this.subJDFNode.getAncestorPool();
        int numAncestors = ancestorPool.numChildElements("Ancestor", null);
        if (numAncestors <= 0) {
            throw new JDFException("JDFNode.MergeJDF no Ancestors in AncestorPool found. Node: " + subJDFID);
        }
        int iFound = 0;
        for (int whereToLook = 1; whereToLook <= numAncestors && (k = this.m_ParentNode.getTarget(idParent = ancestorPool.getAncestor(numAncestors - whereToLook).getNodeID(), "ID")) != null; ++whereToLook) {
            JDFNode nodeInParent = (JDFNode)k;
            JDFAuditPool auditPool = nodeInParent.getCreateAuditPool();
            VElement vMergeAudit = auditPool.getAudits(JDFAudit.EnumAuditType.Merged, null, null);
            for (int nMerged = 0; nMerged < vMergeAudit.size(); ++nMerged) {
                JDFMerged merged = (JDFMerged)vMergeAudit.elementAt(nMerged);
                this.previousMergeIDs.appendUnique(merged.getMergeID());
            }
            if (iFound != 0) continue;
            VElement vSpawnAudit = auditPool.getChildrenByTagName("Spawned", null, new JDFAttributeMap("jRef", subJDFID), true, true, 0);
            this.spawnID = this.subJDFNode.getSpawnID(false);
            for (int isp = vSpawnAudit.size() - 1; isp >= 0; --isp) {
                JDFSpawned testSpawn = (JDFSpawned)vSpawnAudit.elementAt(isp);
                String newSpawnID = testSpawn.getNewSpawnID();
                if (newSpawnID == null || !newSpawnID.equals(this.spawnID)) continue;
                this.spawnAudit = testSpawn;
                JDFMerged matchingMerged = (JDFMerged)auditPool.getChildWithAttribute("Merged", "MergeID", null, this.spawnID, 0, true);
                if (matchingMerged == null) break;
                throw new JDFException("JDFNode.MergeJDF Spawn Audit already merged, SpawnID: " + this.spawnID, 10001);
            }
            if (this.spawnAudit == null) continue;
            iFound = whereToLook;
        }
        boolean bl = this.bSnafu = iFound != 1;
        if (this.spawnAudit == null) {
            throw new JDFException("JDFNode.MergeJDF no matching Spawn Audit, SpawnID: " + this.spawnID);
        }
    }

    private void mergeAuditPool(JDFNode _overWriteNode, JDFNode toMerge, boolean remerge) {
        JDFAuditPool overWriteAuditPool = _overWriteNode.getAuditPool();
        JDFAuditPool toMergeAuditPool = toMerge.getAuditPool();
        if (overWriteAuditPool != null) {
            if (toMergeAuditPool == null) {
                toMerge.copyElement(overWriteAuditPool, null);
            } else if (remerge) {
                toMergeAuditPool.appendUnique(overWriteAuditPool);
            } else {
                overWriteAuditPool.appendUnique(toMergeAuditPool);
                toMergeAuditPool.replaceElement(overWriteAuditPool);
            }
        }
    }

    private String mergeCheckPrespawn() {
        String preSpawn = this.spawnAudit.getSpawnID();
        while (preSpawn != null && !preSpawn.equals("")) {
            JDFMerged preMerge = (JDFMerged)this.m_ParentNode.getTarget(preSpawn, "MergeID");
            if (preMerge != null) {
                JDFSpawned preSpawnAudit = (JDFSpawned)this.m_ParentNode.getTarget(preSpawn, "NewSpawnID");
                this.vsRO.addAll(preSpawnAudit.getrRefsROCopied());
                this.vsRW.addAll(preSpawnAudit.getrRefsRWCopied());
                preSpawn = preSpawnAudit.getSpawnID();
                continue;
            }
            this.subJDFNode.setSpawnID(preSpawn);
            break;
        }
        return preSpawn;
    }

    private void mergeComments(JDFNode poverWriteNode, JDFNode toMerge) {
        VElement v = poverWriteNode.getChildElementVector("Comment", null, null, false, 0, false);
        VElement vToMerge = toMerge.getChildElementVector("Comment", null, null, false, 0, false);
        int siz = vToMerge.size();
        vToMerge.appendUniqueElement(v);
        for (int i = siz; i < vToMerge.size(); ++i) {
            toMerge.moveElement(vToMerge.elementAt(i), null);
        }
    }

    private void mergeLocalLinks() {
        int numParts = this.parts == null ? 0 : this.parts.size();
        VElement vn = this.overWriteNode.getvJDFNode(null, null, false);
        int size = vn.size();
        for (int nod = 0; nod < size; ++nod) {
            JDFElement.EnumNodeStatus stat;
            JDFNode overwriteLocalNode = (JDFNode)vn.elementAt(nod);
            JDFNode toMergeLocalNode = this.subJDFNode.getChildJDFNode(overwriteLocalNode.getID(), false);
            this.mergeResourceLinkPool(overwriteLocalNode, toMergeLocalNode);
            JDFElement.EnumVersion version = toMergeLocalNode.getVersion(true);
            if (version == null || version.getValue() < JDFElement.EnumVersion.Version_1_3.getValue() || (stat = toMergeLocalNode.getStatus()) == null || stat.equals((Object)JDFElement.EnumNodeStatus.Part) || stat.equals((Object)JDFElement.EnumNodeStatus.Pool) || numParts <= 0) continue;
            toMergeLocalNode.setPartStatus(this.parts, stat, null);
        }
    }

    private void mergeLocalNodes() {
        VElement vn = this.overWriteNode.getvJDFNode(null, null, false);
        for (int nod = 0; nod < vn.size(); ++nod) {
            JDFNode overwriteLocalNode = (JDFNode)vn.elementAt(nod);
            this.mergeLocalNode(overwriteLocalNode);
        }
    }

    private void mergeLocalNode(JDFNode overwriteLocalNode) {
        JDFNode toMergeLocalNode = (JDFNode)this.subJDFNode.getTarget(overwriteLocalNode.getID(), "ID");
        this.mergeLocalResourcePool(overwriteLocalNode, toMergeLocalNode);
        VElement localChildren = overwriteLocalNode.getChildElementVector(null, null, null, true, 0, false);
        int siz = localChildren.size();
        for (int i = 0; i < siz; ++i) {
            KElement e = localChildren.elementAt(i);
            String nodeName = e.getLocalName();
            if (nodeName.endsWith("Pool")) {
                if (nodeName.equals("ResourceLinkPool") || nodeName.equals("ResourcePool")) continue;
                if (nodeName.equals("AuditPool")) {
                    this.mergeAuditPool(overwriteLocalNode, toMergeLocalNode, false);
                    continue;
                }
                if (nodeName.equals("StatusPool")) {
                    this.mergeStatusPool(overwriteLocalNode, toMergeLocalNode, this.parts);
                    continue;
                }
                if (nodeName.equals("AncestorPool")) continue;
            }
            if (nodeName.equals("JDF")) continue;
            if (nodeName == "Comment") {
                this.mergeComments(overwriteLocalNode, toMergeLocalNode);
                continue;
            }
            toMergeLocalNode.removeChildren(nodeName, null, null);
            toMergeLocalNode.moveElement(e, null);
            for (int j = i + 1; j < siz; ++j) {
                JDFElement localChild = (JDFElement)localChildren.elementAt(j);
                if (localChild == null || !localChild.getNodeName().equals(nodeName)) continue;
                toMergeLocalNode.moveElement(localChild, null);
                localChildren.set(j, null);
            }
        }
    }

    protected void mergeLocalResourcePool(JDFNode overwriteLocalNode, JDFNode toMergeLocalNode) {
        JDFResourcePool poolOverWrite = overwriteLocalNode.getResourcePool();
        JDFResourcePool poolToMerge = toMergeLocalNode.getResourcePool();
        if (poolOverWrite != null) {
            VElement resOverWrite = poolOverWrite.getPoolChildren(null, null, null);
            int size = resOverWrite.size();
            for (int i = 0; i < size; ++i) {
                JDFResource res1 = (JDFResource)resOverWrite.elementAt(i);
                this.mergeLocalResource(this.amountPolicy, poolToMerge, res1);
            }
        }
    }

    public static JDFResource mergePartition(JDFResource targetRes, JDFResource resToMerge, String spawnID, JDFResource.EnumAmountMerge amountPolicy, boolean bLocalResource) {
        if (resToMerge == null) {
            return null;
        }
        if (!targetRes.getID().equals(resToMerge.getID())) {
            throw new JDFException("JDFResource.mergePartition  merging incompatible resources ID=" + targetRes.getID() + " IDMerge=" + resToMerge.getID());
        }
        JDFResource toMerge = resToMerge;
        JDFResource root = targetRes.getResourceRoot();
        VString partIDKeys = root.getPartIDKeys();
        VString mergeIDKeys = toMerge.getPartIDKeys();
        VElement allChildren = resToMerge.getNodesWithSpawnID(spawnID);
        if (allChildren.isEmpty()) {
            allChildren.addElement(toMerge);
        }
        boolean bTargetGone = false;
        for (int i = 0; i < allChildren.size(); ++i) {
            JDFResource src = (JDFResource)allChildren.elementAt(i);
            if (src.getIdentical() != null) continue;
            JDFAttributeMap srcMap = src.getPartMap(mergeIDKeys);
            JDFResource trg = targetRes.getPartition(srcMap, JDFResource.EnumPartUsage.Implicit);
            if (trg == null) {
                trg = targetRes;
            }
            JDFAttributeMap trgMap = trg.getPartMap();
            if (!src.getLocked() && trgMap.getKeys().size() < srcMap.getKeys().size()) {
                LogFactory.getLog(JDFMerge.class).warn((Object)(targetRes.getLocalName() + " ID=" + targetRes.getID() + " - creating non existing rw partition: " + srcMap));
                trg = targetRes.getCreatePartition(srcMap, partIDKeys);
                trg.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRW);
                trgMap = trg.getPartMap();
            }
            if (bLocalResource || trg.getSpawnStatus() == JDFResource.EnumSpawnStatus.SpawnedRW) {
                if (srcMap.equals(trgMap)) {
                    if (trgMap.isEmpty()) {
                        bTargetGone = true;
                        trg = (JDFResource)targetRes.replaceElement(src);
                        root = trg.getResourceRoot();
                    } else {
                        KElement copyElement = targetRes.copyElement(src, null);
                        trg = (JDFResource)trg.replaceElement(copyElement);
                    }
                } else if (srcMap.subMap(trgMap)) {
                    if (trgMap.size() + 1 != srcMap.size()) {
                        throw new JDFException("JDFResource.mergePartition attempting to merge incompatible sub-partitions in: " + trg.getID());
                    }
                    trg.copyElement(src, null);
                } else {
                    throw new JDFException("JDFResource.mergePartition attempting to merge incompatible partitions in: " + trg.getID());
                }
            }
            if (amountPolicy == JDFResource.EnumAmountMerge.None || !targetRes.isPhysical()) continue;
            JDFResource trgKeep = trg;
            trg = root.getPartition(srcMap, JDFResource.EnumPartUsage.Implicit);
            if (trg == null) {
                trg = trgKeep;
            }
            VElement vr = trg.getLeaves(true);
            for (int l = 0; l < vr.size(); ++l) {
                JDFResource r = (JDFResource)vr.elementAt(l);
                r.updateAmounts(JDFResource.EnumAmountMerge.UpdateLink.equals((Object)amountPolicy));
            }
        }
        if (!bTargetGone) {
            toMerge.deleteNode();
        }
        partIDKeys.appendUnique(mergeIDKeys);
        if (partIDKeys.isEmpty()) {
            root.removeAttribute("PartIDKeys");
        } else {
            root.setPartIDKeys(partIDKeys);
        }
        return root;
    }

    private void mergeLocalResource(JDFResource.EnumAmountMerge amountPolicy, JDFResourcePool poolToMerge, JDFResource res1) {
        String resID = res1.getID();
        JDFResource res2 = poolToMerge.getResourceByID(resID);
        if (res2 != null) {
            this.mergeSpawnIDs(res2, res1, false);
            res1 = JDFMerge.mergePartition(res1, res2, this.spawnID, amountPolicy, true);
        }
        poolToMerge.copyElement(res1, null);
        res1 = poolToMerge.getResourceByID(resID);
        VElement resLeafsSpawned = res1.getNodesWithSpawnID(this.spawnID);
        for (int leaf = 0; leaf < resLeafsSpawned.size(); ++leaf) {
            JDFResource leafRes = (JDFResource)resLeafsSpawned.elementAt(leaf);
            leafRes.removeFromSpawnIDs(this.spawnID);
            VString spawnIDs = leafRes.getSpawnIDs(false);
            if (spawnIDs != null) {
                spawnIDs.removeAll(this.previousMergeIDs);
            }
            leafRes.setSpawnIDs(spawnIDs);
            this.calcSpawnStatus(leafRes, true);
        }
    }

    private void calcSpawnStatus(JDFResource leafRes, boolean bLocal) {
        if (leafRes == null) {
            return;
        }
        this.prepareNewSpawnMap();
        VString spawnIDs = leafRes.getSpawnIDs(false);
        String resID = leafRes.getID();
        if (spawnIDs == null || spawnIDs.isEmpty()) {
            this.removeSpawnAttributes(leafRes);
            return;
        }
        if (bLocal || this.vsRW.contains(resID)) {
            boolean bWrite = bLocal;
            for (int i = 0; i < spawnIDs.size(); ++i) {
                String resSpawnID = spawnIDs.stringAt(i);
                JDFSpawned spawnedAudit = this.newSpawnMap.get(resSpawnID);
                if (spawnedAudit != null) {
                    VString rw = spawnedAudit.getrRefsRWCopied();
                    if (rw == null || !rw.contains(resID)) continue;
                    bWrite = true;
                    continue;
                }
                String mainSpawnID = leafRes.getJDFRoot().getSpawnID(true);
                if (!KElement.isWildCard(mainSpawnID)) continue;
                leafRes.removeFromAttribute("SpawnIDs", resSpawnID, null, null, -1);
                String spawnIDsNew = leafRes.getAttribute_KElement("SpawnIDs", null, null);
                if (StringUtil.getNonEmpty(spawnIDsNew) != null) continue;
                this.removeSpawnAttributes(leafRes);
                return;
            }
            if (bWrite) {
                leafRes.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRW);
                leafRes.setLocked(true);
            } else {
                leafRes.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRO);
                leafRes.setLocked(false);
            }
        }
    }

    private void removeSpawnAttributes(JDFResource leafRes) {
        leafRes.removeAttribute("SpawnIDs");
        leafRes.removeAttribute("SpawnStatus");
        leafRes.removeAttribute("Locked");
    }

    private void prepareNewSpawnMap() {
        if (this.newSpawnMap != null) {
            return;
        }
        this.newSpawnMap = new HashMap();
        JDFNode[] array = new JDFNode[]{this.subJDFNode, this.m_ParentNode};
        for (JDFNode nParent : array) {
            VElement v = nParent.getvJDFNode(null, null, false);
            for (int i = 0; i < v.size(); ++i) {
                VElement v2;
                JDFNode n = (JDFNode)v.get(i);
                JDFAuditPool ap = n.getAuditPool();
                VElement vElement = v2 = ap == null ? null : ap.getAudits(JDFAudit.EnumAuditType.Spawned, null, null);
                if (v2 == null) continue;
                int siz = v2.size();
                for (int j = 0; j < siz; ++j) {
                    JDFSpawned s = (JDFSpawned)v2.get(j);
                    String nsID = s.getNewSpawnID();
                    if (KElement.isWildCard(nsID)) continue;
                    this.newSpawnMap.put(nsID, s);
                }
            }
        }
    }

    private JDFMerged mergeMainPools(String preSpawn) {
        JDFNode overWriteParent = null;
        JDFAuditPool ap = this.subJDFNode.getAuditPool();
        JDFSpawned spawnedAudit = null;
        if (ap != null) {
            spawnedAudit = (JDFSpawned)ap.getChildWithAttribute("Spawned", "NewSpawnID", null, this.spawnID, 0, true);
            overWriteParent = this.overWriteNode;
        }
        if (spawnedAudit == null) {
            overWriteParent = this.overWriteNode.getParentJDF();
            if (overWriteParent == null) {
                throw new JDFException("mergeMainPools - corrupt audit structure");
            }
            ap = overWriteParent.getAuditPool();
            if (ap != null) {
                spawnedAudit = (JDFSpawned)ap.getChildWithAttribute("Spawned", "NewSpawnID", null, this.spawnID, 0, true);
            }
        }
        if (spawnedAudit == null || overWriteParent == null || ap == null) {
            throw new JDFException("mergeMainPools - corrupt audit structure; no Spawn Audit found");
        }
        VString vs = new VString();
        Iterator<String> it = this.vsRW.iterator();
        while (it.hasNext()) {
            vs.add(it.next());
        }
        JDFMerged mergeAudit = this.createMergeAudit(ap, vs);
        if (this.bSnafu) {
            JDFNotification notification = ap.addNotification(JDFAutoNotification.EnumClass.Error, "JDFNode.MergeJDF ", this.parts);
            notification.setType("Error");
            notification.appendComment().appendText("The Ancestor list was incorrectly ordered for merging in the spawned JDF");
        }
        this.subJDFNode.removeChild("AncestorPool", null, 0);
        if (this.parts != null && this.parts.size() >= 1) {
            this.mergeStatusPool(this.overWriteNode, this.subJDFNode, this.parts);
            JDFAncestorPool ancPool = overWriteParent.getAncestorPool();
            if (ancPool != null) {
                this.subJDFNode.copyElement(ancPool, null);
            }
        }
        String jid = overWriteParent.getJobID(true);
        if (this.subJDFNode.getAttribute("JobID", null, "").equals(jid)) {
            this.subJDFNode.removeAttribute("JobID", null);
        }
        if (preSpawn == null || preSpawn.equals("")) {
            this.subJDFNode.removeAttribute("SpawnID", null);
            mergeAudit.removeAttribute("SpawnID", null);
        } else {
            this.subJDFNode.setSpawnID(preSpawn);
        }
        return mergeAudit;
    }

    private JDFMerged createMergeAudit(JDFAuditPool ap, VString vs) {
        JDFMerged lastMerged = (JDFMerged)ap.getAudit(-1, JDFAudit.EnumAuditType.Merged, new JDFAttributeMap("MergeID", this.spawnID), null);
        JDFMerged mergeAudit = ap.addMerged(this.subJDFNode, vs, null, this.parts);
        mergeAudit.setRef(lastMerged);
        if (this.urlMerge != null && !this.urlMerge.equals("")) {
            String url = this.urlMerge;
            if (url.indexOf("://") == -1) {
                url = "File://" + url;
            }
            mergeAudit.setURL(url);
        }
        mergeAudit.setMergeID(this.spawnID);
        return mergeAudit;
    }

    private void mergeResourceLinkPool(JDFNode mainNode, JDFNode toMerge) {
        JDFResourceLinkPool resourceLinkPool = toMerge.getResourceLinkPool();
        this.expandLinkedResources(resourceLinkPool);
        JDFResourceLinkPool toMergeRLP = resourceLinkPool;
        if (toMergeRLP == null) {
            return;
        }
        JDFResourceLinkPool overWriteRLP = mainNode.getCreateResourceLinkPool();
        if (this.parts != null && !this.parts.isEmpty()) {
            VElement overWriteLinks = overWriteRLP.getPoolChildren(null, null, null);
            VElement toMergeLinks = toMergeRLP.getPoolChildren(null, null, null);
            if (toMergeLinks != null && overWriteLinks != null) {
                for (int rl = 0; rl < toMergeLinks.size(); ++rl) {
                    KElement overWriteLink = null;
                    JDFResourceLink toMergeLink = (JDFResourceLink)toMergeLinks.elementAt(rl);
                    String rRef = toMergeLink.getAttribute("rRef");
                    for (int k = 0; k < overWriteLinks.size(); ++k) {
                        if (!((JDFResourceLink)overWriteLinks.elementAt(k)).getAttribute("rRef").equals(rRef)) continue;
                        overWriteLink = (JDFResourceLink)overWriteLinks.elementAt(k);
                        overWriteLinks.remove(overWriteLinks.elementAt(k));
                        break;
                    }
                    if (overWriteLink != null) {
                        if (toMergeLink.hasChildElement("Part", null)) {
                            this.fixPartAmountAttributes((JDFResourceLink)overWriteLink, toMergeLink);
                            continue;
                        }
                        overWriteLink.replaceElement(toMergeLink);
                        continue;
                    }
                    toMergeLink.setPartMapVector(null);
                    overWriteRLP.copyElement(toMergeLink, null);
                }
            }
            toMergeRLP.deleteNode();
            toMerge.copyElement(overWriteRLP, null);
        } else {
            overWriteRLP.deleteNode();
            mainNode.copyElement(toMergeRLP, null);
        }
    }

    private void fixPartAmountAttributes(JDFResourceLink mainLink, JDFResourceLink subLink) {
        JDFAmountPool subAmountPool = subLink.getAmountPool();
        VJDFAttributeMap subLinkParts = subLink.getPartMapVector();
        int partSize = subLinkParts.size();
        for (int i = 0; i < partSize; ++i) {
            VElement vSubPartAmounts = null;
            if (subAmountPool != null) {
                vSubPartAmounts = subAmountPool.getMatchingPartAmountVector(subLinkParts.elementAt(i));
            }
            if (vSubPartAmounts == null) {
                JDFAttributeMap subLinkMap = subLink.getAttributeMap();
                subLinkMap.remove("CombinedProcessIndex");
                subLinkMap.remove("CombinedProcessType");
                subLinkMap.remove("PipeProtocol");
                subLinkMap.remove("ProcessUsage");
                subLinkMap.remove("rRef");
                subLinkMap.remove("rSubRef");
                subLinkMap.remove("Usage");
                this.removeIdenticalFromPartAmountMap(mainLink, subLinkMap);
                if (subLinkMap.isEmpty() || subLinkMap.equals(subLinkParts.elementAt(i))) continue;
                JDFPartAmount mainPartAmount = mainLink.getCreateAmountPool().getCreatePartAmount(subLinkParts.elementAt(i));
                mainPartAmount.setAttributes(subLinkMap);
                mainLink.removeAttributes(subLinkMap.getKeys());
                continue;
            }
            for (int j = 0; j < vSubPartAmounts.size(); ++j) {
                JDFPartAmount subPartAmount = (JDFPartAmount)vSubPartAmounts.elementAt(j);
                JDFAttributeMap subAmountMap = subPartAmount.getAttributeMap();
                this.removeIdenticalFromPartAmountMap(mainLink, subAmountMap);
                if (subAmountMap.isEmpty()) continue;
                JDFAttributeMap subPartMap = subPartAmount.getPartMap();
                JDFPartAmount mainPartAmount = mainLink.getCreateAmountPool().getCreatePartAmount(subPartMap);
                mainPartAmount.setAttributes(subAmountMap);
                mainLink.removeAttributes(subAmountMap.getKeys());
            }
        }
    }

    private void removeIdenticalFromPartAmountMap(JDFResourceLink mainLink, JDFAttributeMap subLinkMap) {
        JDFAttributeMap mainLinkMap = mainLink.getAttributeMap();
        Iterator<String> iter = mainLinkMap.getKeyIterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!mainLinkMap.get(key).equals(subLinkMap.get(key))) continue;
            subLinkMap.remove(key);
        }
    }

    private void expandLinkedResources(JDFResourceLinkPool resourceLinkPool) {
        VElement links;
        VElement vElement = links = resourceLinkPool == null ? null : resourceLinkPool.getPoolChildren(null, null, null);
        if (links != null) {
            int size = links.size();
            for (int i = 0; i < size; ++i) {
                JDFResourceLink rl = (JDFResourceLink)links.elementAt(i);
                if (!this.vsRW.contains(rl.getrRef())) continue;
                rl.expandTarget(false);
            }
        }
    }

    private void mergeSpawnIDs(JDFResource mainRes, JDFResource resToMerge, boolean bReadOnly) {
        if (mainRes == null || resToMerge == null) {
            return;
        }
        if (!ContainerUtil.equals(mainRes.getID(), resToMerge.getID())) {
            throw new JDFException("JDFResource.mergeSpawnIDs  merging incompatible resources ID = " + mainRes.getID() + " IDMerge = " + resToMerge.getID());
        }
        VElement allLeaves = new VElement();
        VElement spawnedLeaves = mainRes.getNodesWithSpawnID(this.spawnID);
        if (spawnedLeaves != null) {
            for (int i = 0; i < spawnedLeaves.size(); ++i) {
                allLeaves.addAll(((JDFResource)spawnedLeaves.get(i)).getLeaves(true));
            }
            allLeaves.unify();
        }
        VString partIDKeys = mainRes.getPartIDKeys();
        for (int i = 0; i < allLeaves.size(); ++i) {
            int siz;
            JDFResource thisResNode = (JDFResource)allLeaves.elementAt(i);
            JDFAttributeMap partMap = thisResNode.getPartMap(partIDKeys);
            JDFResource mergeResNode = resToMerge.getPartition(partMap, JDFResource.EnumPartUsage.Explicit);
            if (mergeResNode == null) continue;
            VString vSpawnIDs = thisResNode.getSpawnIDs(false);
            int n = siz = vSpawnIDs == null ? 0 : vSpawnIDs.size();
            if (!bReadOnly) {
                if (vSpawnIDs == null) {
                    vSpawnIDs = mergeResNode.getSpawnIDs(false);
                } else {
                    vSpawnIDs.appendUnique(mergeResNode.getSpawnIDs(false));
                }
            }
            if (vSpawnIDs != null) {
                vSpawnIDs.removeStrings(this.previousMergeIDs, 999999);
            }
            if (vSpawnIDs == null || vSpawnIDs.isEmpty()) {
                this.removeSpawnAttributes(thisResNode);
                continue;
            }
            if (siz >= vSpawnIDs.size()) continue;
            thisResNode.setSpawnIDs(vSpawnIDs);
            if (mergeResNode.getSpawnStatus() != JDFResource.EnumSpawnStatus.SpawnedRW) continue;
            thisResNode.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRW);
        }
    }

    private void mergeRWResources() {
        for (String s : this.vsRW) {
            JDFResource oldRes = this.overWriteNode.getLinkRoot(s);
            if (oldRes == null && (oldRes = this.overWriteNode.getTargetResource(s)) == null) {
                oldRes = this.overWriteNode.getJDFRoot().getTargetResource(s);
            }
            if (oldRes == null) continue;
            JDFResource newRes = this.subJDFNode.getTargetResource(s);
            this.mergeSpawnIDs(oldRes, newRes, false);
            this.mergeSpawnIDs(newRes, oldRes, false);
            if (newRes != null) {
                try {
                    oldRes = JDFMerge.mergePartition(oldRes, newRes, this.spawnID, this.amountPolicy, false);
                }
                catch (JDFException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JDFException("JDFNode:mergeJDF, error in mergePartition: ID=" + (oldRes == null ? ">>> oldRes is null !!! <<<" : oldRes.getID()) + " SpawnID=" + this.spawnID);
                }
            }
            VElement oldResLeafsSpawned = oldRes.getNodesWithSpawnID(this.spawnID);
            for (int leaf = 0; leaf < oldResLeafsSpawned.size(); ++leaf) {
                JDFResource leafRes = (JDFResource)oldResLeafsSpawned.elementAt(leaf);
                leafRes.removeFromSpawnIDs(this.spawnID);
                this.calcSpawnStatus(leafRes, false);
            }
        }
    }

    private void mergeStatusPool(JDFNode poverWriteNode, JDFNode toMerge, VJDFAttributeMap parts) {
        if (toMerge.hasChildElement("StatusPool", null) || poverWriteNode.hasChildElement("StatusPool", null)) {
            int size;
            JDFStatusPool overWriteStatusPool = poverWriteNode.getCreateStatusPool();
            if (!poverWriteNode.getStatus().equals((Object)JDFElement.EnumNodeStatus.Pool)) {
                overWriteStatusPool.setStatus(poverWriteNode.getStatus());
                poverWriteNode.setStatus(JDFElement.EnumNodeStatus.Pool);
            }
            JDFStatusPool toMergeStatusPool = toMerge.getStatusPool();
            int n = size = parts == null ? 0 : parts.size();
            if (JDFElement.EnumNodeStatus.Pool.equals((Object)toMerge.getStatus())) {
                if (parts != null) {
                    for (int i = 0; i < size; ++i) {
                        VElement vpso = overWriteStatusPool.getMatchingPartStatusVector(parts.elementAt(i));
                        for (int j = 0; j < vpso.size(); ++j) {
                            ((JDFPartStatus)vpso.elementAt(j)).deleteNode();
                        }
                        VElement vps = toMergeStatusPool.getMatchingPartStatusVector(parts.elementAt(i));
                        for (int j = 0; j < vps.size(); ++j) {
                            JDFPartStatus ps = (JDFPartStatus)vps.elementAt(j);
                            JDFAttributeMap m = ps.getPartMap();
                            overWriteStatusPool.setStatus(m, ps.getStatus(), ps.getStatusDetails());
                        }
                    }
                }
                toMergeStatusPool.replaceElement(overWriteStatusPool);
            } else {
                if (parts != null) {
                    for (int i = 0; i < size; ++i) {
                        overWriteStatusPool.setStatus(parts.elementAt(i), toMerge.getStatus(), null);
                    }
                }
                if (toMergeStatusPool != null) {
                    toMergeStatusPool.deleteNode();
                }
                toMerge.setStatus(JDFElement.EnumNodeStatus.Pool);
                toMerge.moveElement(overWriteStatusPool, null);
            }
        }
    }

    private void cleanROResources() {
        for (String ro : this.vsRO) {
            JDFResource newRes = this.subJDFNode.getTargetResource(ro);
            JDFResource oldRes = (JDFResource)this.overWriteNode.getTarget(ro, "ID");
            if (oldRes == null || newRes == null) continue;
            this.mergeSpawnIDs(oldRes, newRes, true);
            VElement oldResLeafsSpawned = oldRes.getNodesWithSpawnID(this.spawnID);
            for (int leaf = 0; leaf < oldResLeafsSpawned.size(); ++leaf) {
                JDFResource leafRes = (JDFResource)oldResLeafsSpawned.elementAt(leaf);
                leafRes.removeFromSpawnIDs(this.spawnID);
                this.calcSpawnStatus(leafRes, false);
            }
            if (!newRes.getParentJDF().getID().equals(oldRes.getParentJDF().getID())) {
                newRes.deleteNode();
                continue;
            }
            newRes.replaceElement(oldRes);
        }
    }

    private void cleanUpMerge(JDFNode overWriteTmpNode) {
        JDFAuditPool auditPool;
        if (this.cleanPolicy == null) {
            this.cleanPolicy = JDFNode.EnumCleanUpMerge.None;
        }
        if (this.bAddMergeToProcessRun) {
            VElement vProcessRun = this.subJDFNode.getChildrenByTagName("ProcessRun", null, new JDFAttributeMap("SpawnID", this.spawnID), false, true, -1);
            JDFSpawned spawned = (JDFSpawned)overWriteTmpNode.getChildByTagName("Spawned", null, 0, new JDFAttributeMap("NewSpawnID", this.spawnID), false, true);
            JDFMerged merged = (JDFMerged)overWriteTmpNode.getChildByTagName("Merged", null, 0, new JDFAttributeMap("MergeID", this.spawnID), false, true);
            for (int k = 0; k < vProcessRun.size(); ++k) {
                JDFProcessRun pr = (JDFProcessRun)vProcessRun.elementAt(k);
                if (pr.hasAttribute("ReturnTime")) continue;
                if (merged != null) {
                    pr.setReturnTime(merged.getTimeStampDate());
                }
                if (spawned == null) continue;
                pr.setSubmissionTime(spawned.getTimeStampDate());
            }
        }
        if (!JDFNode.EnumCleanUpMerge.None.equals((Object)this.cleanPolicy) && (auditPool = overWriteTmpNode.getAuditPool()) != null) {
            this.cleanUpMergeAudits(auditPool);
        }
    }

    private void cleanUpMergeAudits(JDFAuditPool pool) {
        if (this.cleanPolicy != JDFNode.EnumCleanUpMerge.None) {
            VElement vMerged = new VElement();
            VElement vSpawned = new VElement();
            if (KElement.isWildCard(this.spawnID)) {
                vMerged = pool.getAudits(JDFAudit.EnumAuditType.Merged, null, null);
                vSpawned = pool.getAudits(JDFAudit.EnumAuditType.Spawned, null, null);
            } else {
                JDFAttributeMap mSpawnID = new JDFAttributeMap("MergeID", this.spawnID);
                JDFAudit a = pool.getAudit(0, JDFAudit.EnumAuditType.Merged, mSpawnID, null);
                if (a != null) {
                    vMerged.add(a);
                }
                mSpawnID.clear();
                mSpawnID.put("NewSpawnID", this.spawnID);
                a = pool.getAudit(0, JDFAudit.EnumAuditType.Spawned, mSpawnID, null);
                if (a != null) {
                    vSpawned.add(a);
                }
            }
            for (int i = vMerged.size() - 1; i >= 0; --i) {
                JDFMerged merged = (JDFMerged)vMerged.elementAt(i);
                String mergeID = merged.getMergeID();
                KElement doubleSpawn = pool.getChildWithAttribute("Spawned", "SpawnID", null, mergeID, 0, true);
                if (doubleSpawn != null) continue;
                for (int j = vSpawned.size() - 1; j >= 0; --j) {
                    JDFSpawned spawned = (JDFSpawned)vSpawned.elementAt(i);
                    if (!spawned.getNewSpawnID().equals(mergeID)) continue;
                    if (this.cleanPolicy == JDFNode.EnumCleanUpMerge.RemoveAll) {
                        spawned.deleteNode();
                        merged.deleteNode();
                        vSpawned.remove(j);
                        continue;
                    }
                    if (this.cleanPolicy == JDFNode.EnumCleanUpMerge.RemoveRRefs) {
                        spawned.removeAttribute("rRefsRWCopied");
                        spawned.removeAttribute("rRefsROCopied");
                        merged.removeAttribute("rRefsOverwritten");
                        continue;
                    }
                    throw new JDFException("JDFNode.EnumCleanUpMerge: illegal cleanPolicy enumeration: " + this.cleanPolicy.getValue());
                }
            }
        }
    }

    public String toString() {
        return "JDFMerge: " + this.spawnID + " parts: " + this.parts + "\n" + this.subJDFNode;
    }

    public JDFNode.EnumCleanUpMerge getCleanPolicy() {
        return this.cleanPolicy;
    }

    public void setCleanPolicy(JDFNode.EnumCleanUpMerge cleanPolicy) {
        this.cleanPolicy = cleanPolicy;
    }

    public JDFResource.EnumAmountMerge getAmountPolicy() {
        return this.amountPolicy;
    }

    public void setAmountPolicy(JDFResource.EnumAmountMerge amountPolicy) {
        this.amountPolicy = amountPolicy;
    }
}

