/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoResourceAudit;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.util.StringUtil;

@Deprecated
public class StatusUtil {
    JDFNode m_Node;
    private JDFDoc docJMFPhaseTime;
    private JDFDoc docJMFResource;
    protected VJDFAttributeMap m_vPartMap;
    private String m_deviceID = null;
    private LinkAmount[] vLinkAmount = null;

    public StatusUtil(JDFNode node, VJDFAttributeMap vPartMap, VElement vResLinks) {
        this.m_Node = node;
        this.m_vPartMap = vPartMap;
        if (this.m_vPartMap == null) {
            this.m_vPartMap = this.m_Node.getPartMapVector();
        }
        this.setUpResLinks(vResLinks);
    }

    public static AmountBag getBag(String refID, AmountBag[] bags) {
        if (bags == null || refID == null) {
            return null;
        }
        for (int i = 0; i < bags.length; ++i) {
            if (!bags[i].refID.equals(refID)) continue;
            return bags[i];
        }
        return null;
    }

    public LinkAmount getLinkAmount(String refID) {
        if (this.vLinkAmount == null || refID == null) {
            return null;
        }
        for (int i = 0; i < this.vLinkAmount.length; ++i) {
            if (!this.vLinkAmount[i].rl.getrRef().equals(refID)) continue;
            return this.vLinkAmount[i];
        }
        return null;
    }

    public String getFirstRefID() {
        if (this.vLinkAmount == null || this.vLinkAmount.length == 0) {
            return null;
        }
        return this.vLinkAmount[0].rl.getrRef();
    }

    private void setUpResLinks(VElement resLinks) {
        if (resLinks == null || resLinks.size() == 0) {
            return;
        }
        this.vLinkAmount = new LinkAmount[resLinks.size()];
        for (int i = 0; i < this.vLinkAmount.length; ++i) {
            this.vLinkAmount[i] = new LinkAmount((JDFResourceLink)resLinks.elementAt(i));
        }
    }

    public void setPhase(JDFElement.EnumNodeStatus nodeStatus, String nodeStatusDetails, JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails, AmountBag[] amounts) {
        JDFDeviceInfo deviceInfo;
        JDFSignal s;
        JDFPhaseTime pt1;
        this.docJMFPhaseTime = new JDFDoc("JMF");
        JDFJMF jmf = this.docJMFPhaseTime.getJMFRoot();
        this.docJMFResource = new JDFDoc("JMF");
        JDFJMF jmfRes = this.docJMFResource.getJMFRoot();
        AmountBag ab = StatusUtil.getBag(this.getFirstRefID(), amounts);
        LinkAmount la = this.getLinkAmount(this.getFirstRefID());
        AmountBag lastAb = la == null ? null : la.lastBag;
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFPhaseTime pt2 = pt1 = ap.getLastPhase(this.m_vPartMap, null);
        boolean bEnd = nodeStatus.equals((Object)JDFElement.EnumNodeStatus.Completed) || nodeStatus.equals((Object)JDFElement.EnumNodeStatus.Aborted);
        pt2 = ap.setPhase(nodeStatus, nodeStatusDetails, this.m_vPartMap, null);
        if (bEnd) {
            JDFProcessRun pr = (JDFProcessRun)ap.addAudit(JDFAudit.EnumAuditType.ProcessRun, null);
            pr.setPartMapVector(this.m_vPartMap);
            VElement audits = ap.getAudits(JDFAudit.EnumAuditType.PhaseTime, null, this.m_vPartMap);
            for (int i = 0; i < audits.size(); ++i) {
                pr.addPhase((JDFPhaseTime)audits.elementAt(i));
            }
            pr.setEndStatus(nodeStatus);
        }
        if (pt1 != null && pt2 != pt1) {
            s = (JDFSignal)jmf.appendMessageElement(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Status);
            deviceInfo = s.appendDeviceInfo();
            JDFJobPhase jp = deviceInfo.createJobPhaseFromPhaseTime(pt1);
            jp.setJobID(this.m_Node.getJobID(true));
            jp.setJobPartID(this.m_Node.getJobPartID(false));
            this.setJobPhaseAmounts(lastAb, jp);
            if (this.m_deviceID != null) {
                deviceInfo.setDeviceID(this.m_deviceID);
            }
        }
        if (pt2 != null) {
            s = (JDFSignal)jmf.appendMessageElement(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Status);
            deviceInfo = s.appendDeviceInfo();
            if (!bEnd) {
                JDFJobPhase jp = deviceInfo.createJobPhaseFromPhaseTime(pt2);
                this.setJobPhaseAmounts(ab, jp);
            }
            deviceInfo.setDeviceStatus(deviceStatus);
            deviceInfo.setStatusDetails(deviceStatusDetails);
            deviceInfo.setDeviceID(this.m_deviceID);
            this.m_Node.setPartStatus(this.m_vPartMap, nodeStatus, null);
            this.getVResLink(amounts, 2);
            this.generateResourceSignal(amounts, jmfRes);
            if (bEnd) {
                pt2.deleteNode();
            } else {
                pt2.setLinks(this.getVResLink(amounts, 1));
                pt2.eraseEmptyAttributes(true);
            }
        }
        if (this.vLinkAmount != null) {
            for (int i = 0; i < this.vLinkAmount.length; ++i) {
                String refID = this.vLinkAmount[i].rl.getrRef();
                AmountBag bag = StatusUtil.getBag(refID, amounts);
                this.vLinkAmount[i].lastBag = new AmountBag(bag);
            }
        }
        jmf.eraseEmptyAttributes(true);
    }

    private void generateResourceSignal(AmountBag[] amounts, JDFJMF jmfRes) {
        if (amounts != null) {
            VElement vResResourceInfo = this.getVResLink(amounts, 3);
            JDFSignal sig = jmfRes.appendSignal(JDFMessage.EnumType.Resource);
            JDFResourceQuParams rqp = sig.appendResourceQuParams();
            rqp.setJDF(this.m_Node);
            rqp.setExact(false);
            boolean bAllExact = true;
            for (int i = 0; i < vResResourceInfo.size(); ++i) {
                JDFResourceInfo ri = sig.appendResourceInfo();
                JDFResourceLink rl = (JDFResourceLink)vResResourceInfo.elementAt(i);
                LinkAmount la = this.getLinkAmount(rl.getrRef());
                boolean bExact = la.bCopyResInfo;
                bAllExact = bAllExact && bExact;
                rqp.setExact(bExact);
                ri.setLink(rl, rqp);
            }
            rqp.setExact(bAllExact);
        }
    }

    private void setJobPhaseAmounts(AmountBag lastAb, JDFJobPhase jp) {
        if (lastAb == null) {
            return;
        }
        LinkAmount la = this.getLinkAmount(lastAb.refID);
        if (la == null) {
            return;
        }
        if (la.bTrackWaste) {
            if (lastAb.phaseAmount != 0.0) {
                jp.setPhaseAmount(lastAb.phaseAmount);
            }
            if (lastAb.totalAmount != 0.0) {
                jp.setAmount(lastAb.totalAmount);
            }
            if (lastAb.phaseWaste != 0.0) {
                jp.setPhaseWaste(lastAb.phaseWaste);
            }
            if (lastAb.totalWaste != 0.0) {
                jp.setWaste(lastAb.totalWaste);
            }
        } else {
            if (lastAb.phaseAmount + lastAb.phaseWaste != 0.0) {
                jp.setPhaseAmount(lastAb.phaseAmount + lastAb.phaseWaste);
            }
            if (lastAb.totalAmount + lastAb.totalWaste != 0.0) {
                jp.setAmount(lastAb.totalAmount + lastAb.totalWaste);
            }
        }
        double total = 0.0;
        total = la.startAmount;
        if (total != 0.0) {
            jp.setTotalAmount(total);
            jp.setPercentCompleted(lastAb.totalAmount / total * 100.0);
        }
    }

    private VElement getVResLink(AmountBag[] amounts, int n) {
        if (amounts == null && this.vLinkAmount == null) {
            return null;
        }
        if (this.vLinkAmount == null || amounts == null || this.vLinkAmount.length != amounts.length) {
            throw new JDFException("incoherent resLink sizes");
        }
        VElement vRet = new VElement();
        for (int i = 0; i < this.vLinkAmount.length; ++i) {
            LinkAmount la = this.vLinkAmount[i];
            if (n == 1) {
                vRet.add(la.getPhaseTimeLink(StatusUtil.getBag(la.rl.getrRef(), amounts)));
            }
            if (n == 2) {
                vRet.add(la.updateNodeLink(StatusUtil.getBag(la.rl.getrRef(), amounts)));
            }
            if (n != 3) continue;
            vRet.add(la.getResourceInfoLink(StatusUtil.getBag(la.rl.getrRef(), amounts)));
        }
        return vRet;
    }

    public JDFDoc getDocJMFPhaseTime() {
        return this.docJMFPhaseTime;
    }

    public JDFDoc getDocJMFResource() {
        return this.docJMFResource;
    }

    public String getDeviceID() {
        return this.m_deviceID;
    }

    public void setDeviceID(String deviceid) {
        this.m_deviceID = deviceid;
    }

    public void setTrackWaste(JDFResourceLink rl, boolean b) {
        LinkAmount la = this.getLinkAmount(rl.getrRef());
        if (la != null) {
            la.bTrackWaste = b;
        }
    }

    public void setCopyResInResInfo(JDFResourceLink rl, boolean b) {
        LinkAmount la = this.getLinkAmount(rl.getrRef());
        if (la != null) {
            la.bCopyResInfo = b;
        }
    }

    public JDFResourceAudit setResourceAudit(AmountBag bag, JDFAutoResourceAudit.EnumReason reason) {
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFResourceAudit ra = ap.addResourceAudit(null);
        ra.setContentsModified(false);
        ra.setReason(reason);
        LinkAmount la = this.getLinkAmount(bag.refID);
        ra.copyElement(la.getResourceAuditLink(bag), null);
        ra.setPartMapVector(this.m_vPartMap);
        return ra;
    }

    public JDFProcessRun setProcessResult(JDFElement.EnumNodeStatus endStatus) {
        JDFAuditPool ap = this.m_Node.getCreateAuditPool();
        JDFProcessRun pr = ap.addProcessRun(endStatus, null, this.m_vPartMap);
        return pr;
    }

    private class LinkAmount {
        double startAmount = 0.0;
        double startWaste = 0.0;
        JDFResourceLink rl;
        AmountBag lastBag;
        public boolean bTrackWaste = false;
        public boolean bCopyResInfo = false;

        LinkAmount(JDFResourceLink _rl) {
            JDFNode dump = new JDFDoc("JDF").getJDFRoot();
            dump.appendResourceLinkPool().copyElement(_rl, null);
            dump.appendResourcePool().copyElement(_rl.getTarget(), null);
            this.rl = (JDFResourceLink)dump.getResourceLinkPool().getElement(_rl.getNodeName(), null, 0);
            JDFAttributeMap map = StatusUtil.this.m_vPartMap == null || StatusUtil.this.m_vPartMap.size() == 0 ? null : StatusUtil.this.m_vPartMap.elementAt(0);
            this.startAmount = this.rl.getAmount(map);
            if (this.startAmount == -1.0) {
                map = new JDFAttributeMap(map);
                map.put((ValuedEnum)JDFResource.EnumPartIDKey.Condition, "Good");
                this.startAmount = this.rl.getAmount(map);
                if (this.startAmount == -1.0) {
                    this.startAmount = 0.0;
                }
                map.put((ValuedEnum)JDFResource.EnumPartIDKey.Condition, "Waste");
                this.startWaste = this.rl.getAmount(map);
                if (this.startWaste == -1.0) {
                    this.startWaste = 0.0;
                }
            }
        }

        public JDFResourceLink updateNodeLink(AmountBag bag) {
            JDFResourceLink nodeLink = StatusUtil.this.m_Node.getLink(0, null, new JDFAttributeMap("rRef", this.rl.getrRef()), null);
            if (bag != null) {
                VJDFAttributeMap vMap = new VJDFAttributeMap(StatusUtil.this.m_vPartMap);
                if (vMap.size() == 0) {
                    vMap.add(new JDFAttributeMap());
                }
                if (nodeLink != null) {
                    if (this.bTrackWaste) {
                        vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                        nodeLink.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount), null, vMap);
                        vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                        nodeLink.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalWaste), null, vMap);
                    } else {
                        nodeLink.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount + bag.totalWaste), null, vMap);
                    }
                }
            }
            return nodeLink;
        }

        public JDFResourceLink getPhaseTimeLink(AmountBag bag) {
            this.cleanAmounts();
            if (bag != null) {
                VJDFAttributeMap vMap = new VJDFAttributeMap(StatusUtil.this.m_vPartMap);
                if (vMap.size() == 0) {
                    vMap.add(new JDFAttributeMap());
                }
                if (this.bTrackWaste) {
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                    if (bag.phaseAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.phaseAmount), null, vMap);
                    }
                    if (this.startAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount), null, vMap);
                    }
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                    if (bag.phaseWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.phaseWaste), null, vMap);
                    }
                    if (this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startWaste), null, vMap);
                    }
                } else {
                    if (bag.phaseAmount + bag.phaseWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.phaseAmount + bag.phaseWaste), null, vMap);
                    }
                    if (this.startAmount + this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount + this.startWaste), null, vMap);
                    }
                }
            }
            return this.rl;
        }

        public JDFResourceLink getResourceAuditLink(AmountBag bag) {
            this.cleanAmounts();
            if (bag != null) {
                VJDFAttributeMap vMap = new VJDFAttributeMap(StatusUtil.this.m_vPartMap);
                if (vMap.size() == 0) {
                    vMap.add(new JDFAttributeMap());
                }
                if (this.bTrackWaste) {
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                    if (bag.totalAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount), null, vMap);
                    }
                    if (this.startAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount), null, vMap);
                    }
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                    if (bag.totalWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalWaste), null, vMap);
                    }
                    if (this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startWaste), null, vMap);
                    }
                } else {
                    if (bag.totalAmount + bag.totalWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount + bag.totalWaste), null, vMap);
                    }
                    if (this.startAmount + this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount + this.startWaste), null, vMap);
                    }
                }
            }
            return this.rl;
        }

        public JDFResourceLink getResourceInfoLink(AmountBag bag) {
            this.cleanAmounts();
            if (bag != null) {
                VJDFAttributeMap vMap = new VJDFAttributeMap(StatusUtil.this.m_vPartMap);
                if (vMap.size() == 0) {
                    vMap.add(new JDFAttributeMap());
                }
                if (this.bTrackWaste) {
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Good");
                    if (bag.totalAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount), null, vMap);
                    }
                    if (this.startAmount != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount), null, vMap);
                    }
                    vMap.put((Object)JDFResource.EnumPartIDKey.Condition, (Object)"Waste");
                    if (bag.totalWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalWaste), null, vMap);
                    }
                    if (this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startWaste), null, vMap);
                    }
                } else {
                    if (bag.totalAmount + bag.totalWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("ActualAmount", StringUtil.formatDouble(bag.totalAmount + bag.totalWaste), null, vMap);
                    }
                    if (this.startAmount + this.startWaste != 0.0) {
                        this.rl.setAmountPoolAttribute("Amount", StringUtil.formatDouble(this.startAmount + this.startWaste), null, vMap);
                    }
                }
            }
            return this.rl;
        }

        private void cleanAmounts() {
            this.rl.removeAttribute("Amount");
            this.rl.removeAttribute("ActualAmount");
            this.rl.removeChild("AmountPool", null, 0);
        }
    }

    public class AmountBag {
        public String refID;
        public double totalAmount;
        public double phaseAmount;
        public double totalWaste;
        public double phaseWaste;

        public String toString() {
            return "[AmountBag refID=" + this.refID + " totalAmount=" + this.totalAmount + " phaseAmount=" + this.phaseAmount + " totalWaste=" + this.totalWaste + " phaseWaste=" + this.phaseWaste + " ]";
        }

        public AmountBag(JDFResourceLink rl) {
            this(rl.getrRef());
        }

        public AmountBag(String _refID) {
            this.refID = _refID;
            this.reset();
        }

        public void reset() {
            this.totalAmount = 0.0;
            this.phaseAmount = 0.0;
            this.totalWaste = 0.0;
            this.phaseWaste = 0.0;
        }

        public AmountBag(AmountBag bag) {
            this.refID = bag.refID;
            this.totalAmount = bag.totalAmount;
            this.phaseAmount = bag.phaseAmount;
            this.totalWaste = bag.totalWaste;
            this.phaseWaste = bag.phaseWaste;
        }

        public void addPhase(double amount, double waste, boolean bNewPhase) {
            this.totalAmount += amount;
            this.totalWaste += waste;
            if (bNewPhase) {
                this.phaseAmount = amount;
                this.phaseWaste = waste;
            } else {
                this.phaseAmount += amount;
                this.phaseWaste += waste;
            }
        }
    }
}

