/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.RollingBackupFile;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.StorageHotFolder;

class StorageHotFolderListener
implements HotFolderListener {
    private final File storage;
    private File errorStorage;
    private File okStorage;
    private final StorageHotFolder parent;
    private final Log log;
    private int nHotOK = 0;
    private int nHotError = 0;
    private int maxStore;
    HotFolderListener theListener;

    StorageHotFolderListener(File storageDir, HotFolderListener hfListener, StorageHotFolder parent) {
        this.setMaxStore(42);
        this.errorStorage = null;
        this.okStorage = null;
        this.log = LogFactory.getLog(this.getClass());
        if (hfListener == null) {
            this.log.error((Object)"hfListner MUST NOT be null");
            throw new IllegalArgumentException("hfListner MUST NOT be null");
        }
        this.theListener = hfListener;
        this.storage = storageDir;
        this.parent = parent;
    }

    void setOKStorage(File ok) {
        this.okStorage = ok;
        if (ok != null) {
            this.okStorage.mkdirs();
            this.okStorage.setWritable(true);
            if (!this.okStorage.isDirectory()) {
                this.log.error((Object)("OK Directory is not a directory: " + this.okStorage.getAbsolutePath()));
            }
        }
    }

    void setErrorStorage(File error) {
        this.errorStorage = error;
        if (error != null) {
            this.errorStorage.mkdirs();
            this.errorStorage.setWritable(true);
            if (!this.errorStorage.isDirectory()) {
                this.log.error((Object)("Error Directory is not a directory: " + this.errorStorage.getAbsolutePath()));
            }
        }
    }

    @Override
    public boolean hotFile(File hotFile) {
        this.log.info((Object)("processing hot file: " + hotFile));
        File storedFile = this.getStoredFile(hotFile);
        if (storedFile == null) {
            this.log.warn((Object)("snafu retrieving file " + hotFile.getAbsolutePath()));
            this.copyCompleted(hotFile, false);
            return false;
        }
        boolean b = this.theListener.hotFile(storedFile);
        this.copyCompleted(storedFile, b);
        return b;
    }

    void copyCompleted(File storedFile, boolean bOK) {
        if (bOK) {
            if (this.okStorage != null) {
                File backup = FileUtil.getFileInDirectory(this.okStorage, new File(storedFile.getName()));
                RollingBackupFile roller = new RollingBackupFile(backup, 10);
                roller.getNewFile();
                File copied = FileUtil.moveFileToDir(storedFile, this.okStorage);
                if (copied == null) {
                    this.handleBad(storedFile, true);
                } else {
                    copied.setLastModified(System.currentTimeMillis());
                }
                this.cleanup(bOK);
            } else {
                boolean ok = FileUtil.forceDelete(storedFile);
                if (!ok) {
                    this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
                }
            }
        } else if (this.errorStorage != null) {
            File backup = FileUtil.getFileInDirectory(this.errorStorage, new File(storedFile.getName()));
            RollingBackupFile roller = new RollingBackupFile(backup, 10);
            roller.getNewFile();
            File copied = FileUtil.moveFileToDir(storedFile, this.errorStorage);
            if (copied == null) {
                this.handleBad(storedFile, false);
            } else {
                copied.setLastModified(System.currentTimeMillis());
            }
            this.cleanup(bOK);
        } else {
            boolean ok = FileUtil.forceDelete(storedFile);
            if (!ok) {
                this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
            }
        }
    }

    protected void handleBad(File storedFile, boolean bOK) {
        if (bOK) {
            this.log.warn((Object)("could not move ok " + storedFile + " to " + this.okStorage.getAbsolutePath()));
        } else {
            this.log.warn((Object)("could not move error " + storedFile + " to " + this.errorStorage.getAbsolutePath()));
        }
        boolean bZapp = storedFile.delete();
        if (bZapp) {
            this.log.warn((Object)("utterly removed hot file: " + storedFile));
        } else {
            this.log.error((Object)("cannot process hot file: " + storedFile));
        }
    }

    private void cleanup(boolean bOK) {
        int n;
        if (bOK) {
            int n2 = this.nHotOK;
            n = n2;
            this.nHotOK = n2 + 1;
        } else {
            int n3 = this.nHotError;
            n = n3;
            this.nHotError = n3 + 1;
        }
        int nHot = n;
        if (nHot % 13 == 0) {
            FileSorter fs = new FileSorter(bOK ? this.okStorage : this.errorStorage);
            File[] list = fs.sortLastModified(true);
            for (int i = this.maxStore; i < list.length; ++i) {
                boolean ok = FileUtil.forceDelete(list[i]);
                if (ok) continue;
                this.log.warn((Object)("failed to delete temporary file " + list[i].getAbsolutePath()));
            }
        }
    }

    private File getStoredFile(File hotFile) {
        String hotFileName = hotFile.getName();
        File newAbsoluteFile = FileUtil.getFileInDirectory(this.storage, new File(hotFileName));
        boolean ok = FileUtil.moveFile(hotFile, newAbsoluteFile);
        if (ok) {
            this.log.info((Object)("moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        } else {
            this.log.error((Object)("cannot move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        }
        return ok ? newAbsoluteFile : null;
    }

    void setMaxStore(int maxStore) {
        this.maxStore = maxStore;
    }

    public String toString() {
        return "StorageHotFolderListener: ok=" + this.okStorage + " error=" + this.errorStorage;
    }
}

