/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.thread.MyMutex;
import org.cip4.jdflib.util.thread.Sweeper;
import org.cip4.jdflib.util.thread.TimeSweeper;

public final class RegularJanitor {
    private MyMutex theMutex;
    private final Log log = LogFactory.getLog(this.getClass());
    private int nThread = 0;
    private static RegularJanitor theJanitor = null;
    private final Vector<Sweeper> vSweepers = new Vector();
    private final Vector<Sweeper> tmpSweepers = new Vector();
    private final Vector<Sweeper> zappSweepers = new Vector();
    private int interval = 15;

    public void setInterval(int interval) {
        if (interval < 1) {
            this.log.error((Object)"cannot set interval <1; setting to 1 second");
            interval = 1;
        }
        this.interval = interval;
    }

    public String toString() {
        return "RegularJanitor: interval=" + this.interval + " size=" + this.numSweepers();
    }

    int numSweepers() {
        return this.vSweepers.size() + this.tmpSweepers.size() - this.zappSweepers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSweeper(Sweeper sweeper, boolean singleClass) {
        if (sweeper == null) {
            this.log.error((Object)"cannot add null sweeper");
            return;
        }
        Vector<Sweeper> vector = this.tmpSweepers;
        synchronized (vector) {
            if (singleClass) {
                this.checkDuplicates(sweeper);
            }
            this.tmpSweepers.add(sweeper);
            this.log.info((Object)("adding sweeper " + sweeper));
        }
    }

    private void checkDuplicates(Sweeper sweeper) {
        Vector<Sweeper> v = new Vector<Sweeper>();
        v.addAll(this.tmpSweepers);
        v.addAll(this.vSweepers);
        for (Sweeper oldSweeper : v) {
            Class<? extends Object> newClass;
            Class<? extends Object> oldClass = this.getRunnerClass(oldSweeper);
            if (!oldClass.equals(newClass = this.getRunnerClass(sweeper))) continue;
            this.log.info((Object)"removing duplicate tmp sweeper");
            this.zappSweepers.add(oldSweeper);
        }
    }

    private Class<? extends Object> getRunnerClass(Sweeper oldSweeper) {
        return oldSweeper instanceof TimeSweeper ? ((TimeSweeper)oldSweeper).getRunnerClass() : oldSweeper.getClass();
    }

    public synchronized void startSweep(int firstInterval) {
        if (this.theMutex != null) {
            this.log.warn((Object)"Janitor already running - do nothing ");
            return;
        }
        this.log.info((Object)("starting sweeeper in seconds: " + firstInterval));
        JanitorThread janitorThread = new JanitorThread();
        janitorThread.setFirstInterval(firstInterval);
        janitorThread.start();
    }

    public static void feierabend() {
        if (theJanitor != null) {
            RegularJanitor tmp = theJanitor;
            theJanitor = null;
            tmp.shutdown();
        }
    }

    private void shutdown() {
        if (this.theMutex == null) {
            this.log.warn((Object)"cannot shutdown sleeping janitor that has already been shut down");
        }
        MyMutex m = this.theMutex;
        this.theMutex = null;
        ThreadUtil.notifyAll(m);
        this.log.info((Object)"shutting down the janitor");
    }

    public static RegularJanitor getJanitor() {
        if (theJanitor == null) {
            theJanitor = new RegularJanitor();
        }
        return theJanitor;
    }

    protected RegularJanitor() {
        this.log.info((Object)"creating new janitor");
    }

    class JanitorThread
    extends Thread {
        private int firstInterval;

        public JanitorThread() {
            super("Janitor_" + RegularJanitor.this.nThread++);
            this.firstInterval = RegularJanitor.this.interval;
            RegularJanitor.this.theMutex = new MyMutex();
        }

        @Override
        public void run() {
            RegularJanitor.this.log.info((Object)"Janitor starting");
            if (this.firstInterval > 0) {
                RegularJanitor.this.log.info((Object)("Janitor starting - initial pause: " + this.firstInterval + " seconds"));
                ThreadUtil.wait(RegularJanitor.this.theMutex, 1000 * this.firstInterval);
            }
            if (RegularJanitor.this.theMutex != null) {
                RegularJanitor.this.log.info((Object)("Janitor starting - interval: " + RegularJanitor.this.interval + " seconds"));
            }
            while (RegularJanitor.this.theMutex != null) {
                this.moveModifications();
                for (Sweeper sweeper : RegularJanitor.this.vSweepers) {
                    this.sweep(sweeper);
                    if (RegularJanitor.this.theMutex != null) continue;
                    break;
                }
                if (ThreadUtil.wait(RegularJanitor.this.theMutex, 1000 * RegularJanitor.this.interval)) continue;
            }
            RegularJanitor.this.log.info((Object)"Janitor over and out");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void moveModifications() {
            Vector vector = RegularJanitor.this.tmpSweepers;
            synchronized (vector) {
                for (Sweeper oldSweeper : RegularJanitor.this.zappSweepers) {
                    RegularJanitor.this.tmpSweepers.remove(oldSweeper);
                    RegularJanitor.this.vSweepers.remove(oldSweeper);
                }
                RegularJanitor.this.vSweepers.addAll(RegularJanitor.this.tmpSweepers);
                RegularJanitor.this.tmpSweepers.clear();
                RegularJanitor.this.zappSweepers.clear();
            }
        }

        private void sweep(Sweeper sweeper) {
            try {
                if (sweeper.needSweep()) {
                    sweeper.sweep();
                }
            }
            catch (Throwable x) {
                RegularJanitor.this.log.error((Object)"problems sweeping", x);
            }
        }

        void setFirstInterval(int firstInterval) {
            if (firstInterval < 0) {
                firstInterval = RegularJanitor.this.interval;
            }
            this.firstInterval = firstInterval;
        }
    }
}

