/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.thread;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.thread.Sweeper;

public class TimeSweeper
implements Sweeper {
    protected Log log = LogFactory.getLog(this.getClass());
    protected long t0 = -1L;
    private long interval;
    private Runnable runner;

    protected TimeSweeper(int interval) {
        this.setInterval(interval);
        this.runner = null;
    }

    public TimeSweeper(int interval, Runnable runner) {
        this(interval);
        this.runner = runner;
    }

    protected void setInterval(int interval) {
        this.interval = 1000 * interval;
    }

    protected void setFirstInterval(int interval) {
        this.t0 = System.currentTimeMillis() + (long)(1000 * interval);
    }

    public Class<?> getRunnerClass() {
        return this.runner == null ? this.getClass() : this.runner.getClass();
    }

    @Override
    public boolean needSweep() {
        boolean needsweep;
        long t = System.currentTimeMillis();
        boolean bl = needsweep = t > this.t0;
        if (needsweep) {
            this.t0 = t + this.interval;
        }
        return needsweep;
    }

    @Override
    public boolean sweep() {
        if (this.runner != null) {
            this.runner.run();
        }
        return this.runner != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " interval=" + this.interval;
    }
}

