/**
 * The CIP4 Software License, Version 1.0
 *
 * Copyright (c) 2001-2014 The International Cooperation for the Integration of 
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of 
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of 
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration 
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software 
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG 
 * copyright (c) 1999-2001, Agfa-Gevaert N.V. 
 *  
 * For more information on The International Cooperation for the 
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *  
 * 
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoPart.EnumSide;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

/**
 * 
 *  
 * @author rainer prosi
 * @date Feb 26, 2013
 */
public class WalkColorIntentResLink extends WalkResLink
{

	/**
	 * 
	 */
	public WalkColorIntentResLink()
	{
		super();
	}

	/**
	 * @see org.cip4.jdflib.extensions.XJDF20.WalkResLink#setResource(org.cip4.jdflib.core.JDFResourceLink, org.cip4.jdflib.resource.JDFResource, org.cip4.jdflib.core.KElement)
	 */
	@Override
	VElement setResource(JDFResourceLink rl, JDFResource linkTarget, KElement xjdf)
	{
		VElement v = super.setResource(rl, linkTarget, xjdf);
		KElement e0 = null;
		VString frontBack = new VString("ColorsUsed Coatings ColorStandard Coverage", null);
		for (KElement e1 : v)
		{
			JDFPart part = (JDFPart) e1.getElement(ElementName.PART);
			KElement colorIntent = e1.getElement(ElementName.COLORINTENT);

			if (e0 == null)
			{
				e0 = colorIntent;
			}
			if (colorIntent == null)
			{
				if (part != null)
				{
					part.deleteNode();
				}
			}
			else
			{
				if (part != null)
				{
					EnumSide side = part.getSide();
					if (EnumSide.Front.equals(side) && e0 != colorIntent)
					{
						for (String att : frontBack)
						{
							String attVal = colorIntent.getAttribute(att, null, null);
							if (attVal != null)
							{
								e0.setAttribute(att, attVal);
							}
						}
					}
					else if (EnumSide.Back.equals(side))
					{
						for (String att : frontBack)
						{
							String attVal = colorIntent.getAttribute(att, null, null);
							if (attVal != null)
							{
								e0.setAttribute(att + "Back", attVal);
							}
						}
					}
					part.deleteNode();
				}
				else
				{
					for (String att : frontBack)
					{
						String attVal = colorIntent.getAttribute(att, null, null);
						if (attVal != null)
						{
							if (e0 != colorIntent)
							{
								String attValBase = e0.getAttribute(att, null, null);
								if (attValBase == null)
								{
									e0.setAttribute(att, attVal);
								}
							}
							String attValBack = e0.getAttribute(att + "Back", null, null);
							if (attValBack == null)
							{
								e0.setAttribute(att + "Back", attVal);
							}
						}
					}
				}
			}
		}
		return v;
	}

	/**
	 * @see org.cip4.jdflib.extensions.XJDF20.WalkResLink#walk(org.cip4.jdflib.core.KElement, org.cip4.jdflib.core.KElement)
	 */
	@Override
	public KElement walk(KElement jdf, KElement xjdf)
	{
		KElement e = super.walk(jdf, xjdf);
		return e;
	}

	/**
	 * @see org.cip4.jdflib.extensions.XJDF20.WalkResLink#matches(org.cip4.jdflib.core.KElement)
	 */
	@Override
	public boolean matches(KElement toCheck)
	{
		return super.matches(toCheck) && "ColorIntentLink".equals(toCheck.getLocalName());
	}

}