/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFBundle;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFDisjointing;
import org.cip4.jdflib.resource.process.JDFIdentificationField;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.postpress.JDFSheet;

public abstract class JDFAutoComponent
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[22];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoComponent(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoComponent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoComponent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoComponent[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Quantity);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Quantity;
    }

    public void setComponentType(Vector v) {
        this.setEnumerationsAttribute("ComponentType", v, null);
    }

    public Vector getComponentType() {
        return this.getEnumerationsAttribute("ComponentType", null, EnumComponentType.getEnum(0), false);
    }

    public void setAssemblyIDs(VString value) {
        this.setAttribute("AssemblyIDs", value, null);
    }

    public VString getAssemblyIDs() {
        VString vStrAttrib = new VString();
        String s = this.getAttribute("AssemblyIDs", null, "");
        vStrAttrib.setAllStrings(s, " ");
        return vStrAttrib;
    }

    public void setAutomation(EnumAutomation enumVar) {
        this.setAttribute("Automation", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumAutomation getAutomation() {
        return EnumAutomation.getEnum(this.getAttribute("Automation", null, null));
    }

    public void setCartonTopFlaps(JDFXYPair value) {
        this.setAttribute("CartonTopFlaps", value, null);
    }

    public JDFXYPair getCartonTopFlaps() {
        String strAttrName = this.getAttribute("CartonTopFlaps", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setColumns(int value) {
        this.setAttribute("Columns", value, (String)null);
    }

    public int getColumns() {
        return this.getIntAttribute("Columns", null, 0);
    }

    public void setDimensions(JDFShape value) {
        this.setAttribute("Dimensions", value, null);
    }

    public JDFShape getDimensions() {
        String strAttrName = this.getAttribute("Dimensions", null, null);
        JDFShape nPlaceHolder = JDFShape.createShape(strAttrName);
        return nPlaceHolder;
    }

    public void setIsWaste(boolean value) {
        this.setAttribute("IsWaste", value, null);
    }

    public boolean getIsWaste() {
        return this.getBoolAttribute("IsWaste", null, false);
    }

    public void setMaxHeat(double value) {
        this.setAttribute("MaxHeat", value, null);
    }

    public double getMaxHeat() {
        return this.getRealAttribute("MaxHeat", null, 0.0);
    }

    public void setOverfold(double value) {
        this.setAttribute("Overfold", value, null);
    }

    public double getOverfold() {
        return this.getRealAttribute("Overfold", null, 0.0);
    }

    public void setOverfoldSide(EnumOverfoldSide enumVar) {
        this.setAttribute("OverfoldSide", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumOverfoldSide getOverfoldSide() {
        return EnumOverfoldSide.getEnum(this.getAttribute("OverfoldSide", null, null));
    }

    public void setPageListIndex(JDFIntegerRangeList value) {
        this.setAttribute("PageListIndex", value, null);
    }

    public JDFIntegerRangeList getPageListIndex() {
        String strAttrName = this.getAttribute("PageListIndex", null, null);
        JDFIntegerRangeList nPlaceHolder = JDFIntegerRangeList.createIntegerRangeList(strAttrName);
        return nPlaceHolder;
    }

    public void setProductType(String value) {
        this.setAttribute("ProductType", value, null);
    }

    public String getProductType() {
        return this.getAttribute("ProductType", null, "");
    }

    public void setProductTypeDetails(String value) {
        this.setAttribute("ProductTypeDetails", value, null);
    }

    public String getProductTypeDetails() {
        return this.getAttribute("ProductTypeDetails", null, "");
    }

    public void setReaderPageCount(int value) {
        this.setAttribute("ReaderPageCount", value, (String)null);
    }

    public int getReaderPageCount() {
        return this.getIntAttribute("ReaderPageCount", null, 0);
    }

    public void setSheetPart(JDFRectangle value) {
        this.setAttribute("SheetPart", value, null);
    }

    public JDFRectangle getSheetPart() {
        String strAttrName = this.getAttribute("SheetPart", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setSourceRibbon(String value) {
        this.setAttribute("SourceRibbon", value, null);
    }

    public String getSourceRibbon() {
        return this.getAttribute("SourceRibbon", null, "");
    }

    public void setSourceSheet(String value) {
        this.setAttribute("SourceSheet", value, null);
    }

    public String getSourceSheet() {
        return this.getAttribute("SourceSheet", null, "");
    }

    public void setSourceWeb(String value) {
        this.setAttribute("SourceWeb", value, null);
    }

    public String getSourceWeb() {
        return this.getAttribute("SourceWeb", null, "");
    }

    public void setSpineThickness(double value) {
        this.setAttribute("SpineThickness", value, null);
    }

    public double getSpineThickness() {
        return this.getRealAttribute("SpineThickness", null, 0.0);
    }

    public void setSurfaceCount(int value) {
        this.setAttribute("SurfaceCount", value, (String)null);
    }

    public int getSurfaceCount() {
        return this.getIntAttribute("SurfaceCount", null, 0);
    }

    public void setTransformation(JDFMatrix value) {
        this.setAttribute("Transformation", value, null);
    }

    public JDFMatrix getTransformation() {
        String strAttrName = this.getAttribute("Transformation", null, null);
        JDFMatrix nPlaceHolder = JDFMatrix.createMatrix(strAttrName);
        return nPlaceHolder;
    }

    public void setWindingResult(int value) {
        this.setAttribute("WindingResult", value, (String)null);
    }

    public int getWindingResult() {
        return this.getIntAttribute("WindingResult", null, 0);
    }

    public JDFAssembly getAssembly() {
        return (JDFAssembly)this.getElement("Assembly", null, 0);
    }

    public JDFAssembly getCreateAssembly() {
        return (JDFAssembly)this.getCreateElement_KElement("Assembly", null, 0);
    }

    public JDFAssembly appendAssembly() throws JDFException {
        return (JDFAssembly)this.appendElementN("Assembly", 1, null);
    }

    public void refAssembly(JDFAssembly refTarget) {
        this.refElement(refTarget);
    }

    public JDFBundle getBundle() {
        return (JDFBundle)this.getElement("Bundle", null, 0);
    }

    public JDFBundle getCreateBundle() {
        return (JDFBundle)this.getCreateElement_KElement("Bundle", null, 0);
    }

    public JDFBundle appendBundle() throws JDFException {
        return (JDFBundle)this.appendElementN("Bundle", 1, null);
    }

    public void refBundle(JDFBundle refTarget) {
        this.refElement(refTarget);
    }

    public JDFDisjointing getDisjointing() {
        return (JDFDisjointing)this.getElement("Disjointing", null, 0);
    }

    public JDFDisjointing getCreateDisjointing() {
        return (JDFDisjointing)this.getCreateElement_KElement("Disjointing", null, 0);
    }

    public JDFDisjointing appendDisjointing() throws JDFException {
        return (JDFDisjointing)this.appendElementN("Disjointing", 1, null);
    }

    public JDFSheet getSheet() {
        return (JDFSheet)this.getElement("Sheet", null, 0);
    }

    public JDFSheet getCreateSheet() {
        return (JDFSheet)this.getCreateElement_KElement("Sheet", null, 0);
    }

    public JDFSheet appendSheet() throws JDFException {
        return (JDFSheet)this.appendElementN("Sheet", 1, null);
    }

    public void refSheet(JDFSheet refTarget) {
        this.refElement(refTarget);
    }

    public JDFLayout getLayout() {
        return (JDFLayout)this.getElement("Layout", null, 0);
    }

    public JDFLayout getCreateLayout() {
        return (JDFLayout)this.getCreateElement_KElement("Layout", null, 0);
    }

    public JDFLayout appendLayout() throws JDFException {
        return (JDFLayout)this.appendElementN("Layout", 1, null);
    }

    public void refLayout(JDFLayout refTarget) {
        this.refElement(refTarget);
    }

    public JDFMedia getMedia() {
        return (JDFMedia)this.getElement("Media", null, 0);
    }

    public JDFMedia getCreateMedia() {
        return (JDFMedia)this.getCreateElement_KElement("Media", null, 0);
    }

    public JDFMedia appendMedia() throws JDFException {
        return (JDFMedia)this.appendElementN("Media", 1, null);
    }

    public void refMedia(JDFMedia refTarget) {
        this.refElement(refTarget);
    }

    public JDFPageList getPageList() {
        return (JDFPageList)this.getElement("PageList", null, 0);
    }

    public JDFPageList getCreatePageList() {
        return (JDFPageList)this.getCreateElement_KElement("PageList", null, 0);
    }

    public JDFPageList appendPageList() throws JDFException {
        return (JDFPageList)this.appendElementN("PageList", 1, null);
    }

    public void refPageList(JDFPageList refTarget) {
        this.refElement(refTarget);
    }

    public JDFContact getCreateContact(int iSkip) {
        return (JDFContact)this.getCreateElement_KElement("Contact", null, iSkip);
    }

    public JDFContact getContact(int iSkip) {
        return (JDFContact)this.getElement("Contact", null, iSkip);
    }

    public Collection<JDFContact> getAllContact() {
        VElement vc = this.getChildElementVector("Contact", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFContact> v = new Vector<JDFContact>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFContact)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFContact appendContact() {
        return (JDFContact)this.appendElement("Contact", null);
    }

    public void refContact(JDFContact refTarget) {
        this.refElement(refTarget);
    }

    @Override
    public JDFIdentificationField getCreateIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getCreateElement_KElement("IdentificationField", null, iSkip);
    }

    @Override
    public JDFIdentificationField getIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getElement("IdentificationField", null, iSkip);
    }

    public Collection<JDFIdentificationField> getAllIdentificationField() {
        VElement vc = this.getChildElementVector("IdentificationField", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFIdentificationField> v = new Vector<JDFIdentificationField>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFIdentificationField)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFIdentificationField appendIdentificationField() {
        return (JDFIdentificationField)this.appendElement("IdentificationField", null);
    }

    public void refIdentificationField(JDFIdentificationField refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoComponent.atrInfoTable[0] = new AtrInfoTable("ComponentType", 0x22222222L, AttributeInfo.EnumAttributeType.enumerations, EnumComponentType.getEnum(0), null);
        JDFAutoComponent.atrInfoTable[1] = new AtrInfoTable("AssemblyIDs", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFAutoComponent.atrInfoTable[2] = new AtrInfoTable("Automation", 0x33311111L, AttributeInfo.EnumAttributeType.enumeration, EnumAutomation.getEnum(0), null);
        JDFAutoComponent.atrInfoTable[3] = new AtrInfoTable("CartonTopFlaps", 0x33333111L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoComponent.atrInfoTable[4] = new AtrInfoTable("Columns", 0x33311111L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoComponent.atrInfoTable[5] = new AtrInfoTable("Dimensions", 0x33333333L, AttributeInfo.EnumAttributeType.shape, null, null);
        JDFAutoComponent.atrInfoTable[6] = new AtrInfoTable("IsWaste", 0x44443333L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAutoComponent.atrInfoTable[7] = new AtrInfoTable("MaxHeat", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoComponent.atrInfoTable[8] = new AtrInfoTable("Overfold", 0x33333331L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoComponent.atrInfoTable[9] = new AtrInfoTable("OverfoldSide", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumOverfoldSide.getEnum(0), null);
        JDFAutoComponent.atrInfoTable[10] = new AtrInfoTable("PageListIndex", 0x33333111L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFAutoComponent.atrInfoTable[11] = new AtrInfoTable("ProductType", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoComponent.atrInfoTable[12] = new AtrInfoTable("ProductTypeDetails", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoComponent.atrInfoTable[13] = new AtrInfoTable("ReaderPageCount", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoComponent.atrInfoTable[14] = new AtrInfoTable("SheetPart", 0x33333333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoComponent.atrInfoTable[15] = new AtrInfoTable("SourceRibbon", 0x44444333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoComponent.atrInfoTable[16] = new AtrInfoTable("SourceSheet", 0x44444333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoComponent.atrInfoTable[17] = new AtrInfoTable("SourceWeb", 0x44444333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoComponent.atrInfoTable[18] = new AtrInfoTable("SpineThickness", 0x33331111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoComponent.atrInfoTable[19] = new AtrInfoTable("SurfaceCount", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoComponent.atrInfoTable[20] = new AtrInfoTable("Transformation", 0x44444443L, AttributeInfo.EnumAttributeType.matrix, null, null);
        JDFAutoComponent.atrInfoTable[21] = new AtrInfoTable("WindingResult", 0x33311111L, AttributeInfo.EnumAttributeType.integer, null, null);
        elemInfoTable = new ElemInfoTable[9];
        JDFAutoComponent.elemInfoTable[0] = new ElemInfoTable("Assembly", 0x66666111L);
        JDFAutoComponent.elemInfoTable[1] = new ElemInfoTable("Bundle", 0x66666661L);
        JDFAutoComponent.elemInfoTable[2] = new ElemInfoTable("Disjointing", 0x66666666L);
        JDFAutoComponent.elemInfoTable[3] = new ElemInfoTable("Sheet", 0x77777766L);
        JDFAutoComponent.elemInfoTable[4] = new ElemInfoTable("Layout", 0x66666611L);
        JDFAutoComponent.elemInfoTable[5] = new ElemInfoTable("Media", 0x66661111L);
        JDFAutoComponent.elemInfoTable[6] = new ElemInfoTable("PageList", 0x66666111L);
        JDFAutoComponent.elemInfoTable[7] = new ElemInfoTable("Contact", 0x33333333L);
        JDFAutoComponent.elemInfoTable[8] = new ElemInfoTable("IdentificationField", 0x33333333L);
    }

    public static class EnumOverfoldSide
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumOverfoldSide Front = new EnumOverfoldSide("Front");
        public static final EnumOverfoldSide Back = new EnumOverfoldSide("Back");

        private EnumOverfoldSide(String name) {
            super(name, m_startValue++);
        }

        public static EnumOverfoldSide getEnum(String enumName) {
            return (EnumOverfoldSide)EnumOverfoldSide.getEnum(EnumOverfoldSide.class, (String)enumName);
        }

        public static EnumOverfoldSide getEnum(int enumValue) {
            return (EnumOverfoldSide)EnumOverfoldSide.getEnum(EnumOverfoldSide.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumOverfoldSide.getEnumMap(EnumOverfoldSide.class);
        }

        public static List getEnumList() {
            return EnumOverfoldSide.getEnumList(EnumOverfoldSide.class);
        }

        public static Iterator iterator() {
            return EnumOverfoldSide.iterator(EnumOverfoldSide.class);
        }
    }

    public static class EnumAutomation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAutomation Static = new EnumAutomation("Static");
        public static final EnumAutomation Dynamic = new EnumAutomation("Dynamic");

        private EnumAutomation(String name) {
            super(name, m_startValue++);
        }

        public static EnumAutomation getEnum(String enumName) {
            return (EnumAutomation)EnumAutomation.getEnum(EnumAutomation.class, (String)enumName);
        }

        public static EnumAutomation getEnum(int enumValue) {
            return (EnumAutomation)EnumAutomation.getEnum(EnumAutomation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAutomation.getEnumMap(EnumAutomation.class);
        }

        public static List getEnumList() {
            return EnumAutomation.getEnumList(EnumAutomation.class);
        }

        public static Iterator iterator() {
            return EnumAutomation.iterator(EnumAutomation.class);
        }
    }

    public static class EnumComponentType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumComponentType Block = new EnumComponentType("Block");
        public static final EnumComponentType Other = new EnumComponentType("Other");
        public static final EnumComponentType Ribbon = new EnumComponentType("Ribbon");
        public static final EnumComponentType Sheet = new EnumComponentType("Sheet");
        public static final EnumComponentType Web = new EnumComponentType("Web");
        public static final EnumComponentType FinalProduct = new EnumComponentType("FinalProduct");
        public static final EnumComponentType PartialProduct = new EnumComponentType("PartialProduct");
        public static final EnumComponentType Proof = new EnumComponentType("Proof");

        private EnumComponentType(String name) {
            super(name, m_startValue++);
        }

        public static EnumComponentType getEnum(String enumName) {
            return (EnumComponentType)EnumComponentType.getEnum(EnumComponentType.class, (String)enumName);
        }

        public static EnumComponentType getEnum(int enumValue) {
            return (EnumComponentType)EnumComponentType.getEnum(EnumComponentType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumComponentType.getEnumMap(EnumComponentType.class);
        }

        public static List getEnumList() {
            return EnumComponentType.getEnumList(EnumComponentType.class);
        }

        public static Iterator iterator() {
            return EnumComponentType.iterator(EnumComponentType.class);
        }
    }
}

